#ifndef POWER_MANAGEMENT_H_
#define POWER_MANAGEMENT_H_

#include "TYW_stdint.h"

#define PowerExcuteWakeUpFlag 0x55u

typedef enum
{
    m_IGN_OFF_Init,
    m_IGN_OFF,
    m_IGN_Sleep_Init,
    m_IGN_Sleep,
    m_IGN_Wakeup,
    m_IGN_ON_Init,
    m_IGN_ON,
    m_IGN_LVP,
    m_IGN_OVP,
    m_IGN_LIMIT,
} Power_Status_t;

void Power_Management_Init ( uint8_t u8InitFlag );
void Power_Management_Service ( void );
void ClearNoInitArea(void);

Power_Status_t Power_KL30_Init ( void );
Power_Status_t Power_Wakeup_Init ( void );

void Power_IG_OFF_Init(void);
void Power_IG_ON_Init(void);
void BL_TFT_Status_Set(uint8_t val);
uint8_t BL_TFT_Status_Get(void);
void Power_Sleep_Init(void);

Power_Status_t Power_Stay_ON(void);
Power_Status_t Power_Stay_OFF(void);
Power_Status_t Power_Stay_Protect(void);
Power_Status_t Power_Stay_Sleep( void );



#endif
