
#include "System_Monitor.h"
#include "RTE_ADC.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "Watchdog.h"

#if 0                        //别的文件里已定义
#define Volt_Type   1u       //24V系统

#define u16Base_Vol 0u

#if Volt_Type
    #define u16ENTER_LOW_N_RANGE 9000U
    #define u16EXIT_LOW_N_RANGE  9500U

    #define u16ENTER_LOW_Y_RANGE 10000U
    #define u16EXIT_LOW_Y_RANGE  10500U

    #define u16EXIT_HIGH_Y_RANGE  29500U
    #define u16ENTER_HIGH_Y_RANGE 30000U

    #define u16EXIT_HIGH_N_RANGE  31500U
    #define u16ENTER_HIGH_N_RANGE 32000U
#else
    #define u16ENTER_LOW_N_RANGE 6500U
    #define u16EXIT_LOW_N_RANGE  7000U

    #define u16ENTER_LOW_Y_RANGE 9000U
    #define u16EXIT_LOW_Y_RANGE  9500U

    #define u16EXIT_HIGH_Y_RANGE  16000U
    #define u16ENTER_HIGH_Y_RANGE 16500U

    #define u16EXIT_HIGH_N_RANGE  18500U
    #define u16ENTER_HIGH_N_RANGE 19000U
#endif

#define u16Top_Vol 0xffffu
#endif

uint32_t  u32SysRollingCounter;

#if 0                        //在别的文件直接已定义,不需要了
static const uint16_t SysFun_Range[10u] =
{
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
};

static const uint16_t SysNM_Range[10u] =
{
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
};
#endif

uint16_t Sys_Force_Read_KL30_Voltage(void)
{
    uint16_t u16Voltage;
    u16Voltage = (uint16_t)RTE_ForceRead_KL30_Voltage();
    return u16Voltage;
}

uint16_t Sys_Force_Read_KL15_Voltage(void)
{
    uint16_t u16Voltage;
    u16Voltage = (uint16_t)RTE_ForceRead_KL15_Voltage();
    return u16Voltage;
}

uint16_t Sys_Read_KL30_Voltage(void)
{
    uint16_t u16Voltage;
    u16Voltage = (uint16_t)RTE_Read_KL30_Voltage();
    return u16Voltage;
}

uint16_t Sys_Read_KL15_Voltage(void)
{
    uint16_t u16Voltage;
    u16Voltage = (uint16_t)RTE_Read_KL15_Voltage();
    return u16Voltage;
}

uint8_t Sys_Read_KL30_Valid(void)
{
    uint8_t u8Valid;
    u8Valid = RTE_Read_KL30_Valid();
    return u8Valid;
}

uint8_t Sys_Read_KL15_Valid(void)
{
    uint8_t u8Valid;
    u8Valid = RTE_Read_KL15_Valid();
    return u8Valid;
}

uint8_t System_LINE_KL15(void)
{
    uint8_t u8KL15;
    u8KL15 = ACC_AD_MCU;
    return u8KL15;
}

void Sys_KL30_Init ( void)
{
    //Sys_Set_DebounceTimer(1000u, 2u, 25u, 80u);
    Sys_Set_DebounceTimer(1000u, 2u, 1000u, 80u);
    //Sys_Set_VolRange(SysFun_Range, SysNM_Range);
    System_Monitor_KL30Init();
    System_Fast_WakeUp();
}

void Sys_WakeUp_Init ( void)
{
    //Sys_Set_DebounceTimer(1000u, 2u, 25u, 80u);
    Sys_Set_DebounceTimer(1000u, 2u, 1000u, 80u);
    //Sys_Set_VolRange(SysFun_Range, SysNM_Range);
    System_Monitor_WakeupInit();
    System_Fast_WakeUp();
}

/*网络管理部分处理函数*/
void Sys_LogicProcess(void)
{
    //COM_NM_ACT();
}

void Sys_Rolling(void)
{
    if (u32SysRollingCounter != 65535ul)
    {
        u32SysRollingCounter++;
    }
    else
    {
        u32SysRollingCounter = 0;
    }
}

void Sys_RollingClear(void)
{
    u32SysRollingCounter = 0;
}

uint32_t Sys_Get_ms_Rolling_Counter(void)
{
    return u32SysRollingCounter;
}

void Sys_BlockDelay(uint32_t u32Ms)
{
    uint32_t  RocBackup, Counter;
    Sys_RollingClear();
    RocBackup = Sys_Get_ms_Rolling_Counter();
    do
    {
        WDT_Clear();
        Counter  = Sys_Get_ms_Rolling_Counter();
        if ( Counter >= RocBackup )
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535U - RocBackup + Counter + 1U;
        }
    }
    while ( Counter < u32Ms );
}
