#ifndef _SERVICE_TPMS_H_
#define _SERVICE_TPMS_H_

#include "TYW_stdint.h"

/******************************************************************************
乘用车定义对应关系
TPMS    TpmsFrontL              左前轮
        TpmsFrontR              右前轮
        TpmsRearL               左后轮
        TpmsRearR               右后轮

******************************************************************************/
#define    TpmsFrontLID     0X00u
#define    TpmsFrontRID      0x01u
#define    TpmsRearLID     0x02u
#define    TpmsRearRID      0x03u

#define     TYRETEMP_OFFSET_VALUE     273u  /*胎温数据偏移量*/

typedef enum
{
    TpmsFrontL = 0u,
    TpmsFrontR,
    TpmsRearL,
    TpmsRearR,

    TPMSNumMax,
} TPMSNUM_t;

typedef struct
{
    uint8_t  TPMSTyreID                     ; /*轮胎位置            */
    uint16_t TPMSPressure                   ; /*轮胎气压            */
    uint16_t TPMSTemp                       ; /*轮胎温度            */
    uint16_t TPMSLeakrate                   ; /*漏气速率            */
    uint8_t  TPMSPressureThresholdDetection ; /*压力检测            */
    uint8_t  TPMSStandarPressureSetSts      ; /*轮胎标准压力设置状态  */
    uint8_t  TPMSStandarTempSetSts          ; /*轮胎标准温度设置状态  */
    uint8_t  TPMSInvaliddata                ; /*标识报警信号的有效性  */
    uint8_t  TPMSDataupdating               ; /*数据有效性           */
    uint8_t  TPMSNosignal                   ; /*无信号报警                  */
    uint8_t  TPMSRapidleakage               ; /*快速漏气报警      */
    uint8_t  TPMSHightemperature            ; /*高温报警            */
    uint8_t  TPMSHighpressure               ; /*高气压报警           */
    uint8_t  TPMSLowpressure                ; /*低气压报警           */
    uint8_t  TPMSLowvoltage                 ; /*低电压报警           */
    uint8_t  TPMSSensorfault                ; /*传感器故障信息     */
    uint8_t  TPMSLostWarningSig             ; /*轮胎被盗报警信号        */
    uint8_t  TPMSTemporaryNoSignal          ; /*短时无信号           */
    uint16_t TPMSDataInvalidTime            ; /*数据无效计时器     */
    uint16_t TPMSValueSta                   ; /*数据返回状态*/

} _USER_TPMS;

extern _USER_TPMS TPMS_Out[TPMSNumMax];

void Data_TPMS_KL30_Init(void);
void Data_TPMS_KL15_ON_Init(void);

void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID);
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID);

void Data_TPMS_Value_Processing(void );

uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Leakrate_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Highpressure_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Lowpressure_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TyresLostWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_SensorVoltWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TireStandarPressureSettingSts_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TireStandarTemperatureSettingSts_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TyreTempWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_TemporaryNoSignal_Value(TPMSNUM_t TPMSTyreID);


uint8_t Get_DataTPMS_Tyre_Red_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Tyre_FLASH_Sta(TPMSNUM_t TPMSTyreID);

#endif
