
1、在Emulated_EEPROM.c文件中的EEPROM_Init函数请更新成如下：

void EEPROM_Init(void)
{
    EEPROM_Media_Access_st_t stFlashAccessFunc;

    TYW_FDL_Init();
    
    stFlashAccessFunc.pfnMemErase    = TYW_FDL_Erase;//Int_Data_Flash_Erase;
    stFlashAccessFunc.pfnMemBlankChk = TYW_FDL_Blank_Check;//Int_Data_Flash_Blank_Check;
    stFlashAccessFunc.pfnMemRead     = TYW_FDL_Flash_Read;//Int_Data_Flash_Read;
    stFlashAccessFunc.pfnMemWrite    = TYW_FDL_Write;//Int_Data_Flash_Write;
    
    Int_Data_Flash_Register_P_E_Complete_Cb(EEPROM_Mem_Access_Complete_Callback);
    
    EEPROM_Access_Init( g_stEEPROMBlockTable,
                        g_stEEPROMBlockAccess,
                        &stFlashAccessFunc,
                        EEPROM_TOTAL_BLOCK_NUM);
}

2、在init.c中做如下策略:

   uint8_t u8ResetFlag = 0;
    uint32_t u32FDLDataFlag[4] = {0, 0, 0, 0};
uint32_t u32FDLBlank=0;

    u8ResetFlag = Clock_Get_Startup_Mode();
    if (u8ResetFlag==CLOCK_STARTUP_PWR_ON)
    {
        TYW_FDL_Init();

       
        TYW_FDL_Flash_Read(0xFF20FF00 ,u32FDLDataFlag, 4 );
        
        if ((u32FDLDataFlag[0]==0x66666666)&&(u32FDLDataFlag[1]==0x55555555)&&(u32FDLDataFlag[2]==0xA555A55A)&&(u32FDLDataFlag[3]==0X12345678))
        {
            
        }
        else
        {
            u32FDLDataFlag[0]=0x66666666;
            u32FDLDataFlag[1]=0x55555555;
            u32FDLDataFlag[2]=0xA555A55A;
            u32FDLDataFlag[3]=0X12345678;            

            TYW_FDL_Erase(0XFF200000, 0XFF20FFFF);            

            TYW_FDL_Write(0xFF20FF00 ,  u32FDLDataFlag,  4);



        }
    }

 EEPROM_Init();


注：Clock_Get_Startup_Mode函数只有在每次唤醒或者复位后首次读取时才有效！！！

3、更新Emulated_EEPROM_Access.c文件

4、 修改d1mx.ld文件：参考本文件夹下d1mx.ld中以下内容的位置进行添加。不要直接替换

  .R_FDL_Text    align(4)               :>.      /* FDL code in ROM */
  .R_FDL_Const   align(4)               :>.      /* FDL constants in ROM */


  .R_FDL_Data                           :>.      /* FDL data */