
#include "Data_DrvMtrSpd.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "Common_Interface.h"
#include "Data_VehicleSpeed.h"

uint16_t ACT_DrvMtrSpd;
uint16_t DISP_DrvMtrSpd;
uint8_t  DrvMtrSpdValid;

void DrvMtrSpd_Reset(void)
{
    ACT_DrvMtrSpd   = 0u;
    DISP_DrvMtrSpd  = 0u;
    DrvMtrSpdValid  = 0u;
}

void DrvMtrSpd_KL30_Init(void)
{
    DrvMtrSpd_Reset();
}

void DrvMtrSpd_KL15_ON_Init(void)
{
    DrvMtrSpd_Reset();
}

void DrvMtrSpd_Processing_Service(void) //20mS
{
    uint8_t  IgnSts = Common_Get_IG_Sts();
    uint32_t OnTime = Common_GetIgnOnTime(); 

    if (IgnSts == 1u)
    {
        uint32_t u32Result = 0ul;
  
        /*if (OnTime < 1000u)
        { 
            ACT_DrvMtrSpd  = 15000;
            DISP_DrvMtrSpd = 15000;
        }
        else
        */
        {    
            u32Result = Get_ID_18F502F0_Sig_VCU_DrvMtrSpd();
            
            if ((u32Result > 0xFAFF) || (CAN_MSG_Status(ID_VCU_MCUSts2_Msg_Count) == CAN_SIG_LOST))
            {
                DrvMtrSpdValid = 0;
                u32Result      = 0;
            }
            else
            {
                DrvMtrSpdValid = 1;
            }
            
            if (u32Result <= 15000)
            {
                ACT_DrvMtrSpd = (uint16_t)u32Result;
            } 
            else
            {
                //转速>15000rpm,指针指示前一位置
            }
            
            DISP_DrvMtrSpd = ACT_DrvMtrSpd;
        }
    }
    else
    {
        DrvMtrSpd_Reset();
    }
}

uint16_t DrvMtrSpd_Get_ActualValue(void)
{
    return ACT_DrvMtrSpd;
}

uint16_t DrvMtrSpd_Get_DisplayValue(void)
{
    return DISP_DrvMtrSpd;
}

uint8_t DrvMtrSpd_Get_Valid(void)
{
    return DrvMtrSpdValid;
}
