#include "Data_DrvMtrTpt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint8_t DrvMtrTpt_Value;
uint8_t DrvMtrTpt_Sign;
uint8_t DrvMtrTpt_Valid;

void DrvMtrTpt_Reset(void)
{
    DrvMtrTpt_Value = 0;
    DrvMtrTpt_Sign  = 0;
    DrvMtrTpt_Valid = 0;
}

void DrvMtrTpt_KL30_Init(void)
{
    DrvMtrTpt_Reset();
}

void DrvMtrTpt_KL15_ON_Init(void)
{
    DrvMtrTpt_Reset();
}

void DrvMtrTpt_Processing_Service(void)
{
    uint8_t u8Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        DrvMtrTpt_Reset();
        return;              //自检时不处理
    }

    u8Result  = Get_ID_18F501F0_Sig_VCU_DrvMtrTpt();
    
    if ((u8Result >= 0xFE) || (CAN_MSG_Status(ID_VCU_MCUSts1_Msg_Count) != CAN_SIG_RECEIVE))
    {
        DrvMtrTpt_Valid = 0;
        u8Result        = 0;
    }
    else
    {
        DrvMtrTpt_Valid = 1;
    }

    if (u8Result >= 40) 
    {
        DrvMtrTpt_Sign  = 0;
        u8Result       -= 40;
    }
    else
    {
        DrvMtrTpt_Sign = 1;
        u8Result       = 40 - u8Result;
    }

    DrvMtrTpt_Value = u8Result;
}

uint8_t DrvMtrTpt_Get_Value(void)
{
    return DrvMtrTpt_Value;
}

uint8_t DrvMtrTpt_Get_Sign(void)
{
    return DrvMtrTpt_Sign;
}

uint8_t DrvMtrTpt_Get_Valid(void)
{
    return DrvMtrTpt_Valid;
}
