/**********************************************************************************************************
* @file    loc_graphics_data.h
* @author  HZS
* @version V1.0.0
* @date    2021.04.09
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_DATA_H_
#define LOC_GRAPHICS_DATA_H_

#include "loc_graphics_def.h"
#include "images.h"
#include "GUI.h"

#define MAX_Left_SUP_LAYER       7
uint8_t             LeftUpdate = 0;
uint8_t             LeftEn     = 0;
LogicLayerAttr_t    LeftLogicLayerAttr[MAX_Left_SUP_LAYER];
uint8_t             LeftIndex  = 0;
MultiBufferSprite_t LeftSpriteBuf;

#define MAX_Middle_SUP_LAYER       100
uint8_t             MiddleUpdate = 0;
uint8_t             MiddleEn     = 0;
LogicLayerAttr_t    MiddleLogicLayerAttr[MAX_Middle_SUP_LAYER];
uint8_t             MiddleIndex  = 0;
MultiBufferSprite_t MiddleSpriteBuf;

#define MAX_Right_SUP_LAYER       7
uint8_t             RightUpdate = 0;
uint8_t             RightEn     = 0;
LogicLayerAttr_t    RightLogicLayerAttr[MAX_Right_SUP_LAYER];
uint8_t             RightIndex  = 0;
MultiBufferSprite_t RightSpriteBuf;

#define MAX_Top1_SUP_LAYER       4
uint8_t             Top1Update = 0;
uint8_t             Top1En     = 0;
LogicLayerAttr_t    Top1LogicLayerAttr[MAX_Top1_SUP_LAYER];
uint8_t             Top1Index  = 0;
MultiBufferSprite_t Top1SpriteBuf;

#define MAX_Top2_SUP_LAYER       4
uint8_t             Top2Update = 0;
uint8_t             Top2En     = 0;
LogicLayerAttr_t    Top2LogicLayerAttr[MAX_Top2_SUP_LAYER];
uint8_t             Top2Index  = 0;
MultiBufferSprite_t Top2SpriteBuf;

#define MAX_AirP1_SUP_LAYER       7
uint8_t             AirP1Update = 0;
uint8_t             AirP1En     = 0;
LogicLayerAttr_t    AirP1LogicLayerAttr[MAX_AirP1_SUP_LAYER];
uint8_t             AirP1Index  = 0;
MultiBufferSprite_t AirP1SpriteBuf;

#define MAX_Clock_SUP_LAYER       6
uint8_t             ClockUpdate = 0;
uint8_t             ClockEn     = 0;
LogicLayerAttr_t    ClockLogicLayerAttr[MAX_Clock_SUP_LAYER];
uint8_t             ClockIndex  = 0;
MultiBufferSprite_t ClockSpriteBuf;

#define MAX_Top4_SUP_LAYER       6
uint8_t             Top4Update = 0;
uint8_t             Top4En     = 0;
LogicLayerAttr_t    Top4LogicLayerAttr[MAX_Top4_SUP_LAYER];
uint8_t             Top4Index  = 0;
MultiBufferSprite_t Top4SpriteBuf;

#define MAX_Top5_SUP_LAYER       7
uint8_t             Top5Update = 0;
uint8_t             Top5En     = 0;
LogicLayerAttr_t    Top5LogicLayerAttr[MAX_Top5_SUP_LAYER];
uint8_t             Top5Index  = 0;
MultiBufferSprite_t Top5SpriteBuf;

#define MAX_AirP2_SUP_LAYER       7
uint8_t             AirP2Update = 0;
uint8_t             AirP2En     = 0;
LogicLayerAttr_t    AirP2LogicLayerAttr[MAX_AirP2_SUP_LAYER];
uint8_t             AirP2Index  = 0;
MultiBufferSprite_t AirP2SpriteBuf;

#define MAX_Top6_SUP_LAYER       4
uint8_t             Top6Update = 0;
uint8_t             Top6En     = 0;
LogicLayerAttr_t    Top6LogicLayerAttr[MAX_Top6_SUP_LAYER];
uint8_t             Top6Index  = 0;
MultiBufferSprite_t Top6SpriteBuf;

#define MAX_Top7_SUP_LAYER       11
uint8_t             Top7Update = 0;
uint8_t             Top7En     = 0;
LogicLayerAttr_t    Top7LogicLayerAttr[MAX_Top7_SUP_LAYER];
uint8_t             Top7Index  = 0;
MultiBufferSprite_t Top7SpriteBuf;

#define MAX_Bottm1_SUP_LAYER       15
uint8_t             Bottm1Update = 0;
uint8_t             Bottm1En     = 0;
LogicLayerAttr_t    Bottm1LogicLayerAttr[MAX_Bottm1_SUP_LAYER];
uint8_t             Bottm1Index  = 0;
MultiBufferSprite_t Bottm1SpriteBuf;

#define MAX_Bottm2_SUP_LAYER       11
uint8_t             Bottm2Update = 0;
uint8_t             Bottm2En     = 0;
LogicLayerAttr_t    Bottm2LogicLayerAttr[MAX_Bottm2_SUP_LAYER];
uint8_t             Bottm2Index  = 0;
MultiBufferSprite_t Bottm2SpriteBuf;

#define MAX_Bottm2P_SUP_LAYER       8
uint8_t             Bottm2PUpdate = 0;
uint8_t             Bottm2PEn     = 0;
LogicLayerAttr_t    Bottm2PLogicLayerAttr[MAX_Bottm2P_SUP_LAYER];
uint8_t             Bottm2PIndex  = 0;
MultiBufferSprite_t Bottm2PSpriteBuf;

#define MAX_Bottm3_SUP_LAYER       3
uint8_t             Bottm3Update = 0;
uint8_t             Bottm3En     = 0;
LogicLayerAttr_t    Bottm3LogicLayerAttr[MAX_Bottm3_SUP_LAYER];
uint8_t             Bottm3Index  = 0;
MultiBufferSprite_t Bottm3SpriteBuf;

#define MAX_Bottm4_SUP_LAYER       6
uint8_t             Bottm4Update = 0;
uint8_t             Bottm4En     = 0;
LogicLayerAttr_t    Bottm4LogicLayerAttr[MAX_Bottm4_SUP_LAYER];
uint8_t             Bottm4Index  = 0;
MultiBufferSprite_t Bottm4SpriteBuf;

#define MAX_Bottm5_SUP_LAYER       9
uint8_t             Bottm5Update = 0;
uint8_t             Bottm5En     = 0;
LogicLayerAttr_t    Bottm5LogicLayerAttr[MAX_Bottm5_SUP_LAYER];
uint8_t             Bottm5Index  = 0;
MultiBufferSprite_t Bottm5SpriteBuf;

#define MAX_Bottm6_SUP_LAYER       6
uint8_t             Bottm6Update = 0;
uint8_t             Bottm6En     = 0;
LogicLayerAttr_t    Bottm6LogicLayerAttr[MAX_Bottm6_SUP_LAYER];
uint8_t             Bottm6Index  = 0;
MultiBufferSprite_t Bottm6SpriteBuf;

#define MAX_Bottm7_SUP_LAYER       9
uint8_t             Bottm7Update = 0;
uint8_t             Bottm7En     = 0;
LogicLayerAttr_t    Bottm7LogicLayerAttr[MAX_Bottm7_SUP_LAYER];
uint8_t             Bottm7Index  = 0;
MultiBufferSprite_t Bottm7SpriteBuf;

#define MAX_Bottm8_SUP_LAYER       6
uint8_t             Bottm8Update = 0;
uint8_t             Bottm8En     = 0;
LogicLayerAttr_t    Bottm8LogicLayerAttr[MAX_Bottm8_SUP_LAYER];
uint8_t             Bottm8Index  = 0;
MultiBufferSprite_t Bottm8SpriteBuf;

#define MAX_Bottm9_SUP_LAYER       3
uint8_t             Bottm9Update = 0;
uint8_t             Bottm9En     = 0;
LogicLayerAttr_t    Bottm9LogicLayerAttr[MAX_Bottm9_SUP_LAYER];
uint8_t             Bottm9Index  = 0;
MultiBufferSprite_t Bottm9SpriteBuf;

#define MAX_Bottm10_SUP_LAYER       6
uint8_t             Bottm10Update = 0;
uint8_t             Bottm10En     = 0;
LogicLayerAttr_t    Bottm10LogicLayerAttr[MAX_Bottm10_SUP_LAYER];
uint8_t             Bottm10Index  = 0;
MultiBufferSprite_t Bottm10SpriteBuf;

#define MAX_Bottm11_SUP_LAYER       9
uint8_t             Bottm11Update = 0;
uint8_t             Bottm11En     = 0;
LogicLayerAttr_t    Bottm11LogicLayerAttr[MAX_Bottm11_SUP_LAYER];
uint8_t             Bottm11Index  = 0;
MultiBufferSprite_t Bottm11SpriteBuf;

#define MAX_Stop_SUP_LAYER       3
uint8_t             StopUpdate = 0;
uint8_t             StopEn     = 0;
LogicLayerAttr_t    StopLogicLayerAttr[MAX_Stop_SUP_LAYER];
uint8_t             StopIndex  = 0;
MultiBufferSprite_t StopSpriteBuf;

#define MAX_Park_SUP_LAYER       3
uint8_t             ParkUpdate = 0;
uint8_t             ParkEn     = 0;
LogicLayerAttr_t    ParkLogicLayerAttr[MAX_Park_SUP_LAYER];
uint8_t             ParkIndex  = 0;
MultiBufferSprite_t ParkSpriteBuf;
#if 0
#define MAX_Battery_SUP_LAYER       2
uint8_t             BatteryUpdate = 0;
uint8_t             BatteryEn     = 0;
LogicLayerAttr_t    BatteryLogicLayerAttr[MAX_Battery_SUP_LAYER];
uint8_t             BatteryIndex  = 0;
MultiBufferSprite_t BatterySpriteBuf;
#endif

#define MAX_Charge_SUP_LAYER       2
uint8_t             ChargeUpdate = 0;
uint8_t             ChargeEn     = 0;
LogicLayerAttr_t    ChargeLogicLayerAttr[MAX_Charge_SUP_LAYER];
uint8_t             ChargeIndex  = 0;
MultiBufferSprite_t ChargeSpriteBuf;

static const SpritesHandler_t SpriteHandler[Max_Sprite] =
{
    {Left_Sprite,      {60,   82,  300, 290, 3},  TARGET_VRAM,  &LeftSpriteBuf,    &LeftIndex,    LeftLogicLayerAttr,    MAX_Left_SUP_LAYER,    &LeftUpdate,    &LeftEn,    /*NULL*/GUI_Left   },
    {Middle_Sprite,    {306/*390*/,  88,  636/*478*/, 392, 1},  TARGET_SDRAM, &MiddleSpriteBuf,  &MiddleIndex,  MiddleLogicLayerAttr,  MAX_Middle_SUP_LAYER,  &MiddleUpdate,  &MiddleEn,  /*NULL*/GUI_Middle },
    {Right_Sprite,     {886,  82,  300, 290, 3},  TARGET_VRAM,  &RightSpriteBuf,   &RightIndex,   RightLogicLayerAttr,   MAX_Right_SUP_LAYER,   &RightUpdate,   &RightEn,           GUI_Right  },
    {Top1_Sprite,      {12,   25,  90,  78,  2},  TARGET_VRAM, &Top1SpriteBuf,    &Top1Index,    Top1LogicLayerAttr,    MAX_Top1_SUP_LAYER,    &Top1Update,    &Top1En,    /*NULL*/GUI_Top1   },
    {Top2_Sprite,      {616,  55,  92,  14,  1},  TARGET_VRAM, &Top2SpriteBuf,    &Top2Index,    Top2LogicLayerAttr,    MAX_Top2_SUP_LAYER,    &Top2Update,    &Top2En,    /*NULL*/GUI_Top2   },
    //{AirP1_Sprite,     {330,  43,  164, 30,  1},  TARGET_VRAM, &AirP1SpriteBuf,   &AirP1Index,   AirP1LogicLayerAttr,   MAX_AirP1_SUP_LAYER,   &AirP1Update,   &AirP1En,   /*NULL*/GUI_AirP1  },
    //{Clock_Sprite,     {400,  21,  90,  20,  1},  TARGET_VRAM, &ClockSpriteBuf,   &ClockIndex,   ClockLogicLayerAttr,   MAX_Clock_SUP_LAYER,   &ClockUpdate,   &ClockEn,   NULL/*GUI_Clock*/  },
    {Top4_Sprite,      {500,  15,  266, 30,  1},  TARGET_VRAM, &Top4SpriteBuf,    &Top4Index,    Top4LogicLayerAttr,    MAX_Top4_SUP_LAYER,    &Top4Update,    &Top4En,    /*NULL*/GUI_Top4   },
    {Top5_Sprite,      {770,  19,  200, 30,  1},  TARGET_VRAM, &Top5SpriteBuf,    &Top5Index,    Top5LogicLayerAttr,    MAX_Top5_SUP_LAYER,    &Top5Update,    &Top5En,    /*NULL*/GUI_Top5   },
    //{AirP2_Sprite,     {764,  43,  164, 30,  1},  TARGET_VRAM, &AirP2SpriteBuf,   &AirP2Index,   AirP2LogicLayerAttr,   MAX_AirP2_SUP_LAYER,   &AirP2Update,   &AirP2En,   /*NULL*/GUI_AirP2  },
    {Top6_Sprite,      {1173, 25,  90,  78,  2},  TARGET_VRAM, &Top6SpriteBuf,    &Top6Index,    Top6LogicLayerAttr,    MAX_Top6_SUP_LAYER,    &Top6Update,    &Top6En,    /*NULL*/GUI_Top6   },
    {Top7_Sprite,      {398,  73,  480, 30,  2},  TARGET_VRAM, &Top7SpriteBuf,    &Top7Index,    Top7LogicLayerAttr,    MAX_Top7_SUP_LAYER,    &Top7Update,    &Top7En,    /*NULL*/GUI_Top7   },
    {Bottm1_Sprite,    {307,  372, 662, 30,  1},  TARGET_SDRAM, &Bottm1SpriteBuf,  &Bottm1Index,  Bottm1LogicLayerAttr,  MAX_Bottm1_SUP_LAYER,  &Bottm1Update,  &Bottm1En,  /*NULL*/GUI_Bottm1 },
    {Bottm2_Sprite,    {21,   412, 290, 30,  1},  TARGET_VRAM, &Bottm2SpriteBuf,  &Bottm2Index,  Bottm2LogicLayerAttr,  MAX_Bottm2_SUP_LAYER,  &Bottm2Update,  &Bottm2En,  /*NULL*/GUI_Bottm2 },
    {Bottm2P_Sprite,   {21,   444, 260, 30,  1},  TARGET_VRAM, &Bottm2PSpriteBuf, &Bottm2PIndex, Bottm2PLogicLayerAttr, MAX_Bottm2P_SUP_LAYER, &Bottm2PUpdate, &Bottm2PEn, /*NULL*/GUI_Bottm2P},
    {Bottm3_Sprite,    {292,  434, 96,  30,  1},  TARGET_VRAM, &Bottm3SpriteBuf,  &Bottm3Index,  Bottm3LogicLayerAttr,  MAX_Bottm3_SUP_LAYER,  &Bottm3Update,  &Bottm3En,  /*NULL*/GUI_Bottm3 },
    {Bottm4_Sprite,    {408,  412, 204, 30,  1},  TARGET_VRAM, &Bottm4SpriteBuf,  &Bottm4Index,  Bottm4LogicLayerAttr,  MAX_Bottm4_SUP_LAYER,  &Bottm4Update,  &Bottm4En,  /*NULL*/GUI_Bottm4 },
    {Bottm5_Sprite,    {408,  444, 230, 30,  1},  TARGET_VRAM, &Bottm5SpriteBuf,  &Bottm5Index,  Bottm5LogicLayerAttr,  MAX_Bottm5_SUP_LAYER,  &Bottm5Update,  &Bottm5En,  /*NULL*/GUI_Bottm5 },
    {Bottm6_Sprite,    {673,  412, 188, 30,  1},  TARGET_VRAM, &Bottm6SpriteBuf,  &Bottm6Index,  Bottm6LogicLayerAttr,  MAX_Bottm6_SUP_LAYER,  &Bottm6Update,  &Bottm6En,  /*NULL*/GUI_Bottm6 },
    {Bottm7_Sprite,    {673,  444, 218, 30,  1},  TARGET_VRAM, &Bottm7SpriteBuf,  &Bottm7Index,  Bottm7LogicLayerAttr,  MAX_Bottm7_SUP_LAYER,  &Bottm7Update,  &Bottm7En,  /*NULL*/GUI_Bottm7 },
    //{Bottm8_Sprite,    {579,  408, 122, 64,  1},  TARGET_SDRAM, &Bottm8SpriteBuf,  &Bottm8Index,  Bottm8LogicLayerAttr,  MAX_Bottm8_SUP_LAYER,  &Bottm8Update,  &Bottm8En,  /*NULL*/GUI_Bottm8 },
    {Bottm9_Sprite,    {891,  434, 90,  30,  1},  TARGET_VRAM, &Bottm9SpriteBuf,  &Bottm9Index,  Bottm9LogicLayerAttr,  MAX_Bottm9_SUP_LAYER,  &Bottm9Update,  &Bottm9En,  /*NULL*/GUI_Bottm9 },
    {Bottm10_Sprite,   {1098,  412, 150, 30,  1},  TARGET_VRAM, &Bottm10SpriteBuf, &Bottm10Index, Bottm10LogicLayerAttr, MAX_Bottm10_SUP_LAYER, &Bottm10Update, &Bottm10En, /*NULL*/GUI_Bottm10},
    {Bottm11_Sprite,   {1012, 445, 234, 20,  1},  TARGET_VRAM, &Bottm11SpriteBuf, &Bottm11Index, Bottm11LogicLayerAttr, MAX_Bottm11_SUP_LAYER, &Bottm11Update, &Bottm11En, /*NULL*/GUI_Bottm11},
    {Stop_Sprite,      {12,   375, 96,  30,  1},  TARGET_VRAM, &StopSpriteBuf,    &StopIndex,    StopLogicLayerAttr,    MAX_Stop_SUP_LAYER,    &StopUpdate,    &StopEn,    /*NULL*/GUI_Stop   },
    {Park_Sprite,      {1131, 374, 132, 32,  1},  TARGET_VRAM, &ParkSpriteBuf,    &ParkIndex,    ParkLogicLayerAttr,    MAX_Park_SUP_LAYER,    &ParkUpdate,    &ParkEn,    /*NULL*/GUI_Park   },

    //{Battery_Sprite,   {21,   72,  30,  22,  1},  TARGET_VRAM, &BatterySpriteBuf, &BatteryIndex, BatteryLogicLayerAttr, MAX_Battery_SUP_LAYER, &BatteryUpdate, &BatteryEn, /*NULL*/GUI_Battery},
    {Charge_Sprite,    {1216, 109,  56,  72,  1}, TARGET_VRAM, &ChargeSpriteBuf,  &ChargeIndex,  ChargeLogicLayerAttr,  MAX_Charge_SUP_LAYER,  &ChargeUpdate,  &ChargeEn,  /*NULL*/GUI_Charge },
};

static const r_screen_attr_t ScreenAttr =
{
    1280, 480, 1280,      /* JEPG Window*/
    1280, 480, 1280,      /* Loc Window*/
    1,                    /* 刷新时间，50ms*/
    Max_Sprite,           /* 主屏幕Sprite数量*/
    Max_Sprite,           /* 全部Sprite数量*/
    SpriteSize            /* 最大的图片数量*/
};

#endif
