
//  ����汾 REV 0.1

//---------------------------------------------------------------------------
//  ����ͷ�ļ�
#include "HD_Touch.h"
#include "GPIO.h"
#include "RIIC.h"
#include "Sys_Scheduler.h"
#include "Watchdog.h"
#include "dr7f701441.dvf.h"
#include "r_riic_api.h"
#include "r_riic_main.h"
#include "string.h"
#include "debugger.h"
//---------------------------------------------------------------------------
//  ��ر���
SHDTouchInfo  TP_buff;                    //  ��ȡ���ݵĻ���
unsigned char TP_Zero [ TP_DAT_SIZE ];    //  ���㻺��
uint8_t       TouchINT_SIG;
//---------------------------------------------------------------------------
//  ��Ҫ�û��޸ĵĺ���
//---------------------------------------------------------------------------
//  ����IC�����ñ�
static const unsigned char cmd [ 186 ] = {
0x00,0x61,0x46,0x48,0xD3,0x07,0x00,0x39,0x11,0x9C,0xC4,0x00,0xC8,0x5A,0x41,0x00,0x00,0x16,0x1A,0x1E,0x14,0x00,0x00,0xC8,0xC8,0x00,0x00,0x2F,0x02,0x90,0x00,0x00,0x44,0xFF,0x00,0x00,0x03,0x00,0x05,0xE0,0x01,0x15,0x15,0x0F,0x1C,0x1A,0x18,0x16,0x14,0x12,0x10,0x0E,0x0C,0x0A,0x08,0x06,0x04,0x02,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x00,0x28,0x6E,0x8F,0xF3,0x82,0x0A,0x04,0x00,0xD5,0x2C,0x00,0xC8,0x34,0x00,0xB4,0x3F,0x00,0x91,0x4C,0x00,0x78,0x5B,0x00,0x6E,0x00,0x00,0x00,0x2A,0x25,0xAC,0x50,0x32,0x00,0xAA,0xFF,0xFF,0x2D,0x2D,0x2D,0x2D,0xFF,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,0x14,0x03,0x32,0x23,0xAF,0x00,0x0F,0x32,0x64,0x01,0x3C,0xC8,0x33,0x64,0x50,0x8F,0x4B,0xC8,0x00,0x00,0x8B,0x01};
//---------------------------------------------------------------------------
//  ���յ���Ч�Ĵ����ź�ʱ�Ļص�����,�������Ϊ������Ϣ�׵�ַ
void HD_Touch_RecvTouch_CallBack(SHDTouchInfo *ptpbuf)
{
    uint16_t x, y;

    x = ptpbuf->point_info->x_h * 256;
    x += ptpbuf->point_info->x_l;

    y = ptpbuf->point_info->y_h * 256;
    y += ptpbuf->point_info->y_l;
    d_printf("x=%d,y=%d\n", x, y);
}

//---------------------------------------------------------------------------
//  ���ô�������λ�źŵķ���  IO����   1-���  0-����
void TOUCH_RESET_DIR(unsigned char dir) { }

//---------------------------------------------------------------------------
//  ���ô�������λ�źŵĵ�ƽ
void TOUCH_RESET_OUT(unsigned char state)
{
    //  PTE4
    if ( state == 0 )
    {
        TOUCH_RST = 0;
    }
    else
    {
        TOUCH_RST = 1;
    }
}

//---------------------------------------------------------------------------
//  ���ô������ж��źŵķ���  IO����   1-���  0-����
void TOUCH_INT_DIR(unsigned char dir) { }
void Touch_INT_Detect(void)
{
    if ( TOUCH_INT == 0 )
    {
        TouchINT_SIG = 0;
    }
}
//---------------------------------------------------------------------------
//  ��ȡ��������INT�ߵ�״̬
unsigned char TOUCH_GET_INT(void)
{
    unsigned char state = 0;
    state               = TouchINT_SIG;
    TouchINT_SIG        = 1;
    return state;
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_GA657x_WriteData
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned char bsp_GA657x_WriteData(unsigned char  IC_ADDR,
                                   unsigned short u16_register,
                                   unsigned char *WRData,
                                   unsigned short len)
{
    unsigned char data [ 200 ];
    unsigned char i;
    // data[0] = IC_ADDR;
    data [ 0 ] = ( unsigned char )((u16_register >> 8) & 0x00ff);
    data [ 1 ] = ( unsigned char )(u16_register & 0x00FF);
    for ( i = 2; i < len; i++ )
    {
        data [ i ] = WRData [ i - 2 ];
    }
    RIIC_Master_Transmit(0, len + 2, data);
    return CommComplete;
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_GA657x_Read
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned char bsp_GA657x_Read(unsigned char  IC_ADDR,
                              unsigned short u16_register,
                              unsigned char *RDData,
                              unsigned short len)
{
    RIIC_Master_Receive16B(0, u16_register, len, RDData);
    return CommComplete;
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_Touch_Reset
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Touch_Reset(void)
{

    TOUCH_RESET_DIR(TouchOutput);
    TOUCH_RESET_OUT(TouchLow);

    Common_BlockDelay(120);

    TOUCH_RESET_OUT(TouchHigh);
    Common_BlockDelay(205);
}

//---------------------------------------------------------------------------
//  ��������ʼ��
void bsp_Touch_Init(void)
{
    unsigned char ret  = 0;
    unsigned char zero = 0;

    bsp_Touch_Reset( );
    do
    {
        ret = bsp_GA657x_WriteData(TCA9517_ADDR, GTP_READ_COOR_ADDR, &zero, 1);
        WDT_Clear( );
    } while ( ret != CommComplete );
    do
    {
        ret = bsp_GA657x_WriteData(TCA9517_ADDR,
                                   0x8047,
                                   ( unsigned char * )&cmd [ 0 ],
                                   186); /* �д�Ҫ������� ����ֻ��һ�δ��� */
        WDT_Clear( );

    } while ( ret != CommComplete );

    memset(TP_Zero, 0, sizeof(TP_Zero));
}

//---------------------------------------------------------------------------
//  �㶥�����ݴ���
void HD_Touch_Process(void)
{
    //  ����⵽����ָ�������ɻ㶥����IC�������жϵ�ƽ�źź�
    if ( TOUCH_GET_INT( ) == 0 )
    {
        unsigned char ret = 0;

        do
        {
            //  �ӻ㶥��I2C��ȡȫ��״̬��Ϣ��������Ϣ
            ret = bsp_GA657x_Read(TCA9517_ADDR,
                                  GTP_READ_COOR_ADDR,
                                  ( unsigned char * )&TP_buff,
                                  TP_DAT_SIZE);
            WDT_Clear( );
        } while ( ret != CommComplete );

        //  ���ȫ��״̬��Ϣ��������Ϣ��Ϊ��һ�ζ�ȡ��׼��
        memset(TP_Zero, 0, sizeof(TP_Zero));
        do
        {
            ret = bsp_GA657x_WriteData(TCA9517_ADDR, GTP_READ_COOR_ADDR, TP_Zero, 1);
            WDT_Clear( );
        } while ( ret != CommComplete );

        //  ������������Ч
        if ( TP_buff.tp_status & 0x80 )
        {
            //  �����û��Ļص�����
            HD_Touch_RecvTouch_CallBack(&TP_buff);
        }
    }
}
