/******************************************************************************
�� �� ����BU98R10.c
����������BU98R10����Һ������������������ļ�
��    �ߣ�����
��    ����V1.0
��    �ڣ�2017.4.28
******************************************************************************/
#include "dr7f701441.dvf.h"
#include "BU98R10.h"
#include "rh850_macros.h"
#include "GPIO.h"

#ifndef   BU98R10_0_SD
#define   BU98R10_0_SD                      SD2_DM
#endif

#ifndef   BU98R10_0_SCL
#define   BU98R10_0_SCL                     SCL2_DM
#endif

#ifndef   BU98R10_0_CSB
#define   BU98R10_0_CSB                     CSB2_DM
#endif

#ifndef   BU98R10_1_SD
#define   BU98R10_1_SD                      SD1_DM
#endif

#ifndef   BU98R10_1_SCL
#define   BU98R10_1_SCL                     SCL1_DM
#endif

#ifndef   BU98R10_1_CSB
#define   BU98R10_1_CSB                     CSB1_DM
#endif

#if   USE_BU98R10_CHIP_0
volatile BU98R10DDRAMUnion        BU98R10Chip0DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip0DDRAMBackup;
#endif

#if   USE_BU98R10_CHIP_1
volatile BU98R10DDRAMUnion        BU98R10Chip1DDRAM;
BU98R10DDRAMUnion                 BU98R10Chip1DDRAMBackup;
#endif

BU98R10UpdateCtrlStruct           BU98R10Update;

/******************************************************************************
��������BU98R10_Init
��  �ܣ���ʼ��BU98R10
��  ������
����ֵ����
******************************************************************************/
void BU98R10_Init(void)
{
    uint8_t i;
/*
    for (i == 0 ; i++ ; i < BU98R10_DDRAM_SIZE)
        BU98R10Chip1DDRAM.Byte[i] = 0 ;

    for (i == 0 ; i++ ; i < BU98R10_DDRAM_SIZE)
        BU98R10Chip0DDRAM.Byte[i] = 0 ;
*/

#if     BU98R10_WRITE_AT_SAME_TIME

    BU98R10_All_Command_Write(BU98R10_CMD_SWRST);

    BU98R10_All_Command_Write(BU98R10_CMD_ICSET | BU98R10_PAR_ICSET_RGB);

    BU98R10_All_Command_Write(BU98R10_CMD_DRVCTRL | BU98R10_PAR_DRVCTRL_NORMAL);

    BU98R10_All_Command_Write(BU98R10_CMD_FREQ);
    BU98R10_All_Data_Write(BU98R10_FRAME_FREQ, BU98R10_FRAME_FREQ);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_CTRL);
    BU98R10_All_Data_Write(0x12, 0x12);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_R);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_R, BU98R10_REG_SEG_R);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_G);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_G, BU98R10_REG_SEG_G);

    BU98R10_All_Command_Write(BU98R10_CMD_SEG_B);
    BU98R10_All_Data_Write(BU98R10_REG_SEG_B, BU98R10_REG_SEG_B);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTR);
    BU98R10_All_Data_Write(BU98R10_LRS, BU98R10_LRS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTG);
    BU98R10_All_Data_Write(BU98R10_LGS, BU98R10_LGS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_STARTB);
    BU98R10_All_Data_Write(BU98R10_LBS, BU98R10_LBS);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHR);
    BU98R10_All_Data_Write(BU98R10_LRW, BU98R10_LRW);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHG);
    BU98R10_All_Data_Write(BU98R10_LGW, BU98R10_LGW);

    BU98R10_All_Command_Write(BU98R10_CMD_LED_WIDTHB);
    BU98R10_All_Data_Write(BU98R10_LBW, BU98R10_LBW);

    BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
    BU98R10_All_Data_Write(0x00, 0x00);

    BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
    for (i = 0; i < 90; i++)
        BU98R10_All_Data_Write(BU98R10_DEFAULT_BYTE, BU98R10_DEFAULT_BYTE);

    for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip0DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;

        BU98R10Chip1DDRAM.Byte[i] = BU98R10_DEFAULT_BYTE;
        BU98R10Chip1DDRAMBackup.Byte[i] = BU98R10_DEFAULT_BYTE;
    }

    BU98R10_All_Command_Write(BU98R10_CMD_DISPON);

#endif

    BU98R10Update.En   = 0;
    BU98R10Update.Step = 0;
    BU98R10Update.Cont = 0;
    BU98R10Update.Addr = 0;

#if    USE_BU98R10_CHIP_0
    BU98R10Update.Chip = 0;
#elif  USE_BU98R10_CHIP_1
    BU98R10Update.Chip = 1;
#else
    BU98R10Update.Chip = 255;
#endif
}

void BU98R10_Shutdown(void)
{
#if     BU98R10_WRITE_AT_SAME_TIME
    BU98R10_All_Command_Write(BU98R10_CMD_DISPOFF);
#endif
}

/******************************************************************************
��������BU98R10_Update_Request
��  �ܣ�����ˢ��BU98R10�Ķ�����ʾ
��  ������
����ֵ����
******************************************************************************/
void BU98R10_Update_Request(void)
{
    BU98R10Update.En = 1;

#if    USE_BU98R10_CHIP_0
    BU98R10Update.Chip = 0;
#elif  USE_BU98R10_CHIP_1
    BU98R10Update.Chip = 1;
#else
    BU98R10Update.Chip = 255;
#endif
}

/******************************************************************************
��������BU98R10_Update_Service
��   �ܣ�BU98R10������ʾˢ�·���
��   ������
����ֵ����
*******************************************************************************
ע  �⣺�÷���������ÿ��ϵͳ����ʱʵʱ����
******************************************************************************/
void BU98R10_OPENWINDOW(void)
{

  /*  if (SEG0_MCU == 1)
    {
        SEG0_MCU = 0;
        COMM_MCU = 1;
    }
    else
    {
        SEG0_MCU = 1;
        COMM_MCU = 0;
    }*/

}

void BU98R10_Update_Service(void)
{
    if (BU98R10Update.En)
    {
#if BU98R10_WRITE_AT_SAME_TIME

        switch (BU98R10Update.Step)
        {
        case 0  :
            if ((BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr]) || \
                    (BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr] != BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr])
               )
            {
                BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip0DDRAM.Byte[BU98R10Update.Addr];
                BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr] = BU98R10Chip1DDRAM.Byte[BU98R10Update.Addr];

                if (BU98R10Update.Cont)
                    BU98R10Update.Step = 4;
                else
                    BU98R10Update.Step = 1;
            }
            else
            {
                BU98R10Update.Cont = 0;
                BU98R10Update.Addr++;
                if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
                {
                    BU98R10Update.Addr = 0;
                    BU98R10Update.En   = 0;
                }
            }
            break;

        case 1  :
            BU98R10_All_Command_Write(BU98R10_CMD_ADSET);
            BU98R10Update.Step = 2;
            break;

        case 2  :
#if BU98R10_COLORFUL_LCD_MODE
            BU98R10_All_Data_Write(BU98R10Update.Addr, BU98R10Update.Addr);
#else
            BU98R10_All_Data_Write(BU98R10Update.Addr * 4, BU98R10Update.Addr * 4);
#endif
            BU98R10Update.Step = 3;
            break;

        case 3  :
            BU98R10_All_Command_Write(BU98R10_CMD_DATWR);
            BU98R10Update.Step = 4;
            break;

        case 4  :
            BU98R10_All_Data_Write(BU98R10Chip0DDRAMBackup.Byte[BU98R10Update.Addr], BU98R10Chip1DDRAMBackup.Byte[BU98R10Update.Addr]);
            BU98R10Update.Step = 5;
            break;

        case 5  :
            BU98R10Update.Addr++;
            if (BU98R10Update.Addr >= BU98R10_DDRAM_SIZE)
            {
                BU98R10Update.Addr = 0;
                BU98R10Update.En   = 0;
                BU98R10Update.Cont = 0;
            }
            else
                BU98R10Update.Cont = 1;

            BU98R10Update.Step = 0;
            break;

        default : BU98R10Update.En   = 0;
            BU98R10Update.Step = 0;
            BU98R10Update.Cont = 0;
            BU98R10Update.Addr = 0;
            break;
        }
#endif
    }
}

#if   USE_BU98R10_CHIP_0
void BU98R10_0_Command_Write(uint8_t Cmd)
{
    uint8_t i;

    BU98R10_0_SD  = 0;
    BU98R10_0_SCL = 0;
    BU98R10_0_CSB = 0;

    nop();
    nop();
    nop();

    BU98R10_0_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        BU98R10_0_SCL = 0;

        if (Cmd & 0x80)
            BU98R10_0_SD = 1;
        else
            BU98R10_0_SD = 0;

        nop();
        nop();
        nop();

        BU98R10_0_SCL = 1;

        Cmd <<= 1;
    }

    BU98R10_0_CSB = 1;
}

void BU98R10_0_Data_Write(uint8_t Dat)
{
    uint8_t i;

    BU98R10_0_SD  = 1;
    BU98R10_0_SCL = 0;
    BU98R10_0_CSB = 0;

    nop();
    nop();
    nop();

    BU98R10_0_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        BU98R10_0_SCL = 0;

        if (Dat & 0x80)
            BU98R10_0_SD = 1;
        else
            BU98R10_0_SD = 0;

        nop();
        nop();
        nop();

        BU98R10_0_SCL = 1;

        Dat <<= 1;
    }

    BU98R10_0_CSB = 1;
}
#endif

#if   USE_BU98R10_CHIP_1
void BU98R10_1_Command_Write(uint8_t Cmd)
{
    uint8_t i;

    BU98R10_1_SD  = 0;
    BU98R10_1_SCL = 0;
    BU98R10_1_CSB = 0;

    nop();
    nop();
    nop();

    BU98R10_1_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        BU98R10_1_SCL = 0;

        if (Cmd & 0x80)
            BU98R10_1_SD = 1;
        else
            BU98R10_1_SD = 0;

        nop();
        nop();
        nop();

        BU98R10_1_SCL = 1;

        Cmd <<= 1;
    }

    BU98R10_1_CSB = 1;
}

void BU98R10_1_Data_Write(uint8_t Dat)
{
    uint8_t i;

    BU98R10_1_SD  = 1;
    BU98R10_1_SCL = 0;
    BU98R10_1_CSB = 0;

    nop();
    nop();
    nop();

    BU98R10_1_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        BU98R10_1_SCL = 0;

        if (Dat & 0x80)
            BU98R10_1_SD = 1;
        else
            BU98R10_1_SD = 0;

        nop();
        nop();
        nop();

        BU98R10_1_SCL = 1;

        Dat <<= 1;
    }

    BU98R10_1_CSB = 1;
}

#endif

#if   BU98R10_WRITE_AT_SAME_TIME

void BU98R10_All_Command_Write(uint8_t Cmd)
{
    uint8_t i, j;

    BU98R10_0_SD  = 0;
    BU98R10_1_SD  = 0;

    BU98R10_0_SCL = 0;
    BU98R10_1_SCL = 0;

    BU98R10_0_CSB = 0;
    BU98R10_1_CSB = 0;

    for (j = 0; j < 50; j++)
    {
        nop();
        nop();
        nop();
        nop();
        nop();
    }

    BU98R10_0_SCL = 1;
    BU98R10_1_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        for (j = 0; j < 25; j++)
        {
            nop();
            nop();
            nop();
            nop();
            nop();
        }

        BU98R10_0_SCL = 0;
        BU98R10_1_SCL = 0;

        if (Cmd & 0x80)
        {
            BU98R10_0_SD = 1;
            BU98R10_1_SD = 1;
        }
        else
        {
            BU98R10_0_SD = 0;
            BU98R10_1_SD = 0;
        }

        for (j = 0; j < 25; j++)
        {
            nop();
            nop();
            nop();
            nop();
            nop();
        }

        BU98R10_0_SCL = 1;
        BU98R10_1_SCL = 1;

        Cmd <<= 1;
    }

    for (j = 0; j < 50; j++)
    {
        nop();
        nop();
        nop();
        nop();
        nop();
    }
    BU98R10_0_CSB = 1;
    BU98R10_1_CSB = 1;
}

void BU98R10_All_Data_Write(uint8_t Dat0, uint8_t Dat1)
{
    uint8_t i, j;

    BU98R10_0_SD  = 1;
    BU98R10_1_SD  = 1;

    BU98R10_0_SCL = 0;
    BU98R10_1_SCL = 0;

    BU98R10_0_CSB = 0;
    BU98R10_1_CSB = 0;

    for (j = 0; j < 50; j++)
    {
        nop();
        nop();
        nop();
        nop();
        nop();
    }

    BU98R10_0_SCL = 1;
    BU98R10_1_SCL = 1;

    for (i = 0; i < 8; i++)
    {
        for (j = 0; j < 50; j++)
        {
            nop();
            nop();
            nop();
            nop();
            nop();
        }

        BU98R10_0_SCL = 0;
        BU98R10_1_SCL = 0;

        if (Dat0 & 0x80)
            BU98R10_0_SD = 1;
        else
            BU98R10_0_SD = 0;

        if (Dat1 & 0x80)
            BU98R10_1_SD = 1;
        else
            BU98R10_1_SD = 0;

        for (j = 0; j < 50; j++)
        {
            nop();
            nop();
            nop();
            nop();
            nop();
        }

        BU98R10_0_SCL = 1;
        BU98R10_1_SCL = 1;

        Dat0 <<= 1;
        Dat1 <<= 1;
    }

    for (j = 0; j < 50; j++)
    {
        nop();
        nop();
        nop();
        nop();
        nop();
    }
    BU98R10_0_CSB = 1;
    BU98R10_1_CSB = 1;
}
#endif


