#ifndef TW9990_H_
#define TW9990_H_

#include "r_typedefs.h"         /* Renesas basic types, e.g. uint32_t */    
#include "GPIO.h"
#include "dr7f701441.dvf.h"    
#include "r_gpio_api.h"

#define IIC_WaitOverTime 17000
#define ACK  0
#define NACK 1

#define TW9990_IIC_SCL_HIGH    R_GPIO_WritePin(44, 11, 1);  
#define TW9990_IIC_SCL_LOW     R_GPIO_WritePin(44, 11, 0); 
#define TW9990_IIC_SDA_HIGH    R_GPIO_WritePin(44, 10, 1);
#define TW9990_IIC_SDA_LOW     R_GPIO_WritePin(44, 10, 0);

#define TW9990_IIC_RSTB_LOW    R_GPIO_WritePin(42, 9, 0);
#define TW9990_IIC_RSTB_HIGH   R_GPIO_WritePin(42, 9, 1);

typedef struct msm_camera_i2c_reg_conf
{
    uint8_t addr;                    /*!<   */
    uint8_t RegVal;                  /*!<  */
} msm_camera_i2c_reg_conf_t;

typedef union {
    uint8_t RegVal;
    struct {
      uint8_t DET50     :1;
      uint8_t MONO      :1;  
      uint8_t Reserved  :1;
      uint8_t VLOCK     :1;
          
      uint8_t FIELD     :1;
      uint8_t SLOCK     :1;    
      uint8_t HLOCK     :1;
      uint8_t VDLOSS    :1;    
    }RegVal_Bit;
} REGISTER_I_RegVal;
extern REGISTER_I_RegVal REGISTER_I_REGVAL;

extern uint16_t agdgdgdg;
void I2C_INIT(void);
extern void TW9990_SDA_IN(void);
extern void TW9990_SDA_OUT(void);
extern uint8_t TW9990_SDA_GetValue(void);
extern void TW9990_IIC_DelayUs(uint32_t time);
extern void TW9990_IIC_Start(void);
extern void TW9990_IIC_Stop(void);
extern void TW9990_IIC_ACK(void);
extern void TW9990_IIC_NACK(void);
extern uint8_t TW9990_IIC_WaitAck(void);
extern uint8_t TW9990_IIC_SendByte(uint8_t Data);
extern uint8_t TW9990_IIC_WritePage(uint8_t PhyAdd, uint8_t MemAdd, uint8_t *Data, uint8_t len);
extern uint8_t TW9990_IIC_ReadByte(void);
extern uint8_t TW9990_IIC_ReadPage(uint8_t PhyAdd, uint8_t MemAdd, uint8_t *Data, uint8_t len);
extern void InitTW9990(void);
void I2CDeviceInitialize( unsigned char  *RegSet);

void TW9990_IIC_Sleep(void);
#endif
