/**************************************************************************/ /**
  * \file     Init.c
  * \brief    Initializations during work state switching
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Jan-2019
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "debugger.h"
#include "r_typedefs.h"
#include "Init.h"
#include "r_dev_clk_types.h"

#include "Analog_Signals.h"
#include "Clock.h"
#include "Emulated_EEPROM.h"

#include "Internal_Flash.h"
#include "RTC.h"
#include "BU98R10.h"
#include "Watchdog.h"

#include "r_ddb_api.h"
#include "r_dev_api.h"
#include "r_wm_api.h"
#include "r_tick_api.h"

#include "rh850_macros.h"
#include "cpu.h"
#include "Graphic.h"
#include "Sys_Tick.h"
#include "RSCAN.h"
#include "SDRAM.h"
#include "sflash.h"

#include "sys_scheduler.h"

#include "RTE_ADC.h"
#include "RTE_CAN.h"
#include "RTE_CAN_NM.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "IIS_MAX98357.h"
#include "GUI.h"

#include "RIIC.h"
#include "Sound_Data.h"
#include "TimerB.h"
#include "Watchdog.h"
#include "r_riic_api.h"
#include "r_riic_main.h"
#include "r_typedefs.h"

#include "BU98R10.h"
#include "Init.h"
#include "Sound_Data.h"
#include "CAN_APP.h"
#include "BackLight_APP.h"
#include "TW9990.h"
#include "CVBS.h"
#include "UDS_Common.h"
#include "CAN_APP.h"
#include "fdl_descriptor.h"
#include "Services_ODO_User.h"

#define WITHOUT_BOOT 0
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void DelayUs(uint32_t time)
{
    uint32_t i;
    for (i = 0; i < (time *2); i++) 
    {            
        R_DEV_Nop();
        WDT_Clear();
    }
}

/**************************************************************************//**
  * \brief      Initializations during work state switching
  * \attention
  * \retval     None
******************************************************************************/
uint8_t u8ResetFlag = 0;
uint32_t u32FDLDataFlag[4] = {0, 0, 0, 0};
uint32_t u32FDLBlank = 0;

extern uint32_t u32ResetFlag;
extern uint32_t TestBackupRam;
extern uint32_t TestBackupRam_Flag;

#pragma ghs section bss = ".NonInitArea"
uint32_t u32TimeR;
#pragma ghs section bss = default
void Sys_Startup_Pre_Init(void)
{
    //R_DEV_WRITE_REG(32, LOC_XCRAMCFG0, 0x100100U);
    // *((volatile uint32_t*)(0xFFC06050u)) = (0x100100U);
    SET_EBASE(0x00200400); //set Ebase to 0x10000, set RINT to 1
	  SET_PSW_EBV();
    /* Release all Modules (except SDRAM controller) */
    Sys_Peripheral_Reset(SYS_PERI_RESETTABLE & (~SYS_PERI_SDRB0));

    /* Prepare device (clear all internal config, prepare interrupts) */
    R_DEV_Prepare();

#if (WITHOUT_BOOT)
    {
      	Clock_Pre_Init();
    }
#endif   
    
    GPIO_Init(0);

    Mem_SDRAM_Init(MEM_SDRAM_2x_W9812G6KH_120MHz, Mem_SDRAM_DRV_25Ohm);
    Sys_Enable_Preload_Buffer();
}
/**************************************************************************/ /**
  * \brief      Initializations during system power up
  * \attention
  * \retval     None
******************************************************************************/

 
void Sys_Startup_Init(void)
{
    uint32_t itmp = 0u;
    uint8_t *pRam;
    Clock_Init();
    /* Enable interrupts globally */
    enable_interrupt();

    WDT_Init();

    /* init graphic tick driver */
    R_TICK_Init(0);
    
    LCD3V3_EN_MCU = 1U;  /* 3.3V电源使能 */
    
    DelayUs(30000);
    GRB_LCD_MCU   = 1U;  /* TFT RST */
    LP8867_BL_EN  = 1U;  /* TFT背光芯片使能 */
    MP1530_EN_MCU = 1U;  /* TFT供电使能 */
   
    V_APOWER_MCU  = 1U;  /* 5V供电给NTC */

    DelayUs(100);
    
    Gfx_Init(GFX_VO_SINGLE_OPENLDI | GFX_VI_ITU656);

    CPU_Init();
    u8ResetFlag = Clock_Get_Startup_Mode();
    if (u8ResetFlag == CLOCK_STARTUP_PWR_ON)
    {
        if (TestBackupRam_Flag != 0xAABBCCDD)
        {
          if (TestBackupRam == 0xaabbccddul)
          {
            RTC_Pre_Init();
            Rtc_Restore_Time();
          }
          else
          {
            /*首次上电清零backup*/
            pRam = (unsigned int *)0x3FCE4400;
            for (itmp = 0; itmp < 0x3C00; itmp++)
            {
              pRam[itmp] = 0;
            }
            RTC_Pre_Init();
          }
        }
        TYW_FDL_Init();

        TYW_FDL_Flash_Read(0xFF20FF00, u32FDLDataFlag, 4);

        if ((u32FDLDataFlag[0] == 0x66666666) && (u32FDLDataFlag[1] == 0x55555555) && (u32FDLDataFlag[2] == 0xA555A55A) && (u32FDLDataFlag[3] == 0X12345678))
        {
        }
        else
        {
          u32FDLDataFlag[0] = 0x66666666;
          u32FDLDataFlag[1] = 0x55555555;
          u32FDLDataFlag[2] = 0xA555A55A;
          u32FDLDataFlag[3] = 0X12345678;

          TYW_FDL_Erase(0XFF200000, 0XFF20FFFF);

          TYW_FDL_Write(0xFF20FF00, u32FDLDataFlag, 4);
        }
    }
    else
    {
        TestBackupRam = 0x55;
        RTC_Timing_Service();
    }
    Sys_Tick_Timer_Start();
    /*COM_CAN_Init(); 原CAN初始化位置*/

    I2C_INIT();
    RTE_ADC_Init();

    DelayUs(50000);
    DelayUs(50001);
    InitSeriFlashExternReadMode();

    Int_Flash_Init();
        
    WDT_Clear( );
    //RIIC_Init(0);
    BU98R10_Init();
    
    InitTW9990();
    //d_printf("Init complete!\n");

    //APP_Startup_Init(Clock_Get_Startup_Mode());

    EEPROM_Init();
    ReadAllDFlashData();
    
    u32TimeR = 0u; //20230823移到此处，休眠唤醒也存在蓝屏问题
    
    if (u32ResetFlag != 0xA55AA55AUL)
    {
      u8ResetFlag = 0u;
      //u32TimeR    = 0u;
    }
    else
    {
      if ((u8ResetFlag == 0) && (TestBackupRam == 0xaabbccddu))
      {
        //u8ResetFlag = 1;
        Rtc_Restore_Time();
      }
    }

    TestBackupRam = 0x11223344UL;

    APP_Startup_Init(u8ResetFlag);

    //VdoFmtTyp_Read(); 20230830 按领导要求去掉

    /*外发要用到EEP数据，位置移动*/
    COM_CAN_Init();
    Gfx_Sys_Start();

    //Data_User_EEPROM_Read(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));

    Bottom_Display_Service0();

    TimerB_PWM_Init();
    BL_Init();

    WDT_Clear();
}
/**************************************************************************/ /**
  * \brief      Initializations during work state switch to system sleep
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Sleep_Init(void)
{
    Sys_Tick_Timer_Stop();
}

