#include "Data_BtyMaxTpt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint8_t BtyMaxTpt_Value;
uint8_t BtyMaxTpt_Sign;
uint8_t BtyMaxTpt_Valid;

void BtyMaxTpt_Reset(void)
{
    BtyMaxTpt_Value = 0;
    BtyMaxTpt_Sign  = 0;
    BtyMaxTpt_Valid = 0;
}

void BtyMaxTpt_KL30_Init(void)
{
    BtyMaxTpt_Reset();
}

void BtyMaxTpt_KL15_ON_Init(void)
{
    BtyMaxTpt_Reset();
}

void BtyMaxTpt_Processing_Service(void)
{
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        BtyMaxTpt_Reset();
        return;
    }

    uint8_t u8Result = Get_ID_18F13EF3_Sig_BMS_BtyMaxCllTpt();
    
    if ((u8Result >= 0xFE) || (CAN_MSG_Status(ID_BMS_CllBtySts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyMaxTpt_Valid = 0;
        u8Result        = 0;
    }
    else
    {
        BtyMaxTpt_Valid = 1;
    }

    if (u8Result >= 40) 
    {
        BtyMaxTpt_Sign  = 0;
        u8Result       -= 40;
    }
    else
    {
        BtyMaxTpt_Sign = 1;
        u8Result       = 40 - u8Result;
    }

    BtyMaxTpt_Value = u8Result;
}

uint8_t BtyMaxTpt_Get_Value(void)
{
    return BtyMaxTpt_Value;
}

uint8_t BtyMaxTpt_Get_Sign(void)
{
    return BtyMaxTpt_Sign;
}

uint8_t BtyMaxTpt_Get_Valid(void)
{
    return BtyMaxTpt_Valid;
}
