
#ifndef LINE_IN_H
#define LINE_IN_H

#include "TYW_stdint.h"
#include "string.h"

/*
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
Note !  NOW LineIn only support 254 channel!!!!!
*/

/*所有硬线输入的索引*/
typedef enum
{
    LINE_IN_FluidLevel,     /*PIN1 水位报警信号(预留) 低有效*/
    LINE_IN_BrakeFault,     /*PIN5 制动故障(预留)     低有效*/
    LINE_IN_ChargeWake,     /*PIN9 充电唤醒           高有效*/
    LINE_IN_SeatDetection,  /*PIN11座位检测(预留)     低有效*/
    LINE_IN_LeftDoor,       /*PIN17左车门开关         低有效*/
    LINE_IN_SeatBelt,       /*PIN19安全带            低有效*/
    LINE_IN_Parking,        /*PIN20驻车灯            低有效*/
    LINE_IN_RightDoor,      /*PIN21右车门开关        低有效*/
    LINE_IN_FrontFog,       /*PIN22前雾灯            高有效*/
    LINE_IN_RearFog,        /*PIN23后雾灯            高有效*/
    LINE_IN_TrunLeft,       /*PIN24左转              高有效*/
    LINE_IN_Position,       /*PIN25位置灯            高有效*/
    LINE_IN_TrunRight,      /*PIN27右转              高有效*/
    LINE_IN_LoBeam,         /*PIN28近光              高有效*/
    LINE_IN_HiBeam,         /*PIN30远光              高有效*/
    LINE_IN_PTO,            /*PIN31取力器(预留)      低有效*/
    LINE_IN_ABS,            /*PIN32ABS              低有效*/
    LINE_IN_MAX,
} Line_In_Channel_en_t;

/*获取实时硬线电平函数指针*/
typedef LINE_IN_TriggerLevel_en_t (*LineIn_Read_Level)(void);

typedef struct
{
    LINE_IN_TriggerLevel_en_t enValidLevel; /*有效电平*/
    uint16_t u16ValidTime;                  /*从无效到有效的消抖时间 ms*/
    uint16_t u16InvalidTime;                /*从有效到无效的消抖时间*/
    LINE_IN_WorkSt_en_t enPowerStatus;      /*硬线工作的电源状态*/
    LineIn_Read_Level pfnLineIn_Read_Cbk;   /*获取实时电平的回调函数*/
} Line_In_Attribute_st_t;

/*属性表与硬线索引号Line_In_Channel_en_t一一对应*/
extern const Line_In_Attribute_st_t g_stLineInAttribute[LINE_IN_MAX];
extern void Line_In_SetPowerSt(LINE_IN_WorkSt_en_t u8PowerSt);
/*10ms调用*/
extern void Line_In_Debounce_Service(void);

extern LineIn_LogicLevel_en_t Line_In_Get_Status(Line_In_Channel_en_t Channel);

extern void Line_In_KL30_Init(void);
extern void Line_In_KL15_ON_Init(void);
extern void Line_In_KL15_OFF_Init(void);

#endif
