
#ifndef _POPUP_MESSAGE_LIST_H_
#define _POPUP_MESSAGE_LIST_H_

#include "TYW_stdint.h"

/******************************************************************************
报警文字消息名称列表
******************************************************************************/
enum PopupMessageName
{
    POPUP_MSG_VCU_SYS1 = 0x00u          , /*00 系统警报1级*/
    POPUP_MSG_VCU_SYS2                  , /*01 系统警报2级*/
    POPUP_MSG_VCU_SYS3                  , /*02 系统警报3级*/

    POPUP_MSG_VCU_EPS1                  , /*03 转向系统警报1级*/
    POPUP_MSG_VCU_EPS2                  , /*04 转向系统警报2级*/
    POPUP_MSG_VCU_EPS3                  , /*05 转向系统警报3级*/

    POPUP_MSG_VCU_ACM1                  , /*06 空压机警报1级*/
    POPUP_MSG_VCU_ACM2                  , /*07 空压机警报2级*/
    POPUP_MSG_VCU_ACM3                  , /*08 空压机警报3级*/

    POPUP_MSG_VCU_DCDC1                 , /*09 DC/DC警报1级*/
    POPUP_MSG_VCU_DCDC2                 , /*10 DC/DC警报2级*/
    POPUP_MSG_VCU_DCDC3                 , /*11 DC/DC警报3级*/

    POPUP_MSG_VCU_PDU1                  , /*12 高压配电警报1级*/
    POPUP_MSG_VCU_PDU2                  , /*13 高压配电警报2级*/
    POPUP_MSG_VCU_PDU3                  , /*14 高压配电警报3级*/

    POPUP_MSG_VCU_MCU1                  , /*15 电机控制器警报1级*/
    POPUP_MSG_VCU_MCU2                  , /*16 电机控制器警报2级*/
    POPUP_MSG_VCU_MCU3                  , /*17 电机控制器警报3级*/

    POPUP_MSG_BMS_BMS1                  , /*18 动力电池警报1级*/
    POPUP_MSG_BMS_BMS2                  , /*19 动力电池警报2级*/
    POPUP_MSG_BMS_BMS3                  , /*20 动力电池警报3级*/
    
    POPUP_MSG_COM_Maintenance           , /*21 请及时保养车辆*/
    POPUP_MSG_COM_OvrECUSpd             , /*22 超过经济车速*/
    POPUP_MSG_COM_OvrSpd                , /*23 超速报警*/
    POPUP_MSG_COM_Door                  , /*24 车门未关闭*/
    POPUP_MSG_COM_Seatbelt              , /*25 请系好安全带*/
    POPUP_MSG_COM_ParkingOn             , /*26 手刹未释放*/
    POPUP_MSG_COM_ParkingOff            , /*27 请拉手刹*/
    POPUP_MSG_COM_LeaveSeat             , /*28 你已离座，请注意安全*/
    POPUP_MSG_COM_LvlLow                , /*29 水位低报警*/
    POPUP_MSG_COM_NoJurisdictionVhl     , /*30 无权限车辆*/
    POPUP_MSG_ACCM_CmprErrCode0         , /*31 过流*/
    POPUP_MSG_ACCM_CmprErrCode1         , /*32 运行过压*/
    POPUP_MSG_ACCM_CmprErrCode2         , /*33 运行欠压*/
    POPUP_MSG_ACCM_CmprErrCode3         , /*34 过流降频*/
    POPUP_MSG_ACCM_CmprErrCode4         , /*35 过温故障*/
};
/******************************************************************************
消息类型定义
******************************************************************************/
#define   POPUP_TYPE_GENERAL                0x00u  /*一般消息*/
#define   POPUP_TYPE_SYS                    0x01u  /*系统消息*/
#define   POPUP_TYPE_EPS                    0x02u  /*转向消息*/
#define   POPUP_TYPE_ACM                    0x03u  /*空压机消息*/
#define   POPUP_TYPE_DCDC                   0x04u  /*DCDC消息*/
#define   POPUP_TYPE_PDU                    0x05u  /*高压消息*/
#define   POPUP_TYPE_MCU                    0x06u  /*电机消息*/
#define   POPUP_TYPE_BMS                    0x07u  /*电池消息*/
#define   POPUP_TYPE_ACCM                   0x08u  /*压缩机消息*/
/******************************************************************************
伪文字消息列表
******************************************************************************/
#define   POPUP_MSG_NONE                    0xFFFFu
/******************************************************************************
报警文字消息属性
******************************************************************************/
typedef struct
{
    uint8_t   Type;   /*类型*/
} PopupMsgAttributeStruct;

static const PopupMsgAttributeStruct PopupMsgAttributeTable[] =
{
    /*=============================================================
                报警文字消息名称        |       消息类型
    -------------------------------------------------------------*/
    { /* POPUP_MSG_VCU_SYS1          */  POPUP_TYPE_SYS   ,}, /*00 系统*/
    { /* POPUP_MSG_VCU_SYS2          */  POPUP_TYPE_SYS   ,}, /*01 系统*/
    { /* POPUP_MSG_VCU_SYS3          */  POPUP_TYPE_SYS   ,}, /*02 系统*/
    
    { /* POPUP_MSG_VCU_EPS1          */  POPUP_TYPE_EPS   ,}, /*03 转向*/
    { /* POPUP_MSG_VCU_EPS2          */  POPUP_TYPE_EPS   ,}, /*04 转向*/
    { /* POPUP_MSG_VCU_EPS3          */  POPUP_TYPE_EPS   ,}, /*05 转向*/
    
    { /* POPUP_MSG_VCU_ACM1          */  POPUP_TYPE_ACM   ,}, /*06 空压机*/
    { /* POPUP_MSG_VCU_ACM2          */  POPUP_TYPE_ACM   ,}, /*07 空压机*/
    { /* POPUP_MSG_VCU_ACM3          */  POPUP_TYPE_ACM   ,}, /*08 空压机*/
    
    { /* POPUP_MSG_VCU_DCDC1         */  POPUP_TYPE_DCDC  ,}, /*09 DC/DC*/
    { /* POPUP_MSG_VCU_DCDC2         */  POPUP_TYPE_DCDC  ,}, /*10 DC/DC*/
    { /* POPUP_MSG_VCU_DCDC3         */  POPUP_TYPE_DCDC  ,}, /*11 DC/DC*/
    
    { /* POPUP_MSG_VCU_PDU1          */  POPUP_TYPE_PDU   ,}, /*12 高压配电*/
    { /* POPUP_MSG_VCU_PDU2          */  POPUP_TYPE_PDU   ,}, /*13 高压配电*/
    { /* POPUP_MSG_VCU_PDU3          */  POPUP_TYPE_PDU   ,}, /*14 高压配电*/
    
    { /* POPUP_MSG_VCU_MCU1          */  POPUP_TYPE_MCU   ,}, /*15 电机控制器*/
    { /* POPUP_MSG_VCU_MCU2          */  POPUP_TYPE_MCU   ,}, /*16 电机控制器*/
    { /* POPUP_MSG_VCU_MCU3          */  POPUP_TYPE_MCU   ,}, /*17 电机控制器*/
    
    { /* POPUP_MSG_BMS_BMS1          */  POPUP_TYPE_BMS   ,}, /*18 动力电池*/
    { /* POPUP_MSG_BMS_BMS2          */  POPUP_TYPE_BMS   ,}, /*19 动力电池*/
    { /* POPUP_MSG_BMS_BMS3          */  POPUP_TYPE_BMS   ,}, /*20 动力电池*/

    { /* POPUP_MSG_COM_Maintenance   */  POPUP_TYPE_GENERAL,}, /*21 请及时保养车辆*/
    { /* POPUP_MSG_COM_OvrECUSpd     */  POPUP_TYPE_GENERAL,}, /*22 超过经济车速*/
    { /* POPUP_MSG_COM_OvrSpd        */  POPUP_TYPE_GENERAL,}, /*23 超速报警*/
    { /* POPUP_MSG_COM_Door          */  POPUP_TYPE_GENERAL,}, /*24 车门未关闭*/
    { /* POPUP_MSG_COM_Seatbelt      */  POPUP_TYPE_GENERAL,}, /*25 请系好安全带*/
    { /* POPUP_MSG_COM_ParkingOn     */  POPUP_TYPE_GENERAL,}, /*26 手刹未释放*/
    { /* POPUP_MSG_COM_ParkingOff    */  POPUP_TYPE_GENERAL,}, /*27 请拉手刹*/
    { /* POPUP_MSG_COM_LeaveSeat     */  POPUP_TYPE_GENERAL,}, /*28 你已离座，请注意安全*/
    { /* POPUP_MSG_COM_LvlLow        */  POPUP_TYPE_GENERAL,}, /*29 水位低报警*/
    { /* POPUP_MSG_COM_NoJurisdictionVhl */ POPUP_TYPE_GENERAL,}, /*30 无权限车辆*/
    { /* POPUP_MSG_ACCM_CmprErrCode0 */  POPUP_TYPE_ACCM,   }, /*31 过流*/
    { /* POPUP_MSG_ACCM_CmprErrCode1 */  POPUP_TYPE_ACCM,   }, /*32 运行过压*/
    { /* POPUP_MSG_ACCM_CmprErrCode2 */  POPUP_TYPE_ACCM,   }, /*33 运行欠压*/
    { /* POPUP_MSG_ACCM_CmprErrCode3 */  POPUP_TYPE_ACCM,   }, /*34 过流降频*/
    { /* POPUP_MSG_ACCM_CmprErrCode4 */  POPUP_TYPE_ACCM,   }, /*35 过温故障*/
    /*===========================================================*/
};

#define   POPUP_MSG_NUMBER_TOTAL            (sizeof(PopupMsgAttributeTable) / sizeof(PopupMsgAttributeStruct))

#endif
