/******************************************************************************
* @file    loc_graphics.h
* @author  HZS
* @version V1.0.0
* @date    2020.12.24
******************************************************************************/
#include "GUI.h"
#include "images.h"
#include "loc_graphics.h"
#include "GUI_Interface.h"
#include "RTE_TIME.h"
#include "Data_DrvMtrSpd.h"
#include "Data_BtyMaxTpt.h"
#include "Data_DrvMtrTpt.h"
#include "Data_BtyPckVtg.h"
#include "Data_BtyPckCrt.h"
#include "Data_DrvMCUTpt.h"
#include "Data_Gear.h"
#include "Data_SOC.h"
#include "Analog_Signals.h"
#include "Services_Mileage.h"
#include "Data_PWR.h"
#include "Data_BtyMaxCllTpt.h"
#include "Data_BtyMinCllTpt.h"
#include "Data_BtyMaxCllVtg.h"
#include "Data_BtyMinCllVtg.h"
#include "AirPressure.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "Data_VehicleSpeed.h"
#include "Key.h"
#include "Flash_synchronizer.h"
#include "Popup_List.h"
#include "Popup_Message_List.h"
#include "Popup_Scheduler.h"
#include "Popups.h"
#include "BackLight_APP.h"
#include "Sound_List.h"
#include "Sound_Scheduler.h"
#include "Common_Interface.h"
#include "jcua.h"
#include "Data_ReversingImage.h"
#include "UDS_Common.h"
/*****************************************************************************/
_pid MtrSpeed;
_pid VehSpeed;

static const uint16_t ImageID_Number_38_white[] = 
{
    Number_38_white_0,
    Number_38_white_1,
    Number_38_white_2,
    Number_38_white_3,
    Number_38_white_4,
    Number_38_white_5,
    Number_38_white_6,
    Number_38_white_7,
    Number_38_white_8,
    Number_38_white_9,
};

static const uint16_t ImageID_Number_18_white[] = 
{
    Number_18_white_0,
    Number_18_white_1,
    Number_18_white_2,
    Number_18_white_3,
    Number_18_white_4,
    Number_18_white_5,
    Number_18_white_6,
    Number_18_white_7,
    Number_18_white_8,
    Number_18_white_9,
};
#if 0
static const uint16_t ImageID_Pointer[] = 
{
    Animation_000,
    Animation_002,
    Animation_004,
    Animation_006,
    Animation_008,
    Animation_010,
    Animation_012,
    Animation_014,
    Animation_016,
    Animation_018,
    Animation_020,
    Animation_022,
    Animation_024,
    Animation_026,
    Animation_028,
    Animation_030,
    Animation_032,
    Animation_034,
    Animation_036,
    Animation_038,
    Animation_040,
    Animation_042,
    Animation_044,
    Animation_046,
    Animation_048,
    Animation_050,
    Animation_052,
    Animation_054,
    Animation_056,
    Animation_058,
    Animation_060,
    Animation_062,
    Animation_064,
    Animation_066,
    Animation_068,
    Animation_070,
    Animation_072,
    Animation_074,
    Animation_076,
    Animation_078,
    Animation_080,
    Animation_082,
    Animation_084,
    Animation_086,
    Animation_088,
    Animation_090,
    Animation_092,
    Animation_094,
    Animation_096,
    Animation_098,
    Animation_100,
    Animation_102,
    Animation_104,
    Animation_106,
    Animation_108,
    Animation_110,
    Animation_112,
    Animation_114,
    Animation_116,
    Animation_118,
    Animation_120,
    Animation_122,
    Animation_124,
    Animation_126,
    Animation_128,
    Animation_130,
    Animation_132,
    Animation_134,
    Animation_136,
    Animation_138,
    Animation_140,
    Animation_142,
    Animation_144,
    Animation_146,
    Animation_148,
    Animation_150,
    Animation_152,
    Animation_154,
    Animation_156,
    Animation_158,
    Animation_160,
    Animation_162,
    Animation_164,
    Animation_166,
    Animation_168,
    Animation_170,
    Animation_172,
    Animation_174,
    Animation_176,
    Animation_178,
    Animation_180,
    Animation_182,
    Animation_184,
    Animation_186,
    Animation_188,
    Animation_190,
    Animation_192,
    Animation_194,
    Animation_196,
    Animation_198,
    Animation_200,
    Animation_202,
    Animation_204,
    Animation_206,
    Animation_208,
    Animation_210,
    Animation_212,
    Animation_214,
    Animation_216,
    Animation_218,
    Animation_220,
    Animation_222,
    Animation_224,
    Animation_226,
    Animation_228,
    Animation_230,
    Animation_232,
    Animation_234,
    Animation_236,
    Animation_238,
    Animation_240,
    Animation_242,
    Animation_244,
    Animation_246,
    Animation_248,
    Animation_250,
    Animation_252,
    Animation_254,
    Animation_256,
    Animation_258,
    Animation_260,
    Animation_262,
    Animation_264,
    Animation_266,
    Animation_268,
    Animation_270,
    Animation_272,
    Animation_274,
    Animation_276,
    Animation_278,
    Animation_280,
    Animation_282,
    Animation_284,
    Animation_286,
    Animation_288,
    Animation_290,
    Animation_292,
    Animation_294,
    Animation_296,
    Animation_298,
    Animation_300,
    Animation_302,
    Animation_304,
    Animation_306,
    Animation_308,
    Animation_310,
    Animation_312,
    Animation_314,
    Animation_316,
    Animation_318,
    Animation_320,
    Animation_322,
    Animation_324,
    Animation_326,
    Animation_328,
    Animation_330,
    Animation_332,
    Animation_334,
    Animation_336,
    Animation_338,
    Animation_340,
    Animation_342,
    Animation_344,
    Animation_346,
    Animation_348,
    Animation_350,
    Animation_352,
    Animation_354,
    Animation_356,
    Animation_358,
    Animation_360,
    Animation_362,
    Animation_364,
    Animation_366,
    Animation_368,
    Animation_370,
    Animation_372,
    Animation_374,
    Animation_376,
    Animation_378,
    Animation_380,
    Animation_382,
    Animation_384,
    Animation_386,
    Animation_388,
    Animation_390,
    Animation_392,
    Animation_394,
    Animation_396,
    Animation_398,
    Animation_400,
    Animation_402,
    Animation_404,
    Animation_406,
    Animation_408,
    Animation_410,
    Animation_412,
    Animation_414,
    Animation_416,
    Animation_418,
    Animation_420,
    Animation_422,
    Animation_424,
    Animation_426,
    Animation_428,
    Animation_430,
    Animation_432,
    Animation_434,
    Animation_436,
    Animation_438,
    Animation_440,
    Animation_442,
    Animation_444,
    Animation_446,
    Animation_448,
    Animation_450,
    Animation_452,
    Animation_454,
    Animation_456,
    Animation_458,
    Animation_460,
    Animation_462,
    Animation_464,
    Animation_466,
    Animation_468,
    Animation_470,
    Animation_472,
    Animation_474,
    Animation_476,
    Animation_478,
    Animation_480,
    Animation_482,
    Animation_484,
    Animation_486,
    Animation_488,
    Animation_490,
};
#endif

#define WordSpace 18u
#define UnitSpace 22u
#define PointSpace_F 18u
#define PointSpace_R 6u
#define PointSpace_D 11u

/* 显示整数程序 SpriteID=区域ID value=数据 endX=个位数X坐标 axisY=Y坐标 无效0消隐*/
void Integer_Display(SpriteName_t SpriteID, uint32_t value, uint16_t endX, uint16_t axisY)
{
    uint8_t Num[4];

    uint16_t axisX = endX - WordSpace * 5U;

    Num[0] = 0u;
    
    if (value >= 100000u)
    {
        Num[0] = (uint8_t)(value / 100000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[0]], axisX, axisY, 0u); /*十万位*/
    }
    
    axisX += WordSpace;

    value %= 100000u;
    
    Num[1] = 0u;
    
    if ((value >= 10000u) || Num[0])
    {
        Num[1] = (uint8_t)(value / 10000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[1]], axisX, axisY, 0u); /*万位*/
    }

    axisX += WordSpace;
    
    value %= 10000u;
    
    Num[2] = 0u;

    if ((value >= 1000u) || Num[0] || Num[1])
    {
        Num[2] = (uint8_t)(value / 1000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[2]], axisX, axisY, 0u); /*千位*/
    }
    
    axisX += WordSpace;
    
    value %= 1000u;

    Num[3] = 0u;
    
    if ((value >= 100u) || Num[0] || Num[1] || Num[2])
    {
        Num[3] = (uint8_t)(value / 100);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[3]], axisX, axisY, 0u); /*百位*/
    }

    axisX += WordSpace;
    
    value %= 100;

    if ((value >= 10u) || Num[0] || Num[1] || Num[2] || Num[3])
    {
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value / 10], axisX, axisY, 0u); /*十位*/
    }

    axisX += WordSpace;

    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value % 10], endX, axisY, 0u); /*个位*/
}
/* 显示一位小数程序 SpriteID=区域ID value=数据 endX=十分位数X坐标 axisY=Y坐标 */
void Decimals_Display(SpriteName_t SpriteID, uint32_t value, uint16_t endX, uint16_t axisY)
{
    uint8_t Num[4];

    uint16_t axisX = endX - WordSpace * 4U - PointSpace_R - PointSpace_F;

    Num[0] = 0u;
    
    if (value >= 100000u)
    {
        Num[0] = (uint8_t)(value / 100000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[0]], axisX, axisY, 0u); /*万位*/
    }
    
    axisX += WordSpace;

    value %= 100000u;
    
    Num[1] = 0u;
    
    if ((value >= 10000u) || Num[0])
    {
        Num[1] = (uint8_t)(value / 10000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[1]], axisX, axisY, 0u); /*千位*/
    }
    
    axisX += WordSpace;

    value %= 10000u;
    
    Num[2] = 0u;
    
    if ((value >= 1000u) || Num[0] || Num[1])
    {
        Num[2] = (uint8_t)(value / 1000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[2]], axisX, axisY, 0u); /*百位*/
    }
    
    axisX += WordSpace;

    value %= 1000u;

    Num[3] = 0u;
    
    if ((value >= 100u) || Num[0] || Num[1] || Num[2])
    {
        Num[3] = (uint8_t)(value / 100);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[3]], axisX, axisY, 0u); /*十位*/
    }
    
    axisX += WordSpace;

    value %= 100;
    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value / 10], axisX, axisY, 0u); /*个位*/
 
    axisX += PointSpace_F;
    
    GUI_Translate_Display(SpriteID, Number_18_white_point, axisX, axisY + PointSpace_D, 0u); /*小数点*/
    
    axisX += PointSpace_R;
    
    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value % 10], axisX, axisY, 0u); /*个位*/
}

/* 显示两位小数程序 SpriteID=区域ID value=数据 endX=十分位数X坐标 axisY=Y坐标 */
void Decimals_Display2(SpriteName_t SpriteID, uint32_t value, uint16_t endX, uint16_t axisY)
{
    uint8_t Num[4];

    uint16_t axisX = endX - WordSpace * 4U - PointSpace_R - PointSpace_F;

    Num[0] = 0u;
    
    if (value >= 100000u)
    {
        Num[0] = (uint8_t)(value / 100000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[0]], axisX, axisY, 0u); /*千位*/
    }
    
    axisX += WordSpace;

    value %= 100000u;
    
    Num[1] = 0u;
    
    if ((value >= 10000u) || Num[0])
    {
        Num[1] = (uint8_t)(value / 10000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[1]], axisX, axisY, 0u); /*百位*/
    }
    
    axisX += WordSpace;

    value %= 10000u;
    
    Num[2] = 0u;
    
    if ((value >= 1000u) || Num[0] || Num[1])
    {
        Num[2] = (uint8_t)(value / 1000u);
        GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[2]], axisX, axisY, 0u); /*十位*/
    }
    
    axisX += WordSpace;

    value %= 1000u;

    Num[3] = (uint8_t)(value / 100);
    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[Num[3]], axisX, axisY, 0u); /*个位*/

    axisX += PointSpace_F;
    
    GUI_Translate_Display(SpriteID, Number_18_white_point, axisX, axisY + PointSpace_D, 0u); /*小数点*/
    
    axisX += PointSpace_R;    
    
    value %= 100;
    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value / 10], axisX, axisY, 0u); /*十分位*/
 
    axisX += WordSpace;
    
    GUI_Translate_Display(SpriteID, ImageID_Number_18_white[value % 10], axisX, axisY, 0u); /*百分位*/
}

void Bottom_Display_Service0(void)
{
    GUI_General_Display(Middle_Sprite, BG, GUI_BLENDMODE_SRC_OVER);
}

void Bottom_Display_Service(void)
{
    GUI_General_Display(Middle_Sprite, BG, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(Middle_Sprite, BG, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(Middle_Sprite, BG, GUI_BLENDMODE_SRC_OVER);
}

uint8_t  MtrSpdUpTim = 5u;
uint16_t MtrSpdUpLst = 0u;
//转速表
void GUI_Left(void)
{
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Left_Sprite, Left_Sprite);
        return;
    }

    uint16_t u16tmp = 0;
    uint16_t Numb[3];
     
    if (((Common_GetIgnOnTime() < 3500u) && (Common_Get_IG_Sts() == 1u)) || (Common_Get_IG_Sts() == 0u))
    {
        //MtrSpdUpLst = 0;
    }
    else
    {
        u16tmp = DrvMtrSpd_Get_ActualValue();
    }

    float ftmp = PID_Realize(u16tmp * 0.0164, &MtrSpeed);
    
    GUI_Translate_Display1(Left_Sprite, pointer, 214, 236u, 1u, ftmp - 32.5, 1.0f, 0u);
    
    ftmp *= 15000;
    ftmp /= 246;
    u16tmp = (uint16_t)ftmp;
    
    if (++MtrSpdUpTim < 5u)
    {
        ;
    }
    else
    {
        MtrSpdUpTim = 0u;
        MtrSpdUpLst = u16tmp;
    }
    
    u16tmp = MtrSpdUpLst;
    
    u16tmp /= 100u;          //*100rpm
    
    Numb[0] = 0u;
    
    if (u16tmp >= 100u)
    {
        Numb[0] = ImageID_Number_38_white[u16tmp / 100]; //*10000rpm
    }

    u16tmp %= 100;
    Numb[1] = ImageID_Number_38_white[(uint8_t)(u16tmp / 10)]; //*1000rpm
    u16tmp %= 10;
    Numb[2] = ImageID_Number_38_white[(uint8_t)u16tmp]; //*100rpm
   
    if (Numb[0])             //10000rpm及以上
    {
        GUI_Translate_Display(Left_Sprite, Numb[2], 238u, 212U, 0); /*转速百位*/
        GUI_Translate_Display(Left_Sprite, Number_38_white_spot, 204u, 212U, 0); /*转速小数点*/
        GUI_Translate_Display(Left_Sprite, Numb[1], 188u, 212U, 0); /*转速千位*/
        GUI_Translate_Display(Left_Sprite, Numb[0], 155u, 212U, 0); /*转速万位*/
    }
    else
    {
        GUI_Translate_Display(Left_Sprite, Numb[2], 221u, 212U, 0); /*转速百位*/
        GUI_Translate_Display(Left_Sprite, Number_38_white_spot, 187u, 212U, 0); /*转速小数点*/
        GUI_Translate_Display(Left_Sprite, Numb[1], 171u, 212U, 0); /*转速千位*/
    }

  #if 0
    //GUI_Translate_Display(Left_Sprite, Lamp_01 , 191U, 175U, 0); /*SPORT*/
  
    if (LED_Get_Status(em_LED_DrvBatChgG))
    {
        GUI_Translate_Display(Left_Sprite, Lamp_027, 192U, 277U, 2); /*充电完成*/
    }
  #endif
}
/*************************** 一级菜单 ******************************/
/*行车电脑1, 行车*/
void GUI_Middle001(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_09, 761U, 217U, 0); /*位置1 日间 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_08, 741U, 287U, 0); /*位置2 夜间*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_01, 605U, 292U, 0); /*位置3 行车 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_12, 489U, 287U, 0); /*位置4 退出*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_13, 476U, 218U, 0); /*位置5 限速*/
}
/*行车电脑2, 夜间*/
void GUI_Middle002(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_10, 761U, 217U, 0); /*位置1 设置 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_09, 741U, 287U, 0); /*位置2 日间*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_02, 605U, 292U, 0); /*位置3 夜间 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_07, 489U, 287U, 0); /*位置4 行车*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_12, 475U, 218U, 0); /*位置5 退出*/
}
/*行车电脑3, 日间*/
void GUI_Middle003(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_11, 761U, 217U, 0); /*位置1 视频 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_10, 741U, 287U, 0); /*位置2 设置*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_03, 605U, 292U, 0); /*位置3 日间 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_08, 489U, 287U, 0); /*位置4 夜间*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_07, 475U, 218U, 0); /*位置5 行车*/
}
/*行车电脑4 设置*/
void GUI_Middle004(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_13, 762U, 217U, 0); /*位置1 限速 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_11, 741U, 287U, 0); /*位置2 视频*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_04, 605U, 292U, 0); /*位置3 设置 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_09, 489U, 287U, 0); /*位置4 日间*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_08, 475U, 218U, 0); /*位置5 夜间*/
}
/*行车电脑5 视频*/
void GUI_Middle005(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_12, 761U, 217U, 0); /*位置1 退出 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_13, 742U, 287U, 0); /*位置2 限速*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_05, 605U, 292U, 0); /*位置3 视频 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_10, 489U, 287U, 0); /*位置4 设置*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_09, 475U, 218U, 0); /*位置5 日间*/
}
/*行车电脑6 限速*/
void GUI_Middle006(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_07, 761U, 217U, 0); /*位置1 行车 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_12, 741U, 287U, 0); /*位置2 退出*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_14, 614U, 299U, 0); /*位置3 限速 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_11, 489U, 287U, 0); /*位置4 视频*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_10, 475U, 218U, 0); /*位置5 设置*/
}
/*行车电脑7 退出*/
void GUI_Middle007(void)
{
    GUI_Translate_Display(Middle_Sprite, ECU_Image_08, 761U, 217U, 0); /*位置1 夜间 右--左*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_07, 741U, 287U, 0); /*位置2 行车*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_06, 605U, 292U, 0); /*位置3 退出 主*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_13, 490U, 287U, 0); /*位置4 限速*/
    GUI_Translate_Display(Middle_Sprite, ECU_Image_11, 475U, 218U, 0); /*位置5 视频*/
}
/*************************** 二级菜单 整车信息 ******************************/
/*菜单 组合仪表*/
void GUI_Middle_001_01(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Yy_1, 619U, 106U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_26_Word1, 617U, 151U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_08_Word1, 568U, 196U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_14_Word1, 583U, 249U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_20_Word1, 588U, 297U, 2u); /*二级菜单 整车控制器*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Yy_1_word1, 597U, 109U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_26_Word0, 495U, 151U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_08_Word0, 491U, 196U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_14_Word0, 496U, 249U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_20_Word0, 509U, 297U, 2u); /*二级菜单 整车控制器*/
    }
}
/*菜单二 动力电池组*/
void GUI_Middle_001_02(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_27_Word1, 619U, 107U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_15_Word1, 583U, 150U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_07_Word1, 568U, 196U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_13_Word1, 583U, 249U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_19_Word1, 588U, 297U, 2u); /*二级菜单 电机控制器*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_27_Word0, 508U, 107U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_15_Word0, 496U, 150U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_07_Word0, 491U, 196U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_13_Word0, 496U, 249U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_19_Word0, 509U, 297U, 2u); /*二级菜单 电机控制器*/
    }
}
/*菜单二 整车控制器*/
void GUI_Middle_001_03(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_22_Word1, 588U, 106U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_14_Word1, 583U, 150U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_06_Word1, 568U, 196U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_12_Word1, 583U, 249U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_18_Word1, 588U, 297U, 2u); /*二级菜单 充电机*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_22_Word0, 509U, 106U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_14_Word0, 496U, 150U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_06_Word0, 491U, 196U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_12_Word0, 496U, 249U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_18_Word0, 509U, 297U, 2u); /*二级菜单 充电机*/
    }
}
/*菜单二 电机控制器*/
void GUI_Middle_001_04(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_21_Word1, 588U, 106U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_13_Word1, 583U, 150U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_05_Word1, 568U, 196U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_11_Word1, 583U, 249U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_17_Word1, 588U, 297U, 2u); /*二级菜单 绝缘检测仪*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_21_Word0, 509U, 106U, 2u); /*二级菜单 动力电池组*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_13_Word0, 496U, 150U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_05_Word0, 491U, 196U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_11_Word0, 496U, 249U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_17_Word0, 509U, 297U, 2u); /*二级菜单 绝缘检测仪*/
    }
}
/*菜单二 充电机*/
void GUI_Middle_001_05(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_20_Word1, 588U, 106U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_12_Word1, 583U, 150U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_04_Word1, 568U, 196U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_10_Word1, 583U, 249U, 2u); /*二级菜单 绝缘检测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_24_Word1, 588U, 297U, 2u); /*二级菜单 辅助控制器*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_20_Word0, 509U, 106U, 2u); /*二级菜单 整车控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_12_Word0, 496U, 150U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_04_Word0, 491U, 196U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_10_Word0, 496U, 249U, 2u); /*二级菜单 绝缘检测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_24_Word0, 509U, 297U, 2u); /*二级菜单 辅助控制器*/
    }
}
/*菜单二 绝缘检测仪*/
void GUI_Middle_001_06(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_19_Word1, 588U, 106U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_11_Word1, 583U, 150U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_03_Word1, 568U, 196U, 2u); /*二级菜单 绝缘检测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_09_Word1, 583U, 249U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_23_Word1, 588U, 297U, 2u); /*二级菜单 ABS*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_19_Word0, 509U, 106U, 2u); /*二级菜单 电机控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_11_Word0, 496U, 150U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_03_Word0, 491U, 196U, 2u); /*二级菜单 绝缘检测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_09_Word0, 496U, 249U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_23_Word0, 509U, 297U, 2u); /*二级菜单 ABS*/
    }
}
/*菜单二 辅助控制器*/
void GUI_Middle_001_07(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_18_Word1, 588U, 106U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_10_Word1, 583U, 150U, 2u); /*二级菜单 绝缘监测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_02_Word1, 568U, 196U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_16_Word1, 583U, 249U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_32_Word0, 568U, 297U, 2u); /*二级菜单 软件版本*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_18_Word0, 509U, 106U, 2u); /*二级菜单 充电机*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_10_Word0, 496U, 150U, 2u); /*二级菜单 绝缘监测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_02_Word0, 491U, 196U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_16_Word0, 496U, 249U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_32_Word1, 505U, 297U, 2u); /*二级菜单 软件版本*/
    }
}
/*菜单二 ABS*/
void GUI_Middle_001_08(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_17_Word1, 588U, 106U, 2u); /*二级菜单 绝缘监测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_09_Word1, 583U, 150U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_01_Word1, 568U, 196U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_30_Word0, 560U, 249U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_1, 619U, 298U, 2u); /*二级菜单 语言*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_17_Word0, 509U, 106U, 2u); /*二级菜单 绝缘监测仪*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_09_Word0, 496U, 150U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_01_Word0, 491U, 196U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_30_Word1, 497U, 249U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_1_word1, 597U, 301U, 2u); /*二级菜单 语言*/
    }
}
/*菜单二 软件版本*/
void GUI_Middle_001_09(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_24_Word1, 588U, 106U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_16_Word1, 583U, 150U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word0, 539U, 196U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_2, 617U, 250U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_27_Word1, 619U, 298U, 2u); /*二级菜单 返回*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_24_Word0, 509U, 106U, 2u); /*二级菜单 辅助控制器*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_16_Word0, 496U, 150U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word1, 491U, 196U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_2_word1, 593U, 253U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_27_Word0, 508U, 297U, 2u); /*二级菜单 返回*/
    }
}
/*菜单二 语言*/
void GUI_Middle_001_10(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_23_Word1, 588U, 106U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_30_Word0, 560U, 150U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_3, 611U, 197U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_26_Word1, 617U, 250U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_22_Word1, 588U, 297U, 2u); /*二级菜单 组合仪表*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_23_Word0, 509U, 106U, 2u); /*二级菜单 ABS*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_30_Word1, 505U, 150U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_3_word1, 580U, 200U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_26_Word0, 495U, 250U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_22_Word0, 509U, 297U, 2u); /*二级菜单 组合仪表*/
    }
}
/*菜单二 返回*/
void GUI_Middle_001_11(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_32_Word0, 568U, 106U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_2, 617U, 150U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_25_Word1, 610U, 197U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_15_Word1, 583U, 249U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_21_Word1, 588U, 297U, 2u); /*二级菜单 动力电池组*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_32_Word1, 517U, 106U, 2u); /*二级菜单 软件版本*/
        GUI_Translate_Display(Middle_Sprite, Yy_2_word1, 593U, 153U, 2u); /*二级菜单 语言*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_25_Word0, 489U, 197U, 2u); /*二级菜单 返回*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_15_Word0, 496U, 249U, 2u); /*二级菜单 组合仪表*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_21_Word0, 509U, 297U, 2u); /*二级菜单 动力电池组*/
    }
}
/********************************************************************/
static const uint16_t ImageID_ProgressBar[] = 
{
    Animation_01,
    Animation_02,
    Animation_03,
    Animation_04,
    Animation_05,
    Animation_06,
    Animation_07,
    Animation_08,
    Animation_09,
    Animation_10,
    Animation_11,
    Animation_12,
    Animation_13,
    Animation_14,
    Animation_15,
    Animation_16,
    Animation_17,
    Animation_18,
    Animation_19,
    Animation_20,
    Animation_21,
    Animation_22,
    Animation_23,
    Animation_24,
    Animation_25,
    Animation_26,
    Animation_27,
    Animation_28,
    Animation_29,
    Animation_30,
    Animation_31,
    Animation_32,
    Animation_33,
    Animation_34,
    Animation_35,
    Animation_36,
    Animation_37,
    Animation_38,
    Animation_39,
    Animation_40,
    Animation_41,
    Animation_42,
    Animation_43,
    Animation_44,
    Animation_45,
    Animation_46,
    Animation_47,
    Animation_48,
    Animation_49,
    Animation_50,
    Animation_51,
    Animation_52,
    Animation_53,
    Animation_54,
    Animation_55,
    Animation_56,
    Animation_57,
    Animation_58,
    Animation_59,
    Animation_60,
    Animation_61,
    Animation_62,
    Animation_63,
    Animation_64,
    Animation_65,
    Animation_66,
    Animation_67,
    Animation_68,
    Animation_69,
    Animation_70,
    Animation_71,
    Animation_72,
    Animation_73,
    Animation_74,
    Animation_75,
    Animation_76,
    Animation_77,
    Animation_78,
    Animation_79,
    Animation_80,
    Animation_81,
    Animation_82,
    Animation_83,
    Animation_84,
    Animation_85,
    Animation_86,
    Animation_87,
    Animation_88,
    Animation_89,
    Animation_90,
    Animation_91,
    Animation_92,
    Animation_93,
    Animation_94,
    Animation_95,
    Animation_96,
    Animation_97,
    Animation_98,
    Animation_99,
    Animation_99,
    Animation_99,
};

void Light_Bar_Display(uint8_t bar)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u);                    /*二级菜单 背景*/
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_Vehicle_Light_Moon, 442U, 242U, 0u);  /*二级菜单 左*/
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_Vehicle_Sun_L, 791U, 242U, 0u);       /*二级菜单 右*/
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_Vehicle_Light_Title, 483U, 248U, 0u); /*二级菜单 进度条全白*/
    GUI_Translate_Display(Middle_Sprite, ImageID_ProgressBar[bar], 481U, 247U, 0u);      /*二级菜单 进度条 */
    
    uint16_t axis_X = 475u;
    axis_X += 284 * bar / 100;
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_Vehicle_piont, axis_X, 233U, 0u);  /*二级菜单 进度条头 */

    if (bar >= 100)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar / 100], 600U, 214U, 0u); /*二级菜单 百位 */
        bar %= 100u;
    
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar / 10], 617U, 214U, 0u); /*二级菜单 十位 */
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar % 10], 634U, 214U, 0u); /*二级菜单 个位 */
    }
    else if (bar >= 10)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar / 10], 608U, 214U, 0u); /*二级菜单 十位 */
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar % 10], 626U, 214U, 0u); /*二级菜单 个位 */
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[bar % 10], 617U, 214U, 0u); /*二级菜单 个位 */
    }
}
/*************************** 二级菜单 夜间亮度 ******************************/
void GUI_Middle002_01(void)
{
    uint8_t bar = CurNitBrt_Get();      
    Light_Bar_Display(bar);
    uint8_t temp = LanguageTyp_Get();
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_YJLD_Title_Word0 + temp, 535U - 101U * temp, 128U + 3U * temp, 0u); /*二级菜单 夜间亮度*/
}
/*************************** 二级菜单 日间亮度 ******************************/
void GUI_Middle003_01(void)
{
    uint8_t bar = CurDayBrt_Get();      
    Light_Bar_Display(bar);
    uint8_t temp = LanguageTyp_Get();
    GUI_Translate_Display(Middle_Sprite, Set_Menu2_RJLD_Title_Word0 + temp, 535U - 101U * temp, 128U + 3U * temp, 0u); /*二级菜单 日间亮度 */
}
/*************************** 二级菜单 恢复设置 ******************************/
/* 选中cancel */
void GUI_Middle004_01(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_YES_02_Word1, 514U, 315U, 0);    /*二级菜单 Yes*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Cancel_01_Word1, 641U, 315U, 0); /*二级菜单 Cancel*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_YES_02_Word0, 525U, 316U, 0);    /*二级菜单 Yes*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Cancel_01_Word0, 653U, 316U, 0); /*二级菜单 Cancel*/
    }
}
/* 选中yes */
void GUI_Middle004_02(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_YES_01_Word1, 514U, 315U, 0);    /*二级菜单 Yes*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Cancel_02_Word1, 641U, 315U, 0); /*二级菜单 Cancel*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_YES_01_Word0, 525U, 316U, 0);    /*二级菜单 Yes*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Cancel_02_Word0, 653U, 316U, 0); /*二级菜单 Cancel*/
    }
}
/*************************** 二级菜单 视频格式 ******************************/
/* 选中OFF */
void GUI_Middle_005_01(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_01_Word1, 482U, 315U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_02_Word1, 580U, 315U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_02_Word1, 705U, 315U, 0);  /*二级菜单 PAL*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_01_Word0, 495U, 317U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_02_Word0, 600U, 316U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_02_Word0, 716U, 317U, 0);  /*二级菜单 PAL*/
    }
}
/* 选中NTSC */
void GUI_Middle_005_02(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_02_Word1, 482U, 315U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_01_Word1, 580U, 315U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_02_Word1, 705U, 315U, 0);  /*二级菜单 PAL*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_02_Word0, 495U, 317U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_01_Word0, 600U, 316U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_02_Word0, 716U, 317U, 0);  /*二级菜单 PAL*/
    }
}
/* 选中PAL */
void GUI_Middle_005_03(void)
{
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_02_Word1, 482U, 315U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_02_Word1, 580U, 315U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_01_Word1, 705U, 315U, 0);  /*二级菜单 PAL*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_OFF_02_Word0, 495U, 317U, 0);  /*二级菜单 OFF*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_NTSC_02_Word0, 600U, 316U, 0); /*二级菜单 NTSC*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_PAL_01_Word0, 716U, 317U, 0);  /*二级菜单 PAL*/
    }
}
/*************************** 二级菜单 限速值 ******************************/
/* 选中89 */
void GUI_Middle_006_01(void)
{
    GUI_Translate_Display(Middle_Sprite, Number_18_white_8, 590U-8, 186U, 0);        /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_9, 607U-8, 186U, 0);        /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_kmh, 639U-8, 186U, 0); /*二级菜单 89*/
    
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 590U-8, 236U, 0);         /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 236U, 0);         /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 236U, 0);   /*二级菜单 99*/

    GUI_Translate_Display(Middle_Sprite, Number_18_grey_1, 572U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_0, 590U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 286U, 0);   /*二级菜单 109*/
}
/* 选中99 */
void GUI_Middle_006_02(void)
{
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_8, 590U-8, 186U, 0);         /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 186U, 0);         /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 186U, 0);   /*二级菜单 89*/
    
    GUI_Translate_Display(Middle_Sprite, Number_18_white_9, 590U-8, 236U, 0);        /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_9, 607U-8, 236U, 0);        /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_kmh, 639U-8, 236U, 0); /*二级菜单 99*/

    GUI_Translate_Display(Middle_Sprite, Number_18_grey_1, 572U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_0, 590U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 286U, 0);         /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 286U, 0);   /*二级菜单 109*/
}
/* 选中109 */
void GUI_Middle_006_03(void)
{
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_8, 590U-8, 186U, 0);         /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 186U, 0);         /*二级菜单 89*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 186U, 0);   /*二级菜单 89*/
    
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 590U-8, 236U, 0);         /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_9, 607U-8, 236U, 0);         /*二级菜单 99*/
    GUI_Translate_Display(Middle_Sprite, Number_18_grey_Unit_km, 639U-8, 236U, 0);   /*二级菜单 99*/

    GUI_Translate_Display(Middle_Sprite, Number_18_white_1, 572U-8, 286U, 0);        /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 590U-8, 286U, 0);        /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_9, 607U-8, 286U, 0);        /*二级菜单 109*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_kmh, 639U-8, 286U, 0); /*二级菜单 109*/
}

/* 菜单选项 select:0=全未选中,1=选中上页,2=选中返回,3=选中下页 */
void Menu_Set_Subroutineu(uint8_t select)
{
    uint8_t temp = LanguageTyp_Get();

    if (select == 0u)        //全不选
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word0, 480U, 343U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word0, 605U, 344U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word0, 711U, 343U, 0); /*下页*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word1, 442U, 346U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word1, 594U, 346U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word1, 693U, 345U, 0); /*下页*/
        }
    }
    else if (select == 1u)   //选上页
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_01_Word0, 480U, 343U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word0, 605U, 344U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word0, 711U, 343U, 0); /*下页*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_01_Word1, 442U, 346U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word1, 594U, 346U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word1, 693U, 345U, 0); /*下页*/
        }
    }
    else if (select == 2u)   //选返回
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word0, 480U, 343U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_03_Word0, 605U, 344U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word0, 711U, 343U, 0); /*下页*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word1, 442U, 346U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_03_Word1, 594U, 346U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_06_Word1, 693U, 345U, 0); /*下页*/
        }
    }
    else                     //选下页
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word0, 480U, 343U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word0, 605U, 344U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_05_Word0, 711U, 343U, 0); /*下页*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_02_Word1, 442U, 346U, 0); /*上页*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word1, 594U, 346U, 0); /*返回*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_05_Word1, 693U, 345U, 0); /*下页*/
        }    
    }
}
/*****************************************************************************/
/* 显示数字和单位 value:数据, ImageID:单位图片, startX:X轴起始坐标, axisY:Y轴坐标, unitY:单位Y坐标*/
void NumUnit_Display(uint32_t value, uint16_t ImageID, uint16_t startX, uint16_t axisY, uint16_t unitY)
{
    if (value >= 100000ul)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100000ul], startX, axisY, 0u); /*十万位*/
        value %= 100000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10000u], startX, axisY, 0u); /*万位*/
        value %= 10000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*千位*/
        value %= 1000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*百位*/
        value %= 100u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 10000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10000u], startX, axisY, 0u); /*万位*/
        value %= 10000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*千位*/
        value %= 1000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*百位*/
        value %= 100u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 1000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*千位*/
        value %= 1000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*百位*/
        value %= 100u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 100u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*百位*/
        value %= 100;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 10u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十位*/
    }
    else
    {
        startX -= WordSpace;
    }
    
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value % 10u], startX, axisY, 0u); /*个位*/
    
    if (ImageID != 0xFFFFu)
    {
        startX += UnitSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID, startX, unitY, 0u); /*单位*/
    }
}
/* 显示数字 小数点和单位 一位小数 value:数据, ImageID:单位图片, startX:X轴起始坐标, axisY:Y轴坐标, unitY:单位Y坐标*/
void NumPointUnit_Display1(uint16_t value, uint16_t ImageID, uint16_t startX, uint16_t axisY, uint16_t unitY)
{
    if (value >= 10000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10000u], startX, axisY, 0u); /*千位*/
        value %= 10000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*百位*/
        value %= 1000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 1000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*百位*/
        value %= 1000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*十位*/
    }
    else if (value >= 100u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*十位*/
    }
    else
    {
        startX -= WordSpace;
    }
    
    value %= 100u;
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*个位*/
    
    startX += PointSpace_F;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, startX, axisY + 11u, 0u); /*小数点*/
    
    startX += PointSpace_R;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value % 10u], startX, axisY, 0u); /*十分位*/
    
    if (ImageID != 0xFFFFu)
    {
        startX += UnitSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID, startX, unitY, 0u); /*单位*/
    }
}
/* 显示数字 小数点和单位 两位小数 value:数据, ImageID:单位图片, startX:X轴起始坐标, axisY:Y轴坐标, unitY:单位Y坐标*/
void NumPointUnit_Display2(uint16_t value, uint16_t ImageID, uint16_t startX, uint16_t axisY, uint16_t unitY)
{
    if (value >= 10000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10000u], startX, axisY, 0u); /*百位*/
        value %= 10000u;
        startX += WordSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*十位*/
        
    }
    else if (value >= 1000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*十位*/
    }
    else
    {
        startX -= WordSpace;
    }
    
    value %= 1000u;
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*个位*/
    
    startX += PointSpace_F;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, startX, axisY + 11u, 0u); /*小数点*/

    value %= 100u;
    startX += PointSpace_R;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*十分位*/
    
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value % 10u], startX, axisY, 0u); /*百分位*/
    
    if (ImageID != 0xFFFFu)
    {
        startX += UnitSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID, startX, unitY, 0u); /*单位*/
    }
}
/* 显示数字 小数点和单位 三位小数 value:数据, ImageID:单位图片, startX:X轴起始坐标, axisY:Y轴坐标, unitY:单位Y坐标*/
void NumPointUnit_Display3(uint16_t value, uint16_t ImageID, uint16_t startX, uint16_t axisY, uint16_t unitY)
{
    if (value >= 10000u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10000u], startX, axisY, 0u); /*十位*/
    }
    else
    {
        startX -= WordSpace;
    }
    
    value %= 10000u;
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 1000u], startX, axisY, 0u); /*个位*/
    
    startX += PointSpace_F;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, startX, axisY + 11u, 0u); /*小数点*/
    
    value %= 1000u;
    startX += PointSpace_R;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 100u], startX, axisY, 0u); /*十分位*/
    value %= 100u;
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value / 10u], startX, axisY, 0u); /*百分位*/
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value % 10u], startX, axisY, 0u); /*千分位*/
    
    if (ImageID != 0xFFFFu)
    {
        startX += UnitSpace;
        GUI_Translate_Display(Middle_Sprite, ImageID, startX, unitY, 0u); /*单位*/
    }
}
/*************************** 三级菜单 电机控制器 *****************************/
/* 第3页 */
void GUI_Middle_001_03_02(void)
{
    /*三级菜单 电机控制器*/
    uint8_t temp = LanguageTyp_Get();
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word0, 535U, 128U, 0u); /*电机控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word1, 453U, 131U, 0u); /*电机控制器 文字*/
    }
    
    /*故障等级*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_06, 440U, 182U, 0u); /*故障等级文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_06, 440U, 182U, 0u); /*故障等级文字*/
    }
    uint8_t value = Get_ID_18F501F0_Sig_VCU_MCUMaxFltLv();
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value], 634U, 186U, 0u); /*故障等级 数字*/
    
    /*故障码*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_18, 440U, 222U, 0u); /*故障码文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_18, 440U, 222U, 0u); /*故障码文字*/
    }
    value = Get_ID_18F501F0_Sig_VCU_MCUDTC();
    
    if (value > 250u)
    {
        value = 250u;
    }
    
    NumUnit_Display(value, 0xFFFFu, 634u, 226u, 223u);

    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_MCU));
}
/* 第2页 */
void GUI_Middle_001_03_01(void)
{
    uint8_t temp = LanguageTyp_Get();
    uint8_t offset = 20u;

    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word0, 535U, 128U, 0u); /*电机控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word1, 453U, 131U, 0u); /*电机控制器 文字*/
    }
    
    /*电机功率*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_07, 440U, 182U, 0); /*电机功率 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_07, 440U, 182U, 0); /*电机功率 文字*/
    }
    uint8_t value = IstDrvMtrPwr_Get_Value();
    uint8_t sign  = IstDrvMtrPwr_Get_Sign();
    
    if (sign)            //负数
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U + temp * offset, 193U, 0u); /*-*/
        NumUnit_Display(value, Number_18_white_Unit_kw, 643u + temp * offset, 186u, 187u);
    }
    else
    {
        NumUnit_Display(value, Number_18_white_Unit_kw, 634u + temp * offset, 186u, 187u);
    }
        
    /*电控温度*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_19, 440U, 222U, 0u); /*电控温度文字 */
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, ECU_05_Word1, 440U, 224U, 0u); /*电控温度文字 */
    }    
    value = DrvMCUTpt_Get_Value();
    sign  = DrvMCUTpt_Get_Sign();

    if (sign)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U + temp * offset, 233U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 643u + temp * offset, 226u, 224u);
    }
    else
    {
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 634u + temp * offset, 226u, 224u);
    } 

    /*电机温度*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_30, 440U, 262U, 0); /*电机温度文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_30, 440U, 262U, 0); /*电机温度文字*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 440U + 116U, 262U + 14U, 0);
    }    
    value = DrvMtrTpt_Get_Value();
    sign  = DrvMtrTpt_Get_Sign();

    if (sign)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U + temp * offset, 273U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 643u + temp * offset, 266u, 264u);
    }
    else
    {
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 634u + temp * offset, 266u, 264u);
    } 
        
    /*故障数量*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_21, 440U, 302U, 0); /*故障数量 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_21, 440U, 302U, 0); /*故障数量 文字*/
    }
    value = Get_ID_18F501F0_Sig_VCU_MCUTtlFlt();
    
    if (value >= 0x3Eu)
    {
        value = 0x0u;
    }

    if (value > 60u)
    {
        value = 60u;
    }
    
    NumUnit_Display(value, 0xFFFFu, 634u + temp * offset, 306u, 304u);

    //选择项        
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_MCU));
}
/* 第1页 */
void GUI_Middle_001_03_00(void)
{
    uint8_t temp = LanguageTyp_Get();
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word0, 535U, 128U, 0u); /*电机控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DJKZQ_Title_Word1, 453U, 131U, 0u); /*电机控制器 文字*/
    }
    /*母线电压*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_08, 440U, 182U, 0u); /*母线电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_08, 440U, 182U, 0u); /*母线电压 文字*/
    }
    uint16_t value = Get_ID_18F501F0_Sig_VCU_MCUIptVtg(); //1V
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }
    
    if (value > 1500u)
    {
        value = 1500u;
    }
    
    NumUnit_Display(value, Number_18_white_Unit_V, 634u, 186u, 186u);
    
    /*母线电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_20, 440U, 222U, 0); /*母线电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_20, 440U, 222U, 0); /*母线电流 文字*/
    }    
    value = Get_ID_18F109D0_Sig_VCU_T_DrvMtrIptVtg(); //0.1A
    
    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_VCU_RMON_3_Msg_Count) != CAN_SIG_RECEIVE))
    {
        value = 10000u;
    }

    if (value > 20000u)
    {
        value = 20000u;
    }
    
    if (value >= 10000u)
    {
        value -= 10000u;
        value /= 10u;        //1A
        NumUnit_Display(value, Number_18_white_Unit_A, 634u, 226u, 228u);
    }
    else
    {
        value = 10000u - value;
        value /= 10u;        //1A
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U, 233U, 0u); /*-*/
        NumUnit_Display(value, Number_18_white_Unit_A, 643u, 226u, 228u);
    }
                
    /*电机转矩*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_31, 440U, 262U, 0u); /*电机转矩文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_31, 440U, 262U, 0u); /*电机转矩文字*/
    }    
    value = Get_ID_18F502F0_Sig_VCU_DrvMtrTrq(); //1Nm
    
    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_VCU_MCUSts2_Msg_Count) != CAN_SIG_RECEIVE))
    {
        /* 显示--- */
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 636U, 273U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 654U, 273U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_71_Unit_nm, 674U, 267U, 0u); /*NM*/
    }
    else
    {
        //if (value > 5000u)
        {
            //value = 5000u;
        }    
    
        NumUnit_Display(value, Set_Menu3_Word0_71_Unit_nm, 634u, 266u, 267u);
    }    
    /*电机转速*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_38, 440U, 302U, 0); /*电机转速 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_38, 440U, 302U, 0); /*电机转速 文字*/
    }    
    value = Get_ID_18F502F0_Sig_VCU_DrvMtrSpd(); //1rpm
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }

    if (value > 15000u)
    {
        value = 15000u;
    }    

    NumUnit_Display(value, Number_18_white_Unit_rm, 634u, 306u, 306u);    
    
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_MCU));
}
/*************************** 三级菜单 动力电池组 *****************************/
//第一页 BMS状态 母线电压 母线电流 剩余电量
void GUI_Middle_001_01_00(void) //001表示二级菜单整车信息,01表示三级菜单动力电池组,00表示第一页
{
    uint8_t temp = LanguageTyp_Get();
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2); /*背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0); /*动力电池组 文字*/
    }
    //BMS状态
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_50 , 440U, 182U, 0); /*BMS状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_50 , 440U, 182U, 0); /*BMS状态 文字*/
    }
    uint16_t value = Get_ID_18F13DF3_Sig_BMS_BMSFltLv();
    
    if (value == 0u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_83, 634U, 185U, 0); /*正常 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_83, 634U, 185U, 0); /*正常 文字*/
        }
    }
    else if (value == 1u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_107, 634U, 185U, 0); /*故障 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_107, 634U, 185U, 0); /*故障 文字*/
        }
    }
    else
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_91, 634U, 185U, 0); /*无效 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_91, 634U, 185U, 0); /*无效 文字*/
        } 
    }
    
    //母线电压
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_08, 440U, 222U, 0); /*母线电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_08, 440U, 222U, 0); /*母线电压 文字*/
    }    
    value = Get_ID_18F13DF3_Sig_BMS_BtyPckVtg(); //0.1V
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }
    
    if (value > 10000u)
    {
        value = 10000u;
    }

    NumPointUnit_Display1(value, Number_18_white_Unit_V, 634u, 226u, 226u);
          
    /*母线电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_20, 440U, 262U, 0u); /*母线电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_20, 440U, 262U, 0u); /*母线电流 文字*/
    }
    value = Get_ID_18F13DF3_Sig_BMS_BtyPckCrt(); //0.1A

    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_BMS_BMSSts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        value = 10000u;
    }
    
    if (value > 20000u)
    {
        value = 20000u;
    }
    
    if (value < 10000u)
    {
        value = 10000u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U, 273U, 0u); /*-*/
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 643u, 266u, 268u);
    }
    else
    {
        value -= 10000u;
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 634u, 266u, 268u);
    }
        
    /*剩余电量*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_39, 440U, 302U, 0u); /*剩余电量 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_39, 440U, 302U, 0u); /*剩余电量 文字*/
    } 
    value = Get_ID_18F13DF3_Sig_BMS_BtySOC(); //0.4%
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }
    
    if (value > 250u)
    {
        value = 250u;
    }
    
    value <<= 1u;
    value /=  5u;

    NumUnit_Display(value, Set_Menu3_Word0_75, 634u, 306u, 307u);
    
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}
//第二页 高压继电器状态 故障数量 BMS故障码 BMS版本
void GUI_Middle_001_01_01(void)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }
    //高压继电器
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_49 , 440U, 182U, 0); /*高压继电器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_49 , 440U, 182U, 0); /*高压继电器 文字*/
    }
    uint16_t value = Get_ID_18F13DF3_Sig_BMS_BtyNgtvRlySts();
    value += Get_ID_18F13DF3_Sig_BMS_BtyPstyRlySts();
    
    if (value == 2u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_108, 634U + 30U * temp, 185U, 0); /*闭合 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_108, 634U + 30U * temp, 185U, 0); /*闭合 文字*/
        }
    }
    else
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_77, 634U + 30U * temp, 185U, 0); /*断开 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_77, 634U + 30U * temp, 185U, 0); /*断开 文字*/
        }
    }
    
    /*故障数量*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_21, 440U, 222U, 0); /*故障数量 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_21, 440U, 222U, 0); /*故障数量 文字*/
    }
    value = Get_ID_18F141F3_Sig_BMS_BMSTtlFlt();
    
    if (value >= 0x3Eu)
    {
        value = 0u;
    }

    if (value > 60u)
    {
        value = 60u;
    }
    
    NumUnit_Display(value, 0xFFFFu, 634u + 30U * temp, 226u, 226u);
        
    /*故障码*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_18, 440U, 262U, 0u); /*故障码 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_18, 440U, 262U, 0u); /*故障码 文字*/
    }    
    
    //if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U + 30U * temp, 267U, 0u); /*Warn 英文*/
    }
    //else
    {
        //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U + 30U * temp, 267U, 0u); /*Warn 英文*/
    }
    
    value = Get_ID_18F141F3_Sig_BMS_BMSDTC();
    
    if (value >= 0xFEu)
    {
        value = 0u;
    }

    if (value > 150u)
    {
        value = 150u;
    }
    
    NumUnit_Display(value, 0xFFFFu, 702u + 30U * temp, 266u, 266u);
    
    /*BMS版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_48, 440U, 302U, 0u); /*BMS版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_48, 440U, 302U, 0u); /*BMS版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_V, 634U + 30U * temp, 306U, 0u); /*V 英文*/
    
    value = Get_ID_18F141F3_Sig_BMS_BMSSwrVrsNbr();
    
    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_BMS_BMSFltSts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        value = 0u;
    }
    else
    {
         if (value < 100u)
        {
            value = 100u;
        }

        if  (value > 9999u)
        {
            value = 9999u;
        }
    }

    NumPointUnit_Display2(value, 0xFFFFu, 652u + 30U * temp, 306u, 306u);
    
    //选项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}

uint8_t  MaxLmtTpt_Last = 0u;
uint8_t  MinLmtTpt_Last = 0u;
uint8_t  MinLmtSOC_Last = 0u;
uint16_t MaxChgCrt_Last = 10000u;
uint16_t MaxDchgCrt_Last = 10000u;

//第三页 BMS CAN版本 Life值 允许最高充电电压 允许最高充电电流
void GUI_Middle_001_01_02(void)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }

    /*BMS版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_48, 440U, 182U, 0); /*BMS版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_48, 440U, 182U, 0); /*BMS版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_76, 634U, 187U, 0); /*CAN 英文*/
    
    uint16_t value = Get_ID_18F141F3_Sig_BMS_CANPtcVer();
    
    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_BMS_BMSFltSts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        value = 0u;
    }
    else
    {
        if (value < 10u)
        {
            value = 10u;
        }

        if  (value > 250u)
        {
            value = 250u;
        }
    }
    
    NumPointUnit_Display1(value, 0xFFFFu, 690u, 186u, 186u);
        
    /*Life值*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_04, 440U, 222U, 0u); /*Life值 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_04, 440U, 222U, 0u); /*Life值 文字*/
    }
    value = Get_ID_18F141F3_Sig_BMS_BMSHrtBt();
    NumUnit_Display(value, 0xFFFFu, 634u, 226u, 226u);
        
    /*允许最高充电电压*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_55, 440U, 262U, 0u); /*允许最高充电电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_084_word1, 440U, 253U, 0u); /*允许最高充电电压 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U, 273U, 0u); /*---*/
    
    /*允许最高充电电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_58, 440U, 302U, 0u); /*允许最高充电电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_158_word1, 440U, 293U, 0u); /*允许最高充电电流 文字*/
    }
    
    if (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) == CAN_SIG_NORMAL)
    {
        MaxLmtTpt_Last = 0u;
        MinLmtTpt_Last = 0u;
        MinLmtSOC_Last = 0u;
        MaxChgCrt_Last = 10000u;
        MaxDchgCrt_Last = 10000u;
    }
        
    value = Get_ID_18F140F3_Sig_BMS_MaxChgCrt(); //0.1A
    
    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) != CAN_SIG_RECEIVE)) 
    {
        ;
    }
    else
    {
        if (value > 20000u)
        {
            ;
        }
        else
        {
            MaxChgCrt_Last = value;
        }
    }

    value = MaxChgCrt_Last;
    
    if (value >= 10000u)
    {
        value -= 10000u;
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 634u, 306u, 308u);
    }
    else
    {
        value = 10000u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U, 313U, 0u); /*-*/
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 643u, 306u, 308u);
    }
      
    //选项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}

//第四页 单体最高充电电压 单体最高充电电流 允许最高温度 允许最低温度
void GUI_Middle_001_01_03(void)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }

    //单体最高充电电压
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_62 , 440U, 182U, 0u); /*单体最高充电电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_62 , 440U, 182U, 0u); /*单体最高充电电压 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 70U, 193U, 0u); /*---*/
    
    //单体最高充电电流
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_47 , 440U, 222U, 0u); /*单体最高充电电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_47 , 440U, 222U, 0u); /*单体最高充电电压 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 70U, 233U, 0u); /*---*/
        
    /*允许最高温度*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_54, 440U, 262U, 0); /*允许最高温度 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_54, 440U, 262U, 0); /*允许最高温度 文字*/
    }
    uint8_t value = Get_ID_18F140F3_Sig_BMS_MaxLmtTpt();
    
    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) != CAN_SIG_RECEIVE))
    {
        ;
    }
    else
    {
        if (value > 250u)
        {
            ;
        }
        else
        {
            MaxLmtTpt_Last = value;
        }
    }

    value = MaxLmtTpt_Last;
            
    if (value >= 40u)
    {
        value -= 40u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 634u + temp * 70U, 266u, 265u);
    }
    else
    {
        value = 40u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U + temp * 70U, 273U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 643u + temp * 70U, 266u, 265u);
    }
 
    /*允许最低温度*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_57, 440U, 302U, 0u); /*允许最低温度 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_57, 440U, 302U, 0u); /*允许最低温度 文字*/
    }    
    value = Get_ID_18F140F3_Sig_BMS_MinLmtTpt();
    
    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) != CAN_SIG_RECEIVE))
    {
        ;
    }
    else
    {
        if (value > 250u)
        {
            ;
        }
        else 
        {
             MinLmtTpt_Last = value;
        }
    }

    value = MinLmtTpt_Last;

    if (value >= 40u)
    {
        value -= 40u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 634u + temp * 70U, 306u, 305u);
    }
    else
    {
        value = 40u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634U + temp * 70U, 313U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 643u + temp * 70U, 306u, 305u);
    }
     
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}

//第五页 单体最低SOC 允许最大放电电流 允许最大回收电流 允许最大漏电流
void GUI_Middle_001_01_04(void)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }

    //允许最低SOC
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_61, 440U, 182U, 0u); /*允许最低SOC 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_61, 440U, 182U, 0u); /*允许最低SOC 文字*/
    }
    uint16_t value = Get_ID_18F140F3_Sig_BMS_MinLmtSOC();
    
    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) != CAN_SIG_RECEIVE))
    {
        ;
    }
    else
    {
        if (value > 250u)
        {
            ;
        }
        else
        {
            MinLmtSOC_Last = value;
        }
    }

    value = MinLmtSOC_Last;

    value <<= 1u;
    value /=  5u;

    NumUnit_Display(value, Set_Menu3_Word0_75, 634u + 20U * temp, 186u, 187u);
    
    /*允许最大放电电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_46, 440U, 222U, 0); /*允许最大放电电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_091_word1, 440U, 213U, 0); /*允许最大放电电流 文字*/
    }
    value = Get_ID_18F140F3_Sig_BMS_MaxDchgCrt();
    
    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_BMS_BtyLmtVal_Msg_Count) != CAN_SIG_RECEIVE))
    {
        ;
    }
    else
    {
        if (value > 20000u)
        {
            ;
        }
        else
        {
            MaxDchgCrt_Last = value;
        }
    }

    value = MaxDchgCrt_Last;
    
    if (value >= 10000u)
    {
        value -= 10000u;
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 634u + 20U * temp, 226u, 228u);
    }
    else
    {
        value = 10000u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 634u + 20U * temp, 233U, 0u); /*-*/
        NumPointUnit_Display1(value, Number_18_white_Unit_A, 643u + 20U * temp, 226u, 228u);
    }
        
    /*允许最大回收电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_53, 440U, 262U, 0u); /*允许最大回收电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_092_word1, 440U, 253U, 0u); /*允许最大回收电流 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + 20U * temp, 273U, 0u); /*---*/
    
    /*允许最大漏电流*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_56, 440U, 302U, 0u); /*允许最大漏电流 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_093_word1, 440U, 293U, 0u); /*允许最大漏电流 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + 20U * temp, 313U, 0u); /*---*/
    
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}
//第六页 节点最高温度 节点最低温度 单体最高电压 单体最低电压
void GUI_Middle_001_01_05(void)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }

    //节点最高温度
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_45, 440U, 182U, 0u); /*节点最高温度 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_45, 440U, 182U, 0u); /*节点最高温度 文字*/
    }
    uint16_t value = Get_ID_18F143F3_Sig_BMS_BtyMaxTpt();
    
    if (value >= 0xFEu)
    {
        value = 0u;
    }

    if (value > 250u)
    {
        value = 250u;
    }
    
    if (value >= 40u)
    {
        value -= 40u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 721u, 186u, 185u);
    }
    else
    {
        value = 40u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 721U, 193U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 730u, 186u, 185u);
    }
    
    //位置编号
    value = Get_ID_18F143F3_Sig_BMS_MaxTptPrbNbr();
    NumUnit_Display(value, Set_Menu3_Word0_72_Unit, 635u, 186u, 187u);
    
    //节点最低温度
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_44, 440U, 222U, 0u); /*节点最低温度 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_44, 440U, 222U, 0u); /*节点最低温度 文字*/
    }
    value = Get_ID_18F142F3_Sig_BMS_BtyMinTpt();
    
    if (value >= 0xFEu)
    {
        value = 0u;
    }

    if (value > 250u)
    {
        value = 250u;
    }
    
    if (value >= 40u)
    {
        value -= 40u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 721u, 226u, 225u);
    }
    else
    {
        value = 40u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, 721U, 233U, 0u); /*-*/
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, 730u, 226u, 225u);
    }
    
    //位置编号
    value = Get_ID_18F142F3_Sig_BMS_MinTptPrbNbr();
    NumUnit_Display(value, Set_Menu3_Word0_72_Unit, 635u, 226u, 227u);
    
    //单体最高电压
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_106, 440U, 262U, 0u); /*单体最高电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_106, 440U, 262U, 0u); /*单体最高电压 文字*/
    }
    value = Get_ID_18F146F3_Sig_BMS_MaxCllVtg();
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }

    if (value > 10000u)
    {
        value = 10000u;
    }

    NumPointUnit_Display3(value, Number_18_white_Unit_V, 721u, 266u, 266u);
    
    //位置编号
    value = Get_ID_18F146F3_Sig_BMS_MaxVtgCllNbr();
    NumUnit_Display(value, Set_Menu3_Word0_72_Unit, 635u, 266u, 267u);
        
    //单体最低电压
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_105, 440U, 302U, 0u); /*单体最低电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_105, 440U, 302U, 0u); /*单体最低电压 文字*/
    }
    value = Get_ID_18F144F3_Sig_BMS_MinCllVtg();
    
    if (value >= 0xFFFEu)
    {
        value = 0u;
    }

    if (value > 10000u)
    {
        value = 10000u;
    }

    NumPointUnit_Display3(value, Number_18_white_Unit_V, 721u, 306u, 306u);
    
    //位置编号
    value = Get_ID_18F144F3_Sig_BMS_MinVtgCllNbr();
    NumUnit_Display(value, Set_Menu3_Word0_72_Unit, 635u, 306u, 307u);
    
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}

#define NodeSpace 36u

void BMS_Tpt_Display(uint8_t node, uint8_t value, uint16_t startX, uint16_t axisY)
{
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[node / 10u], startX, axisY, 0u); /*节点十位*/
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[node % 10u], startX, axisY, 0u); /*节点个位*/
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_72_Unit, startX, axisY + 1u, 0u); /*#号*/
    startX += NodeSpace;
    
    if (value >= 0xFEu)
    {
        value = 0u;
    }

    if (value > 250u)
    {
        value = 250u;
    }
    
    if (value >= 40u)
    {
        value -= 40u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, startX, axisY, axisY - 1u);
    }
    else
    {
        value = 40u - value;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line, startX, axisY + 7U, 0u); /*-*/
        startX += 9u;
        NumUnit_Display(value, Set_Menu3_Word0_82_Unit_C, startX, axisY, axisY - 1u);
    }
}

#define NodeSpace1 22u

void BMS_Vtg_Display(uint8_t node, uint16_t value, uint16_t startX, uint16_t axisY)
{
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[node / 100u], startX, axisY, 0u); /*节点百位*/
    node %= 100u;
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[node / 10u], startX, axisY, 0u); /*节点十位*/
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[node % 10u], startX, axisY, 0u); /*节点个位*/
    startX += WordSpace;
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_72_Unit, startX, axisY + 1u, 0u); /*#号*/
    startX += NodeSpace1;
    
    if (value > 60000)
    {
        value = 60000u;
    }

    value /= 10u;

    NumPointUnit_Display2(value, Number_18_white_Unit_V, startX, axisY, axisY);
}

//第七页~第十二页 节点温度
void GUI_Middle_001_01_06(canlib_uint16_t MsgIdx, uint8_t group)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }
    
    uint8_t note = (group << 3u) + 1u;

    //节点号1
    uint8_t value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 0u);
    BMS_Tpt_Display(note, value, 440u, 186u);

    //节点号2
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 1u);
    note++;
    BMS_Tpt_Display(note, value, 664u, 186u);
        
    //节点号3
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 2u);
    note++;
    BMS_Tpt_Display(note, value, 440u, 226u);

    //节点号4
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 3u);
    note++;
    BMS_Tpt_Display(note, value, 664u, 226u);

    //节点号5
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 4u);
    note++;
    BMS_Tpt_Display(note, value, 440u, 266u);

    //节点号6
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 5u);
    note++;
    BMS_Tpt_Display(note, value, 664u, 266u);
        
    //节点号7
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 6u);
    note++;
    BMS_Tpt_Display(note, value, 440u, 306u);

    //节点号8
    value = Get_ID_BMS_RMON_M_Sig_Tpt(MsgIdx, 7u);
    note++;
    BMS_Tpt_Display(note, value, 664u, 306u);
   
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}
//第十三页~ 节点电压
void GUI_Middle_001_01_12(canlib_uint16_t MsgIdx0, canlib_uint16_t MsgIdx1, uint8_t group)
{
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*背景*/
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word0, 535U, 128U, 0u); /*动力电池组 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_DLDCZ_Title_Word1, 453U, 131U, 0u); /*动力电池组 文字*/
    }
    
    uint8_t note = (group << 3u) + 1u;

    //节点号1
    uint16_t value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx0, 0u);
    BMS_Vtg_Display(note, value, 440u, 186u);

    //节点号2
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx0, 2u);
    note++;
    BMS_Vtg_Display(note, value, 638u, 186u);
        
    //节点号3
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx0, 4u);
    note++;
    BMS_Vtg_Display(note, value, 440u, 226u);

    //节点号4
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx0, 6u);
    note++;
    BMS_Vtg_Display(note, value, 638u, 226u);

    //节点号5
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx1, 0u);
    note++;
    BMS_Vtg_Display(note, value, 440u, 266u);

    //节点号6
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx1, 2u);
    note++;
    BMS_Vtg_Display(note, value, 638u, 266u);
        
    //节点号7
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx1, 4u);
    note++;
    BMS_Vtg_Display(note, value, 440u, 306u);

    //节点号8
    value = Get_ID_BMS_RMON_N_Sig_Vtg(MsgIdx1, 6u);
    note++;
    BMS_Vtg_Display(note, value, 638u, 306u);
   
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_BMS));
}
/*************************** 三级菜单 辅助控制器 *****************************/
//第二页 输入电压
void GUI_Middle_001_06_01(void) //001表示二级菜单整车信息,06表示三级菜单辅助控制器,01表示第二页
{
    /*三级菜单 辅助控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_FZKZQ_Title_Word0, 535U, 128U, 0u); /*辅助控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_FZKZQ_Title_Word1, 453U, 131U, 0u); /*辅助控制器 文字*/
    }
    
    /*输入电压*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_01, 440U, 182U, 0u); /*输入电压 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_01, 440U, 182U, 0u); /*输入电压 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_65, 634U, 187U, 0u); /*Radar- 英文*/
    
    NumPointUnit_Display1(0u, Number_18_white_Unit_V, 715u, 186u, 186u);
     
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_SCU));
}
//第一页 产品型号 硬件版本 Boot版本 软件版本
void GUI_Middle_001_06_00(void) //001表示二级菜单整车信息,06表示三级菜单辅助控制器,00表示第一页
{
    /*三级菜单 辅助控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_FZKZQ_Title_Word0, 535U, 128U, 0u); /*辅助控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_FZKZQ_Title_Word1, 453U, 131U, 0u); /*辅助控制器 文字*/
    }
    /*产品型号*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_03, 440U, 182U, 0u); /*产品型号 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_03, 440U, 182U, 0u); /*产品型号 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_67, 634U, 187U, 0u); /*Unknown 英文*/
    
    /*硬件版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_16, 440U, 222U, 0u); /*硬件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_16, 440U, 222U, 0u); /*硬件版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_67, 634U, 227U, 0u); /*Unknown 英文*/
    
    /*Boot版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_14, 440U, 262U, 0u); /*Boot版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_14, 440U, 262U, 0u); /*Boot版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_66, 634U, 267U, 0u); /*Radar-Can 英文*/
    NumPointUnit_Display1(0u, 0xFFFFu, 761u, 266u, 266u);
    
    /*软件版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_37, 440U, 302U, 0u); /*软件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_37, 440U, 302U, 0u); /*软件版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 633U, 306U, 0u); /*个位*//*0.0.00.00.00*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 651U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 657U, 306U, 0u); /*十分位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 675U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 681U, 306U, 0u); /*十位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 699U, 306U, 0u); /*个位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 717U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 723U, 306U, 0u); /*十位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 741U, 306U, 0u); /*个位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 759U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 765U, 306U, 0u); /*十位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 783U, 306U, 0u); /*个位*/
 
    //选择项
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_SCU));
}
/*************************** 三级菜单 绝缘检测仪 *****************************/
/*第二页 Life值 没找到对应报文 暂按样表用0替代*/
void GUI_Middle_001_05_01(void) //001表示二级菜单整车信息,05表示三级菜单绝缘检测仪,01表示第二页
{
    /*三级菜单 绝缘检测仪*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_JYJCY_Title_Word0, 535U, 128U, 0u); /*绝缘检测仪 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_JYJCY_Title_Word1, 453U, 131U, 0u); /*绝缘检测仪 文字*/
    }
    /*Life值*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_04 , 440U, 182U, 0u); /*Life值 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_04 , 440U, 182U, 0u); /*Life值 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 634U, 186U, 0u); /*0 无报文对应 */
    
    //选择项 
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_ISL));
}
/*第一页 正端阻值 负端阻值 绝缘状态 故障等级*/
void GUI_Middle_001_05_00(void) //001表示二级菜单整车信息,05表示三级菜单绝缘检测仪,00表示第一页
{
    /*三级菜单 绝缘检测仪*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_JYJCY_Title_Word0, 535U, 128U, 0u); /*绝缘检测仪 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_JYJCY_Title_Word1, 453U, 131U, 0u); /*绝缘检测仪 文字*/
    }
    
    if (temp == 0u)
    {
        /*正端阻值*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_05, 440U, 182U, 0u); /*正端阻值 文字*/
        /*负端阻值*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_17, 440U, 222U, 0u); /*负端阻值 文字*/
    }
    else
    {
        /*正端阻值*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_05, 440U, 182U, 0u); /*正端阻值 文字*/
        /*负端阻值*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_17, 440U, 222U, 0u); /*负端阻值 文字*/
    }
    
    if (CAN_MSG_Status(ID_BMS_BtyIslRst_Msg_Count) != CAN_SIG_RECEIVE)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + 50U * temp, 193U, 0u); /*---*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + 50U * temp, 233U, 0u); /*---*/
    }
    else
    {
        uint16_t value = Get_ID_18F13FF3_Sig_BMS_PstvIslRst();

        if (value >= 0xFFFEu)
        {
            ;
        }
        else
        {
            if (value > 60000u)
            {
                value = 60000u;
            }

            NumUnit_Display(value, Set_Menu3_Word0_94_unit_kR, 634u + 50U * temp, 186u, 187u);
        }

        value = Get_ID_18F13FF3_Sig_BMS_NgtvIslRst();

        if (value >= 0xFFFEu)
        {
            ;
        }
        else
        {
            if (value > 60000u)
            {
                value = 60000u;
            }

            NumUnit_Display(value, Set_Menu3_Word0_94_unit_kR, 634u + 50U * temp, 226u, 227u);
        }
    }
        
    if (temp == 0u)
    {
        /*绝缘状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_29, 440U, 262U, 0u); /*绝缘状态 文字*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_68, 633U, 265U, 0u); /*未知 文字 无报文对应*/
    
        /*故障等级*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_06, 440U, 302U, 0u); /*故障等级 文字*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_69, 633U, 306U, 0u); /*无 文字 无报文对应*/
    }
    else
    {
        /*绝缘状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_29, 440U, 262U, 0u); /*绝缘状态 文字*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_68, 633U + 50U * temp, 265U, 0u); /*未知 文字 无报文对应*/
    
        /*故障等级*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_06, 440U, 302U, 0u); /*故障等级 文字*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_69, 633U + 50U * temp, 306U, 0u); /*无 文字 无报文对应*/
    }
    
    //选择项 
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_ISL));
}
/**************************** 三级菜单 充电机 ******************************/
/*第一页 此功能暂未启用*/
void GUI_Middle_001_04_00(void) //001表示二级菜单整车信息,04表示三级菜单充电机,00表示第一页
{
    /*三级菜单 充电机*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_CDJ_Title_Word0, 535U, 128U, 0u); /*充电机 文字*/

        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_70, 545U, 228U, 0u); /*此功能暂未启用 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_CDJ_Title_Word1, 453U, 131U, 0u); /*充电机 文字*/

        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_70, 437U, 229U, 0u); /*此功能暂未启用 文字*/
    }

    //选择项  
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_CHG));
}
/**************************** 三级菜单 语言 ******************************/
extern uint8_t Vhcl_Info_LAN_Step;
/*第一页 中文 英文*/
void GUI_Middle_001_09_00(void) //001表示二级菜单整车信息,09表示三级菜单语言,00表示第一页
{
    /*三级菜单 语言*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Yy_6, 596U, 129U, 0u); /*语言 文字*/

        if (Vhcl_Info_LAN_Step == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Yy_8, 594U, 179U, 0u); /*中文 选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_9, 601U, 222U, 0u); /*英文 未选中*/
        }
        else if (Vhcl_Info_LAN_Step == 1u)
        {
            GUI_Translate_Display(Middle_Sprite, Yy_7, 602U, 183U, 0u); /*中文 未选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_10, 593U, 219U, 0u); /*英文 选中*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Yy_7, 602U, 183U, 0u); /*中文 未选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_9, 601U, 222U, 0u); /*英文 未选中*/
        }
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Yy_6_word1, 565U, 132U, 0u); /*语言 文字*/

        if (Vhcl_Info_LAN_Step == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Yy_8_word1, 568U, 183U, 0u); /*中文 选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_9_word1, 582U, 225U, 0u); /*英文 未选中*/
        }
        else if (Vhcl_Info_LAN_Step == 1u)
        {
            GUI_Translate_Display(Middle_Sprite, Yy_7_word1, 583U, 185U, 0u); /*中文 未选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_10_word1, 568U, 222U, 0u); /*英文 选中*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Yy_7_word1, 583U, 185U, 0u); /*中文 未选中*/

            GUI_Translate_Display(Middle_Sprite, Yy_9_word1, 582U, 225U, 0u); /*英文 未选中*/
        }
    }

    if (Vhcl_Info_LAN_Step != 2u)
    {
        //GUI_Translate_Display(Middle_Sprite, Set_Arrow_R, 690U, 187U + Vhcl_Info_LAN_Step * 39U, 0u); /*右三角*/
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word0, 605U, 344U, 0u); /*返回*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_04_Word1, 594U, 346U, 0u); /*返回*/
        }
    }
    else
    {
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_03_Word0, 605U, 344U, 0u); /*返回*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_03_Word1, 594U, 346U, 0u); /*返回*/
        }
    }
}

extern uint32_t ABS_DTC[100u];
extern uint8_t  ABS_DTC_Cnt;
extern uint8_t  ABS_DTC_End;

uint32_t Get_ABS_Sig_SPN(uint8_t Index)
{
    return ((uint32_t)(((ABS_DTC[Index] >> 5u) & 0x00070000ul) | (ABS_DTC[Index]  & 0x0000FFFFul)));
}
//Byte4的低五位
uint8_t Get_ABS_Sig_FMI(uint8_t Index)
{
    return ((uint8_t)((ABS_DTC[Index] >> 16u) & 0x0000001Ful));
}
/**************************** 三级菜单 ABS ******************************/
/*SPN FMI SPN FMI*/
void GUI_Middle_001_07_Sub(uint8_t page) //001表示二级菜单整车信息,07表示三级菜单ABS,page表示第几页
{
    uint8_t index = page * 2u;
    uint8_t temp  = page + 1u;

    /*三级菜单 ABS*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t lang = LanguageTyp_Get();
    if (lang == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ABS_Title_Word0, 535U, 128U, 0); /*ABS*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ABS_Title_Word1, 453U, 131U, 0); /*ABS*/
    }
    
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_72_Unit, 535U + 66U, 162U, 0); /*#*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + temp / 10u, 552U + 66U, 162U, 0); /*十位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + temp % 10u, 569U + 66U, 162U, 0); /*个位*/
    
    if (lang == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_02, 440U, 182U, 0); /*SPN*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_15, 440U, 222U, 0); /*FMI*/

        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_02, 440U, 262U, 0); /*SPN*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_15, 440U, 302U, 0); /*FMI*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_02, 440U, 182U, 0); /*SPN*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_15, 440U, 222U, 0); /*FMI*/

        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_02, 440U, 262U, 0); /*SPN*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_15, 440U, 302U, 0); /*FMI*/
    }
    if ((ABS_DTC_End == 0u) || (index >= ABS_DTC_Cnt))
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 195U, 0); /*---*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 235U, 0); /*---*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 275U, 0); /*---*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 315U, 0); /*---*/
    }
    else
    {
        NumUnit_Display(Get_ABS_Sig_SPN(index), 0xFFFFu, 634u, 186u, 186u);
        NumUnit_Display(Get_ABS_Sig_FMI(index), 0xFFFFu, 634u, 226u, 226u);

        if (ABS_DTC_Cnt == (index + 1u))
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 275U, 0); /*---*/
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_line3, 635U, 315U, 0); /*---*/
        }
        else
        {
            NumUnit_Display(Get_ABS_Sig_SPN(index + 1u), 0xFFFFu, 634u, 266u, 266u);
            NumUnit_Display(Get_ABS_Sig_FMI(index + 1u), 0xFFFFu, 634u, 306u, 306u);
        }
    }
    
    //选择项  
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_ABS));
}

static const uint16_t ImageID_Gear[] = 
{
    Gear_N,
    Gear_R,
    Gear_D1,
    Gear_D2,
    Gear_D3,
    Gear_D4,
    Gear_D5,
    Gear_D6,
    Gear_P,
    Gear_D,
};

static const uint16_t ImageID_Gear_1[] = 
{
    Set_Menu3_Word0_87,
    Set_Menu3_Word0_96,
    Set_Menu3_Word0_97,
    Set_Menu3_Word0_98,
    Set_Menu3_Word0_99,
    Set_Menu3_Word0_100,
    Set_Menu3_Word0_101,
    Set_Menu3_Word0_102,
    Set_Menu3_Word0_96_P,
    Set_Menu3_Word0_96_D,
};

/*************************** 三级菜单 整车控制器 *****************************/
/*第一页 整车状态 互锁状态 自检状态 挡位状态*/
void GUI_Middle_001_02_00(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,00表示第一页
{
    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    }
    /*整车状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_12, 440U, 182U, 0u); /*整车状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_12, 440U, 182U, 0u); /*整车状态 文字*/
    }
    
    if (Get_ID_18F101D0_Sig_VCU_VhclSts())
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_90, 633U, 186U, 0u); /*READY 英文*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_90, 633U, 187U, 0u); /*READY 英文*/
        }
    }
    else
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_84, 633U, 187U, 0u); /*WAIT 英文*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_84, 633U, 186U, 0u); /*WAIT 英文*/
        } 
    }
    
    /*互锁状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_25, 440U, 222U, 0u); /*互锁状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_25, 440U, 222U, 0u); /*互锁状态 文字*/
    }
    uint8_t tmp = Get_ID_18F101D0_Sig_VCU_SysIntlck();
    
    if (tmp == 1u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_92, 633U, 225U, 0u); /*充电互锁 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_92, 633U, 226U, 0u); /*充电互锁 文字*/
        }
    }
    else if (tmp == 2u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_93, 633U, 225U, 0u); /*尾门互锁 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_93, 633U, 226U, 0u); /*尾门互锁 文字*/
        }
    }
    else
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_85, 633U, 225U, 0u); /*未互锁 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_85, 633U, 226U, 0u); /*未互锁 文字*/
        }
    }

    /*自检状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_35, 440U, 262U, 0u); /*自检状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_35, 440U, 262U, 0u); /*自检状态 文字*/
    }
    
    tmp = Get_ID_18F101D0_Sig_VCU_SlftstSts();
    
    if (tmp == 0u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_86, 633U, 265U, 0u); /*自检中 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_86, 633U, 266U, 0u); /*自检中 文字*/
        }
    }
    else if (tmp == 1u)
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_95, 633U, 265U, 0u); /*成功 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_95, 633U, 266U, 0u); /*成功 文字*/
        }
    }
    else
    {
        if (temp == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_94, 633U, 265U, 0u); /*失败 文字*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_94, 633U, 266U, 0u); /*失败 文字*/
        }
    }
    
    /*挡位状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_42, 440U, 302U, 0u); /*档位状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_42, 440U, 302U, 0u); /*档位状态 文字*/
    }   
    
    if (Gear_Get_Value() < 10u)
    {
        GUI_Translate_Display(Middle_Sprite, ImageID_Gear_1[Gear_Get_Value()], 634U, 307U, 0); /*档位*/
    }

    //选择项     
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*第二页 续航里程 加速踏板 制动踏板 故障数量*/
void GUI_Middle_001_02_01(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,01表示第二页
{
    uint16_t value = 0u;

    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    }
    /*续航里程*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_11, 440U, 182U, 0u); /*续航里程 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_11, 440U, 182U, 0u); /*续航里程 文字*/
    }
    
    if (CAN_MSG_Status(ID_BMS_BMSSts_Msg_Count) != CAN_SIG_RECEIVE)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 20U, 193U, 0u); /*---*/
    }
    else
    {
        value  = SOC_Get_DesVal();
        value *= 20u;
        value /= 100u;
        NumUnit_Display(value, Number_18_white_Unit_km, 634u, 186u, 183u);
    }
    
    /*加速踏板*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_24, 440U, 222U, 0u); /*加速踏板 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_24, 440U, 222U, 0u); /*加速踏板 文字*/
    }
    
    value = Get_ID_18F103D0_Sig_VCU_ActPdlDgr(); //0.4%

    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_VCU_VCUSts2_Msg_Count) != CAN_SIG_RECEIVE))
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 636U + temp * 20U, 233U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 654U + temp * 20U, 233U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_75, 674U + temp * 20U, 228U, 0u); /*%*/
    }
    else
    {
        if (value > 250u)
        {
            value = 250u;
        }

        value <<= 1u;
        value /= 5u;
        
        NumUnit_Display(value, Set_Menu3_Word0_75, 634u + temp * 20U, 226u, 228u);
    }

    /*制动踏板*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_34, 440U, 262U, 0u); /*制动踏板 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_34, 440U, 262U, 0u); /*制动踏板 文字*/
    }
    
    value = Get_ID_18F103D0_Sig_VCU_BrkPdlDgr(); //0.4%

    if ((value >= 0xFEu) || (CAN_MSG_Status(ID_VCU_VCUSts2_Msg_Count) != CAN_SIG_RECEIVE))
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 636U + temp * 20U, 273U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 654U + temp * 20U, 273U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_75, 674U + temp * 20U, 268U, 0u); /*%*/
    }
    else
    {
        if (value > 250u)
        {
            value = 250u;
        }

        value <<= 1u;
        value /= 5u;
        
        NumUnit_Display(value, Set_Menu3_Word0_75, 634u + temp * 20U, 266u, 268u);
    }

    /*故障数量*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_21, 440U, 302U, 0u); /*故障数量 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_21, 440U, 302U, 0u); /*故障数量 文字*/
    }

    value = Get_ID_18F101D0_Sig_VCU_SysTtlFlt();
    
    if (value >= 0xFEu)
    {
        value = 0u;
    }

    if (value > 60u)
    {
        value = 60u;
    }
    
    NumUnit_Display(value, 0xFFFFu, 634u + temp * 20U, 306u, 306u);

    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*第三页 故障等级 故障码 DC/DC状态 气泵状态*/
void GUI_Middle_001_02_02(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,02表示第三页
{
    uint16_t value = 0u;

    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    }
    /*故障等级*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_06, 440U, 182U, 0u); /*故障等级 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_06, 440U, 182U, 0u); /*故障等级 文字*/
    }
    value = Get_ID_18F101D0_Sig_VCU_MaxFltLv();
    GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[value], 634U, 186U, 0u); /*故障等级 数字*/
    
    /*故障码*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_18, 440U, 222U, 0u); /*故障码 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_18, 440U, 222U, 0u); /*故障码 文字*/
    }

    value = Get_ID_18F101D0_Sig_VCU_SysDTC(); 
    
    NumUnit_Display(value, 0xFFFFu, 634u, 226u, 226u);
    
    if (temp == 0u)
    {
        /*DC/DC状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_59, 440U, 262U, 0u); /*DC/DC状态 文字*/
        /*气泵状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_41, 440U, 302U, 0u); /*气泵状态 文字*/
    }
    else
    {
        /*DC/DC状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_59, 440U, 262U, 0u); /*DC/DC状态 文字*/
        /*气泵状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_41, 440U, 302U, 0u); /*气泵状态 文字*/
    }
    
    if (CAN_MSG_Status(ID_VCU_MutiOneSts_Msg_Count) != CAN_SIG_RECEIVE)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U, 269U, 0u); /*---*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U, 309U, 0u); /*---*/
    }
    else
    {
        value = Get_ID_18F105D0_Sig_VCU_DCDCSts();
        
        if (value == 1u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_103, 634U, 267U, 0u); /*ON 英文*/
            }    
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_103, 634U, 267U, 0u); /*ON 英文*/
            }    
        }
        else if (value == 2u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U, 267U, 0u); /*Warn 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U, 267U, 0u); /*Warn 英文*/
            }
        }
        else
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U, 267U, 0u); /*OFF 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_89, 634U, 267U, 0u); /*OFF 英文*/
            }
        }
        
        value = Get_ID_18F105D0_Sig_VCU_ACMSts();
        
        if (value == 1u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_103, 634U, 307U, 0u); /*ON 英文*/
            }    
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_103, 634U, 307U, 0u); /*ON 英文*/
            }    
        }
        else if (value == 2u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U, 307U, 0u); /*Warn 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U, 307U, 0u); /*Warn 英文*/
            }
        }
        else
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U, 307U, 0u); /*OFF 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_89, 634U, 307U, 0u); /*OFF 英文*/
            }
        }
    }
    
    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*第四页 助力状态 水泵状态 空调状态 风扇状态*/
void GUI_Middle_001_02_03(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,03表示第四页
{
    uint16_t value = 0u;

    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    }
    
    if (temp == 0u)
    {
        /*助力状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_10, 440U, 182U, 0u); /*助力状态 文字*/
        /*空调状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_33, 440U, 262U, 0u); /*空调状态 文字*/
    }
    else
    {
        /*助力状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_10, 440U, 182U, 0u); /*助力状态 文字*/
        /*空调状态*/
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_33, 440U, 262U, 0u); /*空调状态 文字*/
    }
    
    if (CAN_MSG_Status(ID_VCU_MutiOneSts_Msg_Count) != CAN_SIG_RECEIVE)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 30U, 189U, 0u); /*---*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 30U, 269U, 0u); /*---*/
    }
    else
    {
        value = Get_ID_18F105D0_Sig_VCU_EPSSts();
        
        if (value == 1u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_103, 634U + temp * 30U, 187U, 0u); /*ON 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_103, 634U + temp * 30U, 187U, 0u); /*ON 英文*/
            }
        }
        else if (value == 2u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U + temp * 30U, 187U, 0u); /*Warn 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U + temp * 30U, 187U, 0u); /*Warn 英文*/
            }
        }
        else
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U + temp * 30U, 187U, 0u); /*OFF 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_89, 634U + temp * 30U, 187U, 0u); /*OFF 英文*/
            }
        }
        
        value = Get_ID_18F105D0_Sig_VCU_ACSts();
        
        if (value == 1u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_103, 634U + temp * 30U, 267U, 0u); /*ON 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_103, 634U + temp * 30U, 267U, 0u); /*ON 英文*/
            }
        }
        else if (value == 2u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U + temp * 30U, 267U, 0u); /*Warn 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U + temp * 30U, 267U, 0u); /*Warn 英文*/
            }
        }
        else
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U + temp * 30U, 267U, 0u); /*OFF 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_89, 634U + temp * 30U, 267U, 0u); /*OFF 英文*/
            }
        }
    }
    
    /*水泵状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_23, 440U, 222U, 0u); /*水泵状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_23, 440U, 222U, 0u); /*水泵状态 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 30U, 233U, 0u); /*--- 无信号对应*/
    /*风扇状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_40, 440U, 302U, 0u); /*风扇状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_40, 440U, 302U, 0u); /*风扇状态 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 30U, 313U, 0u); /*--- 无信号对应*/
        
    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*第五页 加热状态 除霜状态 VCU版本 Life值*/
void GUI_Middle_001_02_04(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,02表示第五页
{
    uint16_t value = 0u;

    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    }
    /*加热状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_09, 440U, 182U, 0u); /*加热状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_09, 440U, 182U, 0u); /*加热状态 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U, 193U, 0u); /*--- 无信号对应*/
    /*除霜状态*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_22, 440U, 222U, 0u); /*除霜状态 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_22, 440U, 222U, 0u); /*除霜状态 文字*/
    }
    
    if (CAN_MSG_Status(ID_VCU_MutiOneSts_Msg_Count) != CAN_SIG_RECEIVE)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U, 233U, 0u); /*---*/
    }
    else
    {
        value = Get_ID_18F105D0_Sig_VCU_PTCSts();
        
        if (value == 1u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_103, 634U, 227U, 0u); /*ON 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_103, 634U, 227U, 0u); /*ON 英文*/
            }
        }
        else if (value == 2u)
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_78, 634U, 227U, 0u); /*Warn 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_78, 634U, 227U, 0u); /*Warn 英文*/
            }
        }
        else
        {
            //if (temp == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U, 227U, 0u); /*OFF 英文*/
            }
            //else
            {
                //GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_89, 634U, 227U, 0u); /*OFF 英文*/
            }
        }
    }
    
    /*VCU版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_32, 440U, 262U, 0u); /*VCU版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_32, 440U, 262U, 0u); /*VCU版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_V, 634U, 266U, 0u); /*V*/
    value = Get_ID_18F103D0_Sig_VCU_SwrVrsNbr();
    NumPointUnit_Display1(value, 0xFFFFu, 654u, 266u, 266u);
    
    /*Life值*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_04, 440U, 302U, 0u); /*Life值 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_04, 440U, 302U, 0u); /*Life值 文字*/
    }
    value = Get_ID_18F101D0_Sig_VCU_HrtBt();
    NumUnit_Display(value, 0xFFFFu, 634u, 306u, 306u);
        
    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*第六页 真空罐压力*/
void GUI_Middle_001_02_05(void) //001表示二级菜单整车信息,02表示三级菜单整车控制器,02表示第五页
{
    uint16_t value = 0u;
    
    /*三级菜单 整车控制器*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    uint8_t temp = LanguageTyp_Get();
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word0, 535U, 128U, 0u); /*整车控制器 文字*/
    
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_115, 440U, 182U, 0u); /*真空罐压力 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZCKZQ_Title_Word01, 453U, 131U, 0u); /*整车控制器 文字*/
    
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_115, 440U, 182U, 0u); /*真空罐压力 文字*/
    }
    value = Get_ID_18F103D0_Sig_VCU_VcmPmpPrsvl(); //0.01kpa

    if ((value >= 0xFFFEu) || (CAN_MSG_Status(ID_VCU_VCUSts2_Msg_Count) != CAN_SIG_RECEIVE))
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 636U + temp * 50U, 193U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, 655U + temp * 50U, 193U, 0u); /*-*/
        GUI_Translate_Display(Middle_Sprite, kpa, 674U + temp * 50U, 186U, 0u); /*kpa*/
    }
    else
    {
        value /= 100u;
        NumUnit_Display(value, kpa, 634u + temp * 50U, 186u, 186u);
    }

    //选择项    
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_VCU));
}
/*************************** 三级菜单 组合仪表 *****************************/
/*第一页 硬件版本 软件版本 BOOT版本 图文版本*/
void GUI_Middle_001_00_00(void) //001表示二级菜单整车信息,0表示三级菜单组合仪表,00表示第一页
{
    uint8_t temp = LanguageTyp_Get();
    /*三级菜单 组合仪表*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZHYB_Title_Word0, 535U, 128U, 0u); /*组合仪表 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZHYB_Title_Word1, 453U, 131U, 0u); /*组合仪表 文字*/
    }

    /*硬件版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_16, 440U, 182U, 0u); /*硬件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_16, 440U, 182U, 0u); /*硬件版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F193[1u] - 0x30u, 633U, 186U, 0u); /*个位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 651U, 197U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F193[3u] - 0x30u, 657U, 186U, 0u); /*十分位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 675U, 197U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F193[5u] - 0x30u, 681U, 186U, 0u); /*百分位*/
    
    /*软件版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_37, 440U, 222U, 0u); /*软件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_37, 440U, 222U, 0u); /*软件版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F195[1u] - 0x30u, 633U, 226U, 0u); /*个位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 651U, 237U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F195[3u] - 0x30u, 657U, 226U, 0u); /*十分位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 675U, 237U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + Ser22_DID_F195[5u] - 0x30u, 681U, 226U, 0u); /*百分位*/

    /*BOOT版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_14, 440U, 262U, 0u); /*BOOT版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_14, 440U, 262U, 0u); /*BOOT版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_1, 633U, 266U, 0u); /*个位*//*1.0.2*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 651U, 277U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0, 657U, 266U, 0u); /*十分位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 675U, 277U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_2, 681U, 266U, 0u); /*十位*/
        
    /*图文版本*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_27, 440U, 302U, 0u); /*图文版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_27, 440U, 302U, 0u); /*图文版本 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_1, 633U, 306U, 0u); /*个位*//*1.1.2*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 651U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_1, 657U, 306U, 0u); /*十分位*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_point, 675U, 317U, 0u); /*小数点*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_2, 681U, 306U, 0u); /*十位*/

    //选择项     
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_IC));
}
/*第二页 实时车速 轮胎滚动半径 主减速比 倒车影像功能*/
void GUI_Middle_001_00_01(void) //001表示二级菜单整车信息,0表示三级菜单组合仪表,01表示第二页
{
    uint8_t temp = LanguageTyp_Get();
    /*三级菜单 组合仪表*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZHYB_Title_Word0, 535U, 128U, 0u); /*组合仪表 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_ZHYB_Title_Word1, 453U, 131U, 0u); /*组合仪表 文字*/
    }
    /*实时车速*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_43, 440U, 182U, 0u); /*实时车速 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_43, 440U, 182U, 0u); /*实时车速 文字*/
    }
    uint16_t value = Get_ID_18F101D0_Sig_VCU_VhclSpd();
    if (value != 0u)
    {
        NumPointUnit_Display2(value, Set_Menu3_Word0_81_Unit_kmh, 634u + temp * 40U, 186u, 186u);
    }
    else
    {
        NumPointUnit_Display1(value, Set_Menu3_Word0_81_Unit_kmh, 634u + temp * 40U, 186u, 186u); 
    }
        
    /*轮胎滚动半径*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_52, 440U, 222U, 0u); /*轮胎滚动半径 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_52, 440U, 222U, 0u); /*轮胎滚动半径 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 40U, 233U, 0u); /*---*/
    GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_88, 666U + temp * 40U, 229U, 0u); /*mm*/

    /*主减速比*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_26, 440U, 262U, 0u); /*主减速比 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_26, 440U, 262U, 0u); /*主减速比 文字*/
    }
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Line3, 634U + temp * 40U, 273U, 0u); /*---*/
        
    /*倒车影像*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_36, 440U, 302U, 0u); /*倒车影像 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_36, 440U, 302U, 0u); /*倒车影像 文字*/
    }
    value = VdoFmtTyp_Get();
    
    if (value == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_89, 634U + temp * 40U, 307U, 0u); /*OFF 英文*/
    }
    else if (value == 1u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_104, 634U + temp * 40U, 307U, 0u); /*NTSC 英文*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_79, 634U + temp * 40U, 307U, 0u); /*PAL 英文*/
    }

    //选择项     
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_IC));
}
void GUI_Middle_001_08_Sub(uint16_t Image, uint8_t *vNum, uint16_t adressY)
{
    uint16_t adressX = 653u;

    GUI_Translate_Display(Middle_Sprite, Image, 440u, adressY - 4u, 0u); /*xxx版本号 文字*/
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_V, 633U, adressY, 0u); /*V*/
    
    if (vNum[0u] == 0xFFu)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, adressY + 7u, 0u); /*主版本十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, adressY + 7u, 0u); /*主版本个位*/
        adressX += 18u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_point, adressX, adressY + 12u, 0u); /*.*/
        adressX += 6u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, adressY + 7u, 0u); /*次版本高位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, adressY + 7u, 0u); /*次版本低位*/
    }
    else
    {
        uint8_t  dig[4u];
        
        dig[0u] = vNum[0u] / 10u;
        dig[1u] = vNum[0u] % 10u;
        
        if (vNum[1u] > 9u)
        {
            vNum[1u] = 9u;
        }
        dig[2u] = vNum[1u];
        
        if (vNum[2u] > 9u)
        {
            vNum[2u] = 9u;
        }
        dig[3u] = vNum[2u];
    
        if (dig[0u])
        {
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[0u], adressX, adressY, 0u); /*主版本十位*/
            adressX += 17u;
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[1u], adressX, adressY, 0u); /*主版本个位*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[1u], adressX, adressY, 0u); /*主版本个位*/
        }
        adressX += 18u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_point, adressX, adressY + 12u, 0u); /*.*/
        adressX += 6u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[2u], adressX, adressY, 0u); /*次版本高位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[3u], adressX, adressY, 0u); /*次版本低位*/
    }
}
/*************************** 三级菜单 软件版本 *****************************/
#pragma ghs section bss=".myNonInitArea" //buckupRAM区
uint8_t VCU_VER_NUM[5u];
uint8_t MCU_VER_NUM[3u];
uint8_t PDU_VER_NUM[3u];
uint8_t DCDC_VER_NUM[3u];
uint8_t EHPS_VER_NUM[3u];
uint8_t ACM_VER_NUM[3u];
#pragma ghs section bss=default

/*第一页 MCU版本号 PDU版本号 DCDC版本号 EHPS版本号*/
void GUI_Middle_001_08_00(void) //001表示二级菜单整车信息,8表示三级菜单软件版本,00表示第一页
{
    uint8_t tmp[3u];
    uint8_t temp = LanguageTyp_Get();
    /*三级菜单 软件版本*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word0, 524U, 128U, 0u); /*软件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word1, 454U, 129U, 0u); /*软件版本 文字*/
    }
    /*MCU版本号*/
    if (CAN_MSG_Status(ID_MCU_VER_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ;
    }
    else
    {
        MCU_VER_NUM[0u] = Get_ID_18FF2F82_Sig_MCU_SW1();
        MCU_VER_NUM[1u] = Get_ID_18FF2F82_Sig_MCU_SW2H();
        MCU_VER_NUM[2u] = Get_ID_18FF2F82_Sig_MCU_SW2L();
    }

    tmp[0u] = MCU_VER_NUM[0u];
    tmp[1u] = MCU_VER_NUM[1u];
    tmp[2u] = MCU_VER_NUM[2u];

    if (temp == 0u)
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word0_114, tmp, 186u);
    }
    else
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word1_114, tmp, 186u);
    }
    /*PDU版本号*/
    if (CAN_MSG_Status(ID_PDU_VER_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ; 
    }
    else
    {
        PDU_VER_NUM[0u] = Get_ID_18FF2FF3_Sig_PDU_SW1();
        PDU_VER_NUM[1u] = Get_ID_18FF2FF3_Sig_PDU_SW2H();
        PDU_VER_NUM[2u] = Get_ID_18FF2FF3_Sig_PDU_SW2L();
    }
    
    tmp[0u] = PDU_VER_NUM[0u];
    tmp[1u] = PDU_VER_NUM[1u];
    tmp[2u] = PDU_VER_NUM[2u];

    if (temp == 0u)
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word0_113, tmp, 226u);
    }
    else
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word1_113, tmp, 226u);
    }
    /*DCDC版本号*/
    if (CAN_MSG_Status(ID_DCDC_VER_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ; 
    }
    else
    {
        DCDC_VER_NUM[0u] = Get_ID_18FF2F85_Sig_DCDC_SW1();
        DCDC_VER_NUM[1u] = Get_ID_18FF2F85_Sig_DCDC_SW2H();
        DCDC_VER_NUM[2u] = Get_ID_18FF2F85_Sig_DCDC_SW2L();
    }

    tmp[0u] = DCDC_VER_NUM[0u];
    tmp[1u] = DCDC_VER_NUM[1u];
    tmp[2u] = DCDC_VER_NUM[2u];

    if (temp == 0u)
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word0_112, tmp, 266u);
    }
    else
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word1_112, tmp, 266u);
    }
    /*EHPS版本号*/
    
    if (CAN_MSG_Status(ID_EHPS_VER_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ; 
    }
    else
    {
        EHPS_VER_NUM[0u] = Get_ID_18FF2F95_Sig_DCAC_SW1();
        EHPS_VER_NUM[1u] = Get_ID_18FF2F95_Sig_DCAC_SW2H();
        EHPS_VER_NUM[2u] = Get_ID_18FF2F95_Sig_DCAC_SW2L();
    }

    tmp[0u] = EHPS_VER_NUM[0u];
    tmp[1u] = EHPS_VER_NUM[1u];
    tmp[2u] = EHPS_VER_NUM[2u];
    if (temp == 0u)
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word0_109, tmp, 306u);
    }
    else
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word1_109, tmp, 306u);
    }
    //选择项     
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_SW));
}

/*第二页 ACM版本号 VCU版本号*/
void GUI_Middle_001_08_01(void) //001表示二级菜单整车信息,8表示三级菜单软件版本,01表示第二页
{
    uint8_t  tmp[5u];
    uint16_t adressX = 583u;
    
    /*三级菜单 软件版本*/
    uint8_t temp = LanguageTyp_Get();
    /*三级菜单 软件版本*/
    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*三级菜单 背景*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word0, 524U, 128U, 0u); /*软件版本 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu2_28_Word1, 454U, 129U, 0u); /*软件版本 文字*/
    }

    /*ACM版本号*/
    if (CAN_MSG_Status(ID_ACM_VER_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ; 
    }
    else
    {
        ACM_VER_NUM[0u] = Get_ID_18FF2F9B_Sig_DCAC_B_SW1();
        ACM_VER_NUM[1u] = Get_ID_18FF2F9B_Sig_DCAC_B_SW2H();
        ACM_VER_NUM[2u] = Get_ID_18FF2F9B_Sig_DCAC_B_SW2L();
    }

    tmp[0u] = ACM_VER_NUM[0u];
    tmp[1u] = ACM_VER_NUM[1u];
    tmp[2u] = ACM_VER_NUM[2u];

    if (temp == 0u)
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word0_110, tmp, 186u);
    }
    else
    {
        GUI_Middle_001_08_Sub(Set_Menu3_Word1_110, tmp, 186u);
    }
    /*VCU版本号*/
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word0_111, 440u, 222u, 0u); /*VCU版本号 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Set_Menu3_Word1_111, 440u, 222u, 0u); /*VCU版本号 文字*/
    }
    if (CAN_MSG_Status(ID_VCU_SV_Msg_Count) != CAN_SIG_RECEIVE)
    {
        ;    
    }
    else
    {    
        VCU_VER_NUM[0u] = Get_ID_18F10BD0_Sig_VCU_MajorVers();
        VCU_VER_NUM[1u] = Get_ID_18F10BD0_Sig_VCU_MinorVers();
        VCU_VER_NUM[2u] = Get_ID_18F10BD0_Sig_VCU_WrittenYear();
        VCU_VER_NUM[3u] = Get_ID_18F10BD0_Sig_VCU_WrittenMonth();
        VCU_VER_NUM[4u] = Get_ID_18F10BD0_Sig_VCU_WrittenDay();
    }

    if (VCU_VER_NUM[0u] == 0xFFu)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*年千位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*年百位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*年十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*年个位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*月十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*月个位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*日十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*日个位*/
    }    
    else
    {    
        tmp[0u] = VCU_VER_NUM[0u];
        tmp[1u] = VCU_VER_NUM[1u];
        tmp[2u] = VCU_VER_NUM[2u];
        tmp[3u] = VCU_VER_NUM[3u];
        tmp[4u] = VCU_VER_NUM[4u];

        GUI_Translate_Display(Middle_Sprite, Number_18_white_2, adressX, 226u, 0u); /*年千位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[2u] / 100u, adressX, 226u, 0u); /*年百位*/
        adressX += 17u;
        tmp[2u] %= 100u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[2u] / 10u, adressX, 226u, 0u); /*年十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[2u] % 10u, adressX, 226u, 0u); /*年个位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[3u] / 10u, adressX, 226u, 0u); /*月十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[3u] % 10u, adressX, 226u, 0u); /*月个位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[4u] / 10u, adressX, 226u, 0u); /*日十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + tmp[4u] % 10u, adressX, 226u, 0u); /*日个位*/
    }
    
    adressX += 19u;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX, 239u, 0u); /*_*/
    adressX += 13u;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_Unit_V, adressX, 226u, 0u); /*V*/
    adressX += 17u;
    
    if (VCU_VER_NUM[0u] == 0xFFu)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*主版本十位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*主版本个位*/
        adressX += 18u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_point, adressX, 238u, 0u); /*.*/
        adressX += 6u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*次版本高位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, adressX + 2u, 233u, 0u); /*次版本低位*/
    }
    else
    {
        uint8_t  dig[4u];
        
        dig[0u] = tmp[0u] / 10u;
        dig[1u] = tmp[0u] % 10u;
        
        if (tmp[1u] > 99u)
        {
            tmp[1u] = 99u;
        }
        dig[2u] = tmp[1u] / 10u;
        dig[3u] = tmp[1u] % 10u;
    
        if (dig[0u])
        {
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[0u], adressX, 226u, 0u); /*主版本十位*/
            adressX += 17u;
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[1u], adressX, 226u, 0u); /*主版本个位*/
        }
        else
        {
            GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[1u], adressX, 226u, 0u); /*主版本个位*/
        }
        adressX += 18u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_point, adressX, 238u, 0u); /*.*/
        adressX += 6u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[2u], adressX, 226u, 0u); /*次版本高位*/
        adressX += 17u;
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + dig[3u], adressX, 226u, 0u); /*次版本低位*/
    }
    
    //选择项     
    Menu_Set_Subroutineu(Info_Select_Get(Vhcl_Info_SW));
}
//操作报警显示文字
static const uint16_t GenPopID[2u][12u] = 
{
    {
        Alarm_115_Word0,     //请及时保养车辆
        Alarm_125_Word0,     //车辆处于非经济模式下
        Alarm_word0_13,      //超速警报
        Alarm_112_Word0,     //车门未关闭
        Alarm_111_Word0,     //请系好安全带
        Alarm_135_Word0,     //手刹未释放
        Alarm_123_Word0,     //请拉手刹
        Alarm_word0_04,      /*制动气压低*/
        Alarm_127_Word0,     //你已离座，请注意安全
        Alarm_128_Word0,     //水位低报警
        Alarm_114_Word0,     //无权限车辆
        Alarm_08_Word0,      //操作警报
    },
    {
        Alarm_115_word1,     //请及时保养车辆
        Alarm_125_word1,     //车辆处于非经济模式下
        Alarm_word1_13,      //超速警报
        Alarm_112_word1,     //车门未关闭
        Alarm_111_word1,     //请系好安全带
        Alarm_135_word1,     //手刹未释放
        Alarm_123_word1,     //请拉手刹
        Alarm_word1_04,      /*制动气压低*/
        Alarm_127_word3,     //你已离座，请注意安全
        Alarm_128_word1,     //水位低报警
        Alarm_114_word1,     //无权限车辆
        Alarm_08_word1,      //操作警报
    },
};
static const uint16_t GenPopID_XY[2u][12u][2u] = 
{
    {
        {526u, 261u},        //0 请及时保养车辆
        {526u, 259u},        //1 车辆处于非经济模式下
        {525u, 259u},        //2 超速警报
        {526u, 260u},        //3 车门未关闭
        {526u, 260u},        //4 请系好安全带
        {577u, 260u},        //5 手刹未释放
        {594u, 260u},        //6 请拉手刹
        {525u, 259u},        //7 制动气压低
        {527u, 260u},        //8 你已离座，请注意安全
        {583u, 260u},        //9 水位低报警
        {526u, 260u},        //10 无权限车辆
        {562u, 159u},        //11 操作警报
    },
    {
        {442u, 260u},        //0 请及时保养车辆
        {442u, 261u},        //1 车辆处于非经济模式下
        {430u, 247u},        //2 超速警报
        {442u, 261u},        //3 车门未关闭
        {442u, 261u},        //4 请系好安全带
        {430u, 247u},        //5 手刹未释放
        {430u, 247u},        //6 请拉手刹
        {430u, 247u},        //7 制动气压低
        {430u, 247u},        //8 你已离座，请注意安全
        {430u, 247u},        //9 水位低报警
        {442u, 261u},        //10 无权限车辆
        {459u, 159u},        //11 操作警报
    },
};

//显示操作报警
void GUI_General_Popup_Display(uint8_t PopupMsg, uint8_t typ)
{
    uint16_t image = 0u;
    uint8_t  temp  = LanguageTyp_Get();
    if (typ == 0u)
    {
        image = 15u;
    }
    
    GUI_Translate_Display(Middle_Sprite, GenPopID[temp][11u], GenPopID_XY[temp][11u][0u], GenPopID_XY[temp][11u][1u] + image, typ); /*操作警报 文字*/
    PopupMsg -= POPUP_MSG_BMS_BMS3 + 1u;
    
    if (PopupMsg >= 7u)
    {
        PopupMsg++;
    }
    GUI_Translate_Display(Middle_Sprite, GenPopID[temp][PopupMsg], GenPopID_XY[temp][PopupMsg][0u], GenPopID_XY[temp][PopupMsg][1u], typ); /*报警内容 文字*/
}
//显示故障码和说明 image=说明文字,为0xFFFF时无,value=故障码,type=1级报警故障码最小值类型,0=151开始,1=101开始
void GUI_Popup_Level_Display(uint16_t image, uint16_t value, uint8_t type, uint8_t typ)
{
    uint8_t offsetX = 0u;
    uint8_t offsetY = 0u;
    uint8_t limit1  = 151u;

    uint8_t temp = LanguageTyp_Get();

    if ((image == 0xFFFFu) && (typ != 0u)) //无对应故障说明
    {
        offsetY = 25u; 
    }

    if (type == 1u)          //类别1
    {
        limit1 = 101u;
    }

    if (value >= 100u)
    {
        ;
    }
    else if (value >= 10u)
    {
        offsetX = 9u;        //2位数后移半位
    }
    else
    {
        offsetX = 18u;       //1位数后移一位
    }
    
    GUI_Translate_Display(Middle_Sprite, Alarm_02_Word1, 572U + offsetX, 264U + offsetY, 0u); /*Lv 英文*/

    if (value < 51u)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_3, 610U + offsetX, 266U + offsetY, 0u); /*3*/
    }
    else if (value < limit1)
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_2, 610U + offsetX, 266U + offsetY, 0u); /*2*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Number_18_white_1, 610U + offsetX, 266U + offsetY, 0u); /*1*/
    }
    
    GUI_Translate_Display(Middle_Sprite, Alarm_05_Image, 641U + offsetX, 273u + offsetY, 0u); /*-*/
    
    NumUnit_Display(value, 0xFFFFu, 656u + offsetX, 266u + offsetY, 266u); //故障码
    
    if (image != 0xFFFFu)
    {
        offsetY = 0u;
        
        if (typ == 0u)
        {
            if (temp == 0u)
            {
                offsetY = 35u;
            }
            else
            {
                offsetY = 18u;
            }
        }
        
        GUI_Translate_Display(Middle_Sprite, image, 503U - 74u * temp, 309U + offsetY, typ);
    }
}
//显示故障总数
void GUI_Popup_Total_Display(uint16_t value)
{
    if (value < 10)          //一位数
    {
        GUI_Translate_Display(Middle_Sprite, Alarm_01_Word1, 591U, 118U, 0u); /*Warn:英文*/
        NumUnit_Display(value, 0xFFFFu, 669u, 115u, 115u); //故障总数
    }
    else                     //二位数
    {
        GUI_Translate_Display(Middle_Sprite, Alarm_01_Word1, 582U, 118U, 0u); /*Warn:英文*/
        NumUnit_Display(value, 0xFFFFu, 660u, 115u, 115u); //故障总数
    }
}
//系统故障3级2级对应表格
static const uint16_t SYSPopID_3_2[2u][61u] = 
{
    {
        0xFFFFu,                 //0 无报警
        Alarm_87_Word1,          //1 VCU硬件故障
        Alarm_86_Word1,          //2 VCU 24V供电异常
        Alarm_85_Word1,          //3 电机控制器预充电故障
        Alarm_84_Word1,          //4 VCU系统故障
        Alarm_103_Word1,         //5 VCU与BMS通讯故障
        Alarm_82_Word1,          //6 VCU与MCU通讯故障
        Alarm_81_Word1,          //7 VCU与换档面板通讯故障
        Alarm_80_Word1,          //8 A区常电供电异常
        Alarm_79_Word1,          //9 B区常电供电异常
        Alarm_78_Word1,          //10 制动踏板故障
        
        Alarm_77_Word1,          //11 加速踏板故障
        0xFFFFu,                 //12
        Alarm_76_Word1,          //13 换档面板故障
        0xFFFFu,                 //14
        Alarm_75_Word1,          //15 电机转速传感器故障
        0xFFFFu,                 //16
        0xFFFFu,                 //17
        0xFFFFu,                 //18
        0xFFFFu,                 //19
        Alarm_74_Word1,          //20 变速器故障
        
        Alarm_73_Word1,          //21 变速器转速传感器故障
        0xFFFFu,                 //22
        Alarm_72_Word1,          //23 变速器位置传感器1故障 
        Alarm_71_Word1,          //24 变速器位置传感器2故障 
        Alarm_70_Word1,          //25 变速器位置传感器3故障 
        Alarm_69_Word1,          //26 变速器位置传感器4故障 
        Alarm_68_Word1,          //27 变速器位置传感器5故障 
        0xFFFFu,                 //28
        Alarm_67_Word1,          //29 变速器执行器1故障 
        Alarm_66_Word1,          //30 变速器执行器2故障 
        
        Alarm_65_Word1,          //31 变速器执行器3故障 
        Alarm_64_Word1,          //32 变速器执行器4故障 
        Alarm_63_Word1,          //33 挡位啮合故障
        Alarm_62_Word1,          //34 摘档故障
        Alarm_61_Word1,          //35 选档故障
        Alarm_60_Word1,          //36 挂档故障
        Alarm_59_Word1,          //37 主接触器常闭故障 
        Alarm_58_Word1,          //38 主接触器常开故障 
        Alarm_57_Word1,          //39 预充接触器故障
        Alarm_56_Word1,          //40 PDU三级故障
        
        Alarm_55_Word1,          //41 BMS三级故障
        Alarm_54_Word1,          //42 电机控制器三级故障
        Alarm_53_Word1,          //43 转向泵控制器三级故障
        Alarm_52_Word1,          //44 空压机控制器三级故障
        Alarm_51_Word1,          //45 DCDC三级故障
        Alarm_50_Word1,          //46 旋变三级故障
        Alarm_49_Word1,          //47 空压机故障
        Alarm_48_Word1,          //48 转向泵故障
        Alarm_47_Word1,          //49 高压配电故障
        0xFFFFu,                 //50

        Alarm_94_Word1,          //51 ICU二级故障
        Alarm_93_Word1,          //52 BMS二级故障
        0xFFFFu,                 //53
        Alarm_92_Word1,          //54 电机控制器二级故障
        Alarm_91_Word1,          //55 转向泵控制器二级故障
        Alarm_90_Word1,          //56 空压机控制器二级故障
        Alarm_89_Word1,          //57 DCDC二级故障
        0xFFFFu,                 //58
        Alarm_47_Word1,          //59 高压配电故障
        Alarm_88_Word1,          //60 车速故障
    },
    {
        0xFFFFu,                 //0 无报警
        Alarm_87_word3,          //1 VCU硬件故障
        Alarm_86_word3,          //2 VCU 24V供电异常
        Alarm_85_word3,          //3 电机控制器预充电故障
        Alarm_84_word3,          //4 VCU系统故障
        Alarm_103_word3,         //5 VCU与BMS通讯故障
        Alarm_82_word3,          //6 VCU与MCU通讯故障
        Alarm_81_word3,          //7 VCU与换档面板通讯故障
        Alarm_80_word3,          //8 A区常电供电异常
        Alarm_79_word3,          //9 B区常电供电异常
        Alarm_78_word3,          //10 制动踏板故障
        
        Alarm_77_word3,          //11 加速踏板故障
        0xFFFFu,                 //12
        Alarm_76_word3,          //13 换档面板故障
        0xFFFFu,                 //14
        Alarm_75_word3,          //15 电机转速传感器故障
        0xFFFFu,                 //16
        0xFFFFu,                 //17
        0xFFFFu,                 //18
        0xFFFFu,                 //19
        Alarm_100_word2,         //20 变速器故障
        
        Alarm_73_word3,          //21 变速器转速传感器故障
        0xFFFFu,                 //22
        Alarm_72_word3,          //23 变速器位置传感器1故障 
        Alarm_71_word3,          //24 变速器位置传感器2故障 
        Alarm_70_word3,          //25 变速器位置传感器3故障 
        Alarm_69_word3,          //26 变速器位置传感器4故障 
        Alarm_68_word3,          //27 变速器位置传感器5故障 
        0xFFFFu,                 //28
        Alarm_67_word3,          //29 变速器执行器1故障 
        Alarm_66_word3,          //30 变速器执行器2故障 
        
        Alarm_65_word3,          //31 变速器执行器3故障 
        Alarm_64_word3,          //32 变速器执行器4故障 
        Alarm_63_word3,          //33 挡位啮合故障
        Alarm_62_word3,          //34 摘档故障
        Alarm_61_word3,          //35 选档故障
        Alarm_60_word3,          //36 挂档故障
        Alarm_59_word3,          //37 主接触器常闭故障 
        Alarm_58_word3,          //38 主接触器常开故障 
        Alarm_57_word3,          //39 预充接触器故障
        Alarm_56_word3,          //40 PDU三级故障
        
        Alarm_55_word3,          //41 BMS三级故障
        Alarm_54_word3,          //42 电机控制器三级故障
        Alarm_53_word3,          //43 转向泵控制器三级故障
        Alarm_52_word3,          //44 空压机控制器三级故障
        Alarm_51_word3,          //45 DCDC三级故障
        Alarm_50_word3,          //46 旋变三级故障
        Alarm_49_word3,          //47 空压机故障
        Alarm_48_word3,          //48 转向泵故障
        Alarm_47_word3,          //49 高压配电故障
        0xFFFFu,                 //50

        Alarm_94_word3,          //51 ICU二级故障
        Alarm_93_word3,          //52 BMS二级故障
        0xFFFFu,                 //53
        Alarm_92_word3,          //54 电机控制器二级故障
        Alarm_91_word3,          //55 转向泵控制器二级故障
        Alarm_90_word3,          //56 空压机控制器二级故障
        Alarm_89_word3,          //57 DCDC二级故障
        0xFFFFu,                 //58
        Alarm_47_word3,          //59 高压配电故障
        Alarm_88_word3,          //60 车速故障
    },
};
//系统故障1级对应表格
static const uint16_t SYSPopID_1[2u][9u] = 
{
    {
        Alarm_102_Word1,     //151 ICU一级故障
        Alarm_101_Word1,     //152 BMS一级故障
        Alarm_100_Word1,     //153 ABS故障
        Alarm_99_Word1,      //154 电机控制器一级故障
        Alarm_98_Word1,      //155 转向泵控制器一级故障
        Alarm_97_Word1,      //156 空压控制器一级故障
        Alarm_96_Word1,      //157 DCDC一级故障
        Alarm_95_Word1,      //158 门互锁
        Alarm_47_Word1,      //159 高压配电故障
    },
    {
        Alarm_102_word3,     //151 ICU一级故障
        Alarm_101_word3,     //152 BMS一级故障
        Alarm_100_word3,     //153 ABS故障
        Alarm_99_word3,      //154 电机控制器一级故障
        Alarm_98_word3,      //155 转向泵控制器一级故障
        Alarm_97_word3,      //156 空压控制器一级故障
        Alarm_96_word3,      //157 DCDC一级故障
        Alarm_95_word3,      //158 门互锁
        Alarm_47_word3,      //159 高压配电故障
    },
};
extern uint8_t  DTC_Code[7u];
extern uint8_t  DTC_Count[7u];
//显示系统报警
void GUI_SYS_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[0u]; //Get_ID_18F101D0_Sig_VCU_SysTtlFlt(); //故障总数
        
    GUI_Popup_Total_Display(value); //故障总数

    if (typ == 0u)
    {
        image = 15u;
    }

    uint8_t temp = LanguageTyp_Get();
    
    GUI_Translate_Display(Middle_Sprite, Alarm_07_Word0 + temp, 562U - 103U * temp, 159U + image, typ); /*系统警报 文字*/
        
    value = DTC_Code[0u]; //Get_ID_18F101D0_Sig_VCU_SysDTC(); //故障码
    
    /*
    if (value < 61u)
    {
        image = SYSPopID_3_2[value];
    }
    else if (value < 151u)
    {
        image = 0xFFFFu;
    }
    else if (value < 160u)
    {
        image = SYSPopID_1[value - 151u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 0u, typ);
}
//转向系统故障3级2级对应表格
static const uint16_t EPSPopID_3_2[] = 
{
    0xFFFFu,                 //0 无报警
    Alarm_74_Word0,          //1 输出过流故障
    Alarm_54_Word0,          //2 相电流过大故障
    Alarm_53_Word0,          //3 相电流过小故障
    Alarm_52_Word0,          //4 相电流零漂故障
    Alarm_51_Word0,          //5 三相电流不平衡故障
    Alarm_68_Word0,          //6 相间短路故障
    Alarm_80_Word0,          //7 控制器硬件过压故障
    Alarm_49_Word0,          //8 缺相故障
    Alarm_79_Word0,          //9 控制器电源欠压故障
    Alarm_38_Word0,          //10 母线过压三级故障
    
    Alarm_39_Word0,          //11 母线欠压三级故障
    0xFFFFu,                 //12 控制器过温三级故障
    Alarm_101_Word0,         //13 控制器过载故障
    0xFFFFu,                 //14 速度偏差过大故障
    Alarm_48_Word0,          //15 EEPROM故障
};
//转向系统故障1级对应表格
static const uint16_t EPSPopID_1[] = 
{
    Alarm_85_Word0,          //151 主动放电超时故障
    Alarm_29_Word0,          //152 CAN通讯故障
    Alarm_86_Word0,          //153 控制器电源过压故障
};

//显示转向系统报警
void GUI_EPS_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[1u]; //Get_ID_18F105D0_Sig_VCU_EPSTtlFlt(); //故障总数
    
    GUI_Popup_Total_Display(value); //故障总数
    
    if (typ == 0u)
    {
        image = 15u;
    }
    
    uint8_t temp = LanguageTyp_Get();

    GUI_Translate_Display(Middle_Sprite, Alarm_06_Word0 + temp, 562U - 103U * temp, 159U + image, typ); /*转向系统警报 文字*/
        
    value = DTC_Code[1u]; //Get_ID_18F105D0_Sig_VCU_EPSDTC(); //故障码
    
    /*
    if (value < 16u)
    {
        image = EPSPopID_3_2[value];
    }
    else if (value < 151u)
    {
        image = 0xFFFFu;
    }
    else if (value < 154u)
    {
        image = EPSPopID_1[value - 151u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 0u, typ);
}

//空压机警报
void GUI_ACM_Popup_Display(uint8_t typ)
{
    uint16_t value = DTC_Count[2u]; //Get_ID_18F105D0_Sig_VCU_ACMTtlFlt(); //故障总数
        
    GUI_Popup_Total_Display(value); //故障总数
    
    uint16_t image = 0u;

    if (typ == 0u)
    {
        image = 15u;
    }
    
    uint8_t temp = LanguageTyp_Get();

    GUI_Translate_Display(Middle_Sprite, Alarm_05_Word0 + temp, 562U - 103U * temp, 159U + image, typ); /*空压机警报 文字*/
        
    value = DTC_Code[2u]; //Get_ID_18F105D0_Sig_VCU_ACMDTC(); //故障码
    
    GUI_Popup_Level_Display(0xFFFFu, value, 0u, typ);
}
//电池管理系统故障3级对应表格
static const uint16_t BMSPopID_3[2u][18u] = 
{
    {
        0xFFFFu,             //0 无报警
        Alarm_16_Word1,      //1 温度超过最大极限值
        Alarm_15_Word1,      //2 单体电压低于最小极限值
        Alarm_14_Word1,      //3 单体电压高于最高极限值
        Alarm_13_Word1,      //4 绝缘故障
        Alarm_12_Word1,      //5 回馈电流超过最高极限值
        Alarm_11_Word1,      //6 总电压过高
        Alarm_10_Word1,      //7 总电压过低
        Alarm_9_Word0,       //8 单体压差过大
        Alarm_8_Word0,       //9 温度低于最小极限值
        Alarm_7_Word0,       //10 电池温差过大三级故障
        
        Alarm_6_Word0,       //11 充电过流
        Alarm_5_Word0,       //12 充电插座高温
        Alarm_4_Word0,       //13 内网通讯故障
        Alarm_3_Word0,       //14 加热故障
        Alarm_2_Word0,       //15 BMS硬件故障
        Alarm_1_Word0,       //16 电流传感器故障
        Alarm_00_Word0,      //17 放电电流过大
    },
    {
        0xFFFFu,             //0 无报警
        Alarm_16_word3,      //1 温度超过最大极限值
        Alarm_15_word3,      //2 单体电压低于最小极限值
        Alarm_14_word3,      //3 单体电压高于最高极限值
        Alarm_13_word3,      //4 绝缘故障
        Alarm_12_word3,      //5 回馈电流超过最高极限值
        Alarm_11_word3,      //6 总电压过高
        Alarm_10_word3,      //7 总电压过低
        Alarm_9_word1,       //8 单体压差过大
        Alarm_8_word1,       //9 温度低于最小极限值
        Alarm_7_word1,       //10 电池温差过大三级故障
        
        Alarm_6_word1,       //11 充电过流
        Alarm_5_word1,       //12 充电插座高温
        Alarm_4_word1,       //13 内网通讯故障
        Alarm_3_word1,       //14 加热故障
        Alarm_2_word1,       //15 BMS硬件故障
        Alarm_1_word1,       //16 电流传感器故障
        Alarm_00_word1,      //17 放电电流过大
    },

};
//电池管理系统故障2级对应表格
static const uint16_t BMSPopID_2[2u][19u] = 
{
    {
        Alarm_32_Word1,      //51 单体电压高于危险值
        Alarm_31_Word1,      //52 单体电压低于危险值
        Alarm_30_Word1,      //53 放电温度小于危险值
        Alarm_29_Word1,      //54 放电温度大于危险值
        Alarm_28_Word1,      //55 放电电流超过危险值
        Alarm_27_Word1,      //56 总电压低于危险值
        Alarm_26_Word1,      //57 总电压超过危险值
        Alarm_25_Word1,      //58 SOC低于危险值
        Alarm_24_Word1,      //59 电池温差过大二级故障
        Alarm_9_Word0,       //60 单体压差过大
        
        Alarm_13_Word1,      //61 绝缘故障
        Alarm_23_Word1,      //62 通讯故障
        Alarm_5_Word0,       //63 充电插座高温
        Alarm_22_Word1,      //64 电压排线脱落
        Alarm_21_Word1,      //65 温感排线脱落
        Alarm_20_Word1,      //66 充电电流高于危险值
        Alarm_19_Word1,      //67 放电回馈电流高于危险值
        Alarm_18_Word1,      //68 继电器故障
        Alarm_17_Word1,      //69 继电器粘连
    },
    {
        Alarm_32_word3,      //51 单体电压高于危险值
        Alarm_31_word3,      //52 单体电压低于危险值
        Alarm_30_word3,      //53 放电温度小于危险值
        Alarm_29_word3,      //54 放电温度大于危险值
        Alarm_28_word3,      //55 放电电流超过危险值
        Alarm_27_word3,      //56 总电压低于危险值
        Alarm_26_word3,      //57 总电压超过危险值
        Alarm_25_word3,      //58 SOC低于危险值
        Alarm_24_word3,      //59 电池温差过大二级故障
        Alarm_9_word1,       //60 单体压差过大
        
        Alarm_13_word3,      //61 绝缘故障
        Alarm_23_word3,      //62 通讯故障
        Alarm_5_word1,       //63 充电插座高温
        Alarm_22_word3,      //64 电压排线脱落
        Alarm_21_word3,      //65 温感排线脱落
        Alarm_20_word3,      //66 充电电流高于危险值
        Alarm_19_word3,      //67 放电回馈电流高于危险值
        Alarm_18_word3,      //68 继电器故障
        Alarm_17_word3,      //69 继电器粘连
    },
};
static const uint16_t BMSPopID_1[2u][16u] = 
{
    {
        Alarm_46_Word1,      //101 充电机充电故障
        Alarm_45_Word1,      //102 单体电压高于预警值
        Alarm_44_Word1,      //103 单体电压低于预警值
        Alarm_43_Word1,      //104 放电温度小于预警值
        Alarm_42_Word1,      //105 放电温度大于预警值
        Alarm_41_Word1,      //106 放电电流大于预警值
        Alarm_40_Word1,      //107 总电压低于预警值
        Alarm_39_Word1,      //108 总电压大于预警值
        Alarm_38_Word1,      //109 SOC低于预警值
        Alarm_37_Word1,      //110 电池温差过大一级故障
        
        Alarm_9_Word0,       //111 单体压差过大
        Alarm_13_Word1,      //112 绝缘故障
        Alarm_36_Word1,      //113 充电电流大于预警值
        Alarm_35_Word1,      //114 SOC过高
        Alarm_34_Word1,      //115 SOC跳变故障
        Alarm_33_Word1,      //116 放电回馈一级故障
    },
    {
        Alarm_46_word3,      //101 充电机充电故障
        Alarm_45_word3,      //102 单体电压高于预警值
        Alarm_44_word3,      //103 单体电压低于预警值
        Alarm_43_word3,      //104 放电温度小于预警值
        Alarm_42_word3,      //105 放电温度大于预警值
        Alarm_41_word3,      //106 放电电流大于预警值
        Alarm_40_word3,      //107 总电压低于预警值
        Alarm_39_word3,      //108 总电压大于预警值
        Alarm_38_word3,      //109 SOC低于预警值
        Alarm_37_word3,      //110 电池温差过大一级故障
        
        Alarm_9_word1,       //111 单体压差过大
        Alarm_13_word3,      //112 绝缘故障
        Alarm_36_word3,      //113 充电电流大于预警值
        Alarm_35_word3,      //114 SOC过高
        Alarm_34_word3,      //115 SOC跳变故障
        Alarm_33_word3,      //116 放电回馈一级故障
    },
};
//电池管理系统报警
void GUI_BMS_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[3u]; //Get_ID_18F141F3_Sig_BMS_BMSTtlFlt(); //故障总数

    uint8_t  temp  = LanguageTyp_Get();

    GUI_Popup_Total_Display(value); //故障总数
    
    if (typ == 0u)
    {
        image = 15u;
    }
    
    if (temp == 0u)
    {
        GUI_Translate_Display(Middle_Sprite, Alarm_01_Word0, 562U, 159U + image, typ); /*动力电池警报 文字*/
    }
    else
    {
        GUI_Translate_Display(Middle_Sprite, Alarm_01_word2, 459U, 159U + image, typ); /*动力电池警报 文字*/
    }    
    
    value = DTC_Code[3u]; //Get_ID_18F141F3_Sig_BMS_BMSDTC(); //故障码
    /*
    if (value < 18u)
    {
        image = BMSPopID_3[value];
    }
    else if (value < 51u)
    {
        image = 0xFFFFu;
    }
    else if (value < 70u)
    {
        image = BMSPopID_2[value - 51u];
    }
    else if (value < 101u)
    {
        image = 0xFFFFu;
    }
    else if (value < 117u)
    {
        image = BMSPopID_1[value - 101u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 1u, typ);
}

//压缩机报警显示文字
static const uint16_t ACCM_PopID[2u][7u] = 
{
    {
        Alarm_132_Word0,     //过流
        Alarm_131_Word0,     //运行过压
        Alarm_130_Word0,     //运行欠压
        Alarm_129_Word0,     //过流降频
        Alarm_136_Word0,     //过温故障
        Alarm_133_Word0,     //压缩机警报
        Set_Menu3_Word0_18,  //故障码
    },
    {
        Alarm_132_word1,     //过流
        Alarm_131_word1,     //运行过压
        Alarm_130_word1,     //运行欠压
        Alarm_129_word1,     //过流降频
        Alarm_136_word1,     //过温故障
        Alarm_133_word1,     //压缩机警报
        Set_Menu3_Word1_18,  //故障码
    },
};

static const uint16_t ACCM_Word_XY[2u][2u] = 
{
    {583u, 159u},
    {546u, 160u},
};

static const uint8_t ACCM_Code[] = {1u, 2u, 4u, 4u, 8u};
    
//压缩机报警
void GUI_ACCM_Popup_Display(uint8_t PopupMsg, uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t AdressX = 577u;
    uint8_t  popId   = PopupMsg - 32u;
    uint8_t  temp = LanguageTyp_Get(); 

    if (typ == 0u)
    {
        image = 15u;
    }
    
    GUI_Translate_Display(Middle_Sprite, ACCM_PopID[temp][5u], ACCM_Word_XY[temp][0u], ACCM_Word_XY[temp][1u] + image, typ); /*压缩机警报 文字*/

    AdressX += temp * 18u;        
    
    if (PopupMsg < POPUP_ACCM_CmprErrCode3)
    {
        AdressX += 8u;
    }
    GUI_Translate_Display(Middle_Sprite, ACCM_PopID[temp][6u], AdressX, 264u, typ); /*故障码 文字*/
    AdressX += 71u - 33u * temp;
    GUI_Translate_Display(Middle_Sprite, Number_18_white_line1, AdressX, 272u, typ); /*-*/
    AdressX += 14u;
    
    GUI_Translate_Display(Middle_Sprite, Number_18_white_0 + ACCM_Code[popId], AdressX, 265u, typ); /*x*/
    if (PopupMsg > POPUP_ACCM_CmprErrCode2)
    {
        AdressX += 17u;
    
        GUI_Translate_Display(Middle_Sprite, Number_18_white_0, AdressX, 265u, typ); /*0*/
    }

    image = 342u;
    if (typ == 2u)
    {
       image -= 32u; 
    }

    GUI_Translate_Display(Middle_Sprite, ACCM_PopID[temp][popId], 594u - temp * 164u, image - temp * 13u, typ); /*报警内容 文字*/
}
//高压配电系统故障3级对应表格
static const uint16_t PDUPopID_3[] = 
{
    0xFFFFu,                 //0 无报警
    Alarm_109_Word0,         //1 主驱回路主接触器粘连故障
    Alarm_103_Word0,         //2 主驱回路短路故障
    Alarm_108_Word0,         //3 主驱回路预充电故障
    Alarm_107_Word0,         //4 辅驱回路主接触器粘连故障
    Alarm_106_Word0,         //5 辅驱回路预充电故障
    Alarm_105_Word0,         //6 辅驱回路短路故障
    Alarm_104_Word0,         //7 高压配电故障
    Alarm_103_Word0,         //8 EEPROM故障
    Alarm_103_Word0,         //9 高压互锁故障
    Alarm_102_Word0,         //10 CAN通讯故障持续故障
};
//高压配电系统故障2级对应表格
static const uint16_t PDUPopID_2[] = 
{
    0xFFFFu,                 //51 主驱回路上电反向压差故障
    Alarm_109_Word0,         //52 主驱回路带转速上电故障
    Alarm_103_Word0,         //53 主驱上电24V电压偏低故障
    Alarm_108_Word0,         //54 辅驱回路上电反向压差故障
    Alarm_107_Word0,         //55 辅驱上电24V电压偏低故障
    Alarm_106_Word0,         //56 前端电压故障
    Alarm_105_Word0,         //57 CAN通讯故障
};
static const uint16_t PDUPopID_1[] = 
{
    0xFFFFu,                 //151 主驱回路主接触器闭合异常故障
    Alarm_109_Word0,         //152 辅驱回路主接触器闭合异常故障
    Alarm_103_Word0,         //153 辅驱接触器粘连故障
    Alarm_108_Word0,         //154 快充接触器粘连故障
    Alarm_107_Word0,         //155 24V一级欠压故障
    Alarm_106_Word0,         //156 24V一级过压故障
};

//高压配电系统报警
void GUI_PDU_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[4u]; //Get_ID_18F106D0_Sig_VCU_PDUTtlFlt(); //故障总数
        
    GUI_Popup_Total_Display(value); //故障总数
    
    if (typ == 0u)
    {
        image = 15u;
    }
    
    uint8_t temp = LanguageTyp_Get();

    GUI_Translate_Display(Middle_Sprite, Alarm_03_Word0 + temp, 562U - 103U * temp, 159U + image, typ); /*高压配电警报 文字*/
        
    value = DTC_Code[4u]; //Get_ID_18F106D0_Sig_VCU_PDUDTC(); //故障码
    
    /*
    if (value < 11u)
    {
        image = PDUPopID_3[value];
    }
    else if (value < 51u)
    {
        image = 0xFFFFu;
    }
    else if (value < 58u)
    {
        image = PDUPopID_2[value - 51u];
    }
    else if (value < 151u)
    {
        image = 0xFFFFu;
    }
    else if (value < 157u)
    {
        image = EPSPopID_1[value - 151u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 0u, typ);
}
//电机控制器故障3级对应表格
static const uint16_t MCUPopID_3[] = 
{
    0xFFFFu,                 //0 无报警
    Alarm_109_Word0,         //1 输出过流故障
    Alarm_103_Word0,         //2 相电流过大故障
    Alarm_108_Word0,         //3 相电流过小故障
    Alarm_107_Word0,         //4 相电流零漂故障
    Alarm_106_Word0,         //5 三相电流不平衡故障
    Alarm_105_Word0,         //6 相间短路故障
    Alarm_104_Word0,         //7 控制器硬件过压故障
    Alarm_103_Word0,         //8 电机缺相故障
    Alarm_103_Word0,         //9 EEPROM故障
    Alarm_102_Word0,         //10 IGBT硬件故障

    Alarm_109_Word0,         //11 控制器电源欠压故障
    Alarm_103_Word0,         //12 母线过压三级故障
    Alarm_103_Word0,         //13 母线欠压三级故障
    Alarm_108_Word0,         //14 控制器过温三级故障
    Alarm_107_Word0,         //15 电机过温三级故障
    Alarm_106_Word0,         //16 控制器过载故障
    Alarm_105_Word0,         //17 超速故障
    Alarm_104_Word0,         //18 速度偏差过大故障
    Alarm_103_Word0,         //19 旋变故障
};
//电机控制器故障2级对应表格
static const uint16_t MCUPopID_2[] = 
{
    0xFFFFu,                 //51 电机温度采样故障
    Alarm_109_Word0,         //52 操作顺序保护故障
    Alarm_103_Word0,         //53 高速误挂档保护报警
    Alarm_108_Word0,         //54 母线欠压预警
    Alarm_107_Word0,         //55 母线过压预警
    Alarm_106_Word0,         //56 电机过温预警
    Alarm_105_Word0,         //57 控制器IGBT过温预警
    Alarm_105_Word0,         //58 CAN通讯故障
};
//电机控制器故障1级对应表格
static const uint16_t MCUPopID_1[] = 
{
    0xFFFFu,                 //151 主动放电超时故障
    Alarm_109_Word0,         //152 控制器电源过压故障
    Alarm_103_Word0,         //153 IGBT温度检测故障
};
//电机控制器报警
void GUI_MCU_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[5u]; //Get_ID_18F501F0_Sig_VCU_MCUTtlFlt(); //故障总数
    
    GUI_Popup_Total_Display(value); //故障总数
    
    if (typ == 0u)
    {
        image = 15u;
    }

    uint8_t temp = LanguageTyp_Get();

    GUI_Translate_Display(Middle_Sprite, Alarm_02_Word0 + 2U * temp, 562U - 103U * temp, 159U + image, typ); /*电机控制器警报 文字*/
        
    value = DTC_Code[5u]; //Get_ID_18F501F0_Sig_VCU_MCUDTC(); //故障码
    
    /*
    if (value < 20u)
    {
        image = MCUPopID_3[value];
    }
    else if (value < 51u)
    {
        image = 0xFFFFu;
    }
    else if (value < 59u)
    {
        image = MCUPopID_2[value - 51u];
    }
    else if (value < 151u)
    {
        image = 0xFFFFu;
    }
    else if (value < 154u)
    {
        image = MCUPopID_1[value - 151u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 0u, typ);
}
//DCDC故障3级对应表格
static const uint16_t DCDCPopID_3[] = 
{
    0xFFFFu,                 //0 无报警
    Alarm_109_Word0,         //1 输入过压故障
    Alarm_103_Word0,         //2 输入欠压故障
    Alarm_108_Word0,         //3 输入过流故障
    Alarm_107_Word0,         //4 输出过压故障
    Alarm_106_Word0,         //5 输出欠压故障
    Alarm_105_Word0,         //6 输出过流故障
    Alarm_104_Word0,         //7 硬件保护故障
    Alarm_103_Word0,         //8 控制器电源过压故障
    Alarm_103_Word0,         //9 控制器电源欠压故障
    Alarm_102_Word0,         //10 基板过温

    Alarm_109_Word0,         //11 MOS过温
    Alarm_103_Word0,         //12 硬件故障
    Alarm_103_Word0,         //13 输出反向过流
    Alarm_108_Word0,         //14 EEPROM故障
    Alarm_107_Word0,         //15 并机模式参数不一致
    Alarm_106_Word0,         //16 输出电压设置错误
    Alarm_105_Word0,         //17 软起动失败
};
//DCDC故障2级对应表格
static const uint16_t DCDCPopID_2[] = 
{
    0xFFFFu,                 //51 DCDC输出过载故障
    Alarm_109_Word0,         //52 DCDC过温降额故障
    Alarm_103_Word0,         //53 主模块故障
    Alarm_108_Word0,         //54 从模块故障
};
//DCDC故障1级对应表格
static const uint16_t DCDCPopID_1[] = 
{
    0xFFFFu,                 //151 DCDC输出断线
    Alarm_109_Word0,         //152 DCDC驱动电压异常
    Alarm_103_Word0,         //153 DCDC硬件保护电路故障
    0xFFFFu,                 //154 DCDC低压信号及保护电路自检
    Alarm_109_Word0,         //155 CAN通讯故障
    Alarm_103_Word0,         //156 EEPROM故障
};
//DCDC报警
void GUI_DCDC_Popup_Display(uint8_t typ)
{
    uint16_t image = 0u;
    uint16_t value = DTC_Count[6u]; //Get_ID_18F105D0_Sig_VCU_DCDCTtlFlt(); //故障总数
        
    GUI_Popup_Total_Display(value); //故障总数
    
    if (typ == 0u)
    {
        image = 15u;
    }
    
    uint8_t temp = LanguageTyp_Get();

    GUI_Translate_Display(Middle_Sprite, Alarm_04_Word0 + temp, 562U - 103U * temp, 159U + image, typ); /*DC/DC警报 文字*/
        
    value = DTC_Code[6u]; //Get_ID_18F105D0_Sig_VCU_DCDCDTC(); //故障码
    
    /*
    if (value < 18u)
    {
        image = DCDCPopID_3[value];
    }
    else if (value < 51u)
    {
        image = 0xFFFFu;
    }
    else if (value < 55u)
    {
        image = DCDCPopID_2[value - 51u];
    }
    else if (value < 151u)
    {
        image = 0xFFFFu;
    }
    else if (value < 157u)
    {
        image = DCDCPopID_1[value - 151u];
    }
    else
    */
    {
        image = 0xFFFFu;
    }
    
    GUI_Popup_Level_Display(image, value, 0u, typ);
}

//弹出报警显示
void Popups_Displaying(uint8_t PopupMsg, uint8_t typ)
{
    if ( PopupMsg < POPUP_MSG_NUMBER_TOTAL )
    {
        switch ( PopupMsgAttributeTable [ PopupMsg ].Type )
        {
            case POPUP_TYPE_GENERAL:
                GUI_General_Popup_Display(PopupMsg, typ);
                break;
    
            case POPUP_TYPE_SYS:
                GUI_SYS_Popup_Display(typ);
                break;

            case POPUP_TYPE_EPS:
                GUI_EPS_Popup_Display(typ);
                break;

            case POPUP_TYPE_ACM:
                GUI_ACM_Popup_Display(typ);
                break;
            
            case POPUP_TYPE_DCDC:
                GUI_DCDC_Popup_Display(typ);
                break;
            
            case POPUP_TYPE_PDU:
                GUI_PDU_Popup_Display(typ);
                break;
            
            case POPUP_TYPE_MCU:
                GUI_MCU_Popup_Display(typ);
                break;
            
            case POPUP_TYPE_BMS:
                GUI_BMS_Popup_Display(typ);
                break;
            
            case POPUP_TYPE_ACCM:
                GUI_ACCM_Popup_Display(PopupMsg, typ);
                break;
            
            default:
                break;
        }
    }
}

static const uint16_t ImageID_Number_40_white[] = 
{
    Number_40_white_0,
    Number_40_white_1,
    Number_40_white_2,
    Number_40_white_3,
    Number_40_white_4,
    Number_40_white_5,
    Number_40_white_6,
    Number_40_white_7,
    Number_40_white_8,
    Number_40_white_9,
};

uint8_t  Charged_Time_H_Start; //h
uint8_t  Charged_Time_M_Start; //m
uint8_t  Charged_Time_S_Start; //s
uint32_t Charged_Time;
uint8_t  Point2_Flash;
uint8_t  PopupMsg_Last;

extern uint16_t Popup_Current_Msg;

/*中央区显示主函数*/
void GUI_Middle(void)
{
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        GUI_Translate_Display(Middle_Sprite, dcyx_1, 463U, 433U, 0u);
        GUI_Translate_Display(Middle_Sprite, dcyx_2, 497U, 392U, 0u);
        GUI_Translate_Display(Middle_Sprite, dcyx_3, 530U, 365U, 0u);
        return;
    }

    uint8_t  Status = MenuSetSts_Get();
    uint8_t  select = 0u;
    uint16_t PopupMsg = Popup_Current_Msg; //Popup_Get_Current_Message();
        
    uint8_t typ = 2u;
    
    if (Charged_State_Get())
    {
        typ = 0u;
    }

    if (Status == 0)
    {
        if (Charged_State_Get())
        {
            if (PopupMsg_Last && (PopupMsg >= POPUP_MSG_NONE))
            {
                PopupMsg_Last = 0u;
                loc_Del_Sprite(Middle_Sprite, Middle_Sprite);
            }

            uint16_t value = Get_ID_18F13DF3_Sig_BMS_BtyPckCrt(); //0.1A
        
            if ((value >= 10000u) || (CAN_MSG_Status(ID_BMS_BMSSts_Msg_Count) != CAN_SIG_RECEIVE) || (SOC_Get_DesVal() == 1000)) //正电流,非充电状态或掉线或充满
            {
                Point2_Flash = 1u;
                
                Charged_Time_H_Start = Get_RTC_HOUR();   //h
                Charged_Time_M_Start = Get_RTC_MINUTE(); //m
                Charged_Time_S_Start = Get_RTC_SECOND(); //s
            }
            else
            {
                Point2_Flash = 0u;
            }

            GUI_Translate_Display(Middle_Sprite, CHG, 462U, 88U, 0u); /*充电界面*/
            
            if (LanguageTyp_Get() == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Word0_01, 418U, 127U, 0u); /*预计充电时间 文字*/
            }
            else
            {
                GUI_Translate_Display(Middle_Sprite, Word1_01, 403U, 118U, 0u); /*预计充电时间 文字*/
            }
            
            uint32_t hour   = Get_ID_18F141F3_Sig_BMS_ChgRemnderH(); //h
            uint32_t minute = Get_ID_18F141F3_Sig_BMS_ChgRemnderM(); //m
            
            minute *= 5u;
            if (minute > 55u)
            {
                minute = 55u;
            }
            
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[hour / 10], 433u, 152u, 0u); /*十位*/
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[hour % 10], 451u, 152u, 0u); /*个位*/

            if (Point2_Flash == 0u)
            {
                if (FlashSync1Hz)
                {
                    GUI_Translate_Display(Middle_Sprite, Number_18_white_point2, 459U, 152U, 0U); /*:*/
                }
            }
            else
            {
                GUI_Translate_Display(Middle_Sprite, Number_18_white_point2, 459U, 152U, 0U); /*:*/
            }
            
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[minute / 10], 477u, 152u, 0u); /*十位*/
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[minute % 10], 495u, 152u, 0u); /*个位*/

            if (LanguageTyp_Get() == 0u)
            {
                GUI_Translate_Display(Middle_Sprite, Word0_02, 776U, 127U, 0u); /*已充电时间*/
            }
            else
            {
                GUI_Translate_Display(Middle_Sprite, Word1_02, 776U, 118U, 0u); /*已充电时间*/
            }

            hour   = Get_RTC_HOUR();   //h
            minute = Get_RTC_MINUTE(); //m
            
            uint32_t second = Get_RTC_SECOND(); //m
            
            uint32_t timeE = hour * 3600u + minute * 60u + second;   
            uint32_t timeS = (uint32_t)Charged_Time_H_Start * 3600u + (uint32_t)Charged_Time_M_Start * 60u + Charged_Time_S_Start;
            
            Charged_Time_H_Start = hour;
            Charged_Time_M_Start = minute;
            Charged_Time_S_Start = second;
            
            if (timeE < timeS)
            {
                timeE += 86400u; //24h 
            }
            
            timeE -= timeS;
            
            if (timeE >= 86400u)
            {
                timeE = 86399;
            }

            if (Point2_Flash == 0u)
            {
                Charged_Time += timeE;
            }

            timeE = Charged_Time;
                
            hour   = (uint8_t)(timeE / 3600u);
            timeE %= 3600u;
            minute = (uint8_t)(timeE / 60u); 

            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[hour / 10], 781u, 152u, 0u); /*十位*/
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[hour % 10], 799u, 152u, 0u); /*个位*/

            if (Point2_Flash == 0u)
            {
                if (FlashSync1Hz)
                {
                    GUI_Translate_Display(Middle_Sprite, Number_18_white_point2, 808U, 152U, 0U); /*:*/
                }
            }
            else
            {
                GUI_Translate_Display(Middle_Sprite, Number_18_white_point2, 808U, 152U, 0U); /*:*/
            }
            
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[minute / 10], 826u, 152u, 0u); /*十位*/
            GUI_Translate_Display(Middle_Sprite, ImageID_Number_18_white[minute % 10], 843u, 152u, 0u); /*个位*/
        
            uint32_t u32Result = Get_ID_18F13DF3_Sig_BMS_BtySOC();
        
            u32Result <<= 1u;    //0.01V
            u32Result /=  5u;
            
            if (u32Result > 100u)
            {
                u32Result = 100u;
            }
                        
            if (u32Result >= 100)
            {
                GUI_Translate_Display(Middle_Sprite, Number_40_white_1, 571U, 213U, 0U); /*1*/
                GUI_Translate_Display(Middle_Sprite, Number_40_white_0, 610U, 213U, 0U); /*0*/
                GUI_Translate_Display(Middle_Sprite, Number_40_white_0, 649U, 213U, 0U); /*0*/
            }
            else 
            {
                if (u32Result >= 10)
                {
                    GUI_Translate_Display(Middle_Sprite, ImageID_Number_40_white[u32Result / 10], 603U, 213U, 0U); /*十位*/
                    GUI_Translate_Display(Middle_Sprite, ImageID_Number_40_white[u32Result % 10], 642U, 213U, 0U); /*个位*/
                }
                else
                {
                    GUI_Translate_Display(Middle_Sprite, ImageID_Number_40_white[u32Result % 10], 622U, 213U, 0U); /*个位*/
                }
            }

            if (PopupMsg < POPUP_MSG_NONE)
            {
                Popups_Displaying(PopupMsg, typ);
                PopupMsg_Last = 1u;
            }
            else
            {
                if (LanguageTyp_Get() == 0u)
                {
                    GUI_Translate_Display(Middle_Sprite, Alarm_124_Word0, 584u, 174u, 0u); /*电枪已连接 文字*/
                }
                else
                {
                    GUI_Translate_Display(Middle_Sprite, Alarm_124_word1, 431u, 162u, 0u); /*电枪已连接 文字*/
                }
            }
        }
        else
        {
            Charged_Time = 0ul;
            
            Charged_Time_H_Start = Get_RTC_HOUR();   //h
            Charged_Time_M_Start = Get_RTC_MINUTE(); //m
            Charged_Time_S_Start = Get_RTC_SECOND(); //s

            if (PopupMsg < POPUP_MSG_NONE)
            {
                Popups_Displaying(PopupMsg, typ);
            }
            else
            {
                if ((Common_Get_IG_Sts() == 0u) && ((CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) == CAN_SIG_RECEIVE) ||\
                    (CAN_MSG_Status(ID_BMS_BMSFltSts_Msg_Count) == CAN_SIG_RECEIVE)))
                {
                    if (LanguageTyp_Get() == 0u)
                    {
                        GUI_Translate_Display(Middle_Sprite, Alarm_126_Word0, 572u, 242u, 0u); /*整车正在下电 文字*/
                    }
                    else
                    {
                        GUI_Translate_Display(Middle_Sprite, Alarm_126_word1, 431u, 230u, 0u); /*整车正在下电 文字*/
                    }
                }
                else
                {
                    GUI_Translate_Display(Middle_Sprite, road_grey_L, 442U, 210U, 0);/*灰左道边线*/
                    GUI_Translate_Display(Middle_Sprite, road_grey_R, 663U, 210U, 0);/*灰右道边线*/
                    GUI_Translate_Display(Middle_Sprite, Car, 507U, 203U,0); /*车尾*/
                }
            }
        }
    }
    else
    {
        //Charged_Time = 0ul;

        //Charged_Time_H_Start = Get_RTC_HOUR();   //h
        //Charged_Time_M_Start = Get_RTC_MINUTE(); //m
        //Charged_Time_S_Start = Get_RTC_SECOND(); //s

        Status = MenuSetTyp_Get();
        uint8_t grade = MenuSetGrd_Get();
        
        if (grade == 0u)
        {
            GUI_Translate_Display(Middle_Sprite, ECU_Bottom08, 435U, 113U, 0); /*行车电脑 背景*/

            switch (Status)
            {
                case  0u: GUI_Middle001(); break;
                case  1u: GUI_Middle002(); break;
                case  2u: GUI_Middle003(); break;
                case  3u: GUI_Middle004(); break;
                case  4u: GUI_Middle005(); break;
                case  5u: GUI_Middle006(); break;
                case  6u: GUI_Middle007(); break;
                default : GUI_Middle001(); break;
            }
        }
        else if (grade == 1u)
        {
            switch (Status)
            {
                //整车信息
                case  0:
                    if (LanguageTyp_Get() == 0u)
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Arrow_L, 503U, 202U, 0); /*二级菜单 箭头*/
                        GUI_Translate_Display(Middle_Sprite, Set_Arrow_R, 760U, 201U, 0); /*二级菜单 箭头*/
                    }
                    else
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Arrow_L, 455U + 15U, 202U, 0); /*二级菜单 箭头*/
                        GUI_Translate_Display(Middle_Sprite, Set_Arrow_R, 807U - 15U, 201U, 0); /*二级菜单 箭头*/
                    }
                    
                    switch (VhlInfTyp_Get())
                    {
                        case  0: GUI_Middle_001_01(); break;
                        case  1: GUI_Middle_001_02(); break;
                        case  2: GUI_Middle_001_03(); break;
                        case  3: GUI_Middle_001_04(); break;
                        case  4: GUI_Middle_001_05(); break;
                        case  5: GUI_Middle_001_06(); break;
                        case  6: GUI_Middle_001_07(); break;
                        case  7: GUI_Middle_001_08(); break;
                        case  8: GUI_Middle_001_09(); break;
                        case  9: GUI_Middle_001_10(); break;
                        case 10: GUI_Middle_001_11(); break;

                        default: GUI_Middle_001_01(); break;
                    }

                    GUI_Translate_Display(Middle_Sprite, Set_Arrow_Down, 629U, 354U, 0); /*二级菜单 箭头*/
                    break;        
                
                //夜间亮度
                case  1:
                    GUI_Middle002_01();
                    break;
                
                //日间亮度
                case  2:
                    GUI_Middle003_01();
                    break;

                //默认设置
                case  3:
                    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u);                   /*二级菜单 背景*/
                    if (LanguageTyp_Get() == 0u)
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_HFMRSZ_Title_Word0, 535U, 128U, 0u); /*二级菜单 恢复默认设置*/
                        GUI_Translate_Display(Middle_Sprite, Set_Menu3_TC_03_Word1, 512U, 209U, 0u);        /*二级菜单 Resume To*/
                    }
                    else
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu3_TC_03_Word0, 434U, 131U, 0u);        /*二级菜单 恢复默认设置*/
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_HFMRSZ_Title_Word1, 536U, 210U, 0u); /*二级菜单 Resume To*/
                    }
                    select = ResToDef_Get();
                    
                    if (select == 0u)
                    {
                        GUI_Middle004_01();
                    } 
                    else if (select == 1u)
                    {
                        GUI_Middle004_02();
                    }
                    else
                    {
                        ;
                    }
                                        
                    break;

                //视频信息
                case  4:
                    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*二级菜单 视频格式背景*/
                    if (LanguageTyp_Get() == 0u)
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_SPGS_Title_Word0, 535U, 128U, 0u); /*二级菜单 视频格式*/
                        GUI_Translate_Display(Middle_Sprite, Set_Menu3_TC_02_Word1, 522U, 230U, 0u); /*二级菜单 Video  Format*/
                    }
                    else
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_SPGS_Title_Word2, 434U, 131U, 0u); /*二级菜单 视频格式*/
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_SPGS_Title_Word1, 548U, 230U, 0u); /*二级菜单 Video  Format*/
                    }                
                    
                    switch (VdoFmtTyp_Get())
                    {
                        case  0: GUI_Middle_005_01(); break;
                        case  1: GUI_Middle_005_02(); break;
                        case  2: GUI_Middle_005_03(); break;
                                                
                        default: GUI_Middle_005_01(); break;
                    }
                    
                    break;

                //限速值
                case  5:
                    GUI_Translate_Display(Middle_Sprite, Bottom_Set, 409U, 109U, 2u); /*二级菜单 背景*/
                    if (LanguageTyp_Get() == 0u)
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_CSBJ_Title_Word0, 535U, 128U, 0u); /*二级菜单 超速报警*/
                    }
                    else
                    {
                        GUI_Translate_Display(Middle_Sprite, Set_Menu2_CSBJ_Title_Word1, 504U, 132U, 0u); /*二级菜单 超速报警*/
                    }

                    switch (LitSpdTyp_Get())
                    {
                        case  0: GUI_Middle_006_01(); break;
                        case  1: GUI_Middle_006_02(); break;
                        case  2: GUI_Middle_006_03(); break;
                                                
                        default: GUI_Middle_006_01(); break;
                    }
  
                default: break;
            }
        }
        else
        {
            switch (VhlInfTyp_Get())
            {
                case  0u:
                    /*三级菜单 组合仪表*/
                    switch (Info_Page_Get(Vhcl_Info_IC))
                    {
                        case 0u: GUI_Middle_001_00_00(); break;
                        case 1u: GUI_Middle_001_00_01(); break;
                        
                        default: break;
                    }
                    break;
                case  1u:
                    /*三级菜单 动力电池组*/
                    switch (Info_Page_Get(Vhcl_Info_BMS))
                    {
                        case 0u:  GUI_Middle_001_01_00(); break;
                        case 1u:  GUI_Middle_001_01_01(); break;
                        case 2u:  GUI_Middle_001_01_02(); break;
                        case 3u:  GUI_Middle_001_01_03(); break;
                        case 4u:  GUI_Middle_001_01_04(); break;
                        case 5u:  GUI_Middle_001_01_05(); break;

                        case 6u:  GUI_Middle_001_01_06(ID_BMS_RMON_M0_Msg_Count, 0u); break;
                        case 7u:  GUI_Middle_001_01_06(ID_BMS_RMON_M1_Msg_Count, 1u); break;
                        case 8u:  GUI_Middle_001_01_06(ID_BMS_RMON_M2_Msg_Count, 2u); break;
                        case 9u:  GUI_Middle_001_01_06(ID_BMS_RMON_M3_Msg_Count, 3u); break;
                        case 10u: GUI_Middle_001_01_06(ID_BMS_RMON_M4_Msg_Count, 4u); break;
                        case 11u: GUI_Middle_001_01_06(ID_BMS_RMON_M5_Msg_Count, 5u); break;
                        
                        case 12u: GUI_Middle_001_01_12(ID_BMS_RMON_N00_Msg_Count, ID_BMS_RMON_N01_Msg_Count, 0u); break;
                        case 13u: GUI_Middle_001_01_12(ID_BMS_RMON_N02_Msg_Count, ID_BMS_RMON_N03_Msg_Count, 1u); break;
                        case 14u: GUI_Middle_001_01_12(ID_BMS_RMON_N04_Msg_Count, ID_BMS_RMON_N05_Msg_Count, 2u); break;
                        case 15u: GUI_Middle_001_01_12(ID_BMS_RMON_N06_Msg_Count, ID_BMS_RMON_N07_Msg_Count, 3u); break;
                        case 16u: GUI_Middle_001_01_12(ID_BMS_RMON_N08_Msg_Count, ID_BMS_RMON_N09_Msg_Count, 4u); break;
                        case 17u: GUI_Middle_001_01_12(ID_BMS_RMON_N10_Msg_Count, ID_BMS_RMON_N11_Msg_Count, 5u); break;
                        case 18u: GUI_Middle_001_01_12(ID_BMS_RMON_N12_Msg_Count, ID_BMS_RMON_N13_Msg_Count, 6u); break;
                        case 19u: GUI_Middle_001_01_12(ID_BMS_RMON_N14_Msg_Count, ID_BMS_RMON_N15_Msg_Count, 7u); break;
                        case 20u: GUI_Middle_001_01_12(ID_BMS_RMON_N16_Msg_Count, ID_BMS_RMON_N17_Msg_Count, 8u); break;
                        case 21u: GUI_Middle_001_01_12(ID_BMS_RMON_N18_Msg_Count, ID_BMS_RMON_N19_Msg_Count, 9u); break;
                        case 22u: GUI_Middle_001_01_12(ID_BMS_RMON_N20_Msg_Count, ID_BMS_RMON_N21_Msg_Count, 10u); break;
                        case 23u: GUI_Middle_001_01_12(ID_BMS_RMON_N22_Msg_Count, ID_BMS_RMON_N23_Msg_Count, 11u); break;
                        case 24u: GUI_Middle_001_01_12(ID_BMS_RMON_N24_Msg_Count, ID_BMS_RMON_N25_Msg_Count, 12u); break;
                        case 25u: GUI_Middle_001_01_12(ID_BMS_RMON_N26_Msg_Count, ID_BMS_RMON_N27_Msg_Count, 13u); break;
                        case 26u: GUI_Middle_001_01_12(ID_BMS_RMON_N28_Msg_Count, ID_BMS_RMON_N29_Msg_Count, 14u); break;
                        case 27u: GUI_Middle_001_01_12(ID_BMS_RMON_N30_Msg_Count, ID_BMS_RMON_N31_Msg_Count, 15u); break;
                        case 28u: GUI_Middle_001_01_12(ID_BMS_RMON_N32_Msg_Count, ID_BMS_RMON_N33_Msg_Count, 16u); break;
                        case 29u: GUI_Middle_001_01_12(ID_BMS_RMON_N34_Msg_Count, ID_BMS_RMON_N35_Msg_Count, 17u); break;
                        case 30u: GUI_Middle_001_01_12(ID_BMS_RMON_N36_Msg_Count, ID_BMS_RMON_N37_Msg_Count, 18u); break;
                        case 31u: GUI_Middle_001_01_12(ID_BMS_RMON_N38_Msg_Count, ID_BMS_RMON_N39_Msg_Count, 19u); break;
                        case 32u: GUI_Middle_001_01_12(ID_BMS_RMON_N40_Msg_Count, ID_BMS_RMON_N41_Msg_Count, 20u); break;
                        case 33u: GUI_Middle_001_01_12(ID_BMS_RMON_N42_Msg_Count, ID_BMS_RMON_N43_Msg_Count, 21u); break;
                        case 34u: GUI_Middle_001_01_12(ID_BMS_RMON_N44_Msg_Count, ID_BMS_RMON_N45_Msg_Count, 22u); break;
                        case 35u: GUI_Middle_001_01_12(ID_BMS_RMON_N46_Msg_Count, ID_BMS_RMON_N47_Msg_Count, 23u); break;
                        case 36u: GUI_Middle_001_01_12(ID_BMS_RMON_N48_Msg_Count, ID_BMS_RMON_N49_Msg_Count, 24u); break;
                        default: break;
                    }
                    break;
                
                case  2u:
                    /*三级菜单 整车控制器*/
                    switch (Info_Page_Get(Vhcl_Info_VCU))
                    {
                        case 0u: GUI_Middle_001_02_00(); break;
                        case 1u: GUI_Middle_001_02_01(); break;
                        case 2u: GUI_Middle_001_02_02(); break;
                        case 3u: GUI_Middle_001_02_03(); break;
                        case 4u: GUI_Middle_001_02_04(); break;
                        case 5u: GUI_Middle_001_02_05(); break; //0037用

                        default: break;
                    }
                    break;

                case  3u:
                    /*三级菜单 电机控制器*/
                    switch (Info_Page_Get(Vhcl_Info_MCU))
                    {
                        case 0u: GUI_Middle_001_03_00(); break;
                        case 1u: GUI_Middle_001_03_01(); break;
                        case 2u: GUI_Middle_001_03_02(); break;
                        
                        default: break;
                    }
                    break;    

                case  4u:
                    /*三级菜单 充电机*/
                    GUI_Middle_001_04_00();
                    break;
                
                case  5u:
                    /*三级菜单 绝缘检测仪*/
                    switch (Info_Page_Get(Vhcl_Info_ISL))
                    {
                        case 0u: GUI_Middle_001_05_00(); break;
                        case 1u: GUI_Middle_001_05_01(); break;
                                   
                        default: break;
                    }
                    break;

                case  6u:
                    /*三级菜单 辅助控制器*/
                    switch (Info_Page_Get(Vhcl_Info_SCU))
                    {
                        case 0u: GUI_Middle_001_06_00(); break;
                        case 1u: GUI_Middle_001_06_01(); break;
                                   
                        default: break;
                    }
                    break;            

                case  7u:
                    /*三级菜单 ABS_SPN/FMI/*/
                    GUI_Middle_001_07_Sub(Info_Page_Get(Vhcl_Info_ABS));
                    break;

                case  8u:
                    /*三级菜单 软件版本*/
                    switch (Info_Page_Get(Vhcl_Info_SW))
                    {
                        case 0u: GUI_Middle_001_08_00(); break;
                        case 1u: GUI_Middle_001_08_01(); break;
                                   
                        default: break;
                    }
                    break;

                case  9u:
                    /*三级菜单 语言*/
                    GUI_Middle_001_09_00();
                    break;                    
                
                default: break;
            }
        }
    }
}

void PID_init(_pid *speed, float kp, float ki)
{
	speed->SetSpeed = 0.0;
	speed->ActualSpeed = 0.0;
	speed->err = 0.0;
	speed->err_last = 0.0;
	speed->err_next = 0.0;
	speed->kp = kp;
	speed->ki = ki;
	speed->kd = 0.0;
}

void PID_Parameters_Init(void)
{
	PID_init(&VehSpeed, 0.04, 0.04);
    PID_init(&MtrSpeed, 0.04, 0.04);
}

float ABS(float value)
{
    if (value >= 0)
    {
        return value;
    }
    else
    {
        return (0.0f - value);
    }
}

float PID_Realize(float spd, _pid *speed)
{
	float incrementSpeed;

    speed->SetSpeed = spd;
	speed->err = speed->SetSpeed - speed->ActualSpeed;
    
    if (speed->err > 40)
    {
        speed->err = 40;
    }
    else
    {
        if (speed->err < -40)
        {
            speed->err = -40;
        }
    }
	
    incrementSpeed = speed->kp * (speed->err - speed->err_next) + speed->ki * speed->err/* + speed->kd * (speed->err - 2 * speed->err_next + speed->err_last)*/;
	speed->ActualSpeed += incrementSpeed;
	speed->err_last = speed->err_next;
	speed->err_next = speed->err;
	
    if (ABS(speed->err) < 0.1)
    {
        speed->ActualSpeed = speed->SetSpeed;
    }

    return speed->ActualSpeed;
}

uint8_t  VSpdDispUpTim = 5u;
uint16_t VehSpdLst     = 0u;

//右侧车速表
void GUI_Right(void)
{
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Right_Sprite, Right_Sprite);
        return;
    }

    uint16_t speed = 0;

    if (((Common_GetIgnOnTime() < 3500u) && (Common_Get_IG_Sts() == 1u)) || (Common_Get_IG_Sts() == 0u))
    {
        //VehSpdLst = 0u;
    }
    else
    {
        speed = Speed_Get_Display_Value();
    }
    
    //车速指针
    float u32tmp = PID_Realize((float)speed * 0.203, &VehSpeed);
    
    if (u32tmp > 243.5f)
    {
        u32tmp = 243.5f;
    } 
    
    GUI_Translate_Display1(Right_Sprite, pointer, 1041u, 237u, 1u, u32tmp - 31.5f, 1.0f, 0u);
    
    if (u32tmp <= 243.5f)
    {
        u32tmp *= 1200;
        u32tmp /= 243.5f;
        speed  = (uint16_t)u32tmp;
    }

    if (++VSpdDispUpTim >= 5u)
    {
        VSpdDispUpTim = 0u;
        VehSpdLst     = speed;
    }
    else
    {
        ;
    }
    
    speed = VehSpdLst;

    uint16_t Num[3] = {0};
    
    speed /= 10;
    
    if (speed >= 100)
    {	
        Num[0] = ImageID_Number_38_white[speed / 100];
    }
    
    speed %= 100;
    
    if ((speed >= 10) || Num[0])
    {	
        Num[1] = ImageID_Number_38_white[speed / 10];
    }

    Num[2] = ImageID_Number_38_white[speed % 10];
    
    if (Num[0])
    {
        GUI_Translate_Display(Right_Sprite, Num[0], 989u, 213U, 0);  /*车速 百位*/
        GUI_Translate_Display(Right_Sprite, Num[1], 1022u, 213U, 0); /*车速 十位*/
        GUI_Translate_Display(Right_Sprite, Num[2], 1056u, 213U, 0); /*车速 个位*/
    }
    else
    {
        if (Num[1])
        {
            GUI_Translate_Display(Right_Sprite, Num[1], 1006u, 213U, 0); /*车速 十位*/
            GUI_Translate_Display(Right_Sprite, Num[2], 1039u, 213U, 0); /*车速 个位*/
        }
        else
        {
            GUI_Translate_Display(Right_Sprite, Num[2], 1022u, 213U, 0); /*车速 个位*/
        }
    }
}

uint16_t Speed_Get_CurDisp(void)
{
    return (uint16_t)VehSpdLst;
}

//顶部左侧报警灯
void GUI_Top1(void)
{   
    //清空
    loc_Del_Sprite(Top1_Sprite, Top1_Sprite);

    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        return;
    }    
    
    if (LED_Get_Status(em_LED_MtrMCUHiTpt))
    {
        GUI_Translate_Display(Top1_Sprite, Lamp_010, 12U, 25U, 2u); /*电机过温*/
    }
    
    if (LED_Get_Status(em_LED_VcmPmp))
    {
        GUI_Translate_Display(Top1_Sprite, Lamp_016, 60U, 25U, 2u); /*真空泵故障*/
    }

    if (LED_Get_Status(em_LED_Battery) == 1u)
    {
        GUI_Translate_Display(Top1_Sprite, Lamp_044, 21, 72U, 2); /*电池*/
    }
    else
    {
        if (LED_Get_Status(em_LED_Battery) == 2u)
        {
            if (FLASH_SYNC_1Hz)
            {
                GUI_Translate_Display(Top1_Sprite, Lamp_044, 21, 72U, 2); /*电池*/
            }
            else
            {
                ;
            }
        }
        else
        {
            ;
        }
    }
}

//星期
static const uint16_t ImageID_WEEK[] = 
{
    ECU_Uint_Time_07,
    ECU_Uint_Time_01,
    ECU_Uint_Time_02,
    ECU_Uint_Time_03,
    ECU_Uint_Time_04,
    ECU_Uint_Time_05,
    ECU_Uint_Time_06,
};
//星期
#if 0
void GUI_Top2(void)
{   
    uint8_t time = 0;
    
    time = Get_RTC_WEEK();
    
    GUI_Translate_Display(Top2_Sprite, ImageID_WEEK[time], 337U, 20U, 2); /*星期*/
}
#endif

#if 0
//气压表1
uint8_t AirP1UpTim = 80;

void GUI_AirP1(void)
{
    if (Brake_Type == Oil_Brake)
    {
        //清空
        loc_Del_Sprite(AirP1_Sprite, AirP1_Sprite);
        return;
    }
        
    if (++AirP1UpTim < 80)
    {
        return;
    }
    else
    {
        AirP1UpTim = 0;
    }
    
    uint16_t value = AirPressure_Get_Value(0);
    uint8_t  valid = AirPressure_Get_Valid(0);
    
    GUI_Translate_Display(AirP1_Sprite, Image1, 338U, 48U, 2); /*气刹符号*/
    
    if (valid == 0u)
    {
        GUI_Translate_Display(AirP1_Sprite, Number_18_white_Line3, 403U, 59U, 0); /*---*/
    }
    else
    {
        GUI_Translate_Display(AirP1_Sprite, ImageID_Number_18_white[value / 100], 377U, 50U, 0); /*个位*/
        value %= 100;
        GUI_Translate_Display(AirP1_Sprite, Number_18_white_point, 395U, 60U, 0); /*小数点*/
        GUI_Translate_Display(AirP1_Sprite, ImageID_Number_18_white[value / 10], 402U, 50U, 0); /*十分位*/
        GUI_Translate_Display(AirP1_Sprite, ImageID_Number_18_white[value % 10], 420U, 50U, 0); /*百分位*/
    }

    GUI_Translate_Display(AirP1_Sprite, unit_Mpa, 438U, 50U, 0); /*单位MPa*/
}
#endif
//时钟
#if 0
void GUI_Clock(void)
{
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Clock_Sprite, Clock_Sprite);
        return;
    }

    uint8_t hour   = 0u;
    uint8_t minute = 0u;
    
    uint8_t status = ClkSetSts_Get();
    uint8_t type   = ClkSetTyp_Get();
    
    if (status)
    {
        //清空
        loc_Del_Sprite(Clock_Sprite, Clock_Sprite);
        
        hour   = ClkSetHour_Get();
        minute = ClkSetMinute_Get();
    }
    else
    {
        hour   = Get_RTC_HOUR();
        minute = Get_RTC_MINUTE();
    }    

    if ((status == 0u) || ((type == 1u) && FlashSync1Hz) || (type == 0u))    
    {
        if ((hour >= 10) || status)
        {
            GUI_Translate_Display(Clock_Sprite, ImageID_Number_18_white[hour / 10], 405U, 21U, 0); /*时间小时十位*/
        }
        
        GUI_Translate_Display(Clock_Sprite, ImageID_Number_18_white[hour % 10], 424U, 21U, 0); /*时间小时个位*/
    }
    
    if (FlashSync1Hz)
    {
        GUI_Translate_Display(Clock_Sprite, Number_18_white_point2, 432U, 21U, 0); /*时间冒号*/
    }
    
    if ((status == 0u) || ((type == 0u) && FlashSync1Hz) || (type == 1u))    
    {
        GUI_Translate_Display(Clock_Sprite, ImageID_Number_18_white[minute / 10], 451U, 21U, 0); /*时间分钟十位*/
        GUI_Translate_Display(Clock_Sprite, ImageID_Number_18_white[minute % 10], 470U, 21U, 0);  /*时间分钟个位*/
    }
}
#endif
//挡位
uint8_t GearDispUpTim = 20u;

//顶部上排报警灯+挡位
void GUI_Top4(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Top4_Sprite, Top4_Sprite);

        if (Gear_Get_Value() < 10u)
        {
            if (Gear_Get_Value() != 8u)
            {
                GUI_Translate_Display(Top4_Sprite, ImageID_Gear[Gear_Get_Value()], 613U, 15U, 0); /*档位*/
            }
            else
            {
                GUI_Translate_Display(Top4_Sprite, ImageID_Gear[Gear_Get_Value()], 627U, 14U, 0); /*档位*/
            }
        }
         
        return;
    }

    /*if (++GearDispUpTim < 20u)
    {
        return;
    }
    else
    {
        GearDispUpTim = 0u;
    }*/

    //清空
    loc_Del_Sprite(Top4_Sprite, Top4_Sprite);
        
    if (LED_Get_TurnLeft_Status())
    {
        GUI_Translate_Display(Top4_Sprite, Lamp_039, 505U, 16U, 2); /*左转向*/
    }
    
    if (LED_Get_Status(em_LED_Position))
    {
        if (((MenuSetSts_Get() == 0u) || (MenuSetTyp_Get() != 2u)) && ((Common_GetIgnOnTime() >= 3500u) || (Common_Get_IG_Sts() == 0u)))
        {
            Brightness_Mode_Set(1u);
        }
        
        GUI_Translate_Display(Top4_Sprite, Lamp_037, 551U, 17U, 2); /*小灯*/
    }
    else
    {
        if ((MenuSetSts_Get() == 0u) || (MenuSetTyp_Get() != 1u))
        {
            Brightness_Mode_Set(0u);
        }
    }
    
    if (Gear_Get_Value() < 10u)
    {    
        if (Gear_Get_Value() != 8u)
        {
            GUI_Translate_Display(Top4_Sprite, ImageID_Gear[Gear_Get_Value()], 613U, 15U, 0); /*档位*/
        }
        else
        {
            GUI_Translate_Display(Top4_Sprite, ImageID_Gear[Gear_Get_Value()], 627U, 14U, 0); /*档位*/
        }
    }
     
    if (LED_Get_Status(em_LED_LoBeam))
    {
        GUI_Translate_Display(Top4_Sprite, Lamp_036, 674U, 17U, 2); /*近光灯*/
    }
    
    if (LED_Get_TurnRight_Status())
    {
        GUI_Translate_Display(Top4_Sprite, Lamp_038, 722U, 16U, 2); /*右转向*/
    }
}

//顶部右侧辅助电池电压
uint8_t BatValUptTim = 100;

void GUI_Top5(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Top5_Sprite, Top5_Sprite);
        BatValUptTim = 100;
        return;
    }
    
    /* 修改语言时变化慢 20240111屏掉 */
    /*if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++BatValUptTim < 100)
        {
            return;
        }
        else
        {
            BatValUptTim = 0;
        }
    }*/
    
    uint16_t volt = 0;

    volt = BatVltFlt_Get_Value() / 100; //0.1V
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Top5_Sprite, ECU_01_Word0, 771U, 19U, 2); /*辅助电池：*/
    }
    else
    {
        GUI_Translate_Display(Top5_Sprite, ECU_01_Word1, 786U, 19U, 2); /*辅助电池：*/
    }
    
    if (volt >= 1000)
    {
        volt = 999;
    }
    
    if (volt >= 100)
    {
        GUI_Translate_Display(Top5_Sprite, ImageID_Number_18_white[volt / 100], 866U, 20U, 0); /*十位*/
    }
    
    volt %= 100;
    
    GUI_Translate_Display(Top5_Sprite, ImageID_Number_18_white[volt / 10], 885U, 20U, 0); /*个位*/  
    GUI_Translate_Display(Top5_Sprite, Number_18_white_point, 905U, 31U, 0);              /*小数点*/  
    GUI_Translate_Display(Top5_Sprite, ImageID_Number_18_white[volt % 10], 913U, 20U, 0); /*十分位*/  
    GUI_Translate_Display(Top5_Sprite, Number_18_white_Unit_V, 931U, 20U, 0);             /*单位V*/  
}
#if 0
//气压表2
uint8_t AirP2UpTim = 80u;

void GUI_AirP2(void)
{
    if (Brake_Type == Oil_Brake)
    {
        //清空
        loc_Del_Sprite(AirP2_Sprite, AirP2_Sprite);
        AirP2UpTim = 80u;
        return;
    }
        
    if (++AirP2UpTim < 80u)
    {
        return;
    }
    else
    {
        AirP2UpTim = 0;
    }
    
    uint16_t value = AirPressure_Get_Value(1);
    uint8_t  valid = AirPressure_Get_Valid(1);
    
    GUI_Translate_Display(AirP2_Sprite, Image2, 772U, 48U, 2); /*气刹符号*/    
        
    if (valid == 0u)
    {
        GUI_Translate_Display(AirP2_Sprite, Number_18_white_Line3, 837U, 59U, 0); /*---*/
    }
    else
    {
        GUI_Translate_Display(AirP2_Sprite, ImageID_Number_18_white[value / 100], 811U, 50U, 0); /*个位*/
        GUI_Translate_Display(AirP2_Sprite, Number_18_white_point, 829U, 60U, 0); /*小数点*/
        value %= 100;
        GUI_Translate_Display(AirP2_Sprite, ImageID_Number_18_white[value / 10], 836U, 50U, 0); /*十分位*/
        GUI_Translate_Display(AirP2_Sprite, ImageID_Number_18_white[value % 10], 854U, 50U, 0); /*百分位*/
    }
        
    GUI_Translate_Display(AirP2_Sprite, unit_Mpa, 872U, 50U, 0);  /*单位MPa*/
}
#endif
//顶部右侧报警灯
uint8_t Top6DispUpTim = 20u;

void GUI_Top6(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Top6_Sprite, Top6_Sprite);
        Top6DispUpTim = 20u;
        return;
    }
    
    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Top6DispUpTim < 20u)
        {
            return;
        }
        else
        {
            Top6DispUpTim = 0u;
        }
    }

    //清空
    loc_Del_Sprite(Top6_Sprite, Top6_Sprite);

    if (LED_Get_Status(em_LED_IslFlt))
    {
        GUI_Translate_Display(Top6_Sprite, Lamp_013, 1173U, 25U, 2); /*绝缘电阻报警*/
    }
    
    if (LED_Get_Status(em_LED_BrkPad))
    {
        GUI_Translate_Display(Top6_Sprite, Lamp_018, 1221U, 25U, 2); /*刹车片故障*/
    }

    if (LED_Get_Status(em_LED_Charge))
    {
        GUI_Translate_Display(Top6_Sprite, Lamp_043, 1226, 71U, 2); /*充电连接*/
    }
}
//20231012 加巡航车速
void GUI_Top2(void)
{   
    loc_Del_Sprite(Top2_Sprite, Top2_Sprite);

    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        return;
    }

    if ((LED_Get_Status(em_LED_Cruise) != 2u) || (CAN_MSG_Status(ID_VCU_VCUSts3_Msg_Count) != CAN_SIG_RECEIVE))
    {
        return;
    }

    uint16_t speed = Get_ID_18F104D0_Sig_VCU_ACCSpd();

    if (speed > 120u)
    {
        speed = 120u;
    }

    if (speed >= 100u)
    {
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed / 100u), 616U, 55U, 0u); /*百位*/
        speed %= 100u;
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed / 10u), 630U, 55U, 0u); /*十位*/
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed % 10u), 644U, 55U, 0u); /*个位*/
        GUI_Translate_Display(Top2_Sprite, Lamp_kmh, 661U, 55U, 0u); /*km/h*/
    }
    else if (speed >= 10u)
    {
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed / 10u), 623U, 55U, 0u); /*十位*/
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed % 10u), 637U, 55U, 0u); /*个位*/
        GUI_Translate_Display(Top2_Sprite, Lamp_kmh, 654U, 55U, 0u); /*km/h*/
    }
    else
    {
        GUI_Translate_Display(Top2_Sprite, Number_14_white_0 + (uint8_t)(speed % 10u), 630U, 55U, 0u); /*个位*/
        GUI_Translate_Display(Top2_Sprite, Lamp_kmh, 647U, 55U, 0u); /*km/h*/
    }
}

//顶部下排报警灯
uint8_t Top7DispUpTim = 20u;

void GUI_Top7(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Top7_Sprite, Top7_Sprite);
        return;
    }
    
  /* 20230802 按变更要求修改 */
  #if 0
    if (++Top7DispUpTim < 20u)
    {
        return;
    }
    else
    {
        Top7DispUpTim = 0u;
    }
  #endif  
    //清空
    loc_Del_Sprite(Top7_Sprite, Top7_Sprite);
    
    if (LED_Get_Status(em_LED_HiBeam))
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_035, 399U, 73U, 2); /*远光-蓝色*/
    }
    
    if (LED_Get_Status(em_LED_RFog))
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_034, 451U, 73U, 2); /*后雾灯*/
    }
    
    if (LED_Get_Status(em_LED_FFog))
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_033, 497U, 73U, 2); /*前雾灯*/
    }
    
    if (LED_Get_Status(em_LED_Defrost))
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_032, 544U, 74U, 2); /*除霜灯*/
    }
    
    if (LED_Get_Status(em_LED_BrkFlt))
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_031, 591U, 73U, 2); /*制动故障*/
    }

    if (LED_Get_Status(em_LED_Cruise) == 1u)
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_051, 638U, 74U, 2); /*定速巡航 白灯*/
    }
    else if (LED_Get_Status(em_LED_Cruise) == 2u)
    { 
        GUI_Translate_Display(Top7_Sprite, Lamp_030, 638U, 74U, 2); /*定速巡航 绿灯*/
    }

    if (LED_Get_Status(em_LED_ABS))
    {
        GUI_Translate_Display(Top7_Sprite, Lamp_029, 689U, 75U, 2); /*ABS*/
    }

    if (LED_Get_Status(em_LED_SeatBelt))
    {
        GUI_Translate_Display(Top7_Sprite, Lamp_028, 737U, 75U, 2); /*安全带*/
    }

    if (LED_Get_Status(em_LED_DayLight))
    {
        GUI_Translate_Display(Top7_Sprite, Lamp_040, 788U, 74U, 2); /*日间行车灯*/
    }

    if (LED_Get_Status(em_LED_PwrBatHiTpt))
    {
        GUI_Translate_Display(Top7_Sprite, Lamp_04, 833U, 75U, 2);  /*动力蓄电池过热*/
    }
}

//底部中间报警灯
uint8_t Bot1DispUpTim = 20u;
uint8_t LED_Ready_Last;

void GUI_Bottm1(void)
{   
    uint8_t status = 0u;

    uint8_t ready = LED_Get_Status(em_LED_Ready);

    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm1_Sprite, Bottm1_Sprite);
        Bot1DispUpTim = 20u;
        return;
    }

    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (LED_Ready_Last != ready)
        {
            LED_Ready_Last = ready;
            Bot1DispUpTim = 20u;
        }

        if (++Bot1DispUpTim < 20u)
        {
            return;
        }
        else
        {
            Bot1DispUpTim = 0u;
        }
    }
    
    //清空
    loc_Del_Sprite(Bottm1_Sprite, Bottm1_Sprite);

    //门开
    status = LED_Get_Status(em_LED_Door);

    if (status == 1u)
    {
        GUI_Translate_Display(Bottm1_Sprite, Lamp_025, 307U, 373U, 2); /*左门开*/
    }
    else if (status == 2u)
    {
        GUI_Translate_Display(Bottm1_Sprite, Lamp_045, 319U, 373U, 2); /*右门开*/
    }
    else if (status == 3u)
    {
        GUI_Translate_Display(Bottm1_Sprite, Lamp_046, 319U, 373U, 2); /*左右门开*/
    }
    else
    {
        ;
    }
  
    if (LED_Get_Status(em_LED_CabOverturn))
    {
        GUI_Translate_Display(Bottm1_Sprite, Lamp_023, 353U, 373U, 2); /*驾驶室翻转*/
    }
    
    if (LED_Get_Status(em_LED_CarLifting))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_022, 399U, 376U, 2); /*车厢举升*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_022, 400U, 376U, 2); /*车厢举升*/
    }
    
    if (LED_Get_Status(em_LED_TPMS))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_021, 445U, 373U, 2); /*胎压*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_021, 451U, 373U, 2); /*胎压*/
    }

    if (LED_Get_Status(em_LED_PTO1))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_020, 491U, 375U, 2); /*停车取力*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_020, 497U, 375U, 2); /*停车取力*/
    }

    if (LED_Get_Status(em_LED_PTO2))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_019, 537U, 375U, 2); /*行车取力*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_019, 544U, 375U, 2); /*行车取力*/
    }
    
    if (LED_Get_Status(em_LED_OverSpd))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_02, 583U, 375U, 2); /*超速*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_047, 601U, 374U, 2); /*超速*/
    }
    
    if (LED_Get_Status(em_LED_PwrBatFlt))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_017, 629U, 375U, 2); /*蓄电池相关故障*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_017, 640U, 375U, 2); /*蓄电池相关故障*/
    }

    if (LED_Get_Status(em_LED_PTO1))//((Common_GetIgnOnTime() < 3500) && Common_Get_IG_Sts())
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_024, 675U, 375U, 2); /*黄P*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_024, 688U, 375U, 2); /*黄P*/
    }
        
    if (LED_Get_Status(em_LED_LoSOC))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_015, 721U, 373U, 2); /*电池剩余容量低*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_015, 735U, 373U, 2); /*电池剩余容量低*/
    }

    if (LED_Get_Status(em_LED_SysFlt))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_014, 767U, 374U, 2); /*系统相关故障*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_014, 786U, 374U, 2); /*系统相关故障*/
    }

    if (LED_Get_Status(em_LED_PwrBatCut))
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_03, 813U, 375U, 2); /*动力蓄电池切断*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_03, 835U, 375U, 2); /*动力蓄电池切断*/
    }

    if (LED_Get_Status(em_LED_MtrFlt))
    {
        GUI_Translate_Display(Bottm1_Sprite, Lamp_011, 877U, 373U, 2); /*电机相关故障*/
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_011, 859U, 373U, 2); /*电机相关故障*/
    }

    //ready
    if (ready)
    {
        //GUI_Translate_Display(Bottm1_Sprite, Lamp_012, 905u, 376U, 2); /*READY*/
        GUI_Translate_Display(Bottm1_Sprite, Lamp_012, 921u, 376U, 2); /*READY*/
    }
}

//电池温度
uint8_t Bot2DispUpTim = 60u;

void GUI_Bottm2(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm2_Sprite, Bottm2_Sprite);
        Bot2DispUpTim = 60u;
        return;
    }
    /* 修改语言时变化慢 20240111屏掉 */
    /*if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Bot2DispUpTim < 60u)
        {
            return;
        }
        else
        {
            Bot2DispUpTim = 0u;
        }
    }*/
    
    uint16_t value = BtyMaxTpt_Get_Value();
    uint8_t  valid = BtyMaxTpt_Get_Valid();
    uint8_t  sign  = BtyMaxTpt_Get_Sign();
    uint16_t temp  = 0u;
    
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Bottm2_Sprite, ECU_13_Word0, 30U, 413U, 2); /*电池文字*/
    }
    else
    {
        GUI_Translate_Display(Bottm2_Sprite, ECU_13_Word1, 21U, 415U, 2); /*电池文字*/
        temp = 24u;
    }
    
    if (valid == 1u)
    {
        if (sign)
	    {
            if (value >= 10)
            {
                GUI_Translate_Display(Bottm2_Sprite, Number_18_white_Line, 80U + temp, 423U, 0); /*-*/
                GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value / 10], 89U + temp, 414U, 0); /*电池十位*/
            }
            else
            {
                GUI_Translate_Display(Bottm2_Sprite, Number_18_white_Line, 98U + temp, 423U, 0); /*-*/
            }
        }
        else
        {
            if (value >= 100)
            {
                GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value / 100], 71U + temp, 414U, 0);
                value %= 100;
                GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value / 10], 89U + temp, 414U, 0); /*电池十位*/
            }
            else if (value >= 10)
            {
                GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value / 10], 89U + temp, 414U, 0);
            }
        } 

        GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value % 10], 107U + temp, 414U, 0); /*电池个位*/
    }
    else
    {
        GUI_Translate_Display(Bottm2_Sprite, Number_18_white_Line3, 94U + temp, 423U, 0); /*---*/
    }

    GUI_Translate_Display(Bottm2_Sprite, Number_18_white_Unit_C, 129U + temp, 412U, 0); /*电池 单位*/

    if (LanguageTyp_Get() == 0u)
    {
        temp = 0u;
        GUI_Translate_Display(Bottm2_Sprite, dianliang, 174U, 414U, 2); /*电量文字*/
    }
    else
    {
        temp = 6u;
        GUI_Translate_Display(Bottm2_Sprite, dianliang1, 176U + 22U, 415U, 2); /*电量文字*/
    }
    
    value = SOC_Get_DesVal() / 10;
    
    if (Common_GetIgnOnTime() < 4000u)
    {
        value = 0u;
    } 

    if (value >= 100u)
    {
        GUI_Translate_Display(Bottm2_Sprite, Number_18_white_1, 222U + temp, 414U, 0); /*百位*/
        GUI_Translate_Display(Bottm2_Sprite, Number_18_white_0, 240U + temp, 414U, 0); /*十位*/
        GUI_Translate_Display(Bottm2_Sprite, Number_18_white_0, 258U + temp, 414U, 0); /*个位*/
    }
    else
    {
        if (value >= 10u)
        {
            GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value / 10], 240U + temp, 414U, 0); /*十位*/
            GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value % 10], 258U + temp, 414U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm2_Sprite, ImageID_Number_18_white[value], 258U + temp, 414U, 0); /*个位*/
        }
    }
    
    GUI_Translate_Display(Bottm2_Sprite, unit, 281U + temp, 417U, 2); /*%*/
}

//实时功率/电机转速
uint8_t Bot2PDispUpTim = 60u;

void GUI_Bottm2P(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm2P_Sprite, Bottm2P_Sprite);
        return;
    }

    /*if (++Bot2PDispUpTim < 60u)
    {
        return;
    }
    else
    {
        Bot2PDispUpTim = 0u;
    }*/

    uint16_t value = 0u;
    uint8_t  valid = 0u;
    uint8_t  sign  = 0u;
    uint8_t  Num[3];
    uint8_t  temp = 0u;

    if (Display_Interface_Get() < 2)
    {
        value = IstDrvMtrPwr_Get_Value();
        valid = IstDrvMtrPwr_Get_Valid();
        sign  = IstDrvMtrPwr_Get_Sign();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm2P_Sprite, ECU_06_Word0, 30U, 445U, 2); /*实时功率：*/
        }
        else
        {
            temp = 61u;
            GUI_Translate_Display(Bottm2P_Sprite, ECU_06_Word1, 21U, 447U, 2); /*实时功率：*/
        }
        
        if (valid)
        {
            if (sign)            //负数
            {
                if (value >= 100)
                {
                    GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Line, 116U + temp, 455U, 0); /*-*/
                }
                else if (value >= 10)
                {
                    GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Line, 134U + temp, 455U, 0); /*-*/
                }
                else
                {
                    GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Line, 152U + temp, 455U, 0); /*-*/
                }
            }
            
            Num[0] = 0;
            if (value >= 100)
            {
                Num[0] = value / 100;
                GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[Num[0]], 127U + temp, 446U, 0); /*百位*/
            }
            
            value %= 100;
                    
            if ((value >= 10) || Num[0])
            {
                GUI_Translate_Display(Bottm2P_Sprite, ImageID_Number_18_white[value / 10], 145U + temp, 446U, 0); /*十位*/
            }
                    
            GUI_Translate_Display(Bottm2P_Sprite, ImageID_Number_18_white[value % 10], 163U + temp, 446U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Line3, 150U + temp, 455U, 0); /*---*/
        }

        GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Unit_kw , 185U + temp, 447U, 0); /*单位kw*/
    }
    else if (Display_Interface_Get() == 2) //电机转速
    {
        value = DrvMtrSpd_Get_DisplayValue();
        //valid = DrvMtrSpd_Get_Valid();
        if (LanguageTyp_Get() == 0u)
        {
            temp = 0u;
            GUI_Translate_Display(Bottm2P_Sprite, ECU_07_Word0, 30U, 445U, 2); /*电机转速：*/
        }
        else
        {
            temp = 18u;
            GUI_Translate_Display(Bottm2P_Sprite, ECU_07_Word1, 21U, 447U, 2); /*电机转速：*/
        }
        //if (valid)
        {
            Num[0] = 0;
            
            if (value >= 10000) 
            {
                Num[0] = (uint8_t)(value / 10000);
                GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[Num[0]], 116U + temp, 446U, 0u); /*万位*/
            }
            
            value %= 10000;

            Num[1] = 0;
            if ((value >= 1000) || Num[0]) 
            {
                Num[1] = (uint8_t)(value / 1000);
                GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[Num[1]], 134U + temp, 446U, 0u); /*千位*/
            }

            value %= 1000;

            Num[2] = 0;
            if ((value >= 100) || Num[0] || Num[1]) 
            {
                Num[2] = (uint8_t)(value / 100);
                GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[Num[2]], 152U + temp, 446U, 0u); /*百位*/
            }

            value %= 100;

            if ((value >= 10) || Num[0] || Num[1] || Num[2]) 
            {
                GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[value / 10], 170U + temp, 446U, 0u); /*十位*/
            }
            
            GUI_Translate_Display(Bottm2P_Sprite,  ImageID_Number_18_white[value % 10], 188U + temp, 446U, 0u); /*个位*/
        }
        //else
        {
            //GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Line3, 175U, 455U, 0u); /*---*/
        }

        GUI_Translate_Display(Bottm2P_Sprite, Number_18_white_Unit_rm, 210U + temp, 447U, 0u); /*单位r/m*/
    }
    else
    {
        loc_Del_Sprite(Bottm2P_Sprite, Bottm2P_Sprite);
    }
}

uint8_t Bot3ispUpTim = 20u;

void GUI_Bottm3(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm3_Sprite, Bottm3_Sprite);
        Bot3ispUpTim = 20u;
        return;
    }

    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Bot3ispUpTim < 20u)
        {
            return;
        }
        else
        {
            Bot3ispUpTim = 0u;
        }
    }
    
    //清空
    loc_Del_Sprite(Bottm3_Sprite, Bottm3_Sprite);
    
    if (LED_Get_Status(em_LED_TCUFlt))
    {
        GUI_Translate_Display(Bottm3_Sprite, Lamp_09, 293U, 434U, 2); /*变速箱*/
    }
    
    if (LED_Get_Status(em_LED_EPSFlt))
    {
        GUI_Translate_Display(Bottm3_Sprite, Lamp_08, 340U, 435U, 2); /*EPS*/
    }
}

//电机温度
uint8_t Bot4ispUpTim = 60u;

void GUI_Bottm4(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm4_Sprite, Bottm4_Sprite);
        return;
    }

    /*if (++Bot4ispUpTim < 60u)
    {
        return;
    }
    else
    {
        Bot4ispUpTim = 0u;
    }*/
    
    if (Display_Interface_Get() != 2)
    {
        //清空
        loc_Del_Sprite(Bottm4_Sprite, Bottm4_Sprite);
        return;
    }
        
    uint8_t value = DrvMtrTpt_Get_Value();
    uint8_t valid = DrvMtrTpt_Get_Valid();
    uint8_t sign  = DrvMtrTpt_Get_Sign();
    uint8_t temp  = 0u;

    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Bottm4_Sprite, ECU_04_Word0, 408U, 413U, 2); /*电机温度：*/
    }
    else
    {
        temp = 30u;
        GUI_Translate_Display(Bottm4_Sprite, ECU_04_Word1, 425U, 415U, 2); /*电机温度：*/
    }

    if (valid)
    {
        if (sign)
        {
            if (value >= 10)
            {
                GUI_Translate_Display(Bottm4_Sprite, Number_18_white_Line, 503U + temp, 423U, 0); /*-*/
                GUI_Translate_Display(Bottm4_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 414U, 0); /*十位*/
            }
            else
            {
                GUI_Translate_Display(Bottm4_Sprite, Number_18_white_Line, 521U + temp, 423U, 0); /*-*/
            }
        }
        else
        {
            if (value >= 100)
            {
                GUI_Translate_Display(Bottm4_Sprite, ImageID_Number_18_white[value / 100], 494U + temp, 414U, 0); /*百位*/
                value %= 100;
                GUI_Translate_Display(Bottm4_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 414U, 0); /*十位*/
            }
            else if (value >= 10)
            {
                GUI_Translate_Display(Bottm4_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 414U, 0); /*十位*/
            }
        } 

        GUI_Translate_Display(Bottm4_Sprite, ImageID_Number_18_white[value % 10], 530U + temp, 414U, 0); /*个位*/
    }
    else
    {
        GUI_Translate_Display(Bottm4_Sprite, Number_18_white_Line3, 517U + temp, 423U, 0); /*---*/
    }

    GUI_Translate_Display(Bottm4_Sprite, Number_18_white_Unit_C, 552U + temp, 412U, 0); /*单位摄氏度*/    
}

//电池电压/单体最高/电控温度
uint8_t Bot5ispUpTim = 60u;

void GUI_Bottm5(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm5_Sprite, Bottm5_Sprite);
        return;
    }
    
    /*if (++Bot5ispUpTim < 60u)
    {
        return;
    }
    else
    {
        Bot5ispUpTim = 0u;
    }*/
    
    uint16_t value = 0;
    uint8_t  valid = 0;
    uint8_t  sign  = 0;
    uint8_t  Num[2];
    uint8_t  temp  = 0;
       
    if (Display_Interface_Get() == 0) //电池电压
    {
        value = BtyPckVtg_Get_Value() / 10;
        valid = BtyPckVtg_Get_Valid();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm5_Sprite, ECU_10_Word0, 408U, 445U, 2); /*电池电压：*/
        }
        else
        {
            temp = 30u;
            GUI_Translate_Display(Bottm5_Sprite, ECU_10_Word1, 425U, 447U, 2); /*电池电压：*/
        }

        if (valid)
        {
            Num[0] = 0;
            if (value >= 1000)
            {
                Num[0] = value / 1000;
                GUI_Translate_Display(Bottm5_Sprite,  ImageID_Number_18_white[Num[0]], 494U + temp, 446U, 0); /*千位*/
            }
            value %= 1000;
            Num[1] = 0;
            if ((value >= 100) || Num[0])
            {
                Num[1] = value / 100;
                GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[Num[1]], 512U + temp, 446U, 0); /*百位*/
            }
            value %= 100;
            if ((value >= 10) || Num[0] || Num[1])
            {
                GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 10], 530U + temp, 446U, 0); /*十位*/
            }

            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value % 10], 548U + temp, 446U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Line3, 535U + temp, 455U, 0); /*---*/
        }
        
        GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Unit_V, 570U + temp, 446U, 0); /*单位V*/
    }
    else if (Display_Interface_Get() == 1) //单体最高
    {
        value = BtyMaxCllVtg_Get_Value();
        valid = BtyMaxCllVtg_Get_Valid();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm5_Sprite, ECU_08_Word0, 408U, 445U, 2); /*单体最高：*/
        }
        else
        {
            temp = 30u;
            GUI_Translate_Display(Bottm5_Sprite, ECU_08_Word1, 425U, 447U, 2); /*单体最高：*/
        }

        if (valid)
        {
            if (value >= 10000)
            {
                GUI_Translate_Display(Bottm5_Sprite,  ImageID_Number_18_white[value / 10000], 494U + temp, 446U, 0); /*十位*/
            }
            value %= 10000;
            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 1000], 512U + temp, 446U, 0); /*个位*/
            
            GUI_Translate_Display(Bottm5_Sprite, Number_18_white_point, 530U + temp, 457U, 0); /*小数点*/
            
            value %= 1000;
            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 100], 536U + temp, 446U, 0); /*十分位*/
            value %= 100;
            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 10], 554U + temp, 446U, 0); /*百分位*/
            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value % 10], 572U + temp, 446U, 0); /*千分位*/
        }
        else
        {
            GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Line3, 555U + temp, 455U, 0); /*---*/
        }
        
        GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Unit_V, 590U + temp, 446U, 0); /*单位V*/
    }
    else if (Display_Interface_Get() == 2) //电控温度
    {
        value = DrvMCUTpt_Get_Value();
        valid = DrvMCUTpt_Get_Valid();
        sign  = DrvMCUTpt_Get_Sign();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm5_Sprite, ECU_05_Word0 , 408U, 445U, 2); /*电控温度：*/
        }
        else
        {
            temp = 55u;
            GUI_Translate_Display(Bottm5_Sprite, ECU_05_Word1 , 425U, 447U, 2); /*电控温度：*/
        }

        if (valid == 1u)
        {
            if (sign)
            {
                if (value >= 10)
                {
                    GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Line, 503U + temp, 455U, 0); /*-*/
                    GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 446U, 0); /*十位*/
                }
                else
                {
                    GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Line, 521U + temp, 455U, 0); /*-*/
                }
            }
            else
            {
                if (value >= 100)
                {
                    GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 100], 494U + temp, 446U, 0); /*百位*/
                    value %= 100;
                    GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 446U, 0); /*十位*/
                }
                else if (value >= 10)
                {
                    GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value / 10], 512U + temp, 446U, 0); /*十位*/
                }
            } 

            GUI_Translate_Display(Bottm5_Sprite, ImageID_Number_18_white[value % 10], 530U + temp, 446U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Line3, 517U + temp, 455U, 0); /*---*/
        }

        GUI_Translate_Display(Bottm5_Sprite, Number_18_white_Unit_C, 552U + temp, 444U, 0); /*单位摄氏度*/
    }
    else
    {
        loc_Del_Sprite(Bottm5_Sprite, Bottm5_Sprite);
    }
}

//电池最高温度
uint8_t Bot6ispUpTim = 60u;

void GUI_Bottm6(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm6_Sprite, Bottm6_Sprite);
        return;
    }

    /*if (++Bot6ispUpTim < 60u)
    {
        return;
    }
    else
    {
        Bot6ispUpTim = 0u;
    }*/
    
    if (Display_Interface_Get() != 2)
    {
        //清空
        loc_Del_Sprite(Bottm6_Sprite, Bottm6_Sprite);
        return;
    }

    uint8_t value = BtyMaxTpt_Get_Value();
    uint8_t valid = BtyMaxTpt_Get_Valid();
    uint8_t sign  = BtyMaxTpt_Get_Sign();
    uint8_t temp  = 0u;
    
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Bottm6_Sprite, ECU_02_Word01, 687U, 413U, 2u); /*电池最高：*/
    }
    else
    {
        temp = 10u;
        GUI_Translate_Display(Bottm6_Sprite, ECU_02_Word02, 673U, 415U, 2u); /*电池最高：*/
    }

    if (valid == 1u)
    {
        if (sign)
        {
            if (value >= 10)
            {
                GUI_Translate_Display(Bottm6_Sprite, Number_18_white_Line, 782U - temp, 423U, 0); /*-*/
                GUI_Translate_Display(Bottm6_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 414U, 0); /*十位*/
            }
            else
            {
                GUI_Translate_Display(Bottm6_Sprite, Number_18_white_Line, 800U - temp, 423U, 0); /*-*/
            }
        }
        else
        {
            if (value >= 100)
            {
                GUI_Translate_Display(Bottm6_Sprite, ImageID_Number_18_white[value / 100], 773U - temp, 414U, 0); /*百位*/
                value %= 100;
                GUI_Translate_Display(Bottm6_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 414U, 0); /*十位*/
            }
            else if (value >= 10)
            {
                GUI_Translate_Display(Bottm6_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 414U, 0); /*十位*/
            }
        } 

        GUI_Translate_Display(Bottm6_Sprite, ImageID_Number_18_white[value % 10], 809U - temp, 414U, 0); /*个位*/
    }
    else
    {
        GUI_Translate_Display(Bottm6_Sprite, Number_18_white_Line3, 796U - temp, 423U, 0); /*---*/
    }

    GUI_Translate_Display(Bottm6_Sprite, Number_18_white_Unit_C, 831U - temp, 412U, 0); /*单位摄氏度*/
}
//电池电流/单体最低/电池最低
uint8_t Bot7ispUpTim = 60u;

void GUI_Bottm7(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm7_Sprite, Bottm7_Sprite);
        return;
    }

    /*if (++Bot7ispUpTim < 60u)
    {
        return;
    }
    else
    {
        Bot7ispUpTim = 0u;
    }*/
    
    uint16_t value = 0u;
    uint8_t  valid = 0u;
    uint8_t  sign  = 0u;
    uint8_t  Num[2];
    uint8_t  temp  = 0u;
    
    if (Display_Interface_Get() == 0) //电池电流
    {
        value = BtyPckCrt_Get_Value() / 10; //A
        valid = BtyPckCrt_Get_Valid();
        sign  = BtyPckCrt_Get_Sign();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm7_Sprite, ECU_11_Word0, 687U, 445U, 2); /*电池电流：*/
        }
        else
        {
            temp = 4u;
            GUI_Translate_Display(Bottm7_Sprite, ECU_11_Word1, 673U, 447U, 2); /*电池电流：*/
        }

        if (valid)
        {
            if (sign)            //负数
            {
                if (value >= 1000)
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 773U - temp, 455U, 0); /*-*/
                }
                else if (value >= 100)
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 791U - temp, 455U, 0); /*-*/
                }
                else if (value >= 10)
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 809U - temp, 455U, 0); /*-*/
                } 
                else
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 827U - temp, 455U, 0); /*-*/
                }
            }
            
            Num[0] = 0;
            if (value >= 1000)
            {
                Num[0] = value / 1000;
                GUI_Translate_Display(Bottm7_Sprite,  ImageID_Number_18_white[Num[0]], 784U - temp, 446U, 0); /*千位*/
            }
            
            value %= 1000;
            
            Num[1] = 0;
            if ((value >= 100) || Num[0])
            {
                Num[1] = value / 100;
                GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[Num[1]], 802U - temp, 446U, 0); /*百位*/
            }
                    
            value %= 100;
            
            if ((value >= 10) || Num[0] || Num[1])
            {
                GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 10], 820U - temp, 446U, 0); /*十位*/
            }
            
            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value % 10], 838U - temp, 446U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line3, 825U - temp, 455U, 0); /*---*/
        }

        GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Unit_A , 860U - temp, 447U, 0); /*单位A*/
    }
    else if (Display_Interface_Get() == 1) //单体最低
    {
        value = BtyMinCllVtg_Get_Value();
        valid = BtyMinCllVtg_Get_Valid();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm7_Sprite, ECU_09_Word0, 687U, 445U, 2); /*单体最低：*/
        }
        else
        {
            temp = 1u;
            GUI_Translate_Display(Bottm7_Sprite, ECU_09_Word1, 673U, 447U, 2); /*单体最低：*/
        }

        if (valid)
        {
            if (value >= 10000)
            {
                GUI_Translate_Display(Bottm7_Sprite,  ImageID_Number_18_white[value / 10000], 773U - temp, 446U, 0); /*十位*/
            }
            value %= 10000;
            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 1000], 791U - temp, 446U, 0); /*个位*/
            
            GUI_Translate_Display(Bottm7_Sprite, Number_18_white_point, 809U - temp, 457U, 0); /*小数点*/
            
            value %= 1000;
            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 100], 815U - temp, 446U, 0); /*十分位*/
            value %= 100;
            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 10], 833U - temp, 446U, 0); /*百分位*/
            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value % 10], 851U - temp, 446U, 0); /*千分位*/
        }
        else
        {
            GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line3, 836U - temp, 455U, 0); /*---*/
        }
        
        GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Unit_V, 871U - temp, 446U, 0); /*单位V*/
    }
    else if (Display_Interface_Get() == 2) //电池最低
    {
        value = BtyMinCllTpt_Get_Value();
        valid = BtyMinCllTpt_Get_Valid();
        sign  = BtyMinCllTpt_Get_Sign();
        
        if (LanguageTyp_Get() == 0u)
        {
            GUI_Translate_Display(Bottm7_Sprite, ECU_03_Word0 , 687U, 445U, 2); /*电池最低：*/
        }
        else
        {
            temp = 10u;
            GUI_Translate_Display(Bottm7_Sprite, ECU_03_Word1 , 673U, 447U, 2); /*电池最低：*/
        }
        
        if (valid)
        {
            if (sign)
            {
                if (value >= 10)
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 782U - temp, 455U, 0); /*-*/
                    GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 446U, 0); /*十位*/
                }
                else
                {
                    GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line, 800U - temp, 455U, 0); /*-*/
                }
            }
            else
            {
                if (value >= 100)
                {
                    GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 100], 773U - temp, 446U, 0); /*百位*/
                    value %= 100;
                    GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 446U, 0); /*十位*/
                }
                else if (value >= 10)
                {
                    GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value / 10], 791U - temp, 446U, 0); /*十位*/
                }
            } 

            GUI_Translate_Display(Bottm7_Sprite, ImageID_Number_18_white[value % 10], 809U - temp, 446U, 0); /*个位*/
        }
        else
        {
            GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Line3, 796U - temp, 455U, 0); /*---*/
        }

        GUI_Translate_Display(Bottm7_Sprite, Number_18_white_Unit_C, 831U - temp, 444U, 0); /*单位摄氏度*/
    }
    else
    {
        loc_Del_Sprite(Bottm7_Sprite, Bottm7_Sprite);
    }
}
#if 0
uint8_t Bot8ispUpTim = 20u;

void GUI_Bottm8(void)
{   
    if (++Bot8ispUpTim < 20u)
    {
        return;
    }
    else
    {
        Bot8ispUpTim = 0u;
    }

    if (Display_Interface_Get() != 3u)
    {
        //清空
        loc_Del_Sprite(Bottm8_Sprite, Bottm8_Sprite);
        return;
    }

    GUI_Translate_Display(Bottm8_Sprite, Alarm_01_Image, 620U, 424U, 2); /*图形显示,刹车片磨损符号*/
    GUI_Translate_Display(Bottm8_Sprite, Alarm_02_Image, 579U, 408U, 2); /*图形显示,左上电池符号*/
    GUI_Translate_Display(Bottm8_Sprite, Alarm_03_Image, 579U, 445U, 2); /*图形显示,左下电池符号*/
    GUI_Translate_Display(Bottm8_Sprite, Alarm_04_Image, 687U, 445U, 2); /*图形显示,右下电池符号*/
    GUI_Translate_Display(Bottm8_Sprite, Alarm_03_Image, 687U, 408U, 2); /*图形显示,右上电池符号*/
}
#endif

uint8_t Bot9ispUpTim = 20u;

void GUI_Bottm9(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm9_Sprite, Bottm9_Sprite);
        Bot9ispUpTim = 20u;
        return;
    }
    
    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Bot9ispUpTim < 20u)
        {
            return;
        }
        else
        {
            Bot9ispUpTim = 0u;
        }
    }
    
    //清空
    loc_Del_Sprite(Bottm9_Sprite, Bottm9_Sprite);
    
    if (LED_Get_Status(em_LED_ECO))
    {
        GUI_Translate_Display(Bottm9_Sprite, Lamp_07, 891U, 435U, 2); /*ECO*/
    }

    if (LED_Get_Status(em_LED_PwrLmt))
    {
        GUI_Translate_Display(Bottm9_Sprite, Lamp_06, 939U, 434U, 2); /*跛行（乌龟灯）*/
    }
}

//电控温度
uint8_t Bot10ispUpTim = 60u;

void GUI_Bottm10(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm10_Sprite, Bottm10_Sprite);
        Bot10ispUpTim = 60u;
        return;
    }
    /* 修改语言时变化慢 20240111屏掉 */
    /*if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Bot10ispUpTim < 60u)
        {
            return;
        }
        else
        {
            Bot10ispUpTim = 0u;
        }
    }*/

    uint8_t value = DrvMCUTpt_Get_Value();
    uint8_t valid = DrvMCUTpt_Get_Valid();
    uint8_t sign  = DrvMCUTpt_Get_Sign();
    uint8_t temp  = 0u;
    
    if (LanguageTyp_Get() == 0u)
    {
        GUI_Translate_Display(Bottm10_Sprite, ECU_12_Word0 , 1118U, 413U, 2); /*电控*/
    }
    else
    {
        temp = 0;
        GUI_Translate_Display(Bottm10_Sprite, ECU_12_Word1 , 1098U, 415U, 2); /*电控*/
    }

    if (valid == 1u)
    {
        if (sign)
        {
            if (value >= 10)
            {
                GUI_Translate_Display(Bottm10_Sprite, Number_18_white_Line, 1168U, 423U, 0); /*-*/
                GUI_Translate_Display(Bottm10_Sprite, ImageID_Number_18_white[value / 10], 1177U, 414U, 0); /*十位*/
            }
            else
            {
                GUI_Translate_Display(Bottm10_Sprite, Number_18_white_Line, 1186U, 423U, 0); /*-*/
            }
        }
        else
        {
            if (value >= 100)
            {
                GUI_Translate_Display(Bottm10_Sprite, ImageID_Number_18_white[value / 100], 1159U, 414U, 0); /*百位*/
                value %= 100;
                GUI_Translate_Display(Bottm10_Sprite, ImageID_Number_18_white[value / 10], 1177U, 414U, 0); /*十位*/
            }
            else if (value >= 10)
            {
                GUI_Translate_Display(Bottm10_Sprite, ImageID_Number_18_white[value / 10], 1177U, 414U, 0); /*十位*/
            }
        } 

        GUI_Translate_Display(Bottm10_Sprite, ImageID_Number_18_white[value % 10], 1195U, 414U, 0); /*个位*/
    }
    else
    {
        GUI_Translate_Display(Bottm10_Sprite, Number_18_white_Line3, 1182U, 423U, 0); /*---*/
    }

    GUI_Translate_Display(Bottm10_Sprite, Number_18_white_Unit_C, 1217U, 412U, 0); /*单位摄氏度*/
}
//累计里程
uint8_t Bot11DispUpTim = 5u;

void GUI_Bottm11(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Bottm11_Sprite, Bottm11_Sprite);
        Bot11DispUpTim = 5u;
        return;
    }

    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++Bot11DispUpTim < 5u)
        {
            return;
        }
        else
        {
            Bot11DispUpTim = 0u;
        }
    }
    
    uint32_t odo = 0u;
    uint8_t  Num[4];
    uint8_t  typ = MileType_Get();
    
    if (typ == 0u)
    {
        odo = Data_ODO_Read() / 10;
        Integer_Display(Bottm11_Sprite, odo, 1174u, 446u);
        GUI_Translate_Display(Bottm11_Sprite, ODO, 1012U, 447U, 0); //显示ODO
    }
    else 
    {
        if (typ == 1u)
        {
            odo = Data_Read_Trip(EM_TRIP_A);
            if (odo > 99999ul)
            {
                Data_Clear_Trip(EM_TRIP_A);
                odo = 0ul;
            }
             
            GUI_Translate_Display(Bottm11_Sprite, TripB, 1020U, 445U, 0); //实际显示TripA
        }
        else
        {
            odo = Data_Read_Trip(EM_TRIP_B);
            
            if (odo >= 99999ul)
            {
                Data_Clear_Trip(EM_TRIP_B);
                odo = 0ul;
            }
             
            GUI_Translate_Display(Bottm11_Sprite, TripA, 1020U, 445U, 0); //实际显示TripB
        }

        Decimals_Display(Bottm11_Sprite, odo, 1174u, 446u);
    }
    
    GUI_Translate_Display(Bottm11_Sprite, Number_18_white_Unit_km, 1199U, 444U, 0); /*单位km*/
}

uint8_t StopDispUpTim = 20u;

void GUI_Stop(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        loc_Del_Sprite(Stop_Sprite, Stop_Sprite);
        StopDispUpTim = 20u;
        return;
    }

    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (++StopDispUpTim < 20u)
        {
            return;
        }
        else
        {
            StopDispUpTim = 0u;
        }
    }
    
    //清空
    loc_Del_Sprite(Stop_Sprite, Stop_Sprite);
        
    if (LED_Get_Status(em_LED_EngyRec))
    {
        GUI_Translate_Display(Stop_Sprite, Lamp_05, 12U, 378U, 2); /*能量回收*/
    }
    
    if (LED_Get_Status(em_LED_Stop))
    {
        GUI_Translate_Display(Stop_Sprite, Lamp_041, 60, 384U, 2); /*STOP*/
        /*
        if (Common_Get_IG_Sts() && (Common_GetIgnOnTime() > 4000ul))
        {
            Sound_Request(SND_Stop, 1u);
        }*/
    }
    else
    {
        /*Sound_Delete(SND_Stop);*/
    }
}

uint8_t ParkDispUpTim = 20u;

void GUI_Park(void)
{   
    loc_Del_Sprite(Park_Sprite, Park_Sprite);
    
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        return;
    }
	
	if (LED_Get_Status(em_LED_LvlLow))
    {
        GUI_Translate_Display(Park_Sprite, Lamp_048, 1131, 374U, 2); /*液位低报警*/
    }
        
    if (LED_Get_Status(em_LED_Parking))
    {
        GUI_Translate_Display(Park_Sprite, Lamp_042, 1173, 378U, 2); /*PARK*/
    }

    if (LED_Get_Status(em_LED_DrvBatChgR))
    {
        GUI_Translate_Display(Park_Sprite, Lamp_026, 1221U, 373U, 2); /*动力蓄电池充电*/
    }
}

uint8_t ChgDispUpTim = 20u;
uint8_t LED_SportMd_Last = 0u;
/* 20230912 增加SPORTMODE信号变化时马上刷新 */
void GUI_Charge(void)
{   
    if (ReversingImage_Enable_Flag_Get() == 1u)
    {
        //清空
        loc_Del_Sprite(Charge_Sprite, Charge_Sprite);
        ChgDispUpTim = 20u;
        return;
    }

    uint8_t status = LED_Get_Status(em_LED_SportMd);

    if (LED_Operation.IG_ON_Timer >= 3500)
    {
        if (status != LED_SportMd_Last)
        {
            LED_SportMd_Last = status;
            ChgDispUpTim = 20u;
        }

        if (++ChgDispUpTim < 20u)
        {
            return;
        }
        else
        {
            ChgDispUpTim = 0u;
        }
    }

    //清空
    loc_Del_Sprite(Charge_Sprite, Charge_Sprite);

    if (LED_Get_Status(em_LED_DrvBatChgG))
    {
        GUI_Translate_Display(Charge_Sprite, Lamp_027, 1222, 109U, 2); /*充电连接*/
    }

    if (status)
    {
        GUI_Translate_Display(Charge_Sprite, Lamp_050, 1216, 153U, 2); /*SPORT MODE*/
    }
}

void GUI_DisplUpdTimRst(void)
{
    MtrSpdUpTim = 5u;
    MtrSpdUpLst = 0u;
    VSpdDispUpTim = 5u;
    VehSpdLst = 0u;
    GearDispUpTim = 20u;
    BatValUptTim = 100u;
    Top6DispUpTim = 20u;
    Top7DispUpTim = 20u;
    Bot1DispUpTim = 20u;
    Bot2DispUpTim = 60u;
    Bot2PDispUpTim = 60u;
    Bot3ispUpTim = 20u;
    Bot4ispUpTim = 60u;
    Bot5ispUpTim = 60u;
    Bot6ispUpTim = 60u;
    Bot7ispUpTim = 60u;
    Bot9ispUpTim = 20u;
    Bot10ispUpTim = 60u;
    Bot11DispUpTim = 5u;
    StopDispUpTim = 20u;
    ParkDispUpTim = 20u;
    ChgDispUpTim = 20u;
}

#if 0
uint8_t BattDispUpTim = 20u;

void GUI_Battery(void)
{   
    if (++BattDispUpTim < 20u)
    {
        return;
    }
    else
    {
        BattDispUpTim = 0u;
    }

    //清空
    loc_Del_Sprite(Battery_Sprite, Battery_Sprite);
        
    if (LED_Get_Status(em_LED_Battery) == 1u)
    {
        GUI_Translate_Display(Battery_Sprite, Lamp_044, 21, 72U, 2); /*电池*/
    }
    else
    {
        if (LED_Get_Status(em_LED_Battery) == 2u)
        {
            if (FLASH_SYNC_1Hz)
            {
                GUI_Translate_Display(Battery_Sprite, Lamp_044, 21, 72U, 2); /*电池*/
            }
            else
            {
                ;
            }
        }
        else
        {
            ;
        }
    }
}
#endif

/******************************************************************************
* IGN OFF 清图层
*******************************************************************************/
unsigned char GUI_IGNOFF_ClearSprite_Flag = 0u;
unsigned char GUI_IGNOFF_ClearSprite_Delay = 0u;
unsigned char GUI_IGNIN_InitSprite_Flag = 0u;

void GUI_IGNOFF_ClearSprite_KL30Init(void)
{
    GUI_IGNOFF_ClearSprite_Flag = 0u;
    GUI_IGNOFF_ClearSprite_Delay = 0u;
}

void GUI_IGNOFF_ClearSprite_Enable(void)
{
    GUI_IGNOFF_ClearSprite_Flag = 1u;
    GUI_IGNOFF_ClearSprite_Delay = 0u;
}

void GUI_IGNOFF_DelSprite(void)
{
  #if 0  
    unsigned char PopupMsg = Popup_Get_Current_Message();
    unsigned char tempDriverDoorSts = Get_ID_391_Sig_DriverDoorSts();
    unsigned char tempPsngrDoorSts = Get_ID_391_Sig_PsngrDoorSts();
    unsigned char tempTrunkDoorSts = Get_ID_391_Sig_Trunk_BackDoor_Sts();
    unsigned char tmp_ChargingStatus = GetChargeInterfaceDisplayFlag();
    unsigned char tempCarLightSts = Get_ID_391_Sig_PosLightSts();

    GUI_IGNIN_InitSprite_Flag = 0u;

    loc_Del_Sprite(Middle_Sprite, ChargeWindow_Sprite);
    loc_Del_Sprite(VehSpeedFrame_L_Sprite, ClockWindow_Sprite);

    if((tempDriverDoorSts == 1) || (tempPsngrDoorSts == 1) || (tempTrunkDoorSts == 1) ||\
        (LED_TurnLeft_G_Status == 1u) || (LED_TurnRight_G_Status == 1u) || (LED_HighBeam_B_Status == 1u) ||\
        (LED_LowBeam_G_Status == 1u) || (tempCarLightSts == 1u))
    {
        
    }
    else
    {
        loc_Del_Sprite(CarBodyWindow_Sprite, CarBodyWindow_Sprite);
    }

    if((LED_HighBeam_B_Status == 1u) || (LED_LowBeam_G_Status == 1u) || (LED_Door_R_Status == 1u))
    {
        
    }
    else
    {
        loc_Del_Sprite(LampWindow3_Sprite, LampWindow3_Sprite);
    }

    if((LED_BattOverheat_R_Status == 1u) || (LED_ChargeStatus_Y_Status == 1u) || (LED_Position_G_Status == 1u) ||\
       (LED_ChargeLine_R_Status == 1u))
    {
        
    }
    else
    {
        loc_Del_Sprite(LampWindow7_Sprite, LampWindow7_Sprite);
    }

    if((LED_TurnLeft_G_Status == 1u) && (LED_TurnRight_G_Status == 1u))
    {

    }
    else
    {
        loc_Del_Sprite(LampWindow2_Sprite, LampWindow2_Sprite);
        loc_Del_Sprite(LampWindow4_Sprite, LampWindow4_Sprite);
    }

    JCUA_Disable_window();
  #endif
}

void GUI_IGNOFF_ClearSprite(void)
{
    //unsigned char tmp_ChargeStatus = LED_ChargeLine_R_Status;
    //unsigned char PopupMsg = Popup_Get_Current_Message();
    e_CVBS_Ctrl_Step CVBSStep = ReversingImage_Get_CVBS_Status();

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        GUI_IGNOFF_ClearSprite_Flag = 0u;
        GUI_IGNOFF_ClearSprite_Delay = 0u;
    }
    else
    {
        if (GUI_IGNOFF_ClearSprite_Flag == 1u)
        {
            if (CVBSStep == em_CVBS_Ctrl_Step_Closed)
            {
                GUI_IGNOFF_ClearSprite_Delay++;
            }
        }
        
        if (GUI_IGNOFF_ClearSprite_Delay == 1u)
        {
            GUI_IGNOFF_ClearSprite_Flag = 0u;
            GUI_IGNOFF_ClearSprite_Delay = 3u;

            /*if (tmp_ChargeStatus == 0u)
            {
            }*/
        }
    }    
}

unsigned char GUI_IGNOFF_ClearSpriteFinish(void)
{
    unsigned char ret = 0u;

    if (GUI_IGNOFF_ClearSprite_Delay > 2)
    {
        ret = 1;
    }

    return ret;
}

unsigned char GUI_IGNOFF_ClearingSprite(void)
{
    return GUI_IGNOFF_ClearSprite_Flag;
}
