#include "Data_DTE.h"
#include "CAN_Communication_Matrix.h"
#include "System_Monitor.h"

uint8_t DTE_Value;
uint8_t DTE_Valid;

void DTE_Reset(void)
{
    DTE_Value = 0;
    DTE_Valid = 0;
}

void DTE_KL30_Init(void)
{
    DTE_Reset();
}

void DTE_KL15_ON_Init(void)
{
    DTE_Reset();
}

void DTE_Processing_Service(void)
{
    uint16_t u16Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        DTE_Reset();
        return;
    }

    u16Result  = Get_ID_18F103D0_Sig_VCU_EndMlg();
    
    if ((u16Result > 0xFF00) || (CAN_MSG_Status(0x18F103D0) != CAN_SIG_RECEIVE))
    {
        DTE_Valid = 0;
        u16Result = 0;
    }
    else
    {
        DTE_Valid = 1;
    }
    
    u16Result >>= 8;         //1/256

    if (u16Result < 5) 
    {
        DTE_Valid = 0;
        u16Result = 0;
    }
    
    DTE_Value = (uint8_t)u16Result;
}

uint8_t DTE_Get_Value(void)
{
    return DTE_Value;
}

uint8_t DTE_Get_Valid(void)
{
    return DTE_Valid;
}
