/*****************************************************************************/
#include "Line_In.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"
#include "Airpressure.h"
#include "Data_SOC.h"
#include "Data_BtyPckCrt.h"
#include "Data_VehicleSpeed.h"
#include "Communication_Over_CAN.h"
#include "Sound_Scheduler.h"
#include "GUI.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Common_Interface.h"
#include "Data_ReversingImage.h"
#include "Popups.h"
#include "System_Monitor.h"
#include "PowerManagement.h"
#include "Popup_Message_List.h"
#include "Sound_Data.h"
#include "IIS_MAX98357.h"
/*****************************************************************************/
/*解决编译错误*/
#define MISSING 0xFFU

/*CAN信号接口*/
#define Get_Sig_BMS_BattIsolationWarnDisp() MISSING

#define PIN_18 MISSING       /*PIN18低电平*/
#define VSpeed MISSING       /*车速信号*/

/*模块接口*/
#define Get_SOC_LOW_Sts() MISSING /*电量低*/
#define Get_Fatigue_Sts() MISSING /*疲劳驾驶*/

/*在线配置*/
#define CONFIG_CESC MISSING  /*驱动防滑*/
#define CONFIG_HAC  MISSING  /*坡道辅助*/
#define CONFIG_AVH  MISSING  /*AUTOHOLD(AVH)*/
#define CONFIG_EPB  MISSING  /*手刹类型*/

TelltaleLRCtrlStruct TelltaleLRCtrl;

const LED_Attribute_st LED_Attribute[LED_Max] =
{
    /*  指示灯索引                  是否自检        外部信号自检           工作电源状态      自检开始时间    自检持续时间       指示灯点亮条件                        指示灯执行函数         */
    {em_LED_Position          ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Position_Judgement          ,   LED_Position_Execution     },
    {em_LED_LoBeam            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_LoBeam_Judgement            ,   LED_LoBeam_Execution       },
    {em_LED_HiBeam            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_HiBeam_Judgement            ,   LED_HiBeam_Execution       },
    {em_LED_FFog              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_FFog_Judgement              ,   LED_FFog_Execution         },
    {em_LED_RFog              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_RFog_Judgement              ,   LED_RFog_Execution         },
    {em_LED_Defrost           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Defrost_Judgement           ,   LED_Defrost_Execution      },
    {em_LED_Parking           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON_OFF ,       0u,         3500ul,     LED_Parking_Judgement           ,   LED_Parking_Execution      },
    {em_LED_BrkFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_BrkFlt_Judgement            ,   LED_BrkFlt_Execution       },

    {em_LED_BrkPad            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_BrkPad_Judgement            ,   LED_BrkPad_Execution       },
    {em_LED_ABS               ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_ABS_Judgement               ,   LED_ABS_Execution          },
    {em_LED_Door              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON_OFF ,       0u,         3500ul,     LED_Door_Judgement              ,   LED_Door_Execution         },
    {em_LED_SeatBelt          ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_SeatBelt_Judgement          ,   LED_SeatBelt_Execution     },
    {em_LED_DrvBatChgR        ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_DrvBatChgR_Judgement        ,   LED_DrvBatChgR_Execution   },
    {em_LED_DrvBatChgG        ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_DrvBatChgG_Judgement        ,   LED_DrvBatChgG_Execution   },

    {em_LED_PwrBatCut         ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PwrBatCut_Judgement         ,   LED_PwrBatCut_Execution    },

    {em_LED_CarLifting        ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_CarLifting_Judgement        ,   LED_CarLifting_Execution   },
    {em_LED_CabOverturn       ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_CabOverturn_Judgement       ,   LED_CabOverturn_Execution  },
    {em_LED_DayLight          ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_DayLight_Judgement          ,   LED_DayLight_Execution     },
    {em_LED_TPMS              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_TPMS_Judgement              ,   LED_TPMS_Execution         },
    {em_LED_DrvFatigue        ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_DrvFatigue_Judgement        ,   LED_DrvFatigue_Execution   },
    {em_LED_BackupLamp        ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_BackupLamp_Judgement        ,   LED_BackupLamp_Execution   },
    {em_LED_PTO1              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PTO1_Judgement              ,   LED_PTO1_Execution         },
    {em_LED_PTO2              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PTO2_Judgement              ,   LED_PTO2_Execution         },

    {em_LED_Cruise            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Cruise_Judgement            ,   LED_Cruise_Execution       },
    {em_LED_VcmPmp            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_VcmPmp_Judgement            ,   LED_VcmPmp_Execution       },
    {em_LED_PwrBatFlt         ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PwrBatFlt_Judgement         ,   LED_PwrBatFlt_Execution    },
    {em_LED_PwrBatHiTpt       ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PwrBatHiTpt_Judgement       ,   LED_PwrBatHiTpt_Execution  },
    {em_LED_LoSOC             ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_LoSOC_Judgement             ,   LED_LoSOC_Execution        },
    {em_LED_SysFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_SysFlt_Judgement            ,   LED_SysFlt_Execution       },
    {em_LED_IslFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_IslFlt_Judgement            ,   LED_IslFlt_Execution       },

    {em_LED_Ready             ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Ready_Judgement             ,   LED_Ready_Execution        },
    {em_LED_Stop              ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Stop_Judgement              ,   LED_Stop_Execution         },
    {em_LED_OverSpd           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_OverSpd_Judgement           ,   LED_OverSpd_Execution      },
    {em_LED_MtrFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_MtrFlt_Judgement            ,   LED_MtrFlt_Execution       },
    {em_LED_MtrMCUHiTpt       ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_MtrMCUHiTpt_Judgement       ,   LED_MtrMCUHiTpt_Execution  },
    {em_LED_TCUFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_TCUFlt_Judgement            ,   LED_TCUFlt_Execution       },
    {em_LED_EPSFlt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_EPSFlt_Judgement            ,   LED_EPSFlt_Execution       },
    {em_LED_EngyRec           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_EngyRec_Judgement           ,   LED_EngyRec_Execution      },

    {em_LED_ECO               ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_ECO_Judgement               ,   LED_ECO_Execution          },
    {em_LED_PwrLmt            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_PwrLmt_Judgement            ,   LED_PwrLmt_Execution       },
 
    {em_LED_Battery           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Battery_Judgement           ,   LED_Battery_Execution      },
    {em_LED_Charge            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_Charge_Judgement            ,   LED_Charge_Execution       },

    {em_LED_LvlLow            ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_LvlLow_Judgement            ,   LED_LvlLow_Execution       },
    {em_LED_SportMd           ,   SelfCheck ,   NoExterNalCheck ,      LED_IGN_ON     ,       0u,         3500ul,     LED_SportMd_Judgement           ,   LED_SportMd_Execution      }, 
};

uint8_t LED_Flag[LED_Max];

void TelltalesFlag_KL15_Init(void)
{
    uint8_t i = 0u;

    for (i=0; i<LED_Max; i++)
    {
        LED_Flag[i] = 1u;
    }

    Maintenance_Alarm_Flag_Set(1);
}

/*must put into 10ms task*/
void Telltales_Left_Right_KL30_Init(void)
{
    TelltaleLRCtrl.LastRight = 0u;
    TelltaleLRCtrl.LastLeft  = 0u;
    TelltaleLRCtrl.Delay     = 0u;
}

uint8_t LED_TurnLeft_Flag;
uint8_t LED_TurnRight_Flag;

uint8_t LEFT_ST;
uint8_t RIGHT_ST;

void Telltales_Left_Right_Management_Service(void) /*10ms*/ /*830104,830204,830304*/
{
    if (Common_Get_IG_Sts() && (Common_GetIgnOnTime() < 3500))
    {
        LED_TurnLeft_Execution(0x01u);
        LED_TurnRight_Execution(0x01u);
        Sound_Delete(SND_TICK);
        Sound_Delete(SND_TOCK);
        
        Sound_Request(SND_Start, 1u);
                
        return;
    }
        
    //Sound_Delete(SND_Start);

    if (SYS_OPR_STAT_HALT)
    {
        LED_TurnLeft_Execution(0x00u);
        LED_TurnRight_Execution(0x00u);
        Sound_Delete(SND_TICK);
        Sound_Delete(SND_TOCK);
        return;
    }
        
    uint8_t Edge;
    
    Edge = 0xFFu;
    
    LEFT_ST = Line_In_Get_Status(LINE_IN_TrunLeft);
    
    /*if (Get_ID_18FFDA21_Sig_TurnLeftLight() == 1u)
    {
        LEFT_ST |= 1u;
    }*/
    
    RIGHT_ST = Line_In_Get_Status(LINE_IN_TrunRight);
    
    /*if (Get_ID_18FFDA21_Sig_TurnRightLight() == 1u)
    {
        RIGHT_ST |= 1u;
    }*/

    /*左转向*/
    if (LEFT_ST == 1u)
    {
        LED_TurnLeft_Execution(0x01u);
    }
    else
    {
        LED_TurnLeft_Execution(0x00u);
    }
    
    if (TelltaleLRCtrl.LastLeft != LEFT_ST)
    {
        TelltaleLRCtrl.LastLeft = LEFT_ST;
        Edge = LEFT_ST;
        TelltaleLRCtrl.Delay = 0u;
    }

    /*右转向*/
    if (RIGHT_ST == 1u)
    {
        LED_TurnRight_Execution(0x01u);
    }
    else
    {
        LED_TurnRight_Execution(0x00u);
    }
    
    if (TelltaleLRCtrl.LastRight != RIGHT_ST)
    {
        TelltaleLRCtrl.LastRight = RIGHT_ST;
        Edge = RIGHT_ST;
        TelltaleLRCtrl.Delay = 0u;
    }

    if (TelltaleLRCtrl.Delay > 0u)
    {
        TelltaleLRCtrl.Delay--;
    }
    else
    {
        if (Edge != 0xFFu)
        {
            if ((BL_TFT_Status_Get() == 0) && (Popup_Get_Current_Message() == POPUP_MSG_NONE))
            {
                if (Edge)
                {
                    Sound_Request(SND_TICK, 1u);
                }
                else
                {
                    Sound_Request(SND_TOCK, 1u);
                }
            }
            
            TelltaleLRCtrl.Delay = 4u; /*200ms内不允许重复播放声音*/
        }
        else
        {
            Sound_Delete(SND_TICK);
            Sound_Delete(SND_TOCK);
        }
    }
}

//位置灯,硬线信号+CAN
uint8_t LED_Position_Judgement(void)
{
    uint8_t status  = 0u;
    uint8_t status0 = Line_In_Get_Status(LINE_IN_Position); //硬线信号
    uint8_t status1 = Get_ID_18FFDA21_Sig_SidelightStatus(); //CAN信号
    
    if (status0 || (status1 == 1u))
    {
        status = 1u;
    }
    else
    {
        ;
    }
    
    return (uint8_t)status;
}
//近光灯,硬线信号+CAN
uint8_t LED_LoBeam_Judgement(void)
{
    uint8_t status  = 0u;
    uint8_t status0 = Line_In_Get_Status(LINE_IN_LoBeam); //硬线信号
    uint8_t status1 = Get_ID_18FFDA21_Sig_LowbeamLightStatus(); //CAN信号
    
    if (status0 || (status1 == 1u))
    {
        status = 1u;
    }
    else
    {
        ;
    }
    
    return (uint8_t)status;
}
//远光灯,硬线信号+CAN
uint8_t LED_HiBeam_Judgement(void)
{
    uint8_t status  = 0u;
    uint8_t status0 = Line_In_Get_Status(LINE_IN_HiBeam); //硬线信号
    uint8_t status1 = Get_ID_18FFDA21_Sig_HighBeamSwitch(); //CAN信号
    
    if (status0 || (status1 == 1u))
    {
        status = 1u;
    }
    else
    {
        ;
    }
    
    return (uint8_t)status;
}
//前雾灯,硬线信号+CAN
uint8_t LED_FFog_Judgement(void)
{
    uint8_t status  = 0u;
    uint8_t status0 = Line_In_Get_Status(LINE_IN_FrontFog); //硬线信号
    uint8_t status1 = Get_ID_18FFDA21_Sig_FrontFogLightSwitch(); //CAN信号
    
    if (status0 || (status1 == 1u))
    {
        status = 1u;
    }
    else
    {
        ;
    }
    
    return (uint8_t)status;
}
//后雾灯,硬线信号
uint8_t LED_RFog_Judgement(void)
{
    uint8_t status  = 0u;
    uint8_t status0 = Line_In_Get_Status(LINE_IN_RearFog); //硬线信号
    uint8_t status1 = Get_ID_18FFDA21_Sig_RearFogLightSwitch(); //CAN信号
    
    if (status0 || (status1 == 1u))
    {
        status = 1u;
    }
    else
    {
        ;
    }
    
    return (uint8_t)status;
}
//除霜灯,需要空调CAN信号
uint8_t LED_Defrost_Judgement(void)
{
    return 0;
}
//驻车灯,硬线信号+CAN信号
uint8_t Parking_status;
uint8_t LED_Parking_Judgement(void)
{
    uint8_t status  = 0u;
    
    if ((Get_ID_18FF6060_Sig_EPB_ParkLampState() == 1u) ||\
        ((CAN_MSG_Status(ID_EPB_Sts_Msg_Count) != CAN_SIG_RECEIVE) && Line_In_Get_Status(LINE_IN_Parking)))
    {
        Parking_status = 1u;
        status = 1u;
    }
    else
    {
        Parking_status = 0u;
    }
    
    return (uint8_t)status;
}
//气刹报警状态
uint8_t LED_AirPressure_Status[2];
uint8_t LED_AirP_Deb[2];
//气刹报警判断
uint8_t LED_AirPressure_Judgement(uint8_t pos)
{
    uint8_t  sigVid = AirPressure_Get_Valid(pos);
    uint16_t sigVal = AirPressure_Get_Value(pos);
    
    if (sigVid)
    {
        if (sigVal <= 55u)    //0.55MPa=5.5bar
        {
            if (LED_AirP_Deb[pos] < 150u)
            {
                LED_AirP_Deb[pos]++;
            }
            else
            {
                LED_AirPressure_Status[pos] = 1u;
            }
        }
        else
        {
            if (sigVal >= 60u)
            {
                if (LED_AirP_Deb[pos])
                {
                    LED_AirP_Deb[pos]--;
                }
                else
                {
                    LED_AirPressure_Status[pos] = 0u;
                }
            }
            else
            {
                //过渡区不变;
            }
        }  
    }
    else
    {
        LED_AirPressure_Status[pos] = 1u;
    }

    return LED_AirPressure_Status[pos];
}
//刹车故障,油刹:硬线;气刹:气压低
uint8_t LED_BrkFlt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Brake_Type == Air_Brake)
    {
        ledSts  = LED_AirPressure_Judgement(0);
        ledSts |= LED_AirPressure_Judgement(1);
    }
    else
    {
        ledSts = Line_In_Get_Status(LINE_IN_BrakeFault);
    }
            
    return ledSts;
}
//刹车蹄片磨损,CAN信号
uint8_t LED_BrkPad_Judgement(void)
{
    uint8_t ledSts = 0u;

    if ((Get_ID_18F104D0_Sig_VCU_LFBrkWrAlrm() == 1u) || (Get_ID_18F104D0_Sig_VCU_RFBrkWrAlrm() == 1u) ||\
        (Get_ID_18F104D0_Sig_VCU_LBBrkWrAlrm() == 1u) || (Get_ID_18F104D0_Sig_VCU_RBBrkWrAlrm() == 1u))
    {
        ledSts = 1u;
    }

    return ledSts;
}
//ABS
extern uint8_t TimeOutOffSts;

uint8_t LED_ABS_Judgement(void)
{
    uint8_t ledSts = 0u;

    if (Line_In_Get_Status(LINE_IN_ABS) || (Get_ID_18F0010B_Sig_ABS_YellowAlarmSts() == 0x01u) ||\
        ((CAN_MSG_Status(ID_ABS_EBC1_Msg_Count) == CAN_SIG_LOST) && (TimeOutOffSts == 0u))) 
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//门开
uint8_t LED_Door_Judgement(void)
{
    uint8_t ledSts = 0;
    
    if ((Line_In_Get_Status(LINE_IN_LeftDoor)) || (Get_ID_18FDA5EC_Sig_DoorOpen_Driver() == 1u))
    {
        ledSts |= 0x1u;
    }

    if ((Line_In_Get_Status(LINE_IN_RightDoor)) || (Get_ID_18FDA5EC_Sig_DoorOpen_Passenger() == 1u))
    {
        ledSts |= 0x2u;
    }

    return ledSts;
}
//安全带
uint8_t LED_SeatBelt_Judgement(void)
{
    return (uint8_t)Line_In_Get_Status(LINE_IN_SeatBelt);
}
//红色充电指示灯,CAN信号
uint8_t LED_DrvBatChgR_Judgement(void)
{
    uint8_t ledSts = 0u;
    if (Get_ID_18F13DF3_Sig_BMS_BMSSts() == 0x03u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//绿色充电指示灯,CAN信号
uint8_t LED_DrvBatChgG_Judgement(void)
{
    uint8_t ledSts = 0u;
    if (Get_ID_18F149F3_Sig_BMS_ChrgSts() == 0x04u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//动力蓄电池切断
uint8_t LED_PwrBatCut_Judgement(void)
{
    uint8_t ledSts = 0u;

    if ((Get_ID_18F106D0_Sig_VCU_MtrRlySts() == 0u) && (CAN_MSG_Status(ID_VCU_PDUSts_Msg_Count) == CAN_SIG_RECEIVE))
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//车厢举升,预留
uint8_t LED_CarLifting_Judgement(void)
{
    uint8_t ledSts = 0u;
    return ledSts;
}
//驾驶室翻转,预留
uint8_t LED_CabOverturn_Judgement(void)
{
    uint8_t ledSts = 0u;
    return ledSts;
}
//日间行车灯
uint8_t LED_DayLight_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18FFDA21_Sig_DayLightStatus() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//胎压指示灯,预留
uint8_t LED_TPMS_Judgement(void)
{
    uint8_t ledSts = 0u;
    return ledSts;
}
//驾驶员疲劳驾驶,预留
uint8_t LED_DrvFatigue_Judgement(void)
{
    uint8_t ledSts = 0u;
    return ledSts;
}
//倒车灯
uint8_t LED_BackupLamp_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18FFDA21_Sig_BackLightStatus() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//停车取力,预留
uint8_t LED_PTO1_Judgement(void)
{
    uint8_t ledSts = 0u;

    return ledSts;
}
//行车取力,预留
uint8_t LED_PTO2_Judgement(void)
{
    uint8_t ledSts = 0u;

    return ledSts;
}
//巡航
uint8_t LED_Cruise_Judgement(void)
{
    uint8_t ledSts = 0u;
    if (Get_ID_18F101D0_Sig_VCU_CrsConSts() == 0x1u)
    {
        ledSts = 2u; //绿灯
    }
    else  if (Get_ID_18F104D0_Sig_VCU_AccSwitch() == 0x1u)
    {
        ledSts = 1u; //白灯
    }

    return ledSts;
}
//真空泵故障,新规范中去掉
uint8_t LED_VcmPmp_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    /*if (Get_ID_18F103D0_Sig_VCU_VcmPmpPrsvl() == 0xFFFEu)
    {
        ledSts = 1u;
    }*/
    
    return ledSts;
}
//动力蓄电池故障
uint8_t PwrBatFlt_Last_Status = 0u;

uint8_t LED_PwrBatFlt_Judgement(void)
{
    if (Get_ID_18F141F3_Sig_BMS_BMSDTC() >= 2u)
    {
        PwrBatFlt_Last_Status = 1u;
    }
    else
    {
        if (Get_ID_18F141F3_Sig_BMS_BMSDTC() == 0u)
        {
            PwrBatFlt_Last_Status = 0u;
        }
    }
    
    return PwrBatFlt_Last_Status;
}
//动力蓄电池过热
uint8_t PwrBatHiTpt_Last_Status = 0u;

uint8_t LED_PwrBatHiTpt_Judgement(void)
{
    if (Get_ID_18F141F3_Sig_BMS_BMSDTC() == 1u)
    {
        PwrBatHiTpt_Last_Status = 1u;
    }
    else
    {
        if (Get_ID_18F141F3_Sig_BMS_BMSDTC() == 0u)
        {
            PwrBatHiTpt_Last_Status = 0u;
        }
    }
    
    return PwrBatHiTpt_Last_Status;
}

//电池剩余容量低
uint8_t LoSOC_Last_Status = 0u;

uint8_t LED_LoSOC_Judgement(void)
{
    if (Get_ID_18F141F3_Sig_BMS_BMSDTC() != 0u)
    {
        LoSOC_Last_Status = 1u;
    }
    else
    {
        if (Get_ID_18F141F3_Sig_BMS_BMSDTC() == 0u)
        {
            LoSOC_Last_Status = 0u;
        }
    }
    
    return LoSOC_Last_Status;
}
//系统故障
uint8_t LED_SysFlt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F101D0_Sig_VCU_SysErrMd() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//绝缘电阻报警 ?????????????????????? 样表未测出
uint8_t LED_IslFlt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F14AF3_Sig_BMS_BtyFltFlg2_2() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//运行就绪准备
uint8_t LED_Ready_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F101D0_Sig_VCU_VhclSts() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}

uint8_t Stop_Last_Status_Sys = 0u;
uint8_t Stop_Last_Status_MCU = 0u;
uint8_t Stop_Last_Status_BMS = 0u;

//紧急停车故障报警
uint8_t LED_Stop_Judgement(void)
{
    uint8_t ledSts = 0u;

    if ((Get_ID_18F101D0_Sig_VCU_SysDTC() != 0u) && (Get_ID_18F101D0_Sig_VCU_SysDTC() < 51u))
    {
        Stop_Last_Status_Sys = 1u;
    }
    else
    {
        if (Get_ID_18F101D0_Sig_VCU_SysDTC() == 0u)
        {
            Stop_Last_Status_Sys = 0u;
        }
    } 

    if ((Get_ID_18F501F0_Sig_VCU_MCUDTC() != 0u) && (Get_ID_18F501F0_Sig_VCU_MCUDTC() < 51u))
    {
        Stop_Last_Status_MCU = 1u;
    }
    else
    {
        if (Get_ID_18F501F0_Sig_VCU_MCUDTC() == 0u)
        {
            Stop_Last_Status_MCU = 0u;
        }
    } 

    if ((Get_ID_18F141F3_Sig_BMS_BMSDTC() != 0u) && (Get_ID_18F141F3_Sig_BMS_BMSDTC() < 51u))
    {
        Stop_Last_Status_BMS = 1u;
    }
    else
    {
        if (Get_ID_18F141F3_Sig_BMS_BMSDTC() == 0u)
        {
            Stop_Last_Status_BMS = 0u;
        }
    } 
    
    ledSts |= Stop_Last_Status_Sys;
    ledSts |= Stop_Last_Status_MCU;
    ledSts |= Stop_Last_Status_BMS;

    if (Brake_Type == Air_Brake)
    {
        ledSts |= LED_AirPressure_Judgement(0);
        ledSts |= LED_AirPressure_Judgement(1);
    }
    
    return ledSts;
}

uint8_t Limit_Speed_Last_Status = 0u;
//超速报警
uint8_t LED_OverSpd_Judgement(void)
{
    /*if (Get_ID_18F501F0_Sig_VCU_MCUDTC() == 51u)
    {
        Limit_Speed_Last_Status = 1u;
    }
    else
    {
        if (Get_ID_18F501F0_Sig_VCU_MCUDTC() == 0u)
        {
            Limit_Speed_Last_Status = 0u;
        }
        else
        {
            ;
        }
    }*/
    /* 不按样表做,按规范改成超速报警 */
    
    return Limit_Speed_Last_Status;
}
//电机故障
uint8_t MtrFlt_Last_Status = 0u;

uint8_t LED_MtrFlt_Judgement(void)
{
    if ((Get_ID_18F501F0_Sig_VCU_MCUDTC() != 0u) && (Get_ID_18F501F0_Sig_VCU_MCUDTC() != 51u))
    {
        MtrFlt_Last_Status = 1u;
    }
    else
    {
        if (Get_ID_18F501F0_Sig_VCU_MCUDTC() == 0u)
        {
            MtrFlt_Last_Status = 0u;
        }
    }
    
    return MtrFlt_Last_Status;
}
//电机及控制器过热
uint8_t LED_MtrMCUHiTpt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if ((Get_ID_18F501F0_Sig_VCU_DrvMtrTptWrn() == 0x01u)/* || (Get_ID_18F501F0_Sig_VCU_MCUTptWrn() == 0x01u)*/)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//变速箱故障
uint8_t LED_TCUFlt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F101D0_Sig_VCU_GearbxErr() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//助力转向故障灯
uint8_t LED_EPSFlt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F105D0_Sig_VCU_EPSSts() == 0x02u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//能量回收
uint8_t LED_EngyRec_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F101D0_Sig_VCU_EngyRec() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//ECO,没信号
uint8_t LED_ECO_Judgement(void)
{
    uint8_t ledSts = 0u;
        
    return ledSts;
}
//跛行
uint8_t LED_PwrLmt_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F101D0_Sig_VCU_PwrLmtLmp() == 0x01u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//蓄电池,
uint8_t LED_Battery_Judgement(void)
{
    uint8_t ledSts = 0u;

    if (Get_ID_18F141F3_Sig_BMS_ChgWrCntSts() == 0x55u)
    {
        ledSts = 1u; 
    }
    else
    {
        if ((Get_ID_18F105D0_Sig_VCU_DCDCSts() != 0x01u) && (CAN_MSG_Status(ID_VCU_MutiOneSts_Msg_Count) == CAN_SIG_RECEIVE))
        {
            ledSts = 2u; 
        }
        else
        {
            ;
        }
    }

    return ledSts;
}
//充电线连接
uint8_t LED_Charge_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if ((Get_ID_18F141F3_Sig_BMS_ChgWrCntSts() == 0x55u) || Line_In_Get_Status(LINE_IN_ChargeWake))
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//水位低报警
uint8_t LED_LvlLow_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Line_In_Get_Status(LINE_IN_FluidLevel))
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
//SPORT MODE
uint8_t LED_SportMd_Judgement(void)
{
    uint8_t ledSts = 0u;
    
    if (Get_ID_18F103D0_Sig_VCU_EPMode() == 0x1u)
    {
        ledSts = 1u;
    }
    
    return ledSts;
}
/*---------------------------------------------------------------------------*/
void LED_TurnRight_Execution(uint8_t led_status)
{
    LED_TurnRight_Flag = led_status;
}

void LED_TurnLeft_Execution(uint8_t led_status)
{
    LED_TurnLeft_Flag = led_status;
}

void LED_Position_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Position] = led_status;
}

void LED_LoBeam_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_LoBeam] = led_status;
}

void LED_HiBeam_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_HiBeam] = led_status;
}

void LED_FFog_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_FFog] = led_status;
}

void LED_RFog_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_RFog] = led_status;
}

void LED_Defrost_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Defrost] = led_status;
}

void LED_Parking_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Parking] = led_status;
}

void LED_BrkFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_BrkFlt] = led_status;
}

void LED_BrkPad_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_BrkPad] = led_status;
}

void LED_ABS_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_ABS] = led_status;
}

void LED_Door_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Door] = led_status;
}

void LED_SeatBelt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_SeatBelt] = led_status;
}

void LED_DrvBatChgR_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_DrvBatChgR] = led_status;
}

void LED_DrvBatChgG_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_DrvBatChgG] = led_status;
}

void LED_PwrBatCut_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PwrBatCut] = led_status;
}

void LED_CarLifting_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_CarLifting] = led_status;
}

void LED_CabOverturn_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_CabOverturn] = led_status;
}

void LED_DayLight_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_DayLight] = led_status;
}

void LED_TPMS_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_TPMS] = led_status;
}

void LED_DrvFatigue_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_DrvFatigue] = led_status;
}

void LED_BackupLamp_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_BackupLamp] = led_status;
}

void LED_PTO1_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PTO1] = led_status;
}

void LED_PTO2_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PTO2] = led_status;
}

void LED_Cruise_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Cruise] = led_status;
}

void LED_VcmPmp_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_VcmPmp] = led_status;
}

void LED_PwrBatFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PwrBatFlt] = led_status;
}

void LED_PwrBatHiTpt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PwrBatHiTpt] = led_status;
}

void LED_LoSOC_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_LoSOC] = led_status;
}

void LED_SysFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_SysFlt] = led_status;
}

void LED_IslFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_IslFlt] = led_status;
}

void LED_Ready_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Ready] = led_status;
}

void LED_Stop_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Stop] = led_status;
}

void LED_OverSpd_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_OverSpd] = led_status;
}

void LED_MtrFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_MtrFlt] = led_status;
}

void LED_MtrMCUHiTpt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_MtrMCUHiTpt] = led_status;
}

void LED_TCUFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_TCUFlt] = led_status;
}

void LED_EPSFlt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_EPSFlt] = led_status;
}

void LED_EngyRec_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_EngyRec] = led_status;
}

void LED_ECO_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_ECO] = led_status;
}

void LED_PwrLmt_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_PwrLmt] = led_status;
}

void LED_Battery_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Battery] = led_status;
}

void LED_Charge_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_Charge] = led_status;
}

void LED_LvlLow_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_LvlLow] = led_status;
}

void LED_SportMd_Execution(uint8_t led_status)
{
    LED_Flag[em_LED_SportMd] = led_status;
}
/*---------------------------------------------------------------------------*/
uint8_t LED_Get_TurnRight_Status(void)
{
    return LED_TurnRight_Flag;
}

uint8_t LED_Get_TurnLeft_Status(void)
{
    return LED_TurnLeft_Flag;
}

uint8_t LED_Get_TurnRight_Status1(void)
{
    return LEFT_ST;
}

uint8_t LED_Get_TurnLeft_Status1(void)
{
    return RIGHT_ST;
}

uint8_t LED_Get_Parking_Status(void)
{
    return Parking_status;
}

uint8_t LED_Get_Status(uint8_t led_indx)
{
    return LED_Flag[led_indx];
}

void LED_IgnOff_Init(void)
{
    LED_Parking_Judgement();
    LEFT_ST  = Line_In_Get_Status(LINE_IN_TrunLeft);
    RIGHT_ST = Line_In_Get_Status(LINE_IN_TrunRight);
}


