
#include "RIIC.h"
#include "dr7f701441.dvf.h"
#include "r_riic_main.h"
#include "r_riic_api.h"
#include "r_typedefs.h"
#include "r_config_riic.h"
#include "r_riic_regs.h"
#include "Watchdog.h"

IIC_PARAM iic_prm;

void RIIC_Init(uint8_t channel)
{
    if (channel > 1U)
    {
    }
    else
    {
        pMFS_RIIC[channel]->unCR1.u32Register &= 0xFFFFFF7FUL;
        pMFS_RIIC[channel]->unCR1.u32Register |= 0x00000040UL;
        pMFS_RIIC[channel]->unCR1.u32Register |= 0x00000080UL;

        pMFS_RIIC[channel]->unSAR0.u32Register = (uint32_t)SLAVE_ADDR;
        pMFS_RIIC[channel]->unSER.u32Register = 0x00000001UL;

        pMFS_RIIC[channel]->unMR1.u32Register |= 0x00000030UL;

        pMFS_RIIC[channel]->unBRH.u32Register = 0xEAUL;
        pMFS_RIIC[channel]->unBRL.u32Register = 0xF0UL;

        pMFS_RIIC[channel]->unMR2.u32Register = 0x00000006UL;
        pMFS_RIIC[channel]->unMR3.u32Register = 0x00000010UL;

        pMFS_RIIC[channel]->unFER.u32Register = 0x00000051UL;
        //	pMFS_RIIC[channel]->unIER.u32Register  = 0x000000E8UL;
        pMFS_RIIC[channel]->unIER.u32Register = 0x00000000UL;

        pMFS_RIIC[channel]->unCR1.u32Register = 0xFFFFFF9FUL;
    }
}

void RIIC_Master_Transmit(uint8_t channel, uint32_t len, uint8_t *transmission_data)
{
    /* wait to a bus-free state */
    while (pMFS_RIIC[channel]->unCR2.u32Register & 0x00000080UL)
    {
        //锟酵凤拷CPU
    }

    iic_prm.iic_state = ADDR_W_STATE;
    iic_prm.tx_data_p = transmission_data;
    iic_prm.tx_len = len;
    iic_prm.tx_count = 0UL;

    /* occur a start */
    pMFS_RIIC[channel]->unCR2.u32Register |= 0x00000002UL;
    /*
    pMFS_RIIC[channel]->unCR1.u32Register &= 0xFFFFFFF7UL;

    while( (pMFS_RIIC[channel]->unCR2.u32Register & 0x00000060UL) == 0U )      //wait start
    {
	if(pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL)	       //time out
	    break;
    }
*/
    pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFFBUL; //start clear
    pMFS_RIIC[channel]->unCR2.u32Register &= 0xFFFFFFFDUL;

    /* write slave addr */
    pMFS_RIIC[channel]->unDRT.u32Register = (uint32_t)SLAVE_ADDR + IIC_DIR_W; //write slave addr

    while (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000010UL) //wait ACK
    {
        // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL) //time out
        //     break;
    }

    /* write Tx data */
    // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL)
    // {
    //     pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFFEUL; //tiome out clear
    // }
    // else
    // {
    for (iic_prm.tx_count = 0U; iic_prm.tx_count < iic_prm.tx_len; iic_prm.tx_count++)
    {
        while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000080UL) == 0) //data empty
        {
        }
        pMFS_RIIC[channel]->unDRT.u32Register = *iic_prm.tx_data_p++;
        while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000040UL) == 0) //wait tend
        {
            // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL) //time out
            //     break;
        }
        while (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000010UL) //wait ACK
        {
            // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL) //time out
            //     break;
        }

        // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL)
        // {
        //     pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFFEUL; //tiome out clear
        //     break;
        // }
    }
    // }

    while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000040UL) == 0U)
        ; //wait transmission end

    pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFBFUL; //transmission end clear

    pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFF7UL; //stop clear

    pMFS_RIIC[channel]->unCR2.u32Register |= 0x00000008UL; //set stop

    while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000008UL) == 0U)
        ; //wait stop

    pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFEFUL; //
    pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFF7UL; //
}

void RIIC_Master_Receive16B(uint8_t channel, uint16_t InternalAddress, uint32_t len, uint8_t *recebuff)
{
    uint8_t data[200];
    uint8_t dummy;
    uint32_t i;
    data[0] = (InternalAddress >> 8u) & 0xFFu;
    data[1] = InternalAddress & 0xFFu;
    RIIC_Master_Transmit(0, 2, data);

    while ((pMFS_RIIC[channel]->unCR2.u32Register & 0x00000080UL) != 0) //check bus status
    {
        //busy
    }

    /* occur a start  Start Condition Issuance Request */
    pMFS_RIIC[channel]->unCR2.u32Register |= 0x00000002UL;
    while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000080UL) == 0) //TDRE = 0 ?
    {
    }
    /* write slave addr */
    pMFS_RIIC[channel]->unDRT.u32Register = (uint32_t)SLAVE_ADDR + IIC_DIR_R; //write slave addr
    while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000020UL) == 0)       //wait ACK
    {
        // if (pMFS_RIIC[channel]->unSR2.u32Register & 0x00000001UL) //time out
        //     break;
    }
    if ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000010UL) != 0) //wait ACK
    {
        //NACK
    }
    else
    {

        dummy = pMFS_RIIC[channel]->unDRR.stcField.DRR;
        for (i = 0; i < (len - 1); i++)
        {
            while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000020UL) == 0) //RDRF
            {
                //       dummy = pMFS_RIIC[channel]->unDRR.stcField.DRR;
            }
            recebuff[i] = pMFS_RIIC[channel]->unDRR.stcField.DRR;
            if (i == len - 2)
            {
                pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000040UL;
            }
        }
        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000020UL; //
        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000008UL; //
        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000004UL;
        recebuff[i] = pMFS_RIIC[channel]->unDRR.stcField.DRR;
        while ((pMFS_RIIC[channel]->unSR2.u32Register & 0x00000020UL) == 0) //RDRF
        {
            //    dummy = pMFS_RIIC[channel]->unDRR.stcField.DRR;
        }

        /* STOP CONDITION*/
        pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFB7UL; //stop clear

        pMFS_RIIC[channel]->unCR2.u32Register |= 0x00000008UL; //set stop
        dummy = pMFS_RIIC[channel]->unDRR.stcField.DRR;
        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000010UL; //
        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000018UL; //
        pMFS_RIIC[channel]->unMR3.u32Register &= 0xFFFFFBFUL; //
        while ((pMFS_RIIC[channel]->unSR2.stcField.STOP) == 0)
        {
            WDT_Clear();
        } //wait stop

        pMFS_RIIC[channel]->unMR3.u32Register |= 0x00000010UL; //
        pMFS_RIIC[channel]->unMR3.u32Register &= 0xFFFFFD7UL; //
        pMFS_RIIC[channel]->unSR2.u32Register &= 0xFFFFFFE7UL; //stop clear
    }
}
