#include "BackLight_APP.h"
#include "TimerB.h"
#include "System_Monitor.h"
#include "PowerManagement.h"

#pragma ghs section bss=".myNonInitArea" //buckupRAM区
uint8_t  DesNitBrt;          //夜间背光亮度目标值 
uint8_t  CurNitBrt;          //夜间背光亮度当前值 
uint8_t  DesDayBrt;          //日间背光亮度目标值 
uint8_t  CurDayBrt;          //日间背光亮度当前值
uint8_t  Brightness_Mode;    //照明模式,0=日间,1=夜间
#pragma ghs section bss=default

void BL_Init(void)
{  
    //TFT背光
    TimerB_PWM_Channel_Init(TIMERB_0_CH7, TIMERB_CLOCK_0, 0); //0=高有效,1=低有效
    TimerB_PWM_Channel_Fre_Set(TIMERB_0_CH7, 20000);
    TimerB_PWM_Channel_Duty_Set(TIMERB_0_CH7, 0);
    TimerB_PWM_Channel_Start(TIMERB_0_CH7);
    //段码屏白色背光1()
    TimerB_PWM_Channel_Init(TIMERB_0_CH3, TIMERB_CLOCK_0, 0);
    TimerB_PWM_Channel_Fre_Set(TIMERB_0_CH3, 3000);
    TimerB_PWM_Channel_Duty_Set(TIMERB_0_CH3, 0);
    TimerB_PWM_Channel_Start(TIMERB_0_CH3);
    //段码屏蓝色背光()
    TimerB_PWM_Channel_Init(TIMERB_2_CH15, TIMERB_CLOCK_0, 0);
    TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH15, 3000);
    TimerB_PWM_Channel_Duty_Set(TIMERB_2_CH15, 0);
    TimerB_PWM_Channel_Start(TIMERB_2_CH15);
    //段码屏白色背光2()
    TimerB_PWM_Channel_Init(TIMERB_2_CH11, TIMERB_CLOCK_0, 0);
    TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH11, 3000);
    TimerB_PWM_Channel_Duty_Set(TIMERB_2_CH11, 0);
    //TimerB_PWM_Channel_Start(TIMERB_2_CH11);
}

void BL_TFT_Start(void)
{  
    //TFT背光
    TimerB_PWM_Channel_Start(TIMERB_0_CH7);
}

void BL_LCD_Start(void)
{  
    //段码屏白色背光1()
    TimerB_PWM_Channel_Start(TIMERB_0_CH3);
    //段码屏蓝色背光()
    TimerB_PWM_Channel_Start(TIMERB_2_CH15);
    //段码屏白色背光2()
    //TimerB_PWM_Channel_Start(TIMERB_2_CH11);
}

void BL_TFT_Stop(void)
{  
    //TFT背光
    TimerB_PWM_Channel_Stop(TIMERB_0_CH7);
}

void BL_LCD_Stop(void)
{
    TimerB_PWM_Channel_Stop(TIMERB_0_CH3);
    //段码屏蓝色背光()
    TimerB_PWM_Channel_Stop(TIMERB_2_CH15);
    //段码屏白色背光2()
    TimerB_PWM_Channel_Stop(TIMERB_2_CH11);
}

void BL_Sleep(void)
{
    TimerB_PWM_Channel_Sleep(TIMERB_0_CH7);
    TimerB_PWM_Channel_Sleep(TIMERB_0_CH3);
    TimerB_PWM_Channel_Sleep(TIMERB_2_CH15);
    TimerB_PWM_Channel_Sleep(TIMERB_2_CH11);
}

void BL_KL30_Init(void)
{
    DesNitBrt = 40u;         //夜间背光亮度目标值 
    CurNitBrt = 40u;         //夜间背光亮度当前值 
    DesDayBrt = 50u;         //日间背光亮度目标值 
    CurDayBrt = 50u;         //日间背光亮度当前值

    Brightness_Mode = 0u;    //照明模式,0=日间,1=夜间
}

void DesNitBrt_Add(void)
{
    if (CurNitBrt != DesNitBrt)
    {
        return;
    }

    //DesNitBrt += 10u;
							
    //if (DesNitBrt > 90u)
    {
        //DesNitBrt = 0u;
    }

    if (DesNitBrt < 90u)
    {
        DesNitBrt += 10u;
    }    
}

void DesDayBrt_Add(void)
{
    if (CurDayBrt != DesDayBrt)
    {
        return;
    }

    //DesDayBrt += 10u;
							
    //if (DesDayBrt > 100u)
    {
    //    DesDayBrt = 0u;
    }

    if (DesDayBrt < 100u)
    {
        DesDayBrt += 10u;
    }
}

void DesNitBrt_Sub(void)
{
    if (CurNitBrt != DesNitBrt)
    {
        return;
    }

    if (DesNitBrt >= 10u)
    {
        DesNitBrt -= 10u;
    }
    else
    {
        //DesNitBrt = 90u;
    }
}

void DesDayBrt_Sub(void)
{
    if (CurDayBrt != DesDayBrt)
    {
        return;
    }
    
    if (DesDayBrt >= 10u)
    {
        DesDayBrt -= 10u;
    }
    else
    {
        //DesDayBrt = 100u;
    }
}

uint8_t DesNitBrt_Get(void)
{
    return DesNitBrt;
}

uint8_t CurNitBrt_Get(void)
{
    return CurNitBrt;
}

uint8_t DesDayBrt_Get(void)
{
    return DesDayBrt;
}

uint8_t CurDayBrt_Get(void)
{
    return CurDayBrt;
}

void Brightness_Mode_Set(uint8_t mode)
{
    Brightness_Mode = mode;
}

uint8_t BL_Open_Flag;

void BL_Open_Flag_Set(uint8_t val)
{
    BL_Open_Flag = val;
}

void BL_Management_service(void)
{
    uint16_t brt = 0;
    
    if (SYS_OPR_STAT_RUN && BL_Open_Flag)
    {
        if (CurNitBrt < DesNitBrt)
        {
            CurNitBrt++;
        }
        else
        {
            if (CurNitBrt != DesNitBrt)
            {
                CurNitBrt--;
            }
        }
        
        if (CurDayBrt < DesDayBrt)
        {
            CurDayBrt++;
        }
        else
        {
            if (CurDayBrt != DesDayBrt)
            {
                CurDayBrt--;
            }
        }

        brt = CurNitBrt;
        
        if (Brightness_Mode == 0u)
        {
            brt = CurDayBrt;
        }

        brt *= 10u;

        if (brt < 30u)
        {
            //BL_KL30_Init();
            //brt = CurDayBrt;
            brt = 30u; //20230830按领导要求去掉补丁（上面两行）恢复原样
        }
        
        BL_TFT_Status_Set(0);
    }
    else
    {
        ;
    }
  #if 0  
    if (brt <= 500)
    {
        brt *= 9;
        brt /= 10;
    }
    else
    {
        brt -= 500;
        //brt *= ;
        brt /= 5;
        brt += 450;
    }
  #endif
	TimerB_PWM_Channel_Duty_Set(TIMERB_0_CH7, brt);
    TimerB_PWM_Channel_Duty_Set(TIMERB_0_CH3, brt);
	TimerB_PWM_Channel_Duty_Set(TIMERB_2_CH15, brt);
	//TimerB_PWM_Channel_Duty_Set(TIMERB_2_CH11, brt);
}
