#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "Data_VehicleSpeed.h"
#include "System_Monitor.h"
#include "GaugesInterface.h"
#include "Gauges.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Line_in.h"
#include "Line_In_user.h"

//#include "Menu\Menu.h"

#include "Emulated_EEPROM.h"
#include "Watchdog.h"

/*修饰变量static*/

/*ig on off时间线*/
static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed; /*实际值,十倍的*/
static uint16_t Disp_V_Speed; /*显示值,十倍的*/

/*数据有效 1 ;数据无效 0 /0xff */
static DataValid_t PowerSts_Valid;
static DataValid_t Act_V_Speed_Valid;
static DataValid_t Disp_V_Speed_Valid;

static uint16_t SysRollingCounter;

/*菜单设置项存储EEP结构*/
//_Menu_Configure_Value Menu_Con_EEP_Value;
extern uint8_t u8MenuItemVariateNum[8];//MENU_ITEM_MAX];
extern uint8_t u8MenuItemVariateData[8];//MENU_ITEM_MAX];

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;

    PowerSts_Valid = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0xfffffffful;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

COMMON_PowerStatus_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}

uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}

/*获取超速报警状态*/
uint8_t Common_Get_OverSpeed_Status(void)
{
    uint8_t OverSpeedStatus = 0u;
    uint16_t DispVSpeed = 0u;
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed >= 1000u)
    {
        OverSpeedStatus = 1u;
    }
    else if (DispVSpeed <= 960u)
    {
        OverSpeedStatus = 0u;
    }

    return OverSpeedStatus;
}

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}

void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}

void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}

DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return  Act_V_Speed_Valid;
}

DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}

void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}

void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}

void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}

uint16_t Common_Get_DispSpeed(void)
{
    uint16_t m_Res;
    
    if (Disp_V_Speed_Valid)
    {
        m_Res = (((Disp_V_Speed / 10u) * 16u) / 9u);
    }
    else
    {
        m_Res = 0x1fffu;
    }
    
    return m_Res;
}

extern uint32_t u32TimeR;

/*2MS任务*/
void Common_Input_Para(void)
{
    uint32_t V_Speed_Convert = 0ul;
    uint32_t u32IG_ON_Timer = 0u;
    
    u32IG_ON_Timer = Common_GetIgnOnTime();

    if (u32TimeR < 0x7ffffffful)
    {
        u32TimeR += 2u;
    }
    
    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车速实际值处理 有效无效设定*/
        Common_Set_Act_V_Speed(Cal_Veh_Val());
        
        if ((Common_Get_Act_V_Speed () == 0u) || (Get_ID_18F101D0_Sig_VCU_VhclSpd() > 0xFF00u))
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
        }

        /*车显示值处理 显示值有效*/
        if (u32IG_ON_Timer <= 40u)
        {
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }
        else
        {
            Common_Set_Disp_V_Speed(VehSpeedAmplification(Cal_Veh_Val()));
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }

        PowerIgnOffTimeLine = 0ul;
        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }

        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
    }
}

void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

    }
    while (Counter < DIMCounter);
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

#pragma diag_suppress=Pm064
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char * sFormat, ...);
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char * sFormat, ...)
{
    return 0;
}

void Common_Set_VdoFmtTyp(uint8_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Set_VdoFmtTyp = NUM_Status;
    
    for (uint32_t i=0u; i<10u; i++)
    {
        /*存储*/
        if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
        {
            while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
            {
                WDT_Clear();
            }
            
            enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
            
            if (enResult == EEPROM_RW_PASS)
            {
                break;
            }
        }
    }
}

extern uint8_t LitSpdTyp; //限速类型,0=89,1=99,2=109

void Common_Set_LitSpdTyp(uint8_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Set_LitSpdTyp = NUM_Status;
    
    for (uint32_t i=0u; i<10u; i++)
    {
        /*存储*/
        if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
        {
            while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
            {
                WDT_Clear();
            }
            
            enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
            
            if (enResult == EEPROM_RW_PASS)
            {
                break;
            }
        }
    }
}

#if 0
/*-----------------------------以下设置值---------------------------------------------------------*/
/*行车电脑/TPMS 静态轮胎防盗使能 0-关闭  1-开启*/
void Common_Set_Tpms_Guard_Against_Theft_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Tpms_Guard_Against_Theft_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Tpms_Guard_Against_Theft_Sta_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Tpms_Guard_Against_Theft_Sta;
}

/*ACC车距设置/车距模式选择 0-4-->(1-5 默认3)*/
void Common_Set_ACC_Distance_Mode_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.ACC_Distance_Mode_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_ACC_Distance_Mode_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.ACC_Distance_Mode_Value;
}

/*行车信息/辅助驾驶 ACC   0-关闭  1-开启*/
void Common_Set_ACC_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.ACC_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_ACC_Stae(void)
{
    return (uint32_t)Menu_Con_EEP_Value.ACC_Sta;
}

/*行车信息/辅助驾驶 AEBS  0-关闭  1-开启*/
void Common_Set_AEBS_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.AEBS_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_AEBS_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.AEBS_Sta;
}

/*行车信息/辅助驾驶 坡道辅助 0-关闭  1-开启  2-未配置*/
void Common_Set_Ramp_Assist_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Ramp_Assist_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_Ramp_Assist_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Ramp_Assist_Sta;
}

/*行车信息/辅助驾驶 ESC/ASR 0-关闭  1-开启*/
void Common_Set_ESC_ASR_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.ESC_ASR_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_ESC_ASR_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.ESC_ASR_Sta;
}

/*行车信息/辅助驾驶 智能ADAS -关闭  1-开启*/
void Common_Set_ADAS_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.ADAS_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_ADAS_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.ADAS_Sta;
}

/*辅助驾驶/ADAS灵敏度 0-3-->(1-3 默认2)*/
void Common_Set_ADAS_Sensitivity_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.ADAS_Sensitivity_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_ADAS_Sensitivity_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.ADAS_Sensitivity_Value;
}

/*胎压检测状态     0-关闭  1-开启*/
void Common_Set_Tpms_Monitor_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Tpms_Monitor_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_Tpms_Monitor_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Tpms_Monitor_Sta;
}

/*辅助驾驶/蓄电池类型 0-7  0-135AH 1-165AH免维护 180AH免维护...*/
void Common_Set_Battery_Type_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Battery_Type_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_Battery_Type_Value(void)
{
    return Menu_Con_EEP_Value.Battery_Type_Value;
}

/*保养提示状态     0-关闭  1-开启*/
void Common_Set_TMaintain_Tips_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.TMaintain_Tips_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}
uint32_t Common_Get_TMaintain_Tips_Sta(void)
{
    return Menu_Con_EEP_Value.TMaintain_Tips_Sta;
}

/*提示设置/保养设置 单位km*/
void  Common_Set_TMaintain_Set_Value(void)
{
    uint32_t SettingMaintainMileage_number1 = 0x0u;
    uint32_t SettingMaintainMileage_number2 = 0x0u;
    uint32_t SettingMaintainMileage_number3 = 0x0u;
    uint32_t SettingMaintainMileage_number4 = 0x0u;
    uint32_t SettingMaintainMileage_number5 = 0x0u;
    uint32_t SettingMaintainMileage_number6 = 0x0u;

    SettingMaintainMileage_number1 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_1];
    SettingMaintainMileage_number2 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_2];
    SettingMaintainMileage_number3 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_3];
    SettingMaintainMileage_number4 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_4];
    SettingMaintainMileage_number5 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_5];
    SettingMaintainMileage_number6 = u8MenuItemVariateNum[MENU_ITEM_MAINTENANCE_MILEAGE_NUM_6];

    Menu_Con_EEP_Value.TMaintain_Set_Value = SettingMaintainMileage_number1 * 100000 + \
            SettingMaintainMileage_number2 * 10000 + \
            SettingMaintainMileage_number3 * 1000 + \
            SettingMaintainMileage_number4 * 100 + \
            SettingMaintainMileage_number5 * 10 + \
            SettingMaintainMileage_number6;

    Data_Maintenance_Interval_Reset(Menu_Con_EEP_Value.TMaintain_Set_Value * 10);
}
uint32_t Common_Get_TMaintain_Set_Value(void)
{
    return Menu_Con_EEP_Value.TMaintain_Set_Value;
}

/*提示设置/提示里程 单位km*/
void  Common_Set_TMaintain_Tips_Value(void)
{
    uint32_t SettingPromptMileage_number1 = 0x0u;
    uint32_t SettingPromptMileage_number2 = 0x0u;
    uint32_t SettingPromptMileage_number3 = 0x0u;
    uint32_t SettingPromptMileage_number4 = 0x0u;
    uint32_t SettingPromptMileage_number5 = 0x0u;
    uint32_t SettingPromptMileage_number6 = 0x0u;

    SettingPromptMileage_number1 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_1] ;
    SettingPromptMileage_number2 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_2] ;
    SettingPromptMileage_number3 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_3] ;
    SettingPromptMileage_number4 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_4] ;
    SettingPromptMileage_number5 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_5] ;
    SettingPromptMileage_number6 = u8MenuItemVariateNum[MENU_ITEM_PROMPT_MILEAGE_NUM_6] ;

    Menu_Con_EEP_Value.TMaintain_Tips_Value = SettingPromptMileage_number1 * 100000 + \
            SettingPromptMileage_number2 * 10000 + \
            SettingPromptMileage_number3 * 1000 + \
            SettingPromptMileage_number4 * 100 + \
            SettingPromptMileage_number5 * 10 + \
            SettingPromptMileage_number6;
}
uint32_t Common_Get_TMaintain_Tips_Value(void)
{
    return Menu_Con_EEP_Value.TMaintain_Tips_Value;
}

/*个人设置/语言设置 0-5 (简体中文 繁体中文 EN 俄语RU 阿拉伯)*/
void Common_Set_Language_Set_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Language_Set_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Language_Set_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Language_Set_Value;
}

/*个人设置/雨刮灵敏度设置 0-3 (1-4 默认2)*/
void Common_Set_Wiper_Distance_Mode_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Wiper_Distance_Mode_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }

}

uint32_t Common_Get_Wiper_Distance_Mode_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Wiper_Distance_Mode_Value;
}

/*个人设置/背光调节 0-2 (1-3档)*/
void Common_Set_Backlight_Set_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Backlight_Set_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Backlight_Set_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Backlight_Set_Value;
}

/*个人设置/伴我回家设置*/
void Common_Set_Follow_Me_Home_Time_Value(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Follow_Me_Home_Time_Value = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }

}

uint32_t Common_Get_Follow_Me_Home_Time_Value(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Follow_Me_Home_Time_Value;
}

/*个人设置/主界面设置 瞬时油耗 0-关闭  1-开启*/
void Common_Set_Instantaneous_Oil_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Instantaneous_Oil_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Instantaneous_Oil_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Instantaneous_Oil_Sta;
}

/*个人设置/主界面设置 电池电量 0-关闭  1-开启*/
void Common_Set_Battery_Level_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Battery_Level_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Battery_Level_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Battery_Level_Sta;
}

/*个人设置/主界面设置 尿素液位 0-关闭  1-开启*/
void Common_Set_Adblue_Level_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Adblue_Level_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Adblue_Level_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Adblue_Level_Sta;
}

/*个人设置/主界面设置 累计油耗 0-关闭  1-开启*/
void Common_Set_Cumulative_Oil_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Cumulative_Oil_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Cumulative_Oil_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Cumulative_Oil_Sta;
}

/*个人设置/主界面设置 综合油耗 0-关闭  1-开启*/
void Common_Set_Comprehensive_Oil_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Comprehensive_Oil_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Comprehensive_Oil_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Comprehensive_Oil_Sta;
}

/*个人设置/主界面设置 当前油耗 0-关闭  1-开启*/
void Common_Set_Current_Oil_Sta(uint32_t NUM_Status)
{
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    Menu_Con_EEP_Value.Current_Oil_Sta = NUM_Status;

    /*存储*/
    if (EEPROM_Get_Block_Status (EEPROM_BLOCK_UE_INFO) != EEPROM_STAT_ERROR)
    {
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_UE_INFO, &Menu_Con_EEP_Value, (sizeof(Menu_Con_EEP_Value) / 4u));
    }
}

uint32_t Common_Get_Current_Oil_Sta(void)
{
    return (uint32_t)Menu_Con_EEP_Value.Current_Oil_Sta;
}

/*从菜单获取发动机类型*/
void Common_Set_Engine_Type(void)
{
    uint8_t Engine_Page_Value = 0u;
    uint8_t Engine_Type = 0u;
    uint16_t Engine_Type_Value = 0u;

    Engine_Type_Value = (ENGINE_TYPE_VALUE)Menu_Get_Item_Select_Engine() ;
    if (Engine_Type_Value >= MENU_ITEM_Engine_WP13 )
    {
        Engine_Type_Value = Engine_Type_Value - MENU_ITEM_Engine_WP13;
    }
    else
    {
        Engine_Type_Value = 0u;
    }

    Menu_Con_EEP_Value.Set_Engine_Type_Value = Engine_Type_Value;
}

ENGINE_TYPE_VALUE Common_Get_Engine_Type(void)
{
    return (ENGINE_TYPE_VALUE)Menu_Con_EEP_Value.Set_Engine_Type_Value ;
}

void Common_Set_EngineG5G6_Type(void)
{
    if (Menu_Get_Item_Select_DischargeSet() == MENU_ITEM_DischargeSet_The_Six)
    {
        Menu_Con_EEP_Value.Set_EngineG5G6_Type_Value = ENGINE_TYPE_G6_VALUE;
    }
    else
    {
        Menu_Con_EEP_Value.Set_EngineG5G6_Type_Value = ENGINE_TYPE_G5_VALUE;
    }
}

/*获取国五国六设置*/
uint8_t Common_Get_EngineG5G6_Type(void)
{
    uint8_t Set_EngineG5G6_Type_Value = 0u;
    Set_EngineG5G6_Type_Value = (uint8_t)(Menu_Con_EEP_Value.Set_EngineG5G6_Type_Value & 0xFFu) ;

    return Set_EngineG5G6_Type_Value;
}

/*获取发送机总类型  油  气  LNGCNG*/
uint8_t  Common_Get_Engine_LNGCNG_Type(void)
{
    switch (Common_Get_Engine_Type())
    {
    case Type_WP15LNG  :
    case Type_WP13LNG  :
    case Type_WP12LNG  :
    case Type_WP10LNG  :
    case Type_WP10HLNG :
    case Type_WP11SLNG :
    case Type_WP6_7LNG :
    case Type_WP5LNG   :
    case Type_WP4_6LNG :
    case Type_KMSTRQ   :
    case Type_YCK11    :
    case Type_6K13N    :
        Engine_LNGCNG_Type = 1u;
        break;
    case Type_WP15CNG  :
    case Type_WP13CNG  :
    case Type_WP12CNG  :
    case Type_WP10CNG  :
    case Type_WP10HCNG :
    case Type_WP11SCNG :
    case Type_WP6_7CNG :
    case Type_WP5CNG   :
    case Type_WP4_6CNG :
        Engine_LNGCNG_Type = 2u;
        break;
    default:
        Engine_LNGCNG_Type = 0u;
        break;
    }

    return Engine_LNGCNG_Type ;
}

/*获取发送机总类型  油  气  LNGCNG*/
uint8_t  Common_Get_Engine_Type_TX(void)
{
    switch (Common_Get_Engine_Type())
    {

    case  Type_WP6: /*濰柴柴油發動機*/
    case  Type_WP6H:
    case  Type_WP6_7:
    case  Type_WP7:
    case  Type_WP8:
    case  Type_WP9H:
    case  Type_WP10:
    case  Type_WP10H:
    case  Type_WP10_5H:
    case  Type_WP11S:
    case  Type_WP12:
    case  Type_WP13:
        Engine_Type_TX = 0u;

        break;
    case  Type_L9  :/*康明斯柴油發動機*/
    case  Type_X12 :
    case  Type_X13 :
    case  Type_ISD4_5  :
    case  Type_ISD6_7  :
    case  Type_ISM  :
    case  Type_ISZ  :
    case  Type_M15  :
        Engine_Type_TX = 1u;

        break;
    case  Type_YC6A: /*玉柴柴油發動機*/
    case  Type_YC6L:
    case  Type_YC6K12:
    case  Type_YC4E:
    case  Type_YCK08:
        Engine_Type_TX = 2u;

        break;
    case Type_WP15LNG  :/*天然氣發動機*/
    case Type_WP13LNG  :
    case Type_WP12LNG  :
    case Type_WP10LNG  :
    case Type_WP10HLNG :
    case Type_WP11SLNG :
    case Type_WP6_7LNG :
    case Type_WP5LNG   :
    case Type_WP4_6LNG :
    case Type_KMSTRQ   :
    case Type_WP15CNG  :
    case Type_WP13CNG  :
    case Type_WP12CNG  :
    case Type_WP10CNG  :
    case Type_WP10HCNG :
    case Type_WP11SCNG :
    case Type_WP6_7CNG :
    case Type_WP5CNG   :
    case Type_WP4_6CNG :
    case Type_YCK11    :
    case Type_6K13N    :
        Engine_Type_TX = 3u;

        break;
    case  Type_HPDI: /*HPDI發動機 （油氣混動）*/
        Engine_Type_TX = 4u;

        break;

    default:
        Engine_Type_TX = 15u;

        break;
    }
    return Engine_Type_TX;
}

void Common_Set_Gear_Type(void)
{
    Menu_Item_en_t Gear_Type = 0u;
    Gear_Type = Menu_Get_Item_Select_Box();

    if (Gear_Type >= MENU_ITEM_BoxSet_Mechanical)
    {
        Gear_Type = Gear_Type - MENU_ITEM_BoxSet_Mechanical;
    }
    else
    {
        Gear_Type = 0u;
    }

    Menu_Con_EEP_Value.Set_Gear_Type_Value = (GEARBOX_TYPE_VALUE)Gear_Type ;
}

GEARBOX_TYPE_VALUE Common_Get_Gear_Type(void)
{
    return Menu_Con_EEP_Value.Set_Gear_Type_Value ;
}

void Common_Set_Car_Model_Type(void)
{
    Menu_Item_en_t Car_Model_Type = 0u;

    Car_Model_Type = Menu_Get_Item_Select_VehType();

    if (Car_Model_Type >= MENU_ITEM_VehType_Non_Mixer)
    {
        Car_Model_Type = (Car_Model_Type - MENU_ITEM_VehType_Non_Mixer);
    }
    else
    {
        Car_Model_Type = 0u;
    }

    Menu_Con_EEP_Value.Set_Car_Model_Type =  Car_Model_Type ;
}
uint8_t Common_Get_Car_Model_Type(void)
{
    uint8_t Set_Car_Model_Type = 0u;
    Set_Car_Model_Type = (uint8_t) (Menu_Con_EEP_Value.Set_Car_Model_Type & 0xFFu);

    return Set_Car_Model_Type ;
}

void  Common_Set_Car_APU_Type(void)
{
    Menu_Item_en_t Car_APU_Type = 0u;
    Car_APU_Type = Menu_Get_Item_Select_Braking();
    if (
        (Car_APU_Type == MENU_ITEM_8x4_Braking_IntegratAPU) || \
        (Car_APU_Type == MENU_ITEM_6x4_Braking_IntegratAPU) || \
        (Car_APU_Type == MENU_ITEM_6x2_Braking_IntegratAPU) || \
        (Car_APU_Type == MENU_ITEM_4x2_Braking_IntegratAPU)
    )
    {
        Menu_Con_EEP_Value.Set_Car_APU_Type = 1u;
    }
    else
    {
        Menu_Con_EEP_Value.Set_Car_APU_Type = 0u;
    }
}
uint8_t  Common_Get_Car_APU_Type(void)
{
    uint8_t Set_Car_APU_Type = 0u;
    Set_Car_APU_Type = (uint8_t)(Menu_Con_EEP_Value.Set_Car_APU_Type & 0xFFu);

    return Set_Car_APU_Type;
}

void Common_Set_Tpms_Size(void)
{
    Menu_Item_en_t Get_Tpms_Siz = 0u;
    Get_Tpms_Siz = Menu_Get_Item_Select_DriveMode();
    if (Get_Tpms_Siz >= MENU_ITEM_DriveMode_8x4_EpipoSet_1)
    {
        Get_Tpms_Siz = Get_Tpms_Siz - MENU_ITEM_DriveMode_8x4_EpipoSet_1;
    }
    else
    {
        Get_Tpms_Siz = 0u;
    }

    Menu_Con_EEP_Value.Set_Tpms_Size_Sta = Get_Tpms_Siz - MENU_ITEM_DriveMode_8x4_EpipoSet_1;
}

uint8_t Common_Get_Tpms_Size(void)
{
    uint8_t Set_Tpms_Size_Sta = 0u;
    Set_Tpms_Size_Sta = (uint8_t)(Menu_Con_EEP_Value.Set_Tpms_Size_Sta & 0xFFu);

    return Set_Tpms_Size_Sta;
}

/*调表模式  K值计算*/
void  Common_Set_K_Value_Number(void)
{
    uint32_t K_Value_Number1 = 0u;
    uint32_t K_Value_Number2 = 0u;
    uint32_t K_Value_Number3 = 0u;
    uint32_t K_Value_Number4 = 0u;
    uint32_t K_Value_Number5 = 0u;

    _Menu_Data_Kvalue_Struct Value_NUML = {0u};
    Value_NUML =  Menu_Get_Kvalue(); /*数值获取*/

    K_Value_Number1 = Value_NUML.u8curData1;
    K_Value_Number2 = Value_NUML.u8curData2;
    K_Value_Number3 = Value_NUML.u8curData3;
    K_Value_Number4 = Value_NUML.u8curData4;
    K_Value_Number5 = Value_NUML.u8curData5;

    Menu_Con_EEP_Value.K_Value_Num_Value = K_Value_Number1 * 10000u + \
                                           K_Value_Number2 * 1000 + \
                                           K_Value_Number3 * 100 + \
                                           K_Value_Number4 * 10 + \
                                           K_Value_Number5;
}

uint32_t  Common_Get_K_Value_Number(void)
{
    return Menu_Con_EEP_Value.K_Value_Num_Value;
}
/*-----------------------------以上设置值---------------------------------------------------------*/
/*安全带距离累计*/
uint8_t Commom_Data_Get_Seatbelt_Tiip_Sta(void)
{
    static uint8_t Seatbelt_Sta_Flag = 0u;
    static uint32_t Seatbelt_Start = 0u;
    uint32_t Seatbelt_Stop = 0u;
    uint8_t LineStatus1 = 0u;
    uint8_t LineStatus2 = 0u;
    uint16_t Disp_V_Speed = 0u;
    uint8_t Seatbelt_Sound_Sta = 0u;

    LineStatus1 = (uint8_t)Line_In_Get_Status(LINE_IN_LED_Seatbelt);
    LineStatus2 = (uint8_t)Line_In_Get_Status(LINE_IN_LED_ViceSeatbelt);
    Disp_V_Speed = Common_Get_Disp_V_Speed();

    if ((LineStatus1 == 1u) || (LineStatus2 == 1u))
    {
        if (Seatbelt_Sta_Flag == 0u)
        {
            Seatbelt_Start = Data_ODO_Read();
            Seatbelt_Sta_Flag = 1u;
        }
        Seatbelt_Stop = Data_ODO_Read();

        if (Seatbelt_Stop >= Seatbelt_Start)
        {
            if ((Seatbelt_Stop - Seatbelt_Start) >= 5)
            {
                Seatbelt_Sound_Sta = 1u;
            }
        }
        else
        {
            Seatbelt_Sound_Sta = 0u;
        }

    }
    else if (((LineStatus1 == 0u) && (LineStatus2 == 0u)) || (Disp_V_Speed == 0u))
    {
        Seatbelt_Sta_Flag = 0u;
        Seatbelt_Start = 0u;
        Seatbelt_Sound_Sta = 0u;
    }

    return Seatbelt_Sound_Sta;
}

uint8_t  Common_Get_Select_Sta(void)
{
    uint8_t Select_Sta = 0u;

    Select_Sta = Menu_Con_EEP_Value.Instantaneous_Oil_Sta +
                 Menu_Con_EEP_Value.Battery_Level_Sta +
                 Menu_Con_EEP_Value.Adblue_Level_Sta +
                 Menu_Con_EEP_Value.Cumulative_Oil_Sta +
                 Menu_Con_EEP_Value.Comprehensive_Oil_Sta +
                 Menu_Con_EEP_Value.Current_Oil_Sta;

    return Select_Sta;
}

#endif
