#include "GUI_Menu_Energy.h"

#define GUI_THEME_1_F  0x01u
#define GUI_THEME_2_F  0x02u
#define GUI_THEME_3_F  0x03u

#define GUI_LANGUAGE_CHINESE_F  0x01u
#define GUI_LANGUAGE_ENGLISH_F  0x02u

#define GUI_DRIVEING_TIME_F  0x01u
#define GUI_DRIVEING_TRIP_F  0x02u
#define GUI_DRIVEING_Maintenance_Mileage_F  0x03u

#define GUI_Energy_Recovery_L_F  0x01u
#define GUI_Energy_Recovery_M_F  0x02u
#define GUI_Energy_Recovery_H_F  0x03u

#define GUI_SPEAKING_OPEN_F   0x01u
#define GUI_SPEAKING_CLOSE_F  0x02u
#define GUI_SPEAKING_CLOSE_GREY_F 0x03u

#define GUI_POS_LANGUAGE_CH 0x01u
#define GUI_POS_LANGUAGE_EN 0x02u

uint8_t GUI_Animation_Energy_POS = 0u;

uint8_t GUI_Animation_battery_POS = 0u;

typedef struct
{
    uint16_t   DATA_TPMS_FLTyrePr  ;
    uint16_t   DATA_TPMS_FRTyrePr  ;
    uint16_t   DATA_TPMS_RLTyrePr  ;
    uint16_t   DATA_TPMS_RRTyrePr  ;

    uint16_t   DATA_TPMS_FLTyreTemp;
    uint16_t   DATA_TPMS_FRTyreTemp;
    uint16_t   DATA_TPMS_RLTyreTemp;
    uint16_t   DATA_TPMS_RRTyreTemp;

    uint16_t   DATA_TPMS_FLTyreTemp_MINUS;
    uint16_t   DATA_TPMS_FRTyreTemp_MINUS;
    uint16_t   DATA_TPMS_RLTyreTemp_MINUS;
    uint16_t   DATA_TPMS_RRTyreTemp_MINUS;

    uint8_t   DATA_TPMS_FLTyreWarn;
    uint8_t   DATA_TPMS_FRTyreWarn;
    uint8_t   DATA_TPMS_RLTyreWarn;
    uint8_t   DATA_TPMS_RRTyreWarn;

    uint8_t TPMS_FLTyrePr_Color;
    uint8_t TPMS_FRTyrePr_Color;
    uint8_t TPMS_RLTyrePr_Color;
    uint8_t TPMS_RRTyrePr_Color;

    uint8_t TPMS_FLTyreTemp_Color;
    uint8_t TPMS_FRTyreTemp_Color;
    uint8_t TPMS_RLTyreTemp_Color;
    uint8_t TPMS_RRTyreTemp_Color;


    uint8_t TPMS_FLwheel_Color;
    uint8_t TPMS_FRwheel_Color;
    uint8_t TPMS_RLwheel_Color;
    uint8_t TPMS_RRwheel_Color;

    uint8_t TPMS_FLwheel_Flash_F;
    uint8_t TPMS_FRwheel_Flash_F;
    uint8_t TPMS_RLwheel_Flash_F;
    uint8_t TPMS_RRwheel_Flash_F;


} TPMS_Display_Data_Struct;

TPMS_Display_Data_Struct  TPMS_Display_Data;


uint16_t GUI_F_TyrePr_X[] = {294u, 274u};
uint16_t GUI_R_TyrePr_X[] = {478u, 458u};

uint16_t GUI_F_TyreTemp_X[] = {294u, 280u, 266u};
uint16_t GUI_R_TyreTemp_X[] = {478u, 464u, 450u};

void GUI_TPMS_Display(void)
{
    TPMS_Display_Data.DATA_TPMS_FLTyrePr = 12u;
    TPMS_Display_Data.DATA_TPMS_FRTyrePr = 13u;
    TPMS_Display_Data.DATA_TPMS_RLTyrePr = 14u;
    TPMS_Display_Data.DATA_TPMS_RRTyrePr = 15u;

    TPMS_Display_Data.DATA_TPMS_FLTyreTemp = 16u;
    TPMS_Display_Data.DATA_TPMS_FRTyreTemp = 17u;
    TPMS_Display_Data.DATA_TPMS_RLTyreTemp = 18u;
    TPMS_Display_Data.DATA_TPMS_RRTyreTemp = 19u;

    TPMS_Display_Data.DATA_TPMS_FLTyreWarn = 0u;
    TPMS_Display_Data.DATA_TPMS_FRTyreWarn = 0u;
    TPMS_Display_Data.DATA_TPMS_RLTyreWarn = 0u;
    TPMS_Display_Data.DATA_TPMS_RRTyreWarn = 0u;

    TPMS_Display_Data.TPMS_FLTyrePr_Color = 1u;
    TPMS_Display_Data.TPMS_FRTyrePr_Color = 1u;
    TPMS_Display_Data.TPMS_RLTyrePr_Color = 1u;
    TPMS_Display_Data.TPMS_RRTyrePr_Color = 1u;

    TPMS_Display_Data.TPMS_FLTyreTemp_Color = 1u;
    TPMS_Display_Data.TPMS_FRTyreTemp_Color = 1u;
    TPMS_Display_Data.TPMS_RLTyreTemp_Color = 1u;
    TPMS_Display_Data.TPMS_RRTyreTemp_Color = 1u;


    TPMS_Display_Data.TPMS_FLwheel_Color = 1u;
    TPMS_Display_Data.TPMS_FRwheel_Color = 1u;
    TPMS_Display_Data.TPMS_RLwheel_Color = 1u;
    TPMS_Display_Data.TPMS_RRwheel_Color = 1u;

    TPMS_Display_Data.TPMS_FLwheel_Flash_F = 0u;
    TPMS_Display_Data.TPMS_FRwheel_Flash_F = 0u;
    TPMS_Display_Data.TPMS_RLwheel_Flash_F = 0u;
    TPMS_Display_Data.TPMS_RRwheel_Flash_F = 0u;

    TPMS_Display_Data.DATA_TPMS_FLTyreTemp_MINUS = 1u;
    TPMS_Display_Data.DATA_TPMS_FRTyreTemp_MINUS = 1u;
    TPMS_Display_Data.DATA_TPMS_RLTyreTemp_MINUS = 1u;
    TPMS_Display_Data.DATA_TPMS_RRTyreTemp_MINUS = 1u;
    /*显示车体*/

    GUI_General_Display((uint16_t)TPMS_Car);

    /*显示胎压单位*/
    GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 158U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 261U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 158U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 261U);

    /*显示胎温单位*/
    GUI_Translate_Display( (uint16_t)TPMS_Unit_C, 314U, 187U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_C, 314U, 292U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_C, 498U, 187U);
    GUI_Translate_Display( (uint16_t)TPMS_Unit_C, 498U, 292U);


    /*胎压显示*/
    if (TPMS_Display_Data.TPMS_FLTyrePr_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FLTyrePr , (uint16_t)Number_11_white_0 , 2u, 1U, GUI_F_TyrePr_X, 155U);
        /*胎压小数点*/
        GUI_Translate_Display( (uint16_t)Number_11_white_point3, 284U, 156U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 158U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FLTyrePr , (uint16_t)Number_11_red_0 , 2u, 1U, GUI_F_TyrePr_X, 155U);
        /*胎压小数点*/
        GUI_Translate_Display( (uint16_t)Number_11_red_point3, 284U, 156U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 158U);
    }

    if (TPMS_Display_Data.TPMS_FRTyrePr_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FRTyrePr , (uint16_t)Number_11_white_0 , 2u, 1U, GUI_R_TyrePr_X, 155U);
        GUI_Translate_Display( (uint16_t)Number_11_white_point3, 284U, 259U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 158U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FRTyrePr , (uint16_t)Number_11_red_0 , 2u, 1U, GUI_F_TyrePr_X, 155U);
        GUI_Translate_Display( (uint16_t)Number_11_red_point3, 284U, 259U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 158U);
    }


    if (TPMS_Display_Data.TPMS_RLTyrePr_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RLTyrePr , (uint16_t)Number_11_white_0 , 2u, 1U, GUI_F_TyrePr_X, 258U);
        GUI_Translate_Display( (uint16_t)Number_11_white_point3, 468U, 156U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 261U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RLTyrePr , (uint16_t)Number_11_red_0 , 2u, 1U, GUI_R_TyrePr_X, 258U);
        GUI_Translate_Display( (uint16_t)Number_11_red_point3, 468U, 156U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 312U, 261U);
    }

    if (TPMS_Display_Data.TPMS_RRTyrePr_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RRTyrePr , (uint16_t)Number_11_white_0 , 2u, 1U, GUI_R_TyrePr_X, 258U);
        GUI_Translate_Display( (uint16_t)Number_11_white_point3, 468U, 259U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 261U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RRTyrePr , (uint16_t)Number_11_red_0 , 2u, 1U, GUI_R_TyrePr_X, 258U);
        GUI_Translate_Display( (uint16_t)Number_11_red_point3, 468U, 259U);
        GUI_Translate_Display( (uint16_t)TPMS_Unit_kPa, 496U, 261U);
    }





    /*胎温显示*/

    if (TPMS_Display_Data.TPMS_FLTyreTemp_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FLTyreTemp , (uint16_t)Number_11_white_0 , 4u, 3U, GUI_F_TyreTemp_X, 185U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FLTyreTemp , (uint16_t)Number_11_red_0 , 4u, 3U, GUI_F_TyreTemp_X, 185U);
    }

    if (TPMS_Display_Data.TPMS_FRTyreTemp_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FRTyreTemp , (uint16_t)Number_11_white_0 , 4u, 3U, GUI_F_TyreTemp_X, 290U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_FRTyreTemp , (uint16_t)Number_11_red_0 , 4u, 3U, GUI_F_TyreTemp_X, 290U);
    }

    if (TPMS_Display_Data.TPMS_RLTyreTemp_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RLTyreTemp , (uint16_t)Number_11_white_0 , 4u, 3U, GUI_R_TyreTemp_X, 185U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RLTyreTemp , (uint16_t)Number_11_red_0 , 4u, 3U, GUI_R_TyreTemp_X, 185U);
    }

    if (TPMS_Display_Data.TPMS_RRTyreTemp_Color)
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RRTyreTemp , (uint16_t)Number_11_white_0 , 4u, 3U, GUI_R_TyreTemp_X, 290U);
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)TPMS_Display_Data.DATA_TPMS_RRTyreTemp , (uint16_t)Number_11_red_0 , 4u, 3U, GUI_R_TyreTemp_X, 290U);
    }

    /*轮胎显示*/

    if (TPMS_Display_Data.TPMS_FLwheel_Color)
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Blue, 351U, 172U);
    }
    else
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Red, 351U, 172U);
    }

    if (TPMS_Display_Data.TPMS_FRwheel_Color)
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Blue, 351U, 273U);
    }
    else
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Red, 351U, 273U);
    }

    if (TPMS_Display_Data.TPMS_RLwheel_Color)
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Blue, 419U, 172U);
    }
    else
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Red, 419U, 172U);
    }

    if (TPMS_Display_Data.TPMS_RRwheel_Color)
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Blue, 419U, 273U);
    }
    else
    {
        GUI_Translate_Display((uint16_t)TPMS_Tyre_Red, 419U, 273U);
    }

    /*胎温负号*/
    if (TPMS_Display_Data.DATA_TPMS_FLTyreTemp_MINUS)
    {
        if (TPMS_Display_Data.TPMS_FLwheel_Color)
        {
            GUI_Translate_Display((uint16_t)Number_11_white_point2, 274U, 191U);
        }
        else
        {
            GUI_Translate_Display((uint16_t)Number_11_red_point2, 274U, 191U);
        }
    }
    else
    {
        /* Intentionally Empty */
    }

    if (TPMS_Display_Data.DATA_TPMS_FRTyreTemp_MINUS)
    {
        if (TPMS_Display_Data.TPMS_FRwheel_Color)
        {
            GUI_Translate_Display((uint16_t)Number_11_white_point2, 458U, 191U);
        }
        else
        {
            GUI_Translate_Display((uint16_t)Number_11_red_point2, 458U, 191U);
        }
    }
    else
    {
        /* Intentionally Empty */
    }

    if (TPMS_Display_Data.DATA_TPMS_RLTyreTemp_MINUS)
    {
        if (TPMS_Display_Data.TPMS_RLwheel_Color)
        {
            GUI_Translate_Display((uint16_t)Number_11_white_point2, 274U, 294U);
        }
        else
        {
            GUI_Translate_Display((uint16_t)Number_11_red_point2, 274U, 294U);
        }
    }
    else
    {
        /* Intentionally Empty */
    }

    if (TPMS_Display_Data.DATA_TPMS_RRTyreTemp_MINUS)
    {
        if (TPMS_Display_Data.TPMS_RRwheel_Color)
        {
            GUI_Translate_Display((uint16_t)Number_11_white_point2, 458U, 294U);
        }
        else
        {
            GUI_Translate_Display((uint16_t)Number_11_red_point2, 458U, 294U);
        }
    }
    else
    {
        /* Intentionally Empty */
    }

}



void GUI_THEME_Set_Display(uint8_t GUI_Pos)
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/
    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_01_Word0);	/*主题设置*/

    switch (GUI_Pos)
    {
    case GUI_THEME_1_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_02_Word0);
        break;
    case GUI_THEME_2_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_03_Word0);
        break;
    case GUI_THEME_3_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_04_Word0);
        break;
    default     			:
        break;
    }
    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280U, 344U);	/*左右调节*/
    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

}

void GUI_LANGUAGE_Set_Display(uint8_t GUI_Pos)
{
    GUI_General_Display((uint16_t) Set_Arrow);		/*箭头*/
    GUI_General_Display((uint16_t) Set_Menu2_Vehicle_Language_Title_01_Word0);	/*语言设置*/

    switch (GUI_Pos)
    {
    case GUI_LANGUAGE_CHINESE_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Language_Title_02_Word0);
        break;
    case GUI_LANGUAGE_ENGLISH_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Language_Title_03_Word0);
        break;
    default     			:
        break;
    }
    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280U, 344U);	/*左右调节*/
    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/



}

uint16_t GUI_TRIP_X[] = {415u, 378u, 354u, 329u,};
uint16_t GUI_TRIP_Y = 244u;

uint16_t GUI_Vehicle_Service_X[] = {412u, 387u, 363u, 338u,};
uint16_t GUI_Vehicle_Service_Y = 244u;

uint16_t GUI_TIME_HUOR_X[] = {362u, 337u};
uint16_t GUI_TIME_MINUTE_X[] = {424u, 399u};
uint16_t GUI_TIME_HUOR_Y = 244u;

void GUI_DRIVE_INFO_Set_Display(uint8_t GUI_Pos, uint32_t GUI_NUMBER , uint32_t GUI_NUMBER_HUOR , uint32_t GUI_NUMBER_MINUTE )
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Service_Title_01_Word0);	/*行车信息设置*/


    switch (GUI_Pos)
    {
    case GUI_DRIVEING_Maintenance_Mileage_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Service_Title_04_Word0);	/*保养里程*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER , (uint16_t)Nb_24_white_0 , 4u, 3U, GUI_TRIP_X, (uint16_t)GUI_TRIP_Y);/*数字显示*/
        GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_05_Word0, 444u, 260u);	/*单位*/
        break;
    case  GUI_DRIVEING_TRIP_F     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Service_Title_03_Word0);	/*里程小计*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER , (uint16_t)Nb_24_white_0 , 4u, 3U, GUI_Vehicle_Service_X, (uint16_t)GUI_Vehicle_Service_Y);/*数字显示*/
        GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_05_Word0, 444u, 260u);	/*单位*/
        break;
    case GUI_DRIVEING_TIME_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Service_Title_02_Word0);	/*行驶时间*/

        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_HUOR  , (uint16_t)Nb_24_white_0 , 2u, 1U, GUI_TIME_HUOR_X, (uint16_t)GUI_TIME_HUOR_Y);/*数字显示*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_MINUTE , (uint16_t)Nb_24_white_0 , 2u, 1U, GUI_TIME_MINUTE_X, (uint16_t)GUI_TIME_HUOR_Y);/*数字显示*/
        GUI_Translate_Display((uint16_t)Number_24_white_point, 380u, 241u);	/*冒号显示*/

        GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_04_Word0, 453u, 260u);	/*单位*/
        break;
    default     			:
        break;
    }


    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Service_Title_07_Word0);	/*长按5s清零*/

    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280, 344);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

}

uint16_t GUI_NUM_OVERSPEED_THIER_X[] = {389u, 364u, 340u};
uint16_t GUI_NUM_OVERSPEED_THIER_Y = 244u;

uint16_t GUI_NUM_OVERSPEED_X[] = {377u, 255u};
uint16_t GUI_NUM_OVERSPEED_Y = 244u;

void GUI_OVER_SPEED_Set_Display(uint32_t GUI_NUMBER)   /*超速报警设置*/
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Speed_Title_01_Word0);	/*超速报警设置*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Speed_Title_01_Word0);	/*设置范围时30~130km/h*/
    if (GUI_NUMBER > 100u)
    {
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER , (uint16_t)Nb_24_white_0, 3u, 2U, GUI_NUM_OVERSPEED_THIER_X, GUI_NUM_OVERSPEED_THIER_Y);/*数字显示*/
    }
    else
    {
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER , (uint16_t)Nb_24_white_0, 2u, 1U, GUI_NUM_OVERSPEED_X, GUI_NUM_OVERSPEED_Y);/*数字显示*/
    }


    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280, 344);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

    GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_Speed_Title_03, 417U, 260U);	/*KM/H*/

}

uint16_t GUI_NUM_TIMEHUOR_X[] = {402u, 366u};
uint16_t GUI_NUM_TIMEMINUTE_Y = 244u;
void GUI_Fatigue_Driving_Set_Display(uint32_t GUI_NUMBER_HUOR)    /*疲劳驾驶时间设置*/
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_01_Word0);	/*疲劳驾驶设置*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_02_Word0);	/*设置范围时30~130km/h*/

    GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_HUOR , (uint16_t)Nb_24_white_0 , 2u, 2U, GUI_NUM_TIMEHUOR_X, GUI_NUM_TIMEMINUTE_Y);/*数字显示*/

    GUI_Translate_Display((uint16_t)Number_24_white_point3, 384U, 244U);	/*小数点*/

    GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_Rest_Title_04_Word0, 431U, 260U);	/*单位*/

    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280U, 344U);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

}

void GUI_Energy_Recovery_Display(uint8_t GUI_Pos)    /*能量回收设置*/
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Recovery_Title_01_Word0);	/*能量回收设置*/


    switch (GUI_Pos)
    {
    case GUI_Energy_Recovery_L_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_04_White_Word0);/*低*/
        break;
    case GUI_Energy_Recovery_M_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_03_White_Word0);/*中*/
        break;
    case GUI_Energy_Recovery_H_F      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_02_White_Word0);/*高*/
        break;
    default     			:
        break;
    }
    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280, 344);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

}

void GUI_VOIDE_SETING_Display(uint8_t GUI_Pos, uint8_t GUI_SET)   /*音量调节*/
{
    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_01_Word0);	/*声音控制*/


    switch (GUI_Pos)
    {
    case 0x01u      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_02_Word0);	/*音量调节*/
        switch (GUI_SET)
        {
        case GUI_Energy_Recovery_L_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_04_White_Word0);/*低*/
            break;
        case GUI_Energy_Recovery_M_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_03_White_Word0);/*中*/
            break;
        case GUI_Energy_Recovery_H_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_02_White_Word0);/*高*/
            break;
        default     			:
            break;
        }

        break;
    case 0x02u      :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_03_Word0);	/*语音提示*/
        switch (GUI_SET)
        {
        case GUI_SPEAKING_OPEN_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_04_Word0);/*开启白色字体*/
            break;
        case GUI_SPEAKING_CLOSE_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_05_Word0);/*关闭白色字体*/
            break;
        case GUI_SPEAKING_CLOSE_GREY_F      :
            GUI_General_Display((uint16_t)Set_Menu2_Vehicle_Voice_Title_05_Word0);/*关闭灰色字体*/
            break;
        default     			:
            break;
        }
        break;
    default     						:
        break;
    }
    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280, 344); /*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_Word0);		/*保存*/

}
uint16_t GUI_WOTTINIG_MUN_F_X[] = {381u, 368u};
uint16_t GUI_WOTTINIG_MUN_X[] = {419u, 407u};
uint16_t GUI_WOTTINIG_MUN_Y = 174u;
void GUI_FAULT_LIST_Display(uint8_t GUI_Pos, uint8_t GUI_NUMBER, uint8_t GUI_SUM_NUMBER)    /*报警列表*/
{

    GUI_General_Display((uint16_t)Set_Arrow);		/*箭头*/

    GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_01_Word0);	/*故障查询*/

    GUI_Translate_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_03_Word0, 397u, 174u);	/*斜杠*/


    GUI_General_Digit_Display( (uint32_t)GUI_NUMBER , (uint16_t)Number_12_white_0 , 2u, 1U, GUI_WOTTINIG_MUN_F_X, GUI_WOTTINIG_MUN_Y);/*当前报警个数*/   /*没有坐标*/
    GUI_General_Digit_Display( (uint32_t)GUI_SUM_NUMBER , (uint16_t)Number_12_white_0 , 2u, 1U, GUI_WOTTINIG_MUN_X, GUI_WOTTINIG_MUN_Y);/*报警总数*/	/*没有坐标*/
    switch (GUI_Pos)
    {
    case 1U    	:
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_02_Word0);/*开启白色字体*/
        break;
    case 2U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_03_Word0);/*关闭白色字体*/
        break;
    case 3U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_04_Word0);/*关闭灰色字体*/
        break;
    case 4U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_05_Word0);/*关闭灰色字体*/
        break;
    case 5U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_06_Word0);/*关闭灰色字体*/
        break;
    case 6U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_07_Word0);/*关闭灰色字体*/
        break;
    case 7U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_08_Word0);/*关闭灰色字体*/
        break;
    case 8U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_09_Word0);/*关闭灰色字体*/
        break;
    case 9U     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_10_Word0);/*关闭灰色字体*/
        break;
    case 10U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_11_Word0);/*关闭灰色字体*/
        break;
    case 11U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_12_Word0);/*关闭灰色字体*/
        break;
    case 12U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_13_Word0);/*关闭灰色字体*/
        break;
    case 13U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_14_Word0);/*关闭灰色字体*/
        break;
    case 14U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_15_Word0);/*关闭灰色字体*/
        break;
    case 15U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_16_Word0);/*关闭灰色字体*/
        break;
    case 16U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_17_Word0);/*关闭灰色字体*/
        break;
    case 17U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_18_Word0);/*关闭灰色字体*/
        break;
    case 18U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_19_Word0);/*关闭灰色字体*/
        break;
    case 19U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_20_Word0);/*关闭灰色字体*/
        break;
    case 20U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_21_Word0);/*关闭灰色字体*/
        break;
    case 21U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_22_Word0);/*关闭灰色字体*/
        break;
    case 22U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_23_Word0);/*关闭灰色字体*/
        break;
    case 23U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_24_Word0);/*关闭灰色字体*/
        break;
    case 24U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_25_Word0);/*关闭灰色字体*/
        break;
    case 25U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_26_Word0);/*关闭灰色字体*/
        break;
    case 26U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_27_Word0);/*关闭灰色字体*/
        break;
    case 27U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_28_Word0);/*关闭灰色字体*/
        break;
    case 28U    :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_29_Word0);/*关闭灰色字体*/
        break;
    default     :
        GUI_General_Display((uint16_t)Set_Menu2_Vehicle_fault_Title_30_Word0);/*当前无故障*/
        break;
    }

    GUI_Translate_Display((uint16_t)Set_Menu2_Time_Title_06_Word0, 280, 344);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_01_Word0);		/*退出*/

}

/*选项图片*/
uint16_t MENU_1_1_L[] = {230U, 160U};
uint16_t MENU_1_1_M[] = {347U, 160U};
uint16_t MENU_1_1_R[] = {466U, 160U};

/*时间显示坐标*/
uint16_t MENU_1_1_TIME_L_X[] = {466U, 160U};
uint16_t MENU_1_1_TIME_M_X[] = {466U, 160U};
uint16_t MENU_1_1_TIME_R_X[] = {466U, 160U};

uint16_t MENU_1_1_TIME_Y = 254U;

uint16_t MENU_1_1_TIME_POINT_X[] = {275U, 391U, 510U};
uint16_t MENU_1_1_TIME_POINT_Y = 256U;
/*超速报警显示坐标*/
uint16_t MENU_1_1_OVERSPEED_L_X[] = {326U, 350U, 264U};
uint16_t MENU_1_1_OVERSPEED_M_X[] = {354U, 368U, 382U};
uint16_t MENU_1_1_OVERSPEED_R_X[] = {472U, 486U, 500U};

uint16_t MENU_1_1_OVERSPEED_Y = 254U;

uint16_t MENU_1_1_OVERSPEED_UINT_X[] = {280u, 398u, 516u};

uint16_t MENU_1_1_OVERSPEED_UINT_Y = 256U;

/*语言设置*/
uint16_t MENU_1_1_LANGUAGE_SETING_X[] = {262u, 380u, 498u};
uint16_t MENU_1_1_LANGUAGE_SETING_Y = 254U;

/*疲劳驾驶*/
uint16_t MENU_1_1_TIREDTIME_L_X[] = {254u, 276u};
uint16_t MENU_1_1_TIREDTIME_M_X[] = {371u, 393u};
uint16_t MENU_1_1_TIREDTIME_R_X[] = {489u, 511u};

uint16_t MENU_1_1_TIREDTIME_Y = 254u;

uint16_t MENU_1_1_TIREDTIME_PIONT_X[] = {265u, 282u, 500u};

uint16_t MENU_1_1_TIREDTIME_PIONT_Y = 256u;

uint16_t MENU_1_1_TIREDTIME_uint_X[] = {293u, 401u, 528u};
uint16_t MENU_1_1_TIREDTIME_uint_Y = 256u;

/*能量回收显示*/
uint16_t MENU_1_1_RE_POWER_X[] = {272U, 390u, 590u};

uint16_t MENU_1_1_RE_POWER_Y = 254U;

/*故障显示*/
uint16_t MENU_1_1_NOW_WORRING_double_X[] = {232u, 321u, 428u};

uint16_t MENU_1_1_NOW_WORRING_alone_X[] = {238u, 356u, 474u};

uint16_t MENU_1_1_NOW_WORRING_Y = 254u;

/*故障显示数字*/
uint16_t MENU_1_1_NOW_WORRING_NUM_L_X[] = {310u, 321u};
uint16_t MENU_1_1_NOW_WORRING_NUM_M_X[] = {428u, 439u};
uint16_t MENU_1_1_NOW_WORRING_NUM_R_X[] = {546u, 577u};

uint16_t MENU_1_1_NOW_WORRING_NUM_X[] = {316u, 434u, 552u};

uint16_t MENU_1_1_NOW_WORRING_NUM_Y = 256u;

void GUI_MENU_1_1_Display(uint8_t GUI_Pos, uint16_t RE_POWER_F, uint16_t GUI_NUMBER_TIREDTIME, uint16_t GUI_NUMBER_WORRINIG, uint16_t GUI_NUMBER_HUOR, uint16_t GUI_NUMBER_MINUTE, uint16_t GUI_NUMBER_OVERSPEED, uint16_t GUI_POS_LANGUAGE )
{
    GUI_General_Display((uint16_t)Set_Current);/*选择条*/

    switch (GUI_Pos)
    {
    case 1U    	:
        GUI_Translate_Display((uint16_t)Set_RadioButton_10_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*退出,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_06_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*故障查询,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_03_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*声音控制,右侧*/

        /*故障显示*/
        if (GUI_NUMBER_WORRINIG > 9u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_W_Word0, MENU_1_1_NOW_WORRING_double_X[1], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/
            GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_WORRINIG , (uint16_t)Number_10_white_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_M_X, MENU_1_1_NOW_WORRING_NUM_Y);/*数字显示,灰色,中间侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_W_Word0, MENU_1_1_NOW_WORRING_alone_X[1], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/

            GUI_General_Digit_Display((uint32_t)GUI_NUMBER_WORRINIG , (uint16_t)Number_10_white_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_M_X, MENU_1_1_NOW_WORRING_NUM_Y);/*数字显示,灰色,中间侧*/
        }



        break;
    case 2U     :
        GUI_Translate_Display((uint16_t)Set_RadioButton_06_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*故障查询,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_03_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*声音控制,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_02_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*主题设置,右侧*/
        /*故障显示*/
        if (GUI_NUMBER_WORRINIG > 9u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_G_Word0, MENU_1_1_NOW_WORRING_double_X[0], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/
            GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_WORRINIG , (uint16_t)Number_10_grey_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_L_X, MENU_1_1_NOW_WORRING_NUM_Y);/*数字显示,灰色,中间侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_G_Word0, MENU_1_1_NOW_WORRING_alone_X[0], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/

            GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_WORRINIG , (uint16_t) Number_10_grey_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_L_X, MENU_1_1_NOW_WORRING_NUM_Y); /*数字显示,灰色,中间侧*/
        }

        break;
    case 3U     :
        GUI_Translate_Display((uint16_t)Set_RadioButton_03_Word0, MENU_1_1_L[0u], MENU_1_1_L[1u]); /*声音控制,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_02_Word0, MENU_1_1_M[0u], MENU_1_1_M[1u]); /*主题设置,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_01_Word0, MENU_1_1_R[0u], MENU_1_1_R[1u]); /*时间设置,右侧*/

        GUI_Translate_Display((uint16_t)Number_12_grey_1_point, MENU_1_1_TIME_POINT_X[2u], MENU_1_1_TIME_POINT_Y); /*数字冒号显示,灰色,右侧*/

        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_HUOR , (uint16_t)Number_12_grey_1_0 , 2u, 1U, MENU_1_1_TIME_R_X, MENU_1_1_TIME_Y);/*数字显示,灰色,右侧*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_MINUTE , (uint16_t)Number_12_grey_1_0 , 2u, 1U, MENU_1_1_TIME_R_X, MENU_1_1_TIME_Y);/*数字显示,灰色,右侧*/
        break;
    case 4U     :
        GUI_Translate_Display( (uint16_t) Set_RadioButton_02_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*主题设置,左侧*/
        GUI_Translate_Display( (uint16_t) Set_RadioButtonOK_01_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*时间设置,中间*/
        GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*超速设置,右侧*/
        /*时间设置时间显示*/
        GUI_Translate_Display((uint16_t) Number_11_white_point, MENU_1_1_TIME_POINT_X[1u], MENU_1_1_TIME_POINT_Y); /*数字冒号显示,白色,中间侧*/

        GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_HUOR , (uint16_t) Number_12_white_0 , 2u, 1U, MENU_1_1_TIME_M_X, MENU_1_1_TIME_Y);/*数字显示,白色,中间侧*/
        GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_MINUTE , (uint16_t) Number_12_white_0 , 2u, 1U, MENU_1_1_TIME_M_X, MENU_1_1_TIME_Y);/*数字显示,白色,中间侧*/

        /*超速报警速度显示*/

        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_OVERSPEED , (uint16_t)Number_12_grey_1_0 , 2u, 1U, MENU_1_1_OVERSPEED_R_X, MENU_1_1_OVERSPEED_Y);/*数字显示,灰色,右侧*/

        GUI_Translate_Display( (uint16_t) Set_Img_11_G_Word0, MENU_1_1_OVERSPEED_UINT_X[2], MENU_1_1_OVERSPEED_UINT_Y); /*单位显示,右侧*/

        break;
    case 5U     :
        GUI_Translate_Display( (uint16_t) Set_RadioButton_01_Word0 , MENU_1_1_L[0], MENU_1_1_L[1]); /*时间设置,左侧*/
        GUI_Translate_Display( (uint16_t) Set_RadioButtonOK_04_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*超速报警,中间*/
        GUI_Translate_Display( (uint16_t) Set_RadioButton_07_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*语言设置,右侧*/

        /*时间设置时间显示*/

        GUI_Translate_Display((uint16_t) Number_12_white_0, MENU_1_1_TIME_POINT_X[0u], MENU_1_1_TIME_POINT_Y); /*数字冒号显示,白色,左侧*/

        GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_HUOR , (uint16_t) Number_12_grey_1_0 , 2u, 1U, , MENU_1_1_TIME_Y);/*数字显示,白色,左侧*/
        GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_MINUTE , (uint16_t) Number_12_grey_1_0 , 2u, 1U, MENU_1_1_TIME_L_X, MENU_1_1_TIME_Y);/*数字显示,白色,左侧*/

        /*超速报警速度显示*/

        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_OVERSPEED , (uint16_t) Number_11_white_0 , 2u, 1U, MENU_1_1_OVERSPEED_M_X, MENU_1_1_OVERSPEED_Y);/*数字显示,灰色,中间侧*/

        GUI_Translate_Display( (uint16_t) Set_Img_11_G_Word0, MENU_1_1_OVERSPEED_UINT_X[1], MENU_1_1_OVERSPEED_UINT_Y); /*单位显示,中间侧*/

        /*语言设置显示*/
        if ( GUI_POS_LANGUAGE == ((uint8_t)GUI_POS_LANGUAGE_CH))
        {
            GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[2], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,右侧*/
        }
        else if (GUI_POS_LANGUAGE == ((uint8_t)GUI_POS_LANGUAGE_EN))
        {
            GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[2], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,右侧*/
        }
        else
        {
            /* Intentionally Empty */
        }


        break;
    case 6U     :
        GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*超速设置,左侧*/
        GUI_Translate_Display((uint16_t) Set_RadioButtonOK_07_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*语言设置,中间*/
        GUI_Translate_Display((uint16_t) Set_RadioButton_05_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*行车信息,右侧*/

        /*超速报警速度显示*/

        GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_OVERSPEED , (uint16_t) Number_11_white_0 , 2u, 1U, MENU_1_1_OVERSPEED_L_X, MENU_1_1_OVERSPEED_Y);/*数字显示,灰色,左侧*/

        GUI_Translate_Display((uint16_t) Set_Img_11_W_Word0, MENU_1_1_OVERSPEED_UINT_X[0], MENU_1_1_OVERSPEED_UINT_Y); /*单位显示,左侧*/

        /*语言设置显示*/
        if (GUI_POS_LANGUAGE == ((uint8_t)GUI_POS_LANGUAGE_CH))
        {
            GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[1], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,中间侧*/
        }
        else if (GUI_POS_LANGUAGE == ((uint8_t)GUI_POS_LANGUAGE_EN))
        {
            GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[1], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,中间侧*/
        }
        else
        {
            /* Intentionally Empty */
        }
        break;
    case 7U     :
        GUI_Translate_Display( (uint16_t) Set_RadioButton_07_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*语言设置,左侧*/
        GUI_Translate_Display( (uint16_t) Set_RadioButtonOK_05_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*行车信息,中间*/
        GUI_Translate_Display( (uint16_t) Set_RadioButton_08_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*疲劳驾驶,右侧*/

        /*语言设置显示*/
        if (GUI_POS_LANGUAGE == ((uint8_t)GUI_POS_LANGUAGE_CH))
        {
            GUI_Translate_Display((uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[0], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,左侧*/
        }
        else if (GUI_POS_LANGUAGE == ( (uint8_t)GUI_POS_LANGUAGE_EN))
        {
            GUI_Translate_Display( (uint16_t) Set_RadioButton_04_Word0, MENU_1_1_LANGUAGE_SETING_X[0], MENU_1_1_LANGUAGE_SETING_Y); /*语言设置,左侧*/
        }
        else
        {
            /* Intentionally Empty */
        }

        /*疲劳驾驶显示*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_TIREDTIME , (uint16_t)Number_12_white_0 , 2u, 1U, MENU_1_1_TIREDTIME_R_X, MENU_1_1_TIREDTIME_Y);/*疲劳驾驶时间显示,白色,右侧*/
        GUI_Translate_Display( (uint16_t)Number_12_white_point, MENU_1_1_TIREDTIME_PIONT_X[2], MENU_1_1_TIREDTIME_PIONT_Y); /*疲劳驾驶时间小数点,右侧*/
        GUI_Translate_Display( (uint16_t)Set_Img_10_G_Word0, MENU_1_1_TIREDTIME_uint_X[2], MENU_1_1_TIREDTIME_uint_Y); /*疲劳驾驶时间小数点,右侧*/
        break;
    case 8U     :
        GUI_Translate_Display((uint16_t)Set_RadioButton_06_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*行车信息,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_08_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*疲劳驾驶,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_09_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*能量回收,右侧*/

        /*疲劳驾驶显示*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_TIREDTIME , (uint16_t)Number_12_white_0 , 2u, 1U, MENU_1_1_TIREDTIME_M_X, MENU_1_1_TIREDTIME_Y);/*疲劳驾驶时间显示,白色,中间侧*/
        GUI_Translate_Display((uint16_t)Number_12_white_point, MENU_1_1_TIREDTIME_PIONT_X[1], MENU_1_1_TIREDTIME_PIONT_Y); /*疲劳驾驶时间小数点,中间侧*/
        GUI_Translate_Display((uint16_t)Set_Img_10_G_Word0, MENU_1_1_TIREDTIME_uint_X[1], MENU_1_1_TIREDTIME_uint_Y); /*疲劳驾驶时间小数点,中间侧*/

        /*能量回收*/
        if (RE_POWER_F == 0x01u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_06_G_Word0, MENU_1_1_RE_POWER_X[2], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }
        else if (RE_POWER_F == 0x02u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_07_G_Word0, MENU_1_1_RE_POWER_X[2], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_08_G_Word0, MENU_1_1_RE_POWER_X[2], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }

        break;
    case 9U     :
        GUI_Translate_Display((uint16_t)Set_RadioButton_08_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*疲劳驾驶,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_09_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*能量回收,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_10_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*退出,右侧*/

        /*疲劳驾驶显示*/
        GUI_General_Digit_Display( (uint32_t)GUI_NUMBER_TIREDTIME , (uint16_t)Number_12_white_0 , 2u, 1U, MENU_1_1_TIREDTIME_L_X, MENU_1_1_TIREDTIME_Y);/*疲劳驾驶时间显示,白色,左侧*/
        GUI_Translate_Display((uint16_t)Number_12_white_point, MENU_1_1_TIREDTIME_PIONT_X[0], MENU_1_1_TIREDTIME_PIONT_Y); /*疲劳驾驶时间小数点,左侧*/
        GUI_Translate_Display((uint16_t)Set_Img_10_G_Word0, MENU_1_1_TIREDTIME_uint_X[0], MENU_1_1_TIREDTIME_uint_Y); /*疲劳驾驶时间小数点,左侧*/

        /*能量回收*/
        if (RE_POWER_F == 0x01u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_06_W_Word0, MENU_1_1_RE_POWER_X[1], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }
        else if (RE_POWER_F == 0x02u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_07_W_Word0, MENU_1_1_RE_POWER_X[1], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_08_W_Word0, MENU_1_1_RE_POWER_X[1], MENU_1_1_RE_POWER_Y); /*能量回收,右侧*/
        }


        break;
    case 10U    :
        GUI_Translate_Display((uint16_t)Set_RadioButton_09_Word0, MENU_1_1_L[0], MENU_1_1_L[1]); /*能量回收,左侧*/
        GUI_Translate_Display((uint16_t)Set_RadioButtonOK_10_Word0, MENU_1_1_M[0], MENU_1_1_M[1]); /*退出,中间*/
        GUI_Translate_Display((uint16_t)Set_RadioButton_06_Word0, MENU_1_1_R[0], MENU_1_1_R[1]); /*故障查询,右侧*/

        /*能量回收显示*/
        if (RE_POWER_F == 0x01u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_06_G_Word0, MENU_1_1_RE_POWER_X[0], MENU_1_1_RE_POWER_Y); /*能量回收,左侧*/
        }
        else if (RE_POWER_F == 0x02u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_07_G_Word0, MENU_1_1_RE_POWER_X[0], MENU_1_1_RE_POWER_Y); /*能量回收,左侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_08_G_Word0, MENU_1_1_RE_POWER_X[0], MENU_1_1_RE_POWER_Y); /*能量回收,左侧*/
        }

        /*故障显示*/
        if (GUI_NUMBER_WORRINIG > 9u)
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_G_Word0, MENU_1_1_NOW_WORRING_double_X[2], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/
            GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_WORRINIG , (uint16_t)Number_10_grey_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_R_X, MENU_1_1_NOW_WORRING_NUM_Y);/*数字显示,灰色,中间侧*/
        }
        else
        {
            GUI_Translate_Display((uint16_t)Set_Img_13_G_Word0, MENU_1_1_NOW_WORRING_alone_X[2], MENU_1_1_NOW_WORRING_Y); /*声音控制,中间侧*/

            GUI_General_Digit_Display( (uint32_t) GUI_NUMBER_WORRINIG , (uint16_t)Number_10_grey_0 , 2u, 1U, MENU_1_1_NOW_WORRING_NUM_R_X, MENU_1_1_NOW_WORRING_NUM_Y);/*数字显示,灰色,中间侧*/
        }

        break;
    default     :
        /* Intentionally Empty */
        break;
    }

    GUI_General_Display((uint16_t)Set_Menu2_Time_Title_06_Word0);	/*左右调节*/

    GUI_General_Display((uint16_t)Set_Menu2_Theme_Title_05_01_Word0);		/*退出*/
}



void GUI_Animation_Energy_Display(void)
{

    uint16_t GUI_NUM_Animation_Energy = 1u;


    if (GUI_NUM_Animation_Energy > 0u)
    {
        GUI_General_Display((uint16_t)((uint16_t)Animation_Energy_Freed_00 + (uint16_t)GUI_Animation_Energy_POS));

        if (GUI_Animation_Energy_POS < 25u)
        {
            GUI_Animation_Energy_POS = GUI_Animation_Energy_POS + 1u;
        }
        else
        {
            GUI_Animation_Energy_POS = 0u;
        }

    }
    else
    {

        GUI_General_Display((uint16_t)((uint16_t)Animation_Energy_Collect_00 + (uint16_t)GUI_Animation_Energy_POS));

        if (GUI_Animation_Energy_POS < 25u)
        {
            GUI_Animation_Energy_POS = GUI_Animation_Energy_POS + 1u;
        }
        else
        {
            GUI_Animation_Energy_POS = 0u;
        }
    }
    GUI_General_Display((uint16_t)Animation_Energy_G_00 + (uint16_t)GUI_Animation_battery_POS);

    if (GUI_Animation_battery_POS < 5u)
    {
        GUI_Animation_battery_POS = GUI_Animation_battery_POS + 1u;
    }
    else
    {
        GUI_Animation_battery_POS = 0u;
    }

}

void GUI_MENU_DISPLAY_SERIVES(uint8_t POS_1, uint8_t POS_2)
{
    if (POS_1 == 0x01u)
    {
        GUI_MENU_1_1_Display(1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u);
    }
    else if (POS_1 == 0x02u)
    {
        switch (POS_2)
        {
        case 1U    	:
            GUI_THEME_Set_Display(1u);
            break;
        case 2U    	:
            GUI_THEME_Set_Display(1u);
            break;
        case 3U    	:
            GUI_LANGUAGE_Set_Display(1u);
            break;
        case 4U    	:
            GUI_DRIVE_INFO_Set_Display(1u, 1u, 1u, 1u);
            break;
        case 5U    	:
            GUI_OVER_SPEED_Set_Display(50u);
            break;
        case 6U    	:
            GUI_Fatigue_Driving_Set_Display(15u);
            break;
        case 7U    	:
            GUI_Energy_Recovery_Display(1u);
            break;
        case 8U    	:
            GUI_Energy_Recovery_Display(1u);
            break;
        case 9U    	:
            GUI_VOIDE_SETING_Display(1u, 1u);
            break;
        case 10U    	:
            GUI_FAULT_LIST_Display(1u, 7u, 7u);
            break;


        default         :
            /* Intentionally Empty */
            break;
        }
    }
    else
    {
        /* Intentionally Empty */
    }
}
