#include "Data_Time.h"
#include "CAN_Communication_Matrix.h"

uint8_t  Time_calibration ;
uint8_t  IOTimeCalEnable ;



/******************************************************************************
函数名：Data_Time_FactiryReset
功  能：初始化時間狀態
参  数：无
返回值：无
*******************************************************************************
注  意：KL15On的時候調用
******************************************************************************/

void Data_Time_KL15_Init(void)
{
    Time_calibration = 0u;
    IOTimeCalEnable = 0u;
}

void Data_Time_WakeUp_Init(void)
{
    Time_calibration = 0u;
    IOTimeCalEnable = 0u;
}


void Received_2AF_Calibration(void)
{
    if (Time_calibration <= 3u)/*86104-12*/
    {
        Time_calibration++;
    }
}

/******************************************************************************
Data_Time_Calibration_Data
功  能：时间校准
参  数：无
返回值：无
*******************************************************************************
注  意：该服务函数唤醒后对时
******************************************************************************/
void Data_Time_Calibration(void)
{

    uint16_t   Year_FLAG = 0u;
    uint8_t   Month_FLAG = 0u;
    uint8_t   Date_FLAG = 0u;
    uint8_t   Hour_FLAG = 0u;
    uint8_t   Minute_FLAG = 0u;
    uint8_t   Second_FLAG = 0u;
    uint8_t   Sync_FLAG = 0u;

    Year_FLAG = (uint16_t)(Get_ID_3BB_Sig_IHU_GPS_Time_year());
    Month_FLAG = (uint8_t)Get_ID_3BB_Sig_IHU_GPS_Time_Month();
    Date_FLAG = (uint8_t)Get_ID_3BB_Sig_IHU_GPS_Time_Day();
    Hour_FLAG = (uint8_t)Get_ID_3BB_Sig_IHU_GPS_Time_Hour();
    Minute_FLAG = (uint8_t)Get_ID_3BB_Sig_IHU_GPS_Time_Minute();
    Second_FLAG = (uint8_t)Get_ID_3BB_Sig_IHU_GPS_Time_Second();

    Sync_FLAG = Get_ID_3BB_Sig_IHU_GPS_TimeSwSts();
    if ((IOTimeCalEnable == 0u) && (Sync_FLAG == 1u)) /*時間未同步過*/   /*86104-9*/ /*86104-12*/
    {
        /*86104*/   /*86104-12*/
        if ((Year_FLAG != 0x03Fu) && (Month_FLAG >= 1u) && (Month_FLAG <= 12u) && \
                (Date_FLAG >= 1u) && (Date_FLAG <= 31u) && (Hour_FLAG < 24u) && \
                (Minute_FLAG < 60u) && (Second_FLAG < 60u))
        {
            Year_FLAG = Year_FLAG + 2000u;
            /*時間同步完成，記錄同步狀態 IOTimeCalEnable=1代表已經同步過*/
            IOTimeCalEnable = 1u;
            /*時間顯示是完整的所以同步時間*/

            RTE_RTC_Set_Hour  (  Hour_FLAG  );
            RTE_RTC_Set_Minute(  Minute_FLAG   );
            RTE_RTC_Set_Date  (  Date_FLAG   );
            RTE_RTC_Set_Month (  Month_FLAG  );
            RTE_RTC_Set_Year  (  Year_FLAG );
            RTE_RTC_Confirm_Overwrite();
        }
    }
}

/******************************************************************************
函数名：Get_RTC_Time_calibration
功  能: 获得时间校准状态 1为已经校准 0为未校准
******************************************************************************/
uint8_t Get_RTC_Time_calibration(void)
{
    return IOTimeCalEnable;
}


