#include "Maintenance.h"

/*** 保养里程 ***/
uint32_t DataServiceInterval = 0xFFFFu;
uint32_t NVM_USER_SETTINGS_SERVICE = 5000;                     /***********临时接口*********/
uint32_t MainTimer = 0u;                                       /*****100ms累加器****/
#define Maintenance_def                    5000u               /****默认保养公里********/
MaintenanceStruct MaintenanceTime;


void Data_Maintenance_Rolling_Counter(void)
{
    MainTimer++;
}
/******************************************************************************
函数名：Data_ODO_Service_KL30_Init
功  能: 首次上电初始化
参  数: 无
返回值：无
******************************************************************************/
void Data_Maintenance_Service_KL30_Init(void)
{
    /*保养里程*/
    DataServiceInterval = 0xFFFFu;
    /*保养时间*/
    uint32_t MainTimer = 0u;
}

/******************************************************************************
函数名：Data_Service_Interval_Processing
功  能: 剩余保养里程处理
参  数: 无
返回值：无
******************************************************************************/
uint32_t Get_Data_Maintenace_Interval_Processing(void)
{
    uint32_t MileageDev;
    uint16_t Servicekm;
    uint32_t ODO_Data;
    ODO_Data = Data_ODO_Read();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (ODO_Data >= NVM_USER_SETTINGS_SERVICE)
        {
            Servicekm = 0u;
        }
        else
        {
            MileageDev = NVM_USER_SETTINGS_SERVICE - ODO_Data;
            Servicekm  = ( uint32_t ) MileageDev;
            Servicekm  +=9;
            Servicekm /= 10;
        }
     if(Servicekm>=10000)
              Servicekm=10000;
        DataServiceInterval = Servicekm;
    }
    return DataServiceInterval;

}

/******************************************************************************
函数名：Data_Service_Interval_Reset
功  能: 重置保养里程
参  数: 无
返回值：无
******************************************************************************/
void Data_Maintenance_Interval_Reset(void)
{
    uint32_t ODO_Data;
    ODO_Data = Data_ODO_Read();
    NVM_USER_SETTINGS_SERVICE = ODO_Data + Maintenance_def;
    /*NVM_Data_Update(NVM_USER_SETTINGS);*/
    DataServiceInterval = Maintenance_def;
}

/******************************************************************************
函数名：Data_Service_Time_Procesing
功  能: 剩余保养天数处理
参  数: 无
返回值：无
******************************************************************************/
uint16_t  Get_Calc_Service_Time_Procesing(void)/*ON*/
{
    uint16_t   Maintenance_Day ;
    uint16_t   MainDay;
    uint32_t   second;

    Maintenance_Day = 0u;
    MainDay = 0u;
    second = 0u;

    second = MaintenanceTime.u32second - MaintenanceTime.u32Lastsecond;

    Maintenance_Day = (uint16_t)(MainTimer / 864000u);
    Maintenance_Day = Maintenance_Day + (uint16_t)(second / 86400u);
    if (Maintenance_Set_Days <= Maintenance_Day)
    {
        MainDay = 0u;
    }
    else
    {
        MainDay = Maintenance_Set_Days - Maintenance_Day;
    }
    return MainDay;
}
/******************************************************************************
函数名：ON到OFF存储当次的秒数
功  能: 唤醒获取上次的RTC秒数
参  数: 无
返回值：无
******************************************************************************/
void Maintenance_KL15_OFF_Init(void)
{
    MaintenanceTime.u32Lastsecond = Get_RTC_SECOND();
}
/******************************************************************************
函数名：Main_WakeUp_Init
功  能: 唤醒获取上次的RTC秒数
参  数: 无
返回值：无
******************************************************************************/
void Maintenance_WakeUp_Init(void)
{
    MaintenanceTime.u32second = Get_RTC_SECOND();
}

/******************************************************************************
函数名：Data_Service_Time_Reset
功  能: 重置保养时间
参  数: 无
返回值：无
******************************************************************************/
void Data_Service_Time_Reset(void)
{
    /*NVM_Data_Update(NVM_USER_SETTINGS);*/
    MainTimer = 0u;
}
