#include "SEG_DISPLAY.h"
#include "Seg_Ref.h"
#include "Data_SOC.h"
#include "Data_PWR.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"

#define SEG_LCD_LIGHT   7
#define SEG_LCD_GRAY    4
#define SEG_LCD_OFF     0

#define SOC_SEG01(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_83, x); //与真值表差一位,83对应84
#define SOC_SEG02(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_85, x);
#define SOC_SEG03(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_86, x);
#define SOC_SEG04(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_87, x);
#define SOC_SEG05(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_88, x);
#define SOC_SEG06(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_90, x);
#define SOC_SEG07(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_91, x);
#define SOC_SEG08(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_92, x);
#define SOC_SEG09(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_93, x);
#define SOC_SEG10(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_95, x);

#define SOC_ARC(x)   SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_96, x);
#define SOC_NUM0(x)  SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_84, x);
#define SOC_NUM100(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_94, x);
#define SOC_SYMBOL(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_89, x);

#define PWR_SEG01(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_95, x);
#define PWR_SEG02(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_93, x);
#define PWR_SEG03(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_92, x);
#define PWR_SEG04(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_91, x);
#define PWR_SEG05(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_90, x);
#define PWR_SEG06(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_88, x);
#define PWR_SEG07(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_87, x);
#define PWR_SEG08(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_86, x);
#define PWR_SEG09(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_85, x);
#define PWR_SEG10(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_83, x);

#define PWR_ARC(x)   SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_96, x);
#define PWR_NUM0(x)  SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_94, x);
#define PWR_NUM100(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_84, x);
#define PWR_SYMBOL(x) SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_89, x);

void Seg_SOC_Display(uint8_t Value)
{
    uint8_t tmp = 0u;

    SOC_SEG01(SEG_LCD_OFF)
    SOC_SEG02(SEG_LCD_OFF)
    SOC_SEG03(SEG_LCD_OFF)
    SOC_SEG04(SEG_LCD_OFF)
    SOC_SEG05(SEG_LCD_OFF)
    SOC_SEG06(SEG_LCD_OFF)
    SOC_SEG07(SEG_LCD_OFF)
    SOC_SEG08(SEG_LCD_OFF)
    SOC_SEG09(SEG_LCD_OFF)
    SOC_SEG10(SEG_LCD_OFF)

    tmp = Value / 10u;
    
    if (Value % 10u)
    {
        tmp++;
    }

    if (tmp > 10u)
    {
        tmp = 10u;
    }

    switch (tmp)
    {
        case 10u:
            SOC_SEG10(SEG_LCD_LIGHT)
        case  9u:
            SOC_SEG09(SEG_LCD_LIGHT)
        case  8u:
            SOC_SEG08(SEG_LCD_LIGHT)
        case  7u:
            SOC_SEG07(SEG_LCD_LIGHT)
        case  6u:
            SOC_SEG06(SEG_LCD_LIGHT)
        case  5u:
            SOC_SEG05(SEG_LCD_LIGHT)
        case  4u:
            SOC_SEG04(SEG_LCD_LIGHT)
        case  3u:
            SOC_SEG03(SEG_LCD_LIGHT)
        case  2u:
            SOC_SEG02(SEG_LCD_LIGHT)
        case  1u:
            SOC_SEG01(SEG_LCD_LIGHT)
        default:
            break;
    }
    
    tmp = SEG_LCD_OFF;
    if ((SYS_OPR_STAT_IGN_ON) && (SYS_OPR_STAT_RUN))
    {
        tmp = SEG_LCD_LIGHT;
    }
    
    SOC_ARC(tmp)
    SOC_NUM0(tmp)
    SOC_NUM100(tmp)
    SOC_SYMBOL(tmp)
}

void Seg_PWR_Display(uint8_t Value)
{
    uint8_t tmp = 0u;

    PWR_SEG01(SEG_LCD_OFF)
    PWR_SEG02(SEG_LCD_OFF)
    PWR_SEG03(SEG_LCD_OFF)
    PWR_SEG04(SEG_LCD_OFF)
    PWR_SEG05(SEG_LCD_OFF)
    PWR_SEG06(SEG_LCD_OFF)
    PWR_SEG07(SEG_LCD_OFF)
    PWR_SEG08(SEG_LCD_OFF)
    PWR_SEG09(SEG_LCD_OFF)
    PWR_SEG10(SEG_LCD_OFF)
    
    tmp = Value / 10u;   
    
    if (Value % 10u)
    {
        tmp++;
    }
    
    if (tmp > 10u)
    {
        tmp = 10u;
    }

    switch (tmp)
    {
        case 10:
            PWR_SEG10(SEG_LCD_LIGHT)
        case  9:
            PWR_SEG09(SEG_LCD_LIGHT)
        case  8:
            PWR_SEG08(SEG_LCD_LIGHT)
        case  7:
            PWR_SEG07(SEG_LCD_LIGHT)
        case  6:
            PWR_SEG06(SEG_LCD_LIGHT)
        case  5:
            PWR_SEG05(SEG_LCD_LIGHT)
        case  4:
            PWR_SEG04(SEG_LCD_LIGHT)
        case  3:
            PWR_SEG03(SEG_LCD_LIGHT)
        case  2:
            PWR_SEG02(SEG_LCD_LIGHT)
        case  1:
            PWR_SEG01(SEG_LCD_LIGHT)
        default:
            break;
    }
    
    tmp = SEG_LCD_OFF;
    if ((SYS_OPR_STAT_IGN_ON) && (SYS_OPR_STAT_RUN))
    {
        tmp = SEG_LCD_LIGHT;
    }
    
    PWR_ARC(tmp)
    PWR_NUM0(tmp)
    PWR_NUM100(tmp)
    PWR_SYMBOL(tmp)
}

void Seg_Display_Service(void) //50mS函数
{
    if (SYS_OPR_STAT_IGN_ON && SYS_OPR_STAT_RUN)
    {
        uint16_t tmp = SOC_Get_CurVal();
        
        Seg_SOC_Display(tmp / 10);

        if (Get_ID_18F14AF3_Sig_BMS_BtyFltFlg1_4() && SelfTest_Status_Get())
        {
            BAT_W_MCU = 0u;
            BAT_R_MCU = 1u;
        }
        else
        {
            BAT_W_MCU = 1u;
            BAT_R_MCU = 0u;
        }

        tmp = DrvMtrPwr_Get_CurDis();
        Seg_PWR_Display(tmp / 10);

        if ((tmp > 800u) && (DrvMtrPwr_Get_DISP() > 800u) && SelfTest_Status_Get())
        {
            KW_W_MCU = 0u;
            KW_R_MCU = 1u;
        }
        else
        {
            KW_W_MCU = 1u;
            KW_R_MCU = 0u;
        }
    }    
    else
    {
        Seg_SOC_Display(0);
        Seg_PWR_Display(0);
        
        BAT_W_MCU = 0u;
        BAT_R_MCU = 0u;
        KW_W_MCU = 0u;
        KW_R_MCU = 0u;
    }

    Seg_Buffer_Commit();
}
