#ifndef _TELLTALES_H_
#define _TELLTALES_H_

#include "TYW_stdint.h"
#include "string.h"
#include "RTE_BASE_TYPE.h"

typedef enum
{
    em_LED_Position,         /*3示宽灯  位置灯*/
    em_LED_LoBeam,           /*4近光*/
    em_LED_HiBeam,           /*5远光*/
    em_LED_FFog,             /*6前雾灯*/
    em_LED_RFog,             /*7后雾灯*/
    em_LED_Defrost,          /*8除霜*/
    em_LED_Parking,          /*9驻车制动*/
    em_LED_BrkFlt,           /*10制动故障*/
    em_LED_BrkPad,           /*11刹车片*/
    em_LED_ABS,              /*12ABS*/
    em_LED_Door,             /*13门开*/
    em_LED_SeatBelt,         /*14安全带*/
    em_LED_DrvBatChgR,       /*15动力蓄电池未充电*/
    em_LED_DrvBatChgG,       /*16动力蓄电池充电完成*/
    em_LED_PwrBatCut,        /*17动力蓄电池切断*/
    em_LED_CarLifting,       /*18车厢举升指示*/
    em_LED_CabOverturn,      /*19驾驶室翻转指示*/
    em_LED_DayLight,         /*20日间行车灯*/
    em_LED_TPMS,             /*21胎压报警指示*/
    em_LED_DrvFatigue,       /*22驾驶员疲劳监测报警*/
    em_LED_BackupLamp,       /*23倒车灯状态*/
    em_LED_PTO1,             /*24停车取力*/
    em_LED_PTO2,             /*25行车取力*/
    em_LED_Cruise,           /*26巡航状态指示灯*/
    em_LED_VcmPmp,           /*27真空泵故障*/
    em_LED_PwrBatFlt,        /*28动力蓄电池故障*/
    em_LED_PwrBatHiTpt,      /*29动力蓄电池过热*/
    em_LED_LoSOC,            /*30电池剩余容量低*/
    em_LED_SysFlt,           /*31系统故障*/
    em_LED_IslFlt,           /*32绝缘故障*/
    em_LED_Ready,            /*33READY*/
    em_LED_Stop,             /*34紧急停车故障报警*/
    em_LED_OverSpd,          /*35超速*/
    em_LED_MtrFlt,           /*36电机相关故障*/
    em_LED_MtrMCUHiTpt,      /*37电机及控制器*/
    em_LED_TCUFlt,           /*38变速箱*/
    em_LED_EPSFlt,           /*39EPS*/
    em_LED_EngyRec,          /*40能量回收*/
    em_LED_ECO,              /*41ECO*/
    em_LED_PwrLmt,           /*42跛行*/
    em_LED_Battery,          /*43蓄电池*/
    em_LED_Charge,           /*44充电连接*/
    em_LED_LvlLow,           /*45水位低报警*/
    em_LED_SportMd,          /*46SPORT MODE*/

    LED_Max,
} LED_Idx_t;

typedef uint8_t(*LED_Judgment)(void);
typedef void(*LED_Execution)(uint8_t led_status);

typedef struct
{
    LED_Idx_t    LED_Index;
    SelfCheck_t  isSelfCheck;
    ExtCheck_t   isExCheck;
    WorkStatus_t WorkSts;

    uint32_t CheckStart;
    uint32_t CheckEnd;

    LED_Judgment LED_Judgment_Cbk;
    LED_Execution LED_Execution_Cbk;
} LED_Attribute_st;

typedef struct
{
    PowerStatus_t IG_Status;
    Checktatus_t LED_CheckFinish;
    uint32_t IG_ON_Timer;
    uint32_t IG_OFF_Timer;
} ExternalPara_st;

typedef struct
{
    uint8_t  LastLeft;
    uint8_t  LastRight;
    uint8_t  Delay;
} TelltaleLRCtrlStruct;

extern const LED_Attribute_st LED_Attribute[LED_Max];

void Telltales_Wakeup_Init(void);
void Telltales_KL30_Init(void);
void Telltales_KL15_Init(void);
void Telltales_SetPara(ExternalPara_st *Para);
void Telltales_Management(void);
void Telltales_IG_ON_Work(void);
void Telltales_IGOFF_Work(void);

typedef struct
{
    uint32_t IG_ON_Timer;
    uint32_t IG_OFF_Timer;
    PowerStatus_t IG_Status;
    Checktatus_t LED_CheckFinish;
    WorkPrease_t LED_WorkPhase;
    uint8_t u8LED_Status[LED_Max];
    LED_Judgment LED_Judgment_Cbk;
    LED_Execution LED_Execution_Cbk;
} LED_Operation_st;

extern LED_Operation_st LED_Operation;

#endif
