
#ifndef RTC_H__
#define RTC_H__
#include "r_typedefs.h"
#define RTC_MODE_MAIN 0U
#define RTC_MODE_SUB 1U

#define RTC_MODE_SELECT RTC_MODE_MAIN

typedef struct
{
	uint8_t u8RTCYear;		 /*00~~99 in Dec*/
	uint8_t u8RTCMonth;		 /*01~~12 in Dec*/
	uint8_t u8RTCDayOfMonth; /*01~~31 in Dec*/
	uint8_t u8RTCHour;		 /*fix 24Hour Format 00~~23 in  Dec*/
	uint8_t u8RTCMinute;	 /*0~~59 in Dec*/
	uint8_t u8RTCSecond;	 /*0~~59 in Dec*/
} RTC_Information_st_t;

extern uint8_t RTC_Dec_To_BCD(uint8_t u8RTCDec);
extern volatile uint8_t g_RTCLeapYear; /*1:LeapYear , 0:Not a leap year*/
extern RTC_Information_st_t g_stRTCInformation;

/* RTC exported time register */
#define RTC_YEAR g_stRTCInformation.u8RTCYear
#define RTC_MONTH g_stRTCInformation.u8RTCMonth
#define RTC_DATE g_stRTCInformation.u8RTCDayOfMonth
#define RTC_HOUR g_stRTCInformation.u8RTCHour
#define RTC_MINUTE g_stRTCInformation.u8RTCMinute
#define RTC_SECOND g_stRTCInformation.u8RTCSecond
#define RTC_LEAP_YEAR g_RTCLeapYear

extern void RTC_Pre_Init(void);
extern void RTC_Set_Time(uint16_t day, uint8_t hour, uint8_t minute, uint8_t second);
extern void RTC_Get_Time(void);
extern void RTC_Backup_Time(void);
extern void Rtc_Restore_Time(void);
extern void RTC_Timing_Service(void);

#endif
