
#ifndef _POPUP_LIST_H_
#define _POPUP_LIST_H_

#include <stddef.h>
#include "Popup_Message_List.h"
#include "Sound_List.h"

/******************************************************************************
报警名称列表

注意：1. 报警名称所指代的序号应与该报警位于报警属性表中的序号一一对应
      2. 标注有的"[报警类]"的为报警类名称,不可直接用于报警的申请与删除,但可用于
         该类报警的查询
******************************************************************************/

enum PopupName
{
    POPUP_VCU_SYS1 = 0x00u                ,       /*00 系统警报1级*/
    POPUP_VCU_SYS2                        ,       /*01 系统警报2级*/
    POPUP_VCU_SYS3                        ,       /*02 系统警报3级*/

    POPUP_VCU_EPS1                        ,       /*03 转向系统警报1级*/
    POPUP_VCU_EPS2                        ,       /*04 转向系统警报2级*/
    POPUP_VCU_EPS3                        ,       /*05 转向系统警报3级*/
    
    POPUP_VCU_ACM1                        ,       /*06 空压机警报1级*/
    POPUP_VCU_ACM2                        ,       /*07 空压机警报2级*/
    POPUP_VCU_ACM3                        ,       /*08 空压机警报3级*/
    
    POPUP_VCU_DCDC1                       ,       /*09 DC/DC警报1级*/
    POPUP_VCU_DCDC2                       ,       /*10 DC/DC警报2级*/
    POPUP_VCU_DCDC3                       ,       /*11 DC/DC警报3级*/
    
    POPUP_VCU_PDU1                        ,       /*12 高压配电警报1级*/
    POPUP_VCU_PDU2                        ,       /*13 高压配电警报2级*/
    POPUP_VCU_PDU3                        ,       /*14 高压配电警报3级*/
    
    POPUP_VCU_MCU1                        ,       /*15 电机控制器警报1级*/
    POPUP_VCU_MCU2                        ,       /*16 电机控制器警报2级*/
    POPUP_VCU_MCU3                        ,       /*17 电机控制器警报3级*/
    
    POPUP_BMS_BMS1                        ,       /*18 动力电池警报1级*/
    POPUP_BMS_BMS2                        ,       /*19 动力电池警报2级*/
    POPUP_BMS_BMS3                        ,       /*20 动力电池警报3级*/
   
    POPUP_COM_Maintenance                 ,       /*21 请及时保养车辆*/
    POPUP_COM_OvrECUSpd                   ,       /*22 超过经济车速*/
    POPUP_COM_OvrSpd                      ,       /*23 超速报警*/
    POPUP_COM_Door                        ,       /*24 车门未关闭*/
    POPUP_COM_Seatbelt                    ,       /*25 请系好安全带*/
    POPUP_COM_ParkingOn                   ,       /*26 手刹未释放*/
    POPUP_COM_ParkingOff                  ,       /*27 请拉手刹*/
    POPUP_COM_LeaveSeat                   ,       /*28 离座报警*/
    POPUP_COM_LvlLow                      ,       /*29 水位低报警*/
    POPUP_COM_NoJurisdictionVhl           ,       /*30 无权限车辆*/

    POPUP_ACCM_CmprErrCode0               ,       /*31 过流*/
    POPUP_ACCM_CmprErrCode1               ,       /*32 运行过压*/
    POPUP_ACCM_CmprErrCode2               ,       /*33 运行欠压*/
    POPUP_ACCM_CmprErrCode3               ,       /*34 过流降频*/
    POPUP_ACCM_CmprErrCode4               ,       /*35 过温故障*/
    
    POPUP_MAX
};

#define   POPUP_NONE                        0xFFFF  /*无报警*/

/******************************************************************************
报警类型定义
******************************************************************************/
#define   POPUP_TYPE_FATAL                  0x00  /*严重报警信息*/
#define   POPUP_TYPE_HINT                   0x01  /*提示信息*/
#define   POPUP_TYPE_WARNING                0x02  /*报警信息*/
#define   POPUP_TYPE_EXCEPTION              0x04  /*特殊信息 */

/******************************************************************************
显示/声音模式
******************************************************************************/
#define   POPUP_MODE_MULTI                  0x00  /*可多次触发*/
#define   POPUP_MODE_SINGLE                 0x01  /*只触发一次*/

/******************************************************************************
+15 On / Off
******************************************************************************/
#define   POPUP_IGN_OFF                     0x00
#define   POPUP_IGN_ON                      0x01
#define   POPUP_IGN_ON_OFF                  0x02

/******************************************************************************
报警属性结构
******************************************************************************/
typedef struct
{
    uint8_t        Type;
    uint8_t        Priority;
    uint8_t        SubPriority;
    uint8_t        IGNStatus;
    uint8_t        Class;
    const uint8_t  *pMbrList;
    uint8_t        MbrCnt;
    uint8_t        Message;
    uint8_t        DispMode;
    uint8_t        Snd;
    uint8_t        SndMode;
} PopupAttributeStruct;

/******************************************************************************
报警属性表
******************************************************************************/
static const PopupAttributeStruct PopupAttributeTable[] =
{
    /*==========================================================================================================================================================================================================
               报警名称          |      报警类型      |优先级|副优先级| +15 On/Off  |       报警类         |成员列表|成员数量|         文字消息         |     显示模式     |     报警音        |   声音提示模式
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    {/*00 POPUP_VCU_SYS1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_SYS1,        NULL,    1u,   POPUP_MSG_VCU_SYS1,        POPUP_MODE_MULTI,  SND_VCU_SYS1,       POPUP_MODE_MULTI,},
    {/*01 POPUP_VCU_SYS2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_SYS2,        NULL,    1u,   POPUP_MSG_VCU_SYS2,        POPUP_MODE_MULTI,  SND_VCU_SYS2,       POPUP_MODE_MULTI,},
    {/*02 POPUP_VCU_SYS3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_SYS3,        NULL,    1u,   POPUP_MSG_VCU_SYS3,        POPUP_MODE_MULTI,  SND_VCU_SYS3,       POPUP_MODE_MULTI,},

    {/*03 POPUP_VCU_EPS1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_EPS1,        NULL,    1u,   POPUP_MSG_VCU_EPS1,        POPUP_MODE_MULTI,  SND_VCU_EPS1,       POPUP_MODE_MULTI,},
    {/*04 POPUP_VCU_EPS2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_EPS2,        NULL,    1u,   POPUP_MSG_VCU_EPS2,        POPUP_MODE_MULTI,  SND_VCU_EPS2,       POPUP_MODE_MULTI,},
    {/*05 POPUP_VCU_EPS3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_EPS3,        NULL,    1u,   POPUP_MSG_VCU_EPS3,        POPUP_MODE_MULTI,  SND_VCU_EPS3,       POPUP_MODE_MULTI,},

    {/*06 POPUP_VCU_ACM1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_ACM1,        NULL,    1u,   POPUP_MSG_VCU_ACM1,        POPUP_MODE_MULTI,  SND_VCU_ACM1,       POPUP_MODE_MULTI,},
    {/*07 POPUP_VCU_ACM2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_ACM2,        NULL,    1u,   POPUP_MSG_VCU_ACM2,        POPUP_MODE_MULTI,  SND_VCU_ACM2,       POPUP_MODE_MULTI,},
    {/*08 POPUP_VCU_ACM3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_ACM3,        NULL,    1u,   POPUP_MSG_VCU_ACM3,        POPUP_MODE_MULTI,  SND_VCU_ACM3,       POPUP_MODE_MULTI,},

    {/*09 POPUP_VCU_DCDC1      */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_DCDC1,       NULL,    1u,   POPUP_MSG_VCU_DCDC1,       POPUP_MODE_MULTI,  SND_VCU_DCDC1,      POPUP_MODE_MULTI,},
    {/*10 POPUP_VCU_DCDC2      */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_DCDC2,       NULL,    1u,   POPUP_MSG_VCU_DCDC2,       POPUP_MODE_MULTI,  SND_VCU_DCDC2,      POPUP_MODE_MULTI,},
    {/*11 POPUP_VCU_DCDC3      */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_DCDC3,       NULL,    1u,   POPUP_MSG_VCU_DCDC3,       POPUP_MODE_MULTI,  SND_VCU_DCDC3,      POPUP_MODE_MULTI,},    
    
    {/*12 POPUP_VCU_PDU1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_PDU1,        NULL,    1u,   POPUP_MSG_VCU_PDU1,        POPUP_MODE_MULTI,  SND_VCU_PDU1,       POPUP_MODE_MULTI,},
    {/*13 POPUP_VCU_PDU2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_PDU2,        NULL,    1u,   POPUP_MSG_VCU_PDU2,        POPUP_MODE_MULTI,  SND_VCU_PDU2,       POPUP_MODE_MULTI,},
    {/*14 POPUP_VCU_PDU3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_PDU3,        NULL,    1u,   POPUP_MSG_VCU_PDU3,        POPUP_MODE_MULTI,  SND_VCU_PDU3,       POPUP_MODE_MULTI,},

    {/*15 POPUP_VCU_MCU1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_MCU1,        NULL,    1u,   POPUP_MSG_VCU_MCU1,        POPUP_MODE_MULTI,  SND_VCU_MCU1,       POPUP_MODE_MULTI,},
    {/*16 POPUP_VCU_MCU2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_MCU2,        NULL,    1u,   POPUP_MSG_VCU_MCU2,        POPUP_MODE_MULTI,  SND_VCU_MCU2,       POPUP_MODE_MULTI,},
    {/*17 POPUP_VCU_MCU3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_VCU_MCU3,        NULL,    1u,   POPUP_MSG_VCU_MCU3,        POPUP_MODE_MULTI,  SND_VCU_MCU3,       POPUP_MODE_MULTI,},

    {/*18 POPUP_BMS_BMS1       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_BMS_BMS1,        NULL,    1u,   POPUP_MSG_BMS_BMS1,        POPUP_MODE_MULTI,  SND_BMS_BMS1,       POPUP_MODE_MULTI,},
    {/*19 POPUP_BMS_BMS2       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_BMS_BMS2,        NULL,    1u,   POPUP_MSG_BMS_BMS2,        POPUP_MODE_MULTI,  SND_BMS_BMS2,       POPUP_MODE_MULTI,},
    {/*20 POPUP_BMS_BMS3       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_BMS_BMS3,        NULL,    1u,   POPUP_MSG_BMS_BMS3,        POPUP_MODE_MULTI,  SND_BMS_BMS3,       POPUP_MODE_MULTI,},

    {/*21 POPUP_COM_Maintenance*/ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_Maintenance, NULL,    1u,   POPUP_MSG_COM_Maintenance, POPUP_MODE_MULTI,  SND_Maintenance,    POPUP_MODE_MULTI,},
    {/*22 POPUP_COM_OvrECUSpd  */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_OvrECUSpd,   NULL,    1u,   POPUP_MSG_COM_OvrECUSpd,   POPUP_MODE_MULTI,  SND_NONE/*OvrECUSpd*/, POPUP_MODE_SINGLE,},
    {/*23 POPUP_COM_OvrSpd     */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_OvrSpd,      NULL,    1u,   POPUP_MSG_COM_OvrSpd,      POPUP_MODE_MULTI,  SND_OvrSpd,         POPUP_MODE_SINGLE,},
    {/*24 POPUP_COM_Door       */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_Door,        NULL,    1u,   POPUP_MSG_COM_Door,        POPUP_MODE_MULTI,  SND_Door,           POPUP_MODE_MULTI,},
    {/*25 POPUP_COM_Seatbelt   */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_Seatbelt,    NULL,    1u,   POPUP_MSG_COM_Seatbelt,    POPUP_MODE_MULTI,  SND_Seatbelt,       POPUP_MODE_MULTI,},
    {/*26 POPUP_COM_ParkingOn  */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_ParkingOn,   NULL,    1u,   POPUP_MSG_COM_ParkingOn,   POPUP_MODE_MULTI,  SND_ParkingOn,      POPUP_MODE_SINGLE,},
    {/*27 POPUP_COM_ParkingOff */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON_OFF, POPUP_COM_ParkingOff,  NULL,    1u,   POPUP_MSG_COM_ParkingOff,  POPUP_MODE_MULTI,  SND_ParkingOff,     POPUP_MODE_MULTI,},
    {/*28 POPUP_COM_LeaveSeat  */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_LeaveSeat,   NULL,    1u,   POPUP_MSG_COM_LeaveSeat,   POPUP_MODE_MULTI,  SND_LeaveSeat,      POPUP_MODE_MULTI,},
    {/*29 POPUP_COM_LvlLow     */ POPUP_TYPE_WARNING,  0u,    0u,   POPUP_IGN_ON,     POPUP_COM_LvlLow,      NULL,    1u,   POPUP_MSG_COM_LvlLow,      POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    {/*30 POPUP_COM_NoJurisdictionVhl*/ POPUP_TYPE_WARNING, 0u, 0u, POPUP_IGN_ON, POPUP_COM_NoJurisdictionVhl, NULL, 1u, POPUP_MSG_COM_NoJurisdictionVhl, POPUP_MODE_MULTI, SND_NONE,         POPUP_MODE_SINGLE,},
    {/*31 POPUP_ACCM_CmprErrCode0 */ POPUP_TYPE_WARNING, 0u,  0u,   POPUP_IGN_ON,   POPUP_ACCM_CmprErrCode0, NULL,    1u, POPUP_MSG_ACCM_CmprErrCode0, POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    {/*32 POPUP_ACCM_CmprErrCode1 */ POPUP_TYPE_WARNING, 0u,  0u,   POPUP_IGN_ON,   POPUP_ACCM_CmprErrCode1, NULL,    1u, POPUP_MSG_ACCM_CmprErrCode1, POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    {/*33 POPUP_ACCM_CmprErrCode2 */ POPUP_TYPE_WARNING, 0u,  0u,   POPUP_IGN_ON,   POPUP_ACCM_CmprErrCode2, NULL,    1u, POPUP_MSG_ACCM_CmprErrCode2, POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    {/*34 POPUP_ACCM_CmprErrCode3 */ POPUP_TYPE_WARNING, 0u,  0u,   POPUP_IGN_ON,   POPUP_ACCM_CmprErrCode3, NULL,    1u, POPUP_MSG_ACCM_CmprErrCode3, POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    {/*35 POPUP_ACCM_CmprErrCode4 */ POPUP_TYPE_WARNING, 0u,  0u,   POPUP_IGN_ON,   POPUP_ACCM_CmprErrCode4, NULL,    1u, POPUP_MSG_ACCM_CmprErrCode4, POPUP_MODE_MULTI,  SND_NONE,           POPUP_MODE_SINGLE,},
    /*========================================================================================================================================================================================================*/
};

/******************************************************************************
报警属性表统计信息
******************************************************************************/
#define   POPUP_NUMBER_TOTAL                (sizeof(PopupAttributeTable) / sizeof(PopupAttributeStruct))
#define   POPUP_NUMBER_FATAL                0
#define   POPUP_NUMBER_HINT                 0
#define   POPUP_NUMBER_WARNING              36

#define   POPUP_PRIORITY_NUMBER_FATAL       1
#define   POPUP_PRIORITY_NUMBER_HINT        1
#define   POPUP_PRIORITY_NUMBER_WARNING     3

#endif