/*
****************************************************************************
PROJECT : GRAPE_APP
FILE    : $Id: write.c 25427 2013-06-14 07:55:45Z nan.wang $
============================================================================ 
DESCRIPTION
Sample program for demonstration of the D1MX GFX features
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2014
                                  by 
                       Renesas Electronics (Europe) GmbH. 
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing, not for mass production

DISCLAIMER 

LICENSEE has read, understood and accepted the terms and conditions defined in
the license agreement, especially the usage rights. In any case, it is
LICENSEE's responsibility to make sure that any user of the software complies
with the terms and conditions of the signed license agreement.

SAMPLE CODE is not part of the licensed software, as such it must not be used in
mass-production applications. It can only be used for evaluation and
demonstration purposes at customer抯 premises listed in the signed license
agreement.
****************************************************************************
*/

/***********************************************************
  Title: Write Module 
  
  This module contains the write functions for bitmap fonts.
*/


/***********************************************************
  Section: Includes
*/

#include "r_typedefs.h"         /* Renesas basic types, e.g. uint32_t */
#include "r_drw2d_os.h"
#include "r_drw2d_api.h"
#include "img_format.h"
#include "font.h"
#include "write.h"
#include "r_config_d1x.h"
#include "main.h"
#include "han00002ce20.h"
//#include "han5c009f00.h"
//#include "han34009fff.h"
/***********************************************************
  Variable: locCurrentFont

  Font to be used by text operations.
*/

static const Font_t *locCurrentFont;

static r_drw2d_Rect_t rect;
static r_drw2d_Rect_t src_rect;
static r_drw2d_Texture_t tex;

/***********************************************************
  Function: locGetCharRemapping
*/

static int locGetCharRemapping(unsigned char Character)
{
    int c;
    
    /* Character remapping */
    if ((Character >= 32) && (Character < 128))
    {
        /* visible ASCII characters start with 32 (blank)
           not visible chars 0-31 and will be omitted */
        c = (Character - 32);
    }
    else
    {
        switch (Character)
        {
            case 0xB0:
            	  /* special remapping for non ASCII character 'degree' (掳 or 0xB0)
            	     non visible char DEL (127) will be used for 'degree' */
                c = (127 - 32);
                break;
            default:
                /* use blank as default */
                c = 0;
                break;
        }
    }
    return c;
}


/***********************************************************
  Function: locWriteChar

  Write a single character.

  Use the currently selected buffer, font and color to draw
  a character at the given position.

  Parameters:
  Dev        - R_DRW2D device structure
  PosX       - Display X position (not turned)
  PosY       - Display Y position (not turned)
  Character  - ASCII value of the character

  Returns:
  void
*/
static const FontPos_t FontPos[] = {
    { 0, 4}, /*   */
    { 4, 4}, /* ! */
    { 8, 8}, /* " */
    { 16, 9}, /* # */
    { 25, 9}, /* $ */
    { 34, 16}, /* % */
    { 50, 12}, /* & */
    { 62, 4}, /* ' */
    { 66, 5}, /* ( */
    { 71, 5}, /* ) */
    { 76, 6}, /* * */
    { 82, 9}, /* + */
    { 91, 4}, /* , */
    { 95, 5}, /* - */
    { 100, 4}, /* . */
    { 104, 4}, /* / */
    { 108, 9}, /* 0 */
    { 117, 9}, /* 1 */
    { 126, 9}, /* 2 */
    { 135, 9}, /* 3 */
    { 144, 9}, /* 4 */
    { 153, 9}, /* 5 */
    { 162, 9}, /* 6 */
    { 171, 9}, /* 7 */
    { 180, 9}, /* 8 */
    { 189, 9}, /* 9 */
    { 198, 6}, /* : */
    { 204, 6}, /* ; */
    { 210, 9}, /* < */
    { 219, 9}, /* = */
    { 228, 9}, /* > */
    { 237, 10}, /* ? */
    { 247, 16}, /* @ */
    { 263, 11}, /* A */
    { 274, 12}, /* B */
    { 286, 12}, /* C */
    { 298, 12}, /* D */
    { 310, 11}, /* E */
    { 321, 10}, /* F */
    { 331, 12}, /* G */
    { 343, 12}, /* H */
    { 355, 4}, /* I */
    { 359, 9}, /* J */
    { 368, 12}, /* K */
    { 380, 10}, /* L */
    { 390, 13}, /* M */
    { 403, 12}, /* N */
    { 415, 12}, /* O */
    { 427, 11}, /* P */
    { 438, 12}, /* Q */
    { 450, 12}, /* R */
    { 462, 11}, /* S */
    { 473, 10}, /* T */
    { 483, 12}, /* U */
    { 495, 11}, /* V */
    { 506, 15}, /* W */
    { 521, 11}, /* X */
    { 532, 10}, /* Y */
    { 542, 9}, /* Z */
    { 551, 5}, /* [ */
    { 556, 4}, /* \ */
    { 560, 5}, /* ] */
    { 565, 9}, /* ^ */
    { 574, 9}, /* _ */
    { 583, 5}, /* ` */
    { 588, 9}, /* a */
    { 597, 10}, /* b */
    { 607, 9}, /* c */
    { 616, 10}, /* d */
    { 626, 9}, /* e */
    { 635, 6}, /* f */
    { 641, 9}, /* g */
    { 650, 10}, /* h */
    { 660, 4}, /* i */
    { 664, 5}, /* j */
    { 669, 9}, /* k */
    { 678, 4}, /* l */
    { 682, 14}, /* m */
    { 696, 10}, /* n */
    { 706, 10}, /* o */
    { 716, 10}, /* p */
    { 726, 10}, /* q */
    { 736, 6}, /* r */
    { 742, 9}, /* s */
    { 751, 5}, /* t */
    { 756, 10}, /* u */
    { 766, 9}, /* v */
    { 775, 13}, /* w */
    { 788, 9}, /* x */
    { 797, 9}, /* y */
    { 806, 9}, /* z */
    { 815, 6}, /* { */
    { 821, 4}, /* | */
    { 825, 6}, /* } */
    { 831, 10}, /* ~ */
    { 841, 6}, /*  */
};

static void locWriteChar(r_drw2d_Device_t Dev, int PosX, int PosY, unsigned char Character)
{
    int       xsrc;
    int       wsrc;
    char      c;
   
    c = locGetCharRemapping(Character);
    xsrc  = FontPos[c].Offset;
    wsrc  = FontPos[c].Width;

    rect.Pos.X = R_DRW2D_2X(PosX);
    rect.Pos.Y = R_DRW2D_2X(PosY);
    //rect.Size.Height = R_DRW2D_2X(locCurrentFont->Height);
    rect.Size.Height = R_DRW2D_2X(19);
    rect.Size.Width = R_DRW2D_2X(wsrc);

    src_rect.Pos.X = R_DRW2D_2X(xsrc);
    src_rect.Pos.Y = R_DRW2D_2X(0);
    //src_rect.Size.Height = R_DRW2D_2X(locCurrentFont->Height);
	 src_rect.Size.Height = R_DRW2D_2X(19);
    src_rect.Size.Width = R_DRW2D_2X(wsrc);

    R_DRW2D_TextureBlit(Dev, &src_rect, &rect);
}

/***********************************************************
  Section: Global Functions

  Description see: <write.h>
*/

/***********************************************************
  Function: SelectFont
*/
/*
void SelectFont(const Font_t *Font)
{
    locCurrentFont = Font;
}
*/

/***********************************************************
  Function: GetFontHeight
*/

int GetFontHeight(void)
{
    return locCurrentFont->Height;
}



/***********************************************************
  Function: GetCharWidth
*/

int GetCharWidth(char Character)
{
    int c;

    c = locGetCharRemapping(Character);
    if ((c < 0) || (c > 95))
    {
        return 0;
    }
   // return locCurrentFont->Pos[c].Width;
    return FontPos[c].Width;
}


/***********************************************************
  Function: GetTextWidth
*/

int GetTextWidth(char *Text)
{
    int w;

    w = 0;
    while (*Text != 0)
    {
        w += GetCharWidth(*Text);
        Text++;
    }
    return w;
}

/***********************************************************
  Function: GetTextHeight
*/

int GetTextHeight(char *Text)
{
    int h;

    h = 1; /* To include the last line */
    while (*Text != 0)
    {
        if (*Text == '\n')
        {
            h += GetFontHeight();
        }
        Text++;
    }
    return h;
}

void Write_Hanzi(r_drw2d_Device_t Dev,int PosX, int PosY, r_drw2d_Color_t  Color, uint16_t a[],uint16_t count)
{
    int                   startx,starty;
    
    static r_drw2d_Texture_t tex1,tex2;
    int  counti,countj,counta;
    int i,j;
    static r_drw2d_Rect_t rect;
    static r_drw2d_Rect_t src_rect;
    r_drw2d_EffectStage_t effect[2];
    uint32_t xPos, yPos;
    unsigned short xsrc,ysrc,wsrc,hsrc;
    i=0;
    j=0;
    counta =0;
    tex1.Buffer.Data =  0x134F9020u;//0x106b2c00;
    tex1.Buffer.Pitch = 3000;
    tex1.Buffer.PixelFormat = R_DRW2D_PIXELFORMAT_AL8;
    tex1.Buffer.Size.Height = 2200;
    tex1.Buffer.Size.Width = 3000;
    tex1.Flags = R_DRW2D_TEX_BILINEAR;
    tex1.Handle = 0;
  
    R_DRW2D_CtxIdentity(Dev);
    R_DRW2D_CtxTextureIdentity(Dev);

    R_DRW2D_CtxBlendMode(Dev, R_DRW2D_BLENDMODE_SRC_OVER);
    R_DRW2D_CtxFillMode(Dev, R_DRW2D_FILLMODE_TEXTURE);

    effect[0].Name = R_DRW2D_EFFECT_MODULATE;
    effect[0].Args[0].Source = R_DRW2D_EFFECT_SOURCE_TEXTURE_UNIT;
    effect[0].Args[0].Param.Color.Source.TextureUnit = 0;
    effect[0].Args[0].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;
    effect[0].Args[1].Source = R_DRW2D_EFFECT_SOURCE_CONSTANT_COLOR;
    effect[0].Args[1].Param.Color.Source.ConstantColor = Color;
    effect[0].Args[1].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;

    R_DRW2D_CtxEffectsSet(Dev, effect, 1);
    R_DRW2D_CtxTextureSet(Dev, 0, &tex1);
 
    startx = PosX;
    starty = PosY;
	
	PosY= starty;
	PosX= startx; 


   for(int i=0;i<count ;i++)
   {
      	counta = a[i]; 	
	if((counta>0x0020)&&(counta<0x007f))//CJK latin zihao 20,15*15.
	{
	 xsrc =Hansans00002ce20[counta].Xpos;
	 ysrc =Hansans00002ce20[counta].Ypos;
	 wsrc =Hansans00002ce20[counta].Width;
	 hsrc =Hansans00002ce20[counta].Height;

	 rect.Pos.X = R_DRW2D_2X(PosX);
	 rect.Pos.Y = R_DRW2D_2X(PosY+(15-hsrc)/2);
	 rect.Size.Width  = R_DRW2D_2X(wsrc);
	 rect.Size.Height = R_DRW2D_2X(hsrc);

	 src_rect.Pos.X = R_DRW2D_2X(xsrc);
	 src_rect.Pos.Y = R_DRW2D_2X(ysrc);
	 src_rect.Size.Width = R_DRW2D_2X(wsrc);
	 src_rect.Size.Height = R_DRW2D_2X(hsrc);
	 
	 R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

	 PosX += wsrc ;

	}
	else if((counta>0x33ff)&&(counta<0x4db6))//CJK siyuanheiti zihao 20,15*15.
	{
	 counta -=0x2a5f;
	 xsrc =Hansans00002ce20[counta].Xpos;
	 ysrc =Hansans00002ce20[counta].Ypos;
	 wsrc =Hansans00002ce20[counta].Width;
	 hsrc =Hansans00002ce20[counta].Height;
	 rect.Pos.X = R_DRW2D_2X(PosX);
	 rect.Pos.Y = R_DRW2D_2X(PosY+(15-hsrc)/2);
	 rect.Size.Width  = R_DRW2D_2X(wsrc);
	 rect.Size.Height = R_DRW2D_2X(hsrc);

	 src_rect.Pos.X = R_DRW2D_2X(xsrc);
	 src_rect.Pos.Y = R_DRW2D_2X(ysrc);
	 src_rect.Size.Width = R_DRW2D_2X(wsrc);
	 src_rect.Size.Height = R_DRW2D_2X(hsrc);
	 R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

	 PosX += wsrc ;
	 }
	 else if((counta>0x4e00)&&(counta<0xa000))//CJK siyuanheiti zihao 20,15*15.
	 {
	 counta -=0x2aa9;
	 xsrc =Hansans00002ce20[counta].Xpos;
	 ysrc =Hansans00002ce20[counta].Ypos;
	 wsrc =Hansans00002ce20[counta].Width;
	 hsrc =Hansans00002ce20[counta].Height;

	 rect.Pos.X = R_DRW2D_2X(PosX);
	 rect.Pos.Y = R_DRW2D_2X(PosY+(15-hsrc)/2);
	 rect.Size.Width  = R_DRW2D_2X(wsrc);
	 rect.Size.Height = R_DRW2D_2X(hsrc);

	 src_rect.Pos.X = R_DRW2D_2X(xsrc);
	 src_rect.Pos.Y = R_DRW2D_2X(ysrc);
	 src_rect.Size.Width = R_DRW2D_2X(wsrc);
	 src_rect.Size.Height = R_DRW2D_2X(hsrc);
	 
	 R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

	 PosX += wsrc ;
	 }
	 else
	 {
	 counta =0x03f7;
	 xsrc =Hansans00002ce20[counta].Xpos;
	 ysrc =Hansans00002ce20[counta].Ypos;
	 wsrc =Hansans00002ce20[counta].Width;
	 hsrc =Hansans00002ce20[counta].Height;

	 rect.Pos.X = R_DRW2D_2X(PosX);
	 rect.Pos.Y = R_DRW2D_2X(PosY+(15-hsrc)/2);
	 rect.Size.Width  = R_DRW2D_2X(wsrc);
	 rect.Size.Height = R_DRW2D_2X(hsrc);

	 src_rect.Pos.X = R_DRW2D_2X(xsrc);
	 src_rect.Pos.Y = R_DRW2D_2X(ysrc);
	 src_rect.Size.Width = R_DRW2D_2X(wsrc);
	 src_rect.Size.Height = R_DRW2D_2X(hsrc);
	 
	 R_DRW2D_TextureBlit(Dev, &src_rect, &rect);

	 PosX += wsrc;
	 }  
	}   

  R_DRW2D_CtxEffectsDelete(Dev);
}



static const uint8_t EnglishFont[] =
{
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
};

void Write_String(r_drw2d_Device_t Dev,int PosX, int PosY, r_drw2d_Color_t  Color, char *Text)
{
    
    int                   startx;
    static r_drw2d_Texture_t tex1;
    
    static r_drw2d_Rect_t rect;
    static r_drw2d_Rect_t src_rect;
    r_drw2d_EffectStage_t effect[2];
    uint32_t xPos, yPos;
    tex1.Buffer.Data = &EnglishFont;
    tex1.Buffer.Pitch =  850;/* Pic_Attribute[FONT_English].u16Pic_Width;*/
    tex1.Buffer.PixelFormat = R_DRW2D_PIXELFORMAT_AL8;
    tex1.Buffer.Size.Height =  19;/*Pic_Attribute[FONT_English].u16Pic_Height;*/
    tex1.Buffer.Size.Width =   850;/*Pic_Attribute[FONT_English].u16Pic_Width;*/
    tex1.Flags = R_DRW2D_TEX_BILINEAR;
    tex1.Handle = 0;


    R_DRW2D_CtxIdentity(Dev);
    R_DRW2D_CtxTextureIdentity(Dev);

    R_DRW2D_CtxBlendMode(Dev, R_DRW2D_BLENDMODE_SRC_OVER);
    R_DRW2D_CtxFillMode(Dev, R_DRW2D_FILLMODE_TEXTURE);

    effect[0].Name = R_DRW2D_EFFECT_MODULATE;
    effect[0].Args[0].Source = R_DRW2D_EFFECT_SOURCE_TEXTURE_UNIT;
    effect[0].Args[0].Param.Color.Source.TextureUnit = 0;
    effect[0].Args[0].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;
    effect[0].Args[1].Source = R_DRW2D_EFFECT_SOURCE_CONSTANT_COLOR;
    effect[0].Args[1].Param.Color.Source.ConstantColor = Color;
    effect[0].Args[1].Param.Color.Operand = R_DRW2D_EFFECT_COLOR_OPERAND_RGBA;

    R_DRW2D_CtxEffectsSet(Dev, effect, 1);
    R_DRW2D_CtxTextureSet(Dev, 0, &tex1);

    startx = PosX;
    while (*Text != 0)
    {
        if (*Text == '\n')
        {
            PosX  = startx;
	    PosY += 19;
        }
        else
        {
            locWriteChar(Dev, PosX, PosY, *Text);
            PosX += GetCharWidth(*Text);
        }
        Text++;
    } 
    
    R_DRW2D_CtxEffectsDelete(Dev);

}

