
#include "Key.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "rh850_macros.h"
#include "Services_Mileage.h"
#include "RTE_TIME.h"
#include "RTC.h"
#include "BackLight_APP.h"
#include "None_NM.h"
#include "Flash_synchronizer.h"
#include "Common_Interface.h"
#include "Data_ReversingImage.h"
/*---------------------------------------------------------*/

/*----------按键具体功能执行的回调函数-----------------------*/
void Key_Turn_Test(void);

uint8_t KEY1_Status = 0;     //按键1上次电平
uint8_t KEY2_Status = 0;     //按键2上次电平

uint8_t KeyTurn_Status = 0;  //0=右旋,1=左旋
uint8_t KeyTurnLTime   = 0;  //左旋时间
uint8_t KeyTurnRTime   = 0;  //右旋时间

void Key_Turn_Test(void)
{
    if (KEY1_MCU != 0)
	{
		if (KEY1_Status == 0) //转折点
		{
			KEY1_Status = 1;
				      
			if (KEY2_MCU == 0)
			{
				KEY2_Status = 0;
			}
			else
			{
				KEY2_Status = 1;
			}
		}
		else
		{
			if (KEY2_MCU != 0)
			{
				if (KEY2_Status == 0)
				{
				    KeyTurn_Status = 0;
				    KeyTurnRTime   = 0;
				                
				    if (KeyTurnLTime < 0xFF)
				    {
				        KeyTurnLTime++;
				    }
				}
				           
				KEY2_Status = 1;
			}
			else
			{
				if (KEY2_Status != 0)
				{
				    KeyTurn_Status = 1;
				    KeyTurnLTime   = 0;
				                
				    if (KeyTurnRTime < 0xFF)
				    {
				        KeyTurnRTime++;
				    }
				}
				           
				KEY2_Status = 0;
			}
		}
	}
    else 
    {
        KEY1_Status = 0;
    }
}

#pragma ghs section bss=".myNonInitArea" //buckupRAM区
uint8_t  Display_Interface; //显示界面,0=正常,1=其它
uint8_t  Mileage_Type;      //里程类别,0=累计里程,1=小计A,2=小计B
uint8_t  ResToDef;          //恢复默认设置,0=不恢复,1=恢复
uint8_t  LitSpdTyp;         //限速类型,0=89,1=99,2=109
uint8_t  VdoFmtTyp;         //视频模式,0=OFF,1=NTSC,2=PAL 20230823移到此处，解决休眠唤醒后变为0问题（不从DFLASH读出）
#pragma ghs section bss=default

uint16_t Key3_Press_Time;   //按键3按下时间
uint8_t  Clock_Set_Status;  //时钟设置,0=未设,1=设置
uint16_t Clock_Set_Time;    //时钟设置计时,5秒自动退出
uint8_t  Clock_Set_Type;    //时钟设置类别,0=分钟,1=小时
uint8_t	 Clock_Set_Hour;    //设置时显示的小时
uint8_t  Clock_Set_Minute;  //设置时显示的分钟
uint8_t  Menu_Set_Status;   //菜单状态,0=未进,1=进入
uint8_t  Menu_Set_Grade;    //菜单级数,0=一级,1=二级
uint8_t  Menu_Set_Type;     //菜单类别,0=行车电脑,1=夜间照明亮度,2=日间照明亮度,3=恢复默认设置,4=视频制式,5=限速值,6=退出设置
uint8_t  Vehicle_Info_Type; //行车电脑类别,0=组合仪表,1=动力电池组,2=整车控制器,3=电机控制器,4=充电机,5=绝缘检测仪,6=辅助控制器,7=ABS,8=返回

_MenuDispStruct Info_Disp_Type[Vhcl_Info_Max];

static const uint8_t Vhcl_Info_Page[] = 
{
	/*Vhcl_Info_IC*/  2u,
	/*Vhcl_Info_BMS*/ 37u, 
	/*Vhcl_Info_VCU*/ 6u, 
	/*Vhcl_Info_MCU*/ 3u, 
	/*Vhcl_Info_CHG*/ 1u, 
	/*Vhcl_Info_ISL*/ 2u, 
	/*Vhcl_Info_SCU*/ 2u, 
	/*Vhcl_Info_ABS*/ 50u,
	/*Vhcl_Info_SW*/  2u,
	/*Vhcl_Info_RET*/ 0u,
};

void Display_Info_Init(void)
{
	Display_Interface = 0u;  //显示界面,0=正常,1=其它
    Clock_Set_Status  = 0u;  //时钟设置,0=未设,1=设置
    Menu_Set_Status   = 0u;  //菜单状态,0=未进,1=进入
    Menu_Set_Grade    = 0u;  //菜单级数,0=一级,1=二级
    Clock_Set_Time    = 0u;  //时钟设置计时,5秒自动退出
    Clock_Set_Type    = 0u;  //时钟设置类别,0=分钟,1=小时
    Clock_Set_Hour    = 0u;  //设置时显示的小时
    Clock_Set_Minute  = 0u;  //设置时显示的分钟
    Menu_Set_Type     = 0u;  //菜单类别,0=行车电脑,1=夜间照明亮度,2=日间照明亮度,3=恢复默认设置,4=视频制式,5=限速值,6=退出设置
    Mileage_Type      = 0u;  //里程类别,0=累计里程,1=小计A,2=小计B
    Vehicle_Info_Type = 0u;  //行车电脑类别,0=组合仪表,1=动力电池组,2=整车控制器,3=电机控制器,4=充电机,5=绝缘检测仪,6=辅助控制器,7=ABS,8=返回
    ResToDef          = 0u;  //恢复默认设置,0=不恢复,1=恢复
	
	//LitSpdTyp         = 0ul; //限速类型,0=89,1=99,2=109
    //VdoFmtTyp         = 2u;  //视频模式,0=OFF,1=NTSC,2=PAL
}

void Display_Info_IgnOnInit(void)
{
	Clock_Set_Status  = 0u;  //时钟设置,0=未设,1=设置
    Menu_Set_Status   = 0u;  //菜单状态,0=未进,1=进入
    Menu_Set_Grade    = 0u;  //菜单级数,0=一级,1=二级
    Clock_Set_Time    = 0u;  //时钟设置计时,5秒自动退出
    Clock_Set_Type    = 0u;  //时钟设置类别,0=分钟,1=小时
    Clock_Set_Hour    = 0u;  //设置时显示的小时
    Clock_Set_Minute  = 0u;  //设置时显示的分钟
    Menu_Set_Type     = 0u;  //菜单类别,0=行车电脑,1=夜间照明亮度,2=日间照明亮度,3=恢复默认设置,4=视频制式,5=限速值,6=退出设置
    Vehicle_Info_Type = 0u;  //行车电脑类别,0=组合仪表,1=动力电池组,2=整车控制器,3=电机控制器,4=充电机,5=绝缘检测仪,6=辅助控制器,7=ABS,8=返回
}

uint8_t Info_Select_Get(vhcl_info_en_t info)
{
	return Info_Disp_Type[info].Select;
}

uint8_t Info_Page_Get(vhcl_info_en_t info)
{
	return Info_Disp_Type[info].Page;
}

uint8_t KeyTurnLTime_Delay;
uint8_t KeyTurnRTime_Delay;

uint16_t Menu_Set_QuitTime;

void Key_Turn_Service(void)
{
    if (ReversingImage_Enable_Flag_Get() != 0u)
	{
		return;
	}

	if (Common_Get_IG_Sts() == 0u)
	{
		Menu_Set_Status = 0u;
		return;
	}

 	if (Menu_Set_Status)
	{
		if (Menu_Set_QuitTime < 1000u)
		{
			Menu_Set_QuitTime++;
		}
		else
		{
			Menu_Set_Status = 0u;
		}
	}
	else
	{
		Menu_Set_QuitTime = 0u;
	}
  	  
	if (KeyTurn_Status == 0) //按钮右旋
    {
        if (KeyTurnLTime_Delay < 50u)
		{
			KeyTurnLTime_Delay++;
		}
		else
		{
			if (KeyTurnLTime >= 2u)
			{
				disable_interrupt();
				KeyTurnLTime = 0u;
				enable_interrupt();
				
				KeyTurnLTime_Delay = 0u;

				/*if (IgnOffChgWak_Time_Get() >= 3600000) //3分钟
				{
					IgnOffChgWak_Time_Set(0);
				}*/

				Menu_Set_QuitTime = 0u;

				if ((Clock_Set_Status == 0u) && (Menu_Set_Status == 0u))
				{
					Display_Interface++;
					
					if (Display_Interface > 2u) //未到最末
					{
						Display_Interface = 0; 
					}
				}
				else if (Clock_Set_Status == 1u)
				{
					Clock_Set_Time = 0u;

					if (Clock_Set_Type == Clock_Hour)
					{
						if (++Clock_Set_Hour >= 24u)
						{
							Clock_Set_Hour = 0u;
						}
					} 
					else
					{
						if (++Clock_Set_Minute >= 60u)
						{
							Clock_Set_Minute = 0u;
						}
					}
				}
				else 
				{
					if (Menu_Set_Grade == 0u)
					{
						if (++Menu_Set_Type >= 7u)
						{
							Menu_Set_Type = 0u;
						}
					}
					else 
					{
						switch (Menu_Set_Type)
						{
							//整车信息
							case 0u: 
								if (Menu_Set_Grade == 1u)
								{
									if (++Vehicle_Info_Type >= Vhcl_Info_Max)
									{
										Vehicle_Info_Type = 0u;
									} 
								}
								else 
								{
									if (Info_Disp_Type[Vehicle_Info_Type].Select == 0u) //没有选项
									{
										if (Vhcl_Info_Page[Vehicle_Info_Type] == 1u) //仅一页
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //只有返回一项可选
										}
										else
										{
											if (Info_Disp_Type[Vehicle_Info_Type].Page == 0u) //首页
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //没有上页,第一个只能选返回
											}
											else
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 1u; //上页
											}
										}
									}
									else if (Info_Disp_Type[Vehicle_Info_Type].Select == 1u) //上页
									{
										Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //返回
									}
									else if (Info_Disp_Type[Vehicle_Info_Type].Select == 2u) //返回
									{
										if (Vhcl_Info_Page[Vehicle_Info_Type] == 1u)
										{
											; //无可变选项
										}
										else
										{
											if (Info_Disp_Type[Vehicle_Info_Type].Page == (Vhcl_Info_Page[Vehicle_Info_Type] - 1u)) //末页
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 1u; //上页
											}
											else
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 3u; //下页
											}
										}
									}
									else //下页
									{
										if (Info_Disp_Type[Vehicle_Info_Type].Page == 0u) //首页
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //返回
										}
										else
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 1u; //上页
										}
									} 
								}
								
								break;
							
							//夜间模式
							case 1u:
								DesNitBrt_Add();
								Brightness_Mode_Set(1u); //照明模式,0=日间,1=夜间
								break;
							
							//日间模式
							case 2u: 
								DesDayBrt_Add();
								Brightness_Mode_Set(0u); //照明模式,0=日间,1=夜间  
								break;
							
							//系统设置
							case 3u: 
								if (ResToDef == 0u)
								{
									ResToDef = 1u; 
								}
								else
								{
									ResToDef = 0u;
								}
							
								break;
							
							//视频模式
							case 4:
								if (++VdoFmtTyp > 2u)
								{
									VdoFmtTyp = 0u;
								}

								Common_Set_VdoFmtTyp(VdoFmtTyp);

								break;

							//限速模式
							case 5:
								if (++LitSpdTyp > 2ul)
								{
									LitSpdTyp = 0ul;
								}

								Common_Set_LitSpdTyp(LitSpdTyp); /*20230906增加限速报警类型存储*/

								break;	

							default: break;
						}
					}
				}
			}
		}
    }
    else                     //按钮左旋
    {
        if (KeyTurnRTime_Delay < 50u)
		{
			KeyTurnRTime_Delay++;
		}
		else
		{
			if (KeyTurnRTime >= 2u)
			{
				disable_interrupt();
				KeyTurnRTime = 0;
				enable_interrupt();

				KeyTurnRTime_Delay = 0u;
				
				/*if (IgnOffChgWak_Time_Get() >= 3600000) //3分钟
				{
					IgnOffChgWak_Time_Set(0);
				}*/

				Menu_Set_QuitTime = 0u;
				
				if ((Clock_Set_Status == 0u) && (Menu_Set_Status == 0u))
				{	
					if (Display_Interface) // 未到最初
					{
						Display_Interface--;
					}
					else
					{
						Display_Interface = 2u;
					}
				}
				else if (Clock_Set_Status == 1u)
				{
					Clock_Set_Time = 0u;

					if (Clock_Set_Type == Clock_Hour)
					{
						if (Clock_Set_Hour)
						{
							Clock_Set_Hour--;
						}
						else
						{
							Clock_Set_Hour = 23u;
						}
					} 
					else
					{
						if (Clock_Set_Minute)
						{
							Clock_Set_Minute--;
						}
						else
						{
							Clock_Set_Minute = 59u;
						}
					}
				}
				else 
				{
					if (Menu_Set_Grade == 0u)
					{
						if (Menu_Set_Type)
						{
							Menu_Set_Type--;
						}
						else
						{
							Menu_Set_Type = 6u;
						}
					}
					else 
					{
						switch (Menu_Set_Type)
						{
							//整车信息
							case 0u: 
								if (Menu_Set_Grade == 1u)
								{
									if (Vehicle_Info_Type)
									{
										Vehicle_Info_Type--;
									}
									else
									{
										Vehicle_Info_Type = 9u;
									}
								}
								else 
								{
									if (Info_Disp_Type[Vehicle_Info_Type].Select == 0u) //没有选项
									{
										if (Vhcl_Info_Page[Vehicle_Info_Type] == 1u) //仅一页
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //只有返回一项可选
										}
										else
										{
											if (Info_Disp_Type[Vehicle_Info_Type].Page == (Vhcl_Info_Page[Vehicle_Info_Type] - 1u)) //末页
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //没有下页,只能选返回
											}
											else
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 3u; //下页
											}
										}
									}
									else if (Info_Disp_Type[Vehicle_Info_Type].Select == 1u) //上页
									{
										if (Info_Disp_Type[Vehicle_Info_Type].Page == (Vhcl_Info_Page[Vehicle_Info_Type] - 1u)) //末页
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //返回
										}
										else
										{
											Info_Disp_Type[Vehicle_Info_Type].Select = 3u; //下页
										}
									}
									else if (Info_Disp_Type[Vehicle_Info_Type].Select == 2u) //返回
									{
										if (Vhcl_Info_Page[Vehicle_Info_Type] == 1u)
										{
											; //无可变选项
										}
										else
										{
											if (Info_Disp_Type[Vehicle_Info_Type].Page != 0u) //首页
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 1u; //上页
											}
											else
											{
												Info_Disp_Type[Vehicle_Info_Type].Select = 3u; //下页
											}
										}
									}
									else //下页
									{
										Info_Disp_Type[Vehicle_Info_Type].Select = 2u; //返回
									}
								}
								
								break;
							
							//夜间模式
							case 1u:
								DesNitBrt_Sub();
								Brightness_Mode_Set(1u); //照明模式,0=日间,1=夜间
								break;  
								
							//日间模式
							case 2u: 
								DesDayBrt_Sub();
								Brightness_Mode_Set(0u); //照明模式,0=日间,1=夜间
								break;
							
							//系统设置
							case 3u:
								if (ResToDef == 0u)
								{
									ResToDef = 1u; 
								}
								else
								{
									ResToDef = 0u;
								}
							
								break;

							//视频模式
							case 4u: 
								if (VdoFmtTyp)
								{
									VdoFmtTyp--;
								}
								else
								{
									VdoFmtTyp = 2u;
								}

								Common_Set_VdoFmtTyp(VdoFmtTyp); 
								break;

							//限速值
							case 5u: 
								if (LitSpdTyp)
								{
									LitSpdTyp--;
								}
								else
								{
									LitSpdTyp = 2ul;
								}

								Common_Set_LitSpdTyp(LitSpdTyp); /*20230906增加限速报警类型存储*/

								break;	

							default: break;
						}
					}
				}
			}
		}
    }

	if (KEY3_MCU == 0u)
	{
		Menu_Set_QuitTime = 0u;

		if (Key3_Press_Time < 1000) //10秒
		{
			Key3_Press_Time++;
		}

		if ((Clock_Set_Status == 0u) && (Menu_Set_Status == 0u))
		{
			if ((Mileage_Type != Mileage_ODO) && (Key3_Press_Time >= 200))
			{
				if (Mileage_Type == Mileage_TRIPA)
				{
					Data_Clear_Trip(EM_TRIP_A);
				}
				else
				{
					Data_Clear_Trip(EM_TRIP_B);
				}
			}
		    
			if (Key3_Press_Time >= 600u)
			{
				Menu_Set_Status = 1u;
				Menu_Set_Grade  = 0u;
			}
		}
	}
	else
	{
		if (Clock_Set_Status == 0u)
		{
            if ((Key3_Press_Time >= 5u) && (Key3_Press_Time < 100u))
			{
                /*if (IgnOffChgWak_Time_Get() >= 3600000) //3分钟
				{
					IgnOffChgWak_Time_Set(0);
				}*/
				
				if (Menu_Set_Status == 0u)
				{
	  			    if (++Mileage_Type >= 3u)
					{
						Mileage_Type = 0u;
					}
				}
				else
				{
                    if (Menu_Set_Grade == 0u)
					{
						if (Menu_Set_Type == 6u)
						{
							Menu_Set_Status = 0u;
						}
						else 
						{
							Menu_Set_Grade = 1u;
						}
					}
					else if (Menu_Set_Grade == 1u)
					{
						if (Menu_Set_Type == 0u) //整车信息
						{
							if (Vehicle_Info_Type == Vhcl_Info_RET)
							{
								Menu_Set_Type  = 6u;
							    Menu_Set_Grade = 0u;
							}
							else
							{
								Menu_Set_Grade = 2u; //进入三级菜单
								
								Info_Disp_Type[Vehicle_Info_Type].Page = 0u;
								Info_Disp_Type[Vehicle_Info_Type].Select = 0u;
							}
						}
						else
						{
							if ((Menu_Set_Type == 3u) && (ResToDef == 1u)) //恢复默认设置
							{
								Display_Info_Init();
							}
							
							Menu_Set_Type  = 6u;
							Menu_Set_Grade = 0u;
						}
					}
					else
					{
                        if (Info_Disp_Type[Vehicle_Info_Type].Select == 1u) //选择上页
						{
							if (--Info_Disp_Type[Vehicle_Info_Type].Page == 0u)
							{
                                Info_Disp_Type[Vehicle_Info_Type].Select = 2u;
							}
						}
						else if (Info_Disp_Type[Vehicle_Info_Type].Select == 2u) //选择返回
						{
							Info_Disp_Type[Vehicle_Info_Type].Page = 0u;
							Info_Disp_Type[Vehicle_Info_Type].Select = 0u;
							
							Menu_Set_Grade = 1u; //退到二级菜单
						}
						else if (Info_Disp_Type[Vehicle_Info_Type].Select == 3u) //选择下页
						{
							if (++Info_Disp_Type[Vehicle_Info_Type].Page >= (Vhcl_Info_Page[Vehicle_Info_Type] - 1u))
							{
                                Info_Disp_Type[Vehicle_Info_Type].Select = 2u;
							}
						}
						else
						{
							; //没有选择,啥都不做
						}
					} 
				} 
			}
			//else if ((Key3_Press_Time >= 200u) && (Key3_Press_Time <= 400u) && (Mileage_Type == 0u))
			//{
				//Clock_Set_Status = 1u;
				//Clock_Set_Time   = 0u;
				//Clock_Set_Type   = Clock_Minute;
				//Clock_Set_Hour   = Get_RTC_HOUR();
			    //Clock_Set_Minute = Get_RTC_MINUTE();
			//}
			else
			{
				;
			}
		}
	  #if 0	
		else 
		{
            if ((Key3_Press_Time >= 5u) && (Key3_Press_Time < 100u))
			{
				Clock_Set_Time = 0u;
				
				if (Clock_Set_Type == Clock_Minute)
				{
                    Clock_Set_Type = Clock_Hour;
				}
				else
				{
					Clock_Set_Type = Clock_Minute;
				}
			}

			if (Clock_Set_Time < 500u) //5秒
			{
				Clock_Set_Time++;
				if (Clock_Set_Time == 490) //提前更新,避免调时结束时有时显示一下未调前的值
				{
					RTC_Set_Time(0, Clock_Set_Hour, Clock_Set_Minute, 0);
				}
			}
			else
			{
				Clock_Set_Status = 0u;
			}
            
			if ((Key3_Press_Time >= 200u) && (Key3_Press_Time <= 400u))
			{
				Clock_Set_Status = 0u;
			}
       
			if (Clock_Set_Status == 0u)
			{
				RTC_Set_Time(0, Clock_Set_Hour, Clock_Set_Minute, 0);
				#if 0
				uint16_t u16RTCCount = 0U;
				while ((RTCA0WST != 0U) && (u16RTCCount < 50u)) /*Check that all clock counters are running.*/
				{
					u16RTCCount++;
				}
				RTCA0WAIT = 1U; /*Stop all clock counters*/
				u16RTCCount = 0U;
				while ((RTCA0WST != 1U) && (u16RTCCount < 50u)) /*Wait  all clock counters  stop*/
				{
					u16RTCCount++;
				}
				
				RTCA0HOUR = RTC_Dec_To_BCD(Clock_Set_Hour);
		        RTCA0MIN  = RTC_Dec_To_BCD(Clock_Set_Minute);
		        RTCA0SEC  = RTC_Dec_To_BCD(0u);
				/*Start all clock counters*/
				RTCA0WAIT = 0U;
				u16RTCCount = 0U;
				
				while ((RTCA0WST != 0U) && (u16RTCCount < 50u)) /*Check that all clock counters are running.*/
				{
					u16RTCCount++;
				}
				#endif
            }
		}
	  #endif

		Key3_Press_Time = 0u;
	}
}

uint8_t Display_Interface_Get(void)
{
    return Display_Interface;
}

uint8_t ClkSetSts_Get(void)
{
    return Clock_Set_Status;
}

uint8_t ClkSetTyp_Get(void)
{
    return Clock_Set_Type;
}

uint8_t ClkSetHour_Get(void)
{
    return Clock_Set_Hour;
}

uint8_t ClkSetMinute_Get(void)
{
    return Clock_Set_Minute;
}

uint8_t MileType_Get(void)
{
    return Mileage_Type;
}

uint8_t MenuSetSts_Get(void)
{
    return Menu_Set_Status;
}

uint8_t MenuSetTyp_Get(void)
{
    return Menu_Set_Type;
}

uint8_t MenuSetGrd_Get(void)
{
    return Menu_Set_Grade;
}

uint8_t VhlInfTyp_Get(void)
{
    return Vehicle_Info_Type;
}

uint8_t ResToDef_Get(void)
{
	return ResToDef;
}

uint8_t VdoFmtTyp_Get(void)
{
	return VdoFmtTyp;
}

void VdoFmtTyp_Set(uint8_t SetValue)
{
	VdoFmtTyp = SetValue;
}

uint8_t LitSpdTyp_Get(void)
{
	return LitSpdTyp;
}

void LitSpdTyp_Set(uint8_t SetValue)
{
	LitSpdTyp = SetValue;
}

uint16_t Key3_Press_Time_Get(void)
{
	return Key3_Press_Time;
}
