#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_

#include "TYW_stdint.h"

void Common_DataInit(void);
void Common_Input_Para(void);

COMMON_PowerStatus_t Common_Get_IG_Sts(void);
DataValid_t Common_Get_IG_Sts_Valid(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
void Common_Set_IG_Sts_Valid(DataValid_t Val);

uint16_t Common_Get_Act_V_Speed(void);
uint16_t Common_Get_Disp_V_Speed(void);
uint8_t Common_Get_OverSpeed_Status(void); /*获取超速报警状态*/

DataValid_t Common_Get_Act_V_Speed_Valid(void);
DataValid_t Common_Get_Disp_V_Speed_Valid(void);

void Common_Set_Act_V_Speed(uint16_t Val);
void Common_Set_Disp_V_Speed(uint16_t Val);

void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);

uint16_t Common_Get_DispSpeed(void);

uint32_t Common_GetIgnOnTime(void);  /*ms*/
uint32_t Common_GetIgnOffTime(void); /*ms*/

void Common_RollingCounterAdd(void);
void Common_RollingCounterClear(void);
void Common_BlockDelay(uint16_t m_MS);

uint16_t Common_ReadRollingCounter(void);

#define ENGINE_TYPE_G5_VALUE    1u
#define ENGINE_TYPE_G6_VALUE    0u

#define Engine_Rpm_05        500u
#define Engine_Rpm_95        950u
#define Engine_Rpm_10       1000u
#define Engine_Rpm_11       1100u
#define Engine_Rpm_12       1200u
#define Engine_Rpm_13       1300u
#define Engine_Rpm_14       1400u
#define Engine_Rpm_15       1500u
#define Engine_Rpm_16       1600u
#define Engine_Rpm_17       1700u
#define Engine_Rpm_18       1800u
#define Engine_Rpm_19       1900u
#define Engine_Rpm_20       2000u
#define Engine_Rpm_21       2100u
#define Engine_Rpm_22       2200u
#define Engine_Rpm_23       2300u
#define Engine_Rpm_25       2500u

#define Engine_PageZ 0u
#define Engine_PageO 1u
#define Engine_PageT 2u

/*发动机选择*/
#define  Engine_Type_L9         125u
#define  Engine_Type_WP15LNG     34u  /*35*/
#define  Engine_Type_WP15CNG     36u  /*37*/
#define  Engine_Type_WP13LNG     19u
#define  Engine_Type_WP13CNG     20u  /*21*/
#define  Engine_Type_WP12LNG     14u  /*15*/
#define  Engine_Type_WP12CNG     16u  /*17*/
#define  Engine_Type_WP10LNG    116u
#define  Engine_Type_WP10CNG    117u
/*#define  Engine_Type_WP10HLNG */
/*#define  Engine_Type_WP10HCNG */
#define  Engine_Type_WP11SLNG   155u
#define  Engine_Type_WP11SCNG   156u
/*#define  Engine_Type_WP6_7LNG */
#define  Engine_Type_WP6_7CNG   170u
#define  Engine_Type_WP5LNG       3u /*4*/
#define  Engine_Type_WP5CNG       5u /*6*/
#define  Engine_Type_WP4_6LNG    26u /*27*/
#define  Engine_Type_WP4_6CNG    28u /*29*/
#define  Engine_Type_KMSTRQ     171u             /*康明斯天然气*/
#define  Engine_Type_WP13        12u
#define  Engine_Type_WP12        11u
#define  Engine_Type_WP11S      154u
#define  Engine_Type_WP10_5H     40u
/*#define  Engine_Type_WP10H*/
#define  Engine_Type_WP10       161u
/*#define  Engine_Type_WP9H*/
#define  Engine_Type_WP8         39u
/*#define  Engine_Type_WP7 */
#define  Engine_Type_WP6_7      162u
#define  Engine_Type_WP6H        38u
/*#define  Engine_Type_WP6  */
#define  Engine_Type_WP4_6       23u
/*#define  Engine_Type_ISM */
/*#define  Engine_Type_ISZ*/
#define  Engine_Type_M15        135u
#define  Engine_Type_ISD6_7       2u
#define  Engine_Type_ISD4_5       1u
#define  Engine_Type_X12         44u
#define  Engine_Type_X13        127u
#define  Engine_Type_HPDI        22u
#define  Engine_Type_YCK11      172u
#define  Engine_Type_6K13N      173u
#define  Engine_Type_YC6K12     164u
#define  Engine_Type_YC4E       165u
#define  Engine_Type_YC6L       166u
#define  Engine_Type_YC6A       167u
#define  Engine_Type_YCK08      168u

typedef enum
{
    /* 0*/Type_WP13  = 0  ,
    /* 1*/Type_WP12       ,
    /* 2*/Type_WP11S      ,
    /* 3*/Type_WP10_5H    ,
    /* 4*/Type_WP10H      ,
    /* 5*/Type_WP10       ,
    /* 6*/Type_WP9H       ,
    /* 7*/Type_WP8        ,
    /* 8*/Type_WP7        ,
    /* 9*/Type_WP6_7      ,
    /*10*/Type_WP6H       ,
    /*11*/Type_WP6        ,
    /*12*/Type_WP4_6      ,
    /*13*/Type_ISM        ,
    /*14*/Type_ISZ        ,
    /*15*/Type_M15        ,
    /*16*/Type_ISD6_7     ,
    /*17*/Type_ISD4_5     ,
    /*18*/Type_X12        ,
    /*19*/Type_X13        ,
    /*20*/Type_L9         ,
    /*21*/Type_WP15LNG    ,
    /*22*/Type_WP15CNG    ,
    /*23*/Type_WP13LNG    ,
    /*24*/Type_WP13CNG    ,
    /*25*/Type_WP12LNG    ,
    /*26*/Type_WP12CNG    ,
    /*27*/Type_WP10LNG    ,
    /*28*/Type_WP10CNG    ,
    /*29*/Type_WP10HLNG   ,
    /*30*/Type_WP10HCNG   ,
    /*31*/Type_WP11SLNG   ,
    /*32*/Type_WP11SCNG   ,
    /*33*/Type_WP6_7LNG   ,
    /*34*/Type_WP6_7CNG   ,
    /*35*/Type_WP5LNG     ,
    /*36*/Type_WP5CNG     ,
    /*37*/Type_WP4_6LNG   ,
    /*38*/Type_WP4_6CNG   ,
    /*39*/Type_KMSTRQ     ,
    /*40*/Type_HPDI       ,
    /*41*/Type_YCK11      ,
    /*42*/Type_6K13N      ,
    /*43*/Type_YC6K12     ,
    /*44*/Type_YC4E       ,
    /*45*/Type_YC6L       ,
    /*46*/Type_YC6A       ,
    /*47*/Type_YCK08      ,
    /*48*/Type_Z14        ,

} ENGINE_TYPE_VALUE;

/*变速箱类型*/
#define  Gearbox_MT             0
#define  Gearbox_AMTFLT1        5
#define  Gearbox_AMTYD1         6
#define  Gearbox_ATALX          4
#define  Gearbox_ATST           12
#define  Gearbox_AMTFLT2        1
#define  Gearbox_AMTZF          10
#define  Gearbox_AMTYDE         2

typedef enum
{
    box_MT = 0      , /* 0 机械变速箱*/
    box_AMTFLT1     , /* 1 法士特AMT一代*/
    box_AMTYD1      , /* 2 伊顿AMT*/
    box_ATALX       , /* 3 艾里逊AT*/
    box_ATST        , /* 4 双特AT*/
    box_AMTFLT2     , /* 5 法士特AMT二代*/
    box_AMTZF       , /* 6 ZF变速箱*/
    box_AMTYDE      , /* 7 伊顿Endurant AMT*/
} GEARBOX_TYPE_VALUE;

typedef struct
{
    uint8_t Tpms_Guard_Against_Theft_Sta;  /*00 行车电脑/TPMS 静态轮胎防盗使能 0-关闭  1-开启*/
    uint8_t ACC_Distance_Mode_Value;       /*01 ACC车距设置/车距模式选择 0-4-->(1-5 默认3)*/
    uint8_t ACC_Sta;                       /*02 行车信息/辅助驾驶 ACC   0-关闭  1-开启*/
    uint8_t AEBS_Sta;                      /*03 行车信息/辅助驾驶 AEBS  0-关闭  1-开启*/
    uint8_t Ramp_Assist_Sta;               /*04 行车信息/辅助驾驶 坡道辅助 0-关闭  1-开启  2-未配置*/
    uint8_t ESC_ASR_Sta;                   /*05 行车信息/辅助驾驶 ESC/ASR 0-关闭  1-开启*/
    uint8_t ADAS_Sta;                      /*06 行车信息/辅助驾驶 智能ADAS -关闭  1-开启*/
    uint8_t ADAS_Sensitivity_Value;        /*07 辅助驾驶/ADAS灵敏度 0-3-->(1-3 默认2)*/
    uint8_t Tpms_Monitor_Sta;              /*08 胎压检测状态     0-关闭  1-开启*/
    uint8_t Battery_Type_Value;            /*09 辅助驾驶/蓄电池类型 0-7  0-135AH 1-165AH免维护 180AH免维护...*/
    uint8_t TMaintain_Tips_Sta ;           /*10 保养提示状态     0-关闭  1-开启*/
    uint8_t Language_Set_Value;            /*11 个人设置/语言设置 0-5 (简体中文 繁体中文 EN 俄语RU 阿拉伯)*/
    uint8_t Wiper_Distance_Mode_Value;     /*12 个人设置/雨刮灵敏度设置 0-3 (1-4 默认2)*/
    uint8_t Backlight_Set_Value;           /*13 个人设置/背光调节 0-2 (1-3档)*/
    uint8_t Follow_Me_Home_Time_Value;     /*14 个人设置/伴我回家设置*/
    uint8_t Instantaneous_Oil_Sta;         /*15 个人设置/主界面设置 瞬时油耗 0-关闭  1-开启*/
    uint8_t Battery_Level_Sta;             /*16 个人设置/主界面设置 电池电量 0-关闭  1-开启*/
    uint8_t Adblue_Level_Sta;              /*17 个人设置/主界面设置 尿素液位 0-关闭  1-开启*/
    uint8_t Cumulative_Oil_Sta;            /*18 个人设置/主界面设置 累计油耗 0-关闭  1-开启*/
    uint8_t Comprehensive_Oil_Sta;         /*19 个人设置/主界面设置 综合油耗 0-关闭  1-开启*/
    uint8_t Current_Oil_Sta;               /*20 个人设置/主界面设置 当前油耗 0-关闭  1-开启*/
    uint8_t Set_Engine_Type_Value;         /*21 调表模式/参数 发动机类型*/
    uint8_t Set_EngineG5G6_Type_Value;     /*22 调表模式/参数 0-国六 0-非国六*/
    uint8_t Set_Gear_Type_Value;           /*23 调表模式/参数 变速箱类型*/
    uint8_t Set_Car_Model_Type;            /*24 调表模式/参数 车型 */
    uint8_t Set_Car_APU_Type;              /*25 调表模式/参数 0-非集成 1-集成式*/
    uint8_t Set_Tpms_Size_Sta;             /*26 调表模式/参数 驱动方式 0-8x4第一选项  1-8x4第二选项 ...*/

    uint8_t TMaintain_Set_Value1;          /*27 提示设置/保养设置 单位km*/
    uint8_t TMaintain_Set_Value2;          /*27 提示设置/保养设置 单位km*/
    uint8_t TMaintain_Set_Value3;          /*27 提示设置/保养设置 单位km*/
    uint8_t TMaintain_Set_Value4;          /*27 提示设置/保养设置 单位km*/
    uint8_t TMaintain_Set_Value5;          /*27 提示设置/保养设置 单位km*/

    uint8_t TMaintain_Tips_Value1;         /*28 提示设置/提示里程 单位km*/
    uint8_t TMaintain_Tips_Value2;         /*28 提示设置/提示里程 单位km*/
    uint8_t TMaintain_Tips_Value3;         /*28 提示设置/提示里程 单位km*/
    uint8_t TMaintain_Tips_Value4;         /*28 提示设置/提示里程 单位km*/
    uint8_t TMaintain_Tips_Value5;         /*28 提示设置/提示里程 单位km*/

    uint8_t K_Value_Num_Value1;            /*29 调表模式/参数 K值*/
    uint8_t K_Value_Num_Value2;            /*29 调表模式/参数 K值*/
    uint8_t K_Value_Num_Value3;            /*29 调表模式/参数 K值*/
    uint8_t K_Value_Num_Value4;            /*29 调表模式/参数 K值*/
    uint8_t K_Value_Num_Value5;            /*29 调表模式/参数 K值*/
    uint8_t Set_VdoFmtTyp;                 /* 倒车影像开关 */
    uint8_t Set_LitSpdTyp;                 /* 限速类型*/
    //uint8_t ccc; /* 预留*/

    uint32_t TMaintain_Set_Value;          /*27 提示设置/保养设置 单位km*/
    uint32_t TMaintain_Tips_Value;         /*28 提示设置/提示里程 单位km*/
    uint32_t K_Value_Num_Value;            /*29 调表模式/参数 K值*/

} _Menu_Configure_Value; /*开了30个U32*/
extern _Menu_Configure_Value Menu_Con_EEP_Value;
extern void Common_Set_VdoFmtTyp(uint8_t NUM_Status);
extern void Common_Set_LitSpdTyp(uint8_t NUM_Status);

#if 0
uint8_t Common_Get_TempHigh_Type(void);/*获取水温高状态*/
uint8_t Common_Get_FuelLow_Type(void);/*获取燃油低状态*/

void Common_Set_Tpms_Guard_Against_Theft_Sta(uint32_t NUM_Status);/*行车电脑/TPMS 静态轮胎防盗使能 0-关闭  1-开启*/
uint32_t Common_Get_Tpms_Guard_Against_Theft_Sta_Sta(void);

void Common_Set_ACC_Distance_Mode_Value(uint32_t NUM_Status);/*ACC车距设置/车距模式选择 0-4-->(1-5 默认3)*/
uint32_t Common_Get_ACC_Distance_Mode_Value(void);

void Common_Set_ACC_Sta(uint32_t NUM_Status);/*行车信息/辅助驾驶 ACC   0-关闭  1-开启*/
uint32_t Common_Get_ACC_Stae(void);

void Common_Set_AEBS_Sta(uint32_t NUM_Status);/*行车信息/辅助驾驶 AEBS  0-关闭  1-开启*/
uint32_t Common_Get_AEBS_Sta(void);

void Common_Set_Ramp_Assist_Sta(uint32_t NUM_Status);/*行车信息/辅助驾驶 坡道辅助 0-关闭  1-开启  2-未配置*/
uint32_t Common_Get_Ramp_Assist_Sta(void);

void Common_Set_ESC_ASR_Sta(uint32_t NUM_Status);/*行车信息/辅助驾驶 ESC/ASR 0-关闭  1-开启*/
uint32_t Common_Get_ESC_ASR_Sta(void);

void Common_Set_ADAS_Sta(uint32_t NUM_Status);/*行车信息/辅助驾驶 智能ADAS -关闭  1-开启*/
uint32_t Common_Get_ADAS_Sta(void);

void Common_Set_Battery_Type_Value(uint32_t NUM_Status);/*辅助驾驶/蓄电池类型 0-7  0-135AH 1-165AH免维护 180AH免维护...*/
uint32_t Common_Get_Battery_Type_Value(void);

void  Common_Set_TMaintain_Set_Value(void);/*提示设置/保养设置 单位km*/
uint32_t Common_Get_TMaintain_Set_Value(void);

void  Common_Set_TMaintain_Tips_Value(void);/*提示设置/提示里程 单位km*/
uint32_t Common_Get_TMaintain_Tips_Value(void);

void Common_Set_Language_Set_Value(uint32_t NUM_Status);/*个人设置/语言设置 0-5 (简体中文 繁体中文 EN 俄语RU 阿拉伯)*/
uint32_t Common_Get_Language_Set_Value(void);

void Common_Set_Wiper_Distance_Mode_Value(uint32_t NUM_Status);/*个人设置/雨刮灵敏度设置 0-3 (1-4 默认2)*/
uint32_t Common_Get_Wiper_Distance_Mode_Value(void);

void Common_Set_Backlight_Set_Value(uint32_t NUM_Status);/*个人设置/背光调节 0-2 (1-3档)*/
uint32_t Common_Get_Backlight_Set_Value(void);

void Common_Set_Follow_Me_Home_Time_Value(uint32_t NUM_Status);/*个人设置/伴我回家设置*/
uint32_t Common_Get_Follow_Me_Home_Time_Value(void);

void Common_Set_Instantaneous_Oil_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 瞬时油耗 0-关闭  1-开启*/
uint32_t Common_Get_Instantaneous_Oil_Sta(void);

void Common_Set_Battery_Level_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 电池电量 0-关闭  1-开启*/
uint32_t Common_Get_Battery_Level_Sta(void);

void Common_Set_Adblue_Level_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 尿素液位 0-关闭  1-开启*/
uint32_t Common_Get_Adblue_Level_Sta(void);

void Common_Set_Cumulative_Oil_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 累计油耗 0-关闭  1-开启*/
uint32_t Common_Get_Cumulative_Oil_Sta(void);

void Common_Set_Comprehensive_Oil_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 综合油耗 0-关闭  1-开启*/
uint32_t Common_Get_Comprehensive_Oil_Sta(void);

void Common_Set_Current_Oil_Sta(uint32_t NUM_Status);/*个人设置/主界面设置 当前油耗 0-关闭  1-开启*/
uint32_t Common_Get_Current_Oil_Sta(void);

void Common_Set_Engine_Type(void); /*设置发动机类型*/
ENGINE_TYPE_VALUE Common_Get_Engine_Type(void); /*获取发动机类型*/

void Common_Set_EngineG5G6_Type(void);/*设置国五国六状态*/
uint8_t Common_Get_EngineG5G6_Type(void);/*获取国五国六状态*/

uint8_t Common_Get_Engine_LNGCNG_Type(void); /*获取发动机其燃油的还是气的或者混动的*/
uint8_t Common_Get_Engine_Type_TX(void); /*获取发动机外发状态*/

void Common_Set_Gear_Type(void);    /*设置变速箱类型*/
GEARBOX_TYPE_VALUE Common_Get_Gear_Type(void); /*获取变速箱类型*/

void Common_Set_Car_Model_Type(void); /*设置车型*/
uint8_t Common_Get_Car_Model_Type(void);/*获取车型*/

void  Common_Set_Car_APU_Type(void); /*设置APU状态*/
uint8_t Common_Get_Car_APU_Type(void);/*获取APU状态*/

void Common_Set_Tpms_Size(void); /*设置胎压类型*/
uint8_t Common_Get_Tpms_Size(void); /*获取胎压类型*/

void  Common_Set_K_Value_Number(void);/*设置K值*/
uint32_t Common_Get_K_Value_Number(void);/*获取K值*/

uint8_t Commom_Data_Get_Seatbelt_Tiip_Sta(void);/*安全带距离累计*/

uint8_t Common_Get_Select_Sta(void); /*获取个人设置/主界面设置选项选中个数*/
#endif

#endif

