#ifndef TLC6C5912_H__
#define TLC6C5912_H__

#include "r_typedefs.h"

#define    TLC6C5912_TOTAL_CHIP_NUM	    (4U)
#define    TLC6C5912_CSIH_Channel       (0U)
#define    TLC6C5912

typedef	union		
{
	uint16_t	DByte;					
	struct	
	{
		uint8_t Bit0 		:1;
		uint8_t	Bit1 		:1;
		uint8_t	Bit2 		:1;
		uint8_t	Bit3 		:1;
		uint8_t	Bit4 		:1;
		uint8_t	Bit5 		:1;
		uint8_t	Bit6 		:1;
		uint8_t	Bit7 		:1;
		uint8_t	Bit8 		:1;
		uint8_t	Bit9 		:1;
		uint8_t	Bit10		:1;
		uint8_t	Bit11 		:1;
		uint8_t			    :4;

	}DBits;
}DByteBits;
extern  volatile DByteBits	LEDControl[TLC6C5912_TOTAL_CHIP_NUM];

#if TLC6C5912_TOTAL_CHIP_NUM >= 1U
#define   TLC6C5912_CHIP0_BIT0    LEDControl[0].DBits.Bit0
#define   TLC6C5912_CHIP0_BIT1    LEDControl[0].DBits.Bit1
#define   TLC6C5912_CHIP0_BIT2    LEDControl[0].DBits.Bit2
#define   TLC6C5912_CHIP0_BIT3    LEDControl[0].DBits.Bit3
#define   TLC6C5912_CHIP0_BIT4    LEDControl[0].DBits.Bit4
#define   TLC6C5912_CHIP0_BIT5    LEDControl[0].DBits.Bit5
#define   TLC6C5912_CHIP0_BIT6    LEDControl[0].DBits.Bit6
#define   TLC6C5912_CHIP0_BIT7    LEDControl[0].DBits.Bit7
#define   TLC6C5912_CHIP0_BIT8    LEDControl[0].DBits.Bit8
#define   TLC6C5912_CHIP0_BIT9    LEDControl[0].DBits.Bit9
#define   TLC6C5912_CHIP0_BIT10   LEDControl[0].DBits.Bit10
#define   TLC6C5912_CHIP0_BIT11   LEDControl[0].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 2U
#define   TLC6C5912_CHIP1_BIT0    LEDControl[1].DBits.Bit0
#define   TLC6C5912_CHIP1_BIT1    LEDControl[1].DBits.Bit1
#define   TLC6C5912_CHIP1_BIT2    LEDControl[1].DBits.Bit2
#define   TLC6C5912_CHIP1_BIT3    LEDControl[1].DBits.Bit3
#define   TLC6C5912_CHIP1_BIT4    LEDControl[1].DBits.Bit4
#define   TLC6C5912_CHIP1_BIT5    LEDControl[1].DBits.Bit5
#define   TLC6C5912_CHIP1_BIT6    LEDControl[1].DBits.Bit6
#define   TLC6C5912_CHIP1_BIT7    LEDControl[1].DBits.Bit7
#define   TLC6C5912_CHIP1_BIT8    LEDControl[1].DBits.Bit8
#define   TLC6C5912_CHIP1_BIT9    LEDControl[1].DBits.Bit9
#define   TLC6C5912_CHIP1_BIT10   LEDControl[1].DBits.Bit10
#define   TLC6C5912_CHIP1_BIT11   LEDControl[1].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 3U
#define   TLC6C5912_CHIP2_BIT0    LEDControl[2].DBits.Bit0
#define   TLC6C5912_CHIP2_BIT1    LEDControl[2].DBits.Bit1
#define   TLC6C5912_CHIP2_BIT2    LEDControl[2].DBits.Bit2
#define   TLC6C5912_CHIP2_BIT3    LEDControl[2].DBits.Bit3
#define   TLC6C5912_CHIP2_BIT4    LEDControl[2].DBits.Bit4
#define   TLC6C5912_CHIP2_BIT5    LEDControl[2].DBits.Bit5
#define   TLC6C5912_CHIP2_BIT6    LEDControl[2].DBits.Bit6
#define   TLC6C5912_CHIP2_BIT7    LEDControl[2].DBits.Bit7
#define   TLC6C5912_CHIP2_BIT8    LEDControl[2].DBits.Bit8
#define   TLC6C5912_CHIP2_BIT9    LEDControl[2].DBits.Bit9
#define   TLC6C5912_CHIP2_BIT10   LEDControl[2].DBits.Bit10
#define   TLC6C5912_CHIP2_BIT11   LEDControl[2].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 4U
#define   TLC6C5912_CHIP3_BIT0    LEDControl[3].DBits.Bit0
#define   TLC6C5912_CHIP3_BIT1    LEDControl[3].DBits.Bit1
#define   TLC6C5912_CHIP3_BIT2    LEDControl[3].DBits.Bit2
#define   TLC6C5912_CHIP3_BIT3    LEDControl[3].DBits.Bit3
#define   TLC6C5912_CHIP3_BIT4    LEDControl[3].DBits.Bit4
#define   TLC6C5912_CHIP3_BIT5    LEDControl[3].DBits.Bit5
#define   TLC6C5912_CHIP3_BIT6    LEDControl[3].DBits.Bit6
#define   TLC6C5912_CHIP3_BIT7    LEDControl[3].DBits.Bit7
#define   TLC6C5912_CHIP3_BIT8    LEDControl[3].DBits.Bit8
#define   TLC6C5912_CHIP3_BIT9    LEDControl[3].DBits.Bit9
#define   TLC6C5912_CHIP3_BIT10   LEDControl[3].DBits.Bit10
#define   TLC6C5912_CHIP3_BIT11   LEDControl[3].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 5U
#define   TLC6C5912_CHIP4_BIT0    LEDControl[4].DBits.Bit0
#define   TLC6C5912_CHIP4_BIT1    LEDControl[4].DBits.Bit1
#define   TLC6C5912_CHIP4_BIT2    LEDControl[4].DBits.Bit2
#define   TLC6C5912_CHIP4_BIT3    LEDControl[4].DBits.Bit3
#define   TLC6C5912_CHIP4_BIT4    LEDControl[4].DBits.Bit4
#define   TLC6C5912_CHIP4_BIT5    LEDControl[4].DBits.Bit5
#define   TLC6C5912_CHIP4_BIT6    LEDControl[4].DBits.Bit6
#define   TLC6C5912_CHIP4_BIT7    LEDControl[4].DBits.Bit7
#define   TLC6C5912_CHIP4_BIT8    LEDControl[4].DBits.Bit8
#define   TLC6C5912_CHIP4_BIT9    LEDControl[4].DBits.Bit9
#define   TLC6C5912_CHIP4_BIT10   LEDControl[4].DBits.Bit10
#define   TLC6C5912_CHIP4_BIT11   LEDControl[4].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 6U
#define   TLC6C5912_CHIP5_BIT0    LEDControl[5].DBits.Bit0
#define   TLC6C5912_CHIP5_BIT1    LEDControl[5].DBits.Bit1
#define   TLC6C5912_CHIP5_BIT2    LEDControl[5].DBits.Bit2
#define   TLC6C5912_CHIP5_BIT3    LEDControl[5].DBits.Bit3
#define   TLC6C5912_CHIP5_BIT4    LEDControl[5].DBits.Bit4
#define   TLC6C5912_CHIP5_BIT5    LEDControl[5].DBits.Bit5
#define   TLC6C5912_CHIP5_BIT6    LEDControl[5].DBits.Bit6
#define   TLC6C5912_CHIP5_BIT7    LEDControl[5].DBits.Bit7
#define   TLC6C5912_CHIP5_BIT8    LEDControl[5].DBits.Bit8
#define   TLC6C5912_CHIP5_BIT9    LEDControl[5].DBits.Bit9
#define   TLC6C5912_CHIP5_BIT10   LEDControl[5].DBits.Bit10
#define   TLC6C5912_CHIP5_BIT11   LEDControl[5].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 7U
#define   TLC6C5912_CHIP6_BIT0    LEDControl[6].DBits.Bit0
#define   TLC6C5912_CHIP6_BIT1    LEDControl[6].DBits.Bit1
#define   TLC6C5912_CHIP6_BIT2    LEDControl[6].DBits.Bit2
#define   TLC6C5912_CHIP6_BIT3    LEDControl[6].DBits.Bit3
#define   TLC6C5912_CHIP6_BIT4    LEDControl[6].DBits.Bit4
#define   TLC6C5912_CHIP6_BIT5    LEDControl[6].DBits.Bit5
#define   TLC6C5912_CHIP6_BIT6    LEDControl[6].DBits.Bit6
#define   TLC6C5912_CHIP6_BIT7    LEDControl[6].DBits.Bit7
#define   TLC6C5912_CHIP6_BIT8    LEDControl[6].DBits.Bit8
#define   TLC6C5912_CHIP6_BIT9    LEDControl[6].DBits.Bit9
#define   TLC6C5912_CHIP6_BIT10   LEDControl[6].DBits.Bit10
#define   TLC6C5912_CHIP6_BIT11   LEDControl[6].DBits.Bit11
#endif

#if TLC6C5912_TOTAL_CHIP_NUM >= 8U
#define   TLC6C5912_CHIP7_BIT0    LEDControl[7].DBits.Bit0
#define   TLC6C5912_CHIP7_BIT1    LEDControl[7].DBits.Bit1
#define   TLC6C5912_CHIP7_BIT2    LEDControl[7].DBits.Bit2
#define   TLC6C5912_CHIP7_BIT3    LEDControl[7].DBits.Bit3
#define   TLC6C5912_CHIP7_BIT4    LEDControl[7].DBits.Bit4
#define   TLC6C5912_CHIP7_BIT5    LEDControl[7].DBits.Bit5
#define   TLC6C5912_CHIP7_BIT6    LEDControl[7].DBits.Bit6
#define   TLC6C5912_CHIP7_BIT7    LEDControl[7].DBits.Bit7
#define   TLC6C5912_CHIP7_BIT8    LEDControl[7].DBits.Bit8
#define   TLC6C5912_CHIP7_BIT9    LEDControl[7].DBits.Bit9
#define   TLC6C5912_CHIP7_BIT10   LEDControl[7].DBits.Bit10
#define   TLC6C5912_CHIP7_BIT11   LEDControl[7].DBits.Bit11
#endif

extern void TLC6C5912_Init(void);
extern void TLC6C5912_DeInit(void);
extern void TLC6C5912_Sync_Service(void);

#endif
