
#include "dr7f701441.dvf.h"
#include "TimerB.h"


/*---------------PWM Start--------------------------------------------*/

#define TIMERB_BASE_ADDRESSES 0xFFE30000U
#define TIMERB_TIMEROUT_MAX 50U

/*----target clock----------*/
#define TIMERB_0_CK0 5000000UL
#define TIMERB_0_CK1   39062UL
#define TIMERB_0_CK2 5000000UL
#define TIMERB_0_CK3 5000000UL
#define TIMERB_1_CK0 5000000UL
#define TIMERB_1_CK1 5000000UL
#define TIMERB_1_CK2 5000000UL
#define TIMERB_1_CK3 5000000UL
#define TIMERB_2_CK0 5000000UL
#define TIMERB_2_CK1 5000000UL
#define TIMERB_2_CK2 5000000UL
#define TIMERB_2_CK3 5000000UL

/*-----default clock---------*/
#define TIMERB_PCLK_01 10000000UL
#define TIMERB_PCLK_2 10000000UL
/*-----------------------------------------------------*/
#define TIMERB_0_CK0_DIV (TIMERB_PCLK_01 / TIMERB_0_CK0)
#define TIMERB_0_CK1_DIV (TIMERB_PCLK_01 / TIMERB_0_CK1)
#define TIMERB_0_CK2_DIV (TIMERB_PCLK_01 / TIMERB_0_CK2)
#define TIMERB_0_CK3_DIV (TIMERB_PCLK_01 / TIMERB_0_CK3)
#define TIMERB_1_CK0_DIV (TIMERB_PCLK_01 / TIMERB_1_CK0)
#define TIMERB_1_CK1_DIV (TIMERB_PCLK_01 / TIMERB_1_CK1)
#define TIMERB_1_CK2_DIV (TIMERB_PCLK_01 / TIMERB_1_CK2)
#define TIMERB_1_CK3_DIV (TIMERB_PCLK_01 / TIMERB_1_CK3)
#define TIMERB_2_CK0_DIV (TIMERB_PCLK_2 / TIMERB_2_CK0)
#define TIMERB_2_CK1_DIV (TIMERB_PCLK_2 / TIMERB_2_CK1)
#define TIMERB_2_CK2_DIV (TIMERB_PCLK_2 / TIMERB_2_CK2)
#define TIMERB_2_CK3_DIV (TIMERB_PCLK_2 / TIMERB_2_CK3)

/*-------------------------------------------*/

#if (TIMERB_0_CK0_DIV == 1U)
#define TIMERB_0_CK0_DIV_COE 0U
#elif (TIMERB_0_CK0_DIV == 2U)
#define TIMERB_0_CK0_DIV_COE 1U
#elif (TIMERB_0_CK0_DIV == 4U)
#define TIMERB_0_CK0_DIV_COE 2U
#elif (TIMERB_0_CK0_DIV == 8U)
#define TIMERB_0_CK0_DIV_COE 3U
#elif (TIMERB_0_CK0_DIV == 16U)
#define TIMERB_0_CK0_DIV_COE 4U
#elif (TIMERB_0_CK0_DIV == 32U)
#define TIMERB_0_CK0_DIV_COE 5U
#elif (TIMERB_0_CK0_DIV == 64U)
#define TIMERB_0_CK0_DIV_COE 6U
#elif (TIMERB_0_CK0_DIV == 128U)
#define TIMERB_0_CK0_DIV_COE 7U
#elif (TIMERB_0_CK0_DIV == 256U)
#define TIMERB_0_CK0_DIV_COE 8U
#elif (TIMERB_0_CK0_DIV == 512U)
#define TIMERB_0_CK0_DIV_COE 9U
#elif (TIMERB_0_CK0_DIV == 1024U)
#define TIMERB_0_CK0_DIV_COE 10U
#elif (TIMERB_0_CK0_DIV == 2048U)
#define TIMERB_0_CK0_DIV_COE 11U
#elif (TIMERB_0_CK0_DIV == 4096U)
#define TIMERB_0_CK0_DIV_COE 12U
#elif (TIMERB_0_CK0_DIV == 8192U)
#define TIMERB_0_CK0_DIV_COE 13U
#elif (TIMERB_0_CK0_DIV == 16384U)
#define TIMERB_0_CK0_DIV_COE 14U
#elif (TIMERB_0_CK0_DIV == 32768U)
#define TIMERB_0_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK1_DIV == 1U)
#define TIMERB_0_CK1_DIV_COE 0U
#elif (TIMERB_0_CK1_DIV == 2U)
#define TIMERB_0_CK1_DIV_COE 1U
#elif (TIMERB_0_CK1_DIV == 4U)
#define TIMERB_0_CK1_DIV_COE 2U
#elif (TIMERB_0_CK1_DIV == 8U)
#define TIMERB_0_CK1_DIV_COE 3U
#elif (TIMERB_0_CK1_DIV == 16U)
#define TIMERB_0_CK1_DIV_COE 4U
#elif (TIMERB_0_CK1_DIV == 32U)
#define TIMERB_0_CK1_DIV_COE 5U
#elif (TIMERB_0_CK1_DIV == 64U)
#define TIMERB_0_CK1_DIV_COE 6U
#elif (TIMERB_0_CK1_DIV == 128U)
#define TIMERB_0_CK1_DIV_COE 7U
#elif (TIMERB_0_CK1_DIV == 256U)
#define TIMERB_0_CK1_DIV_COE 8U
#elif (TIMERB_0_CK1_DIV == 512U)
#define TIMERB_0_CK1_DIV_COE 9U
#elif (TIMERB_0_CK1_DIV == 1024U)
#define TIMERB_0_CK1_DIV_COE 10U
#elif (TIMERB_0_CK1_DIV == 2048U)
#define TIMERB_0_CK1_DIV_COE 11U
#elif (TIMERB_0_CK1_DIV == 4096U)
#define TIMERB_0_CK1_DIV_COE 12U
#elif (TIMERB_0_CK1_DIV == 8192U)
#define TIMERB_0_CK1_DIV_COE 13U
#elif (TIMERB_0_CK1_DIV == 16384U)
#define TIMERB_0_CK1_DIV_COE 14U
#elif (TIMERB_0_CK1_DIV == 32768U)
#define TIMERB_0_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK2_DIV == 1U)
#define TIMERB_0_CK2_DIV_COE 0U
#elif (TIMERB_0_CK2_DIV == 2U)
#define TIMERB_0_CK2_DIV_COE 1U
#elif (TIMERB_0_CK2_DIV == 4U)
#define TIMERB_0_CK2_DIV_COE 2U
#elif (TIMERB_0_CK2_DIV == 8U)
#define TIMERB_0_CK2_DIV_COE 3U
#elif (TIMERB_0_CK2_DIV == 16U)
#define TIMERB_0_CK2_DIV_COE 4U
#elif (TIMERB_0_CK2_DIV == 32U)
#define TIMERB_0_CK2_DIV_COE 5U
#elif (TIMERB_0_CK2_DIV == 64U)
#define TIMERB_0_CK2_DIV_COE 6U
#elif (TIMERB_0_CK2_DIV == 128U)
#define TIMERB_0_CK2_DIV_COE 7U
#elif (TIMERB_0_CK2_DIV == 256U)
#define TIMERB_0_CK2_DIV_COE 8U
#elif (TIMERB_0_CK2_DIV == 512U)
#define TIMERB_0_CK2_DIV_COE 9U
#elif (TIMERB_0_CK2_DIV == 1024U)
#define TIMERB_0_CK2_DIV_COE 10U
#elif (TIMERB_0_CK2_DIV == 2048U)
#define TIMERB_0_CK2_DIV_COE 11U
#elif (TIMERB_0_CK2_DIV == 4096U)
#define TIMERB_0_CK2_DIV_COE 12U
#elif (TIMERB_0_CK2_DIV == 8192U)
#define TIMERB_0_CK2_DIV_COE 13U
#elif (TIMERB_0_CK2_DIV == 16384U)
#define TIMERB_0_CK2_DIV_COE 14U
#elif (TIMERB_0_CK2_DIV == 32768U)
#define TIMERB_0_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_0_CK3_DIV == 1U)
#define TIMERB_0_CK3_DIV_COE 0U
#elif (TIMERB_0_CK3_DIV == 2U)
#define TIMERB_0_CK3_DIV_COE 1U
#elif (TIMERB_0_CK3_DIV == 4U)
#define TIMERB_0_CK3_DIV_COE 2U
#elif (TIMERB_0_CK3_DIV == 8U)
#define TIMERB_0_CK3_DIV_COE 3U
#elif (TIMERB_0_CK3_DIV == 16U)
#define TIMERB_0_CK3_DIV_COE 4U
#elif (TIMERB_0_CK3_DIV == 32U)
#define TIMERB_0_CK3_DIV_COE 5U
#elif (TIMERB_0_CK3_DIV == 64U)
#define TIMERB_0_CK3_DIV_COE 6U
#elif (TIMERB_0_CK3_DIV == 128U)
#define TIMERB_0_CK3_DIV_COE 7U
#elif (TIMERB_0_CK3_DIV == 256U)
#define TIMERB_0_CK3_DIV_COE 8U
#elif (TIMERB_0_CK3_DIV == 512U)
#define TIMERB_0_CK3_DIV_COE 9U
#elif (TIMERB_0_CK3_DIV == 1024U)
#define TIMERB_0_CK3_DIV_COE 10U
#elif (TIMERB_0_CK3_DIV == 2048U)
#define TIMERB_0_CK3_DIV_COE 11U
#elif (TIMERB_0_CK3_DIV == 4096U)
#define TIMERB_0_CK3_DIV_COE 12U
#elif (TIMERB_0_CK3_DIV == 8192U)
#define TIMERB_0_CK3_DIV_COE 13U
#elif (TIMERB_0_CK3_DIV == 16384U)
#define TIMERB_0_CK3_DIV_COE 14U
#elif (TIMERB_0_CK3_DIV == 32768U)
#define TIMERB_0_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK0_DIV == 1U)
#define TIMERB_1_CK0_DIV_COE 0U
#elif (TIMERB_1_CK0_DIV == 2U)
#define TIMERB_1_CK0_DIV_COE 1U
#elif (TIMERB_1_CK0_DIV == 4U)
#define TIMERB_1_CK0_DIV_COE 2U
#elif (TIMERB_1_CK0_DIV == 8U)
#define TIMERB_1_CK0_DIV_COE 3U
#elif (TIMERB_1_CK0_DIV == 16U)
#define TIMERB_1_CK0_DIV_COE 4U
#elif (TIMERB_1_CK0_DIV == 32U)
#define TIMERB_1_CK0_DIV_COE 5U
#elif (TIMERB_1_CK0_DIV == 64U)
#define TIMERB_1_CK0_DIV_COE 6U
#elif (TIMERB_1_CK0_DIV == 128U)
#define TIMERB_1_CK0_DIV_COE 7U
#elif (TIMERB_1_CK0_DIV == 256U)
#define TIMERB_1_CK0_DIV_COE 8U
#elif (TIMERB_1_CK0_DIV == 512U)
#define TIMERB_1_CK0_DIV_COE 9U
#elif (TIMERB_1_CK0_DIV == 1024U)
#define TIMERB_1_CK0_DIV_COE 10U
#elif (TIMERB_1_CK0_DIV == 2048U)
#define TIMERB_1_CK0_DIV_COE 11U
#elif (TIMERB_1_CK0_DIV == 4096U)
#define TIMERB_1_CK0_DIV_COE 12U
#elif (TIMERB_1_CK0_DIV == 8192U)
#define TIMERB_1_CK0_DIV_COE 13U
#elif (TIMERB_1_CK0_DIV == 16384U)
#define TIMERB_1_CK0_DIV_COE 14U
#elif (TIMERB_1_CK0_DIV == 32768U)
#define TIMERB_1_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK1_DIV == 1U)
#define TIMERB_1_CK1_DIV_COE 0U
#elif (TIMERB_1_CK1_DIV == 2U)
#define TIMERB_1_CK1_DIV_COE 1U
#elif (TIMERB_1_CK1_DIV == 4U)
#define TIMERB_1_CK1_DIV_COE 2U
#elif (TIMERB_1_CK1_DIV == 8U)
#define TIMERB_1_CK1_DIV_COE 3U
#elif (TIMERB_1_CK1_DIV == 16U)
#define TIMERB_1_CK1_DIV_COE 4U
#elif (TIMERB_1_CK1_DIV == 32U)
#define TIMERB_1_CK1_DIV_COE 5U
#elif (TIMERB_1_CK1_DIV == 64U)
#define TIMERB_1_CK1_DIV_COE 6U
#elif (TIMERB_1_CK1_DIV == 128U)
#define TIMERB_1_CK1_DIV_COE 7U
#elif (TIMERB_1_CK1_DIV == 256U)
#define TIMERB_1_CK1_DIV_COE 8U
#elif (TIMERB_1_CK1_DIV == 512U)
#define TIMERB_1_CK1_DIV_COE 9U
#elif (TIMERB_1_CK1_DIV == 1024U)
#define TIMERB_1_CK1_DIV_COE 10U
#elif (TIMERB_1_CK1_DIV == 2048U)
#define TIMERB_1_CK1_DIV_COE 11U
#elif (TIMERB_1_CK1_DIV == 4096U)
#define TIMERB_1_CK1_DIV_COE 12U
#elif (TIMERB_1_CK1_DIV == 8192U)
#define TIMERB_1_CK1_DIV_COE 13U
#elif (TIMERB_1_CK1_DIV == 16384U)
#define TIMERB_1_CK1_DIV_COE 14U
#elif (TIMERB_1_CK1_DIV == 32768U)
#define TIMERB_1_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK2_DIV == 1U)
#define TIMERB_1_CK2_DIV_COE 0U
#elif (TIMERB_1_CK2_DIV == 2U)
#define TIMERB_1_CK2_DIV_COE 1U
#elif (TIMERB_1_CK2_DIV == 4U)
#define TIMERB_1_CK2_DIV_COE 2U
#elif (TIMERB_1_CK2_DIV == 8U)
#define TIMERB_1_CK2_DIV_COE 3U
#elif (TIMERB_1_CK2_DIV == 16U)
#define TIMERB_1_CK2_DIV_COE 4U
#elif (TIMERB_1_CK2_DIV == 32U)
#define TIMERB_1_CK2_DIV_COE 5U
#elif (TIMERB_1_CK2_DIV == 64U)
#define TIMERB_1_CK2_DIV_COE 6U
#elif (TIMERB_1_CK2_DIV == 128U)
#define TIMERB_1_CK2_DIV_COE 7U
#elif (TIMERB_1_CK2_DIV == 256U)
#define TIMERB_1_CK2_DIV_COE 8U
#elif (TIMERB_1_CK2_DIV == 512U)
#define TIMERB_1_CK2_DIV_COE 9U
#elif (TIMERB_1_CK2_DIV == 1024U)
#define TIMERB_1_CK2_DIV_COE 10U
#elif (TIMERB_1_CK2_DIV == 2048U)
#define TIMERB_1_CK2_DIV_COE 11U
#elif (TIMERB_1_CK2_DIV == 4096U)
#define TIMERB_1_CK2_DIV_COE 12U
#elif (TIMERB_1_CK2_DIV == 8192U)
#define TIMERB_1_CK2_DIV_COE 13U
#elif (TIMERB_1_CK2_DIV == 16384U)
#define TIMERB_1_CK2_DIV_COE 14U
#elif (TIMERB_1_CK2_DIV == 32768U)
#define TIMERB_1_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK3_DIV == 1U)
#define TIMERB_1_CK3_DIV_COE 0U
#elif (TIMERB_1_CK3_DIV == 2U)
#define TIMERB_1_CK3_DIV_COE 1U
#elif (TIMERB_1_CK3_DIV == 4U)
#define TIMERB_1_CK3_DIV_COE 2U
#elif (TIMERB_1_CK3_DIV == 8U)
#define TIMERB_1_CK3_DIV_COE 3U
#elif (TIMERB_1_CK3_DIV == 16U)
#define TIMERB_1_CK3_DIV_COE 4U
#elif (TIMERB_1_CK3_DIV == 32U)
#define TIMERB_1_CK3_DIV_COE 5U
#elif (TIMERB_1_CK3_DIV == 64U)
#define TIMERB_1_CK3_DIV_COE 6U
#elif (TIMERB_1_CK3_DIV == 128U)
#define TIMERB_1_CK3_DIV_COE 7U
#elif (TIMERB_1_CK3_DIV == 256U)
#define TIMERB_1_CK3_DIV_COE 8U
#elif (TIMERB_1_CK3_DIV == 512U)
#define TIMERB_1_CK3_DIV_COE 9U
#elif (TIMERB_1_CK3_DIV == 1024U)
#define TIMERB_1_CK3_DIV_COE 10U
#elif (TIMERB_1_CK3_DIV == 2048U)
#define TIMERB_1_CK3_DIV_COE 11U
#elif (TIMERB_1_CK3_DIV == 4096U)
#define TIMERB_1_CK3_DIV_COE 12U
#elif (TIMERB_1_CK3_DIV == 8192U)
#define TIMERB_1_CK3_DIV_COE 13U
#elif (TIMERB_1_CK3_DIV == 16384U)
#define TIMERB_1_CK3_DIV_COE 14U
#elif (TIMERB_1_CK3_DIV == 32768U)
#define TIMERB_1_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK0_DIV == 1U)
#define TIMERB_2_CK0_DIV_COE 0U
#elif (TIMERB_2_CK0_DIV == 2U)
#define TIMERB_2_CK0_DIV_COE 1U
#elif (TIMERB_2_CK0_DIV == 4U)
#define TIMERB_2_CK0_DIV_COE 2U
#elif (TIMERB_2_CK0_DIV == 8U)
#define TIMERB_2_CK0_DIV_COE 3U
#elif (TIMERB_2_CK0_DIV == 16U)
#define TIMERB_2_CK0_DIV_COE 4U
#elif (TIMERB_2_CK0_DIV == 32U)
#define TIMERB_2_CK0_DIV_COE 5U
#elif (TIMERB_2_CK0_DIV == 64U)
#define TIMERB_2_CK0_DIV_COE 6U
#elif (TIMERB_2_CK0_DIV == 128U)
#define TIMERB_2_CK0_DIV_COE 7U
#elif (TIMERB_2_CK0_DIV == 256U)
#define TIMERB_2_CK0_DIV_COE 8U
#elif (TIMERB_2_CK0_DIV == 512U)
#define TIMERB_2_CK0_DIV_COE 9U
#elif (TIMERB_2_CK0_DIV == 1024U)
#define TIMERB_2_CK0_DIV_COE 10U
#elif (TIMERB_2_CK0_DIV == 2048U)
#define TIMERB_2_CK0_DIV_COE 11U
#elif (TIMERB_2_CK0_DIV == 4096U)
#define TIMERB_2_CK0_DIV_COE 12U
#elif (TIMERB_2_CK0_DIV == 8192U)
#define TIMERB_2_CK0_DIV_COE 13U
#elif (TIMERB_2_CK0_DIV == 16384U)
#define TIMERB_2_CK0_DIV_COE 14U
#elif (TIMERB_2_CK0_DIV == 32768U)
#define TIMERB_2_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK1_DIV == 1U)
#define TIMERB_2_CK1_DIV_COE 0U
#elif (TIMERB_2_CK1_DIV == 2U)
#define TIMERB_2_CK1_DIV_COE 1U
#elif (TIMERB_2_CK1_DIV == 4U)
#define TIMERB_2_CK1_DIV_COE 2U
#elif (TIMERB_2_CK1_DIV == 8U)
#define TIMERB_2_CK1_DIV_COE 3U
#elif (TIMERB_2_CK1_DIV == 16U)
#define TIMERB_2_CK1_DIV_COE 4U
#elif (TIMERB_2_CK1_DIV == 32U)
#define TIMERB_2_CK1_DIV_COE 5U
#elif (TIMERB_2_CK1_DIV == 64U)
#define TIMERB_2_CK1_DIV_COE 6U
#elif (TIMERB_2_CK1_DIV == 128U)
#define TIMERB_2_CK1_DIV_COE 7U
#elif (TIMERB_2_CK1_DIV == 256U)
#define TIMERB_2_CK1_DIV_COE 8U
#elif (TIMERB_2_CK1_DIV == 512U)
#define TIMERB_2_CK1_DIV_COE 9U
#elif (TIMERB_2_CK1_DIV == 1024U)
#define TIMERB_2_CK1_DIV_COE 10U
#elif (TIMERB_2_CK1_DIV == 2048U)
#define TIMERB_2_CK1_DIV_COE 11U
#elif (TIMERB_2_CK1_DIV == 4096U)
#define TIMERB_2_CK1_DIV_COE 12U
#elif (TIMERB_2_CK1_DIV == 8192U)
#define TIMERB_2_CK1_DIV_COE 13U
#elif (TIMERB_2_CK1_DIV == 16384U)
#define TIMERB_2_CK1_DIV_COE 14U
#elif (TIMERB_2_CK1_DIV == 32768U)
#define TIMERB_2_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK2_DIV == 1U)
#define TIMERB_2_CK2_DIV_COE 0U
#elif (TIMERB_2_CK2_DIV == 2U)
#define TIMERB_2_CK2_DIV_COE 1U
#elif (TIMERB_2_CK2_DIV == 4U)
#define TIMERB_2_CK2_DIV_COE 2U
#elif (TIMERB_2_CK2_DIV == 8U)
#define TIMERB_2_CK2_DIV_COE 3U
#elif (TIMERB_2_CK2_DIV == 16U)
#define TIMERB_2_CK2_DIV_COE 4U
#elif (TIMERB_2_CK2_DIV == 32U)
#define TIMERB_2_CK2_DIV_COE 5U
#elif (TIMERB_2_CK2_DIV == 64U)
#define TIMERB_2_CK2_DIV_COE 6U
#elif (TIMERB_2_CK2_DIV == 128U)
#define TIMERB_2_CK2_DIV_COE 7U
#elif (TIMERB_2_CK2_DIV == 256U)
#define TIMERB_2_CK2_DIV_COE 8U
#elif (TIMERB_2_CK2_DIV == 512U)
#define TIMERB_2_CK2_DIV_COE 9U
#elif (TIMERB_2_CK2_DIV == 1024U)
#define TIMERB_2_CK2_DIV_COE 10U
#elif (TIMERB_2_CK2_DIV == 2048U)
#define TIMERB_2_CK2_DIV_COE 11U
#elif (TIMERB_2_CK2_DIV == 4096U)
#define TIMERB_2_CK2_DIV_COE 12U
#elif (TIMERB_2_CK2_DIV == 8192U)
#define TIMERB_2_CK2_DIV_COE 13U
#elif (TIMERB_2_CK2_DIV == 16384U)
#define TIMERB_2_CK2_DIV_COE 14U
#elif (TIMERB_2_CK2_DIV == 32768U)
#define TIMERB_2_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK3_DIV == 1U)
#define TIMERB_2_CK3_DIV_COE 0U
#elif (TIMERB_2_CK3_DIV == 2U)
#define TIMERB_2_CK3_DIV_COE 1U
#elif (TIMERB_2_CK3_DIV == 4U)
#define TIMERB_2_CK3_DIV_COE 2U
#elif (TIMERB_2_CK3_DIV == 8U)
#define TIMERB_2_CK3_DIV_COE 3U
#elif (TIMERB_2_CK3_DIV == 16U)
#define TIMERB_2_CK3_DIV_COE 4U
#elif (TIMERB_2_CK3_DIV == 32U)
#define TIMERB_2_CK3_DIV_COE 5U
#elif (TIMERB_2_CK3_DIV == 64U)
#define TIMERB_2_CK3_DIV_COE 6U
#elif (TIMERB_2_CK3_DIV == 128U)
#define TIMERB_2_CK3_DIV_COE 7U
#elif (TIMERB_2_CK3_DIV == 256U)
#define TIMERB_2_CK3_DIV_COE 8U
#elif (TIMERB_2_CK3_DIV == 512U)
#define TIMERB_2_CK3_DIV_COE 9U
#elif (TIMERB_2_CK3_DIV == 1024U)
#define TIMERB_2_CK3_DIV_COE 10U
#elif (TIMERB_2_CK3_DIV == 2048U)
#define TIMERB_2_CK3_DIV_COE 11U
#elif (TIMERB_2_CK3_DIV == 4096U)
#define TIMERB_2_CK3_DIV_COE 12U
#elif (TIMERB_2_CK3_DIV == 8192U)
#define TIMERB_2_CK3_DIV_COE 13U
#elif (TIMERB_2_CK3_DIV == 16384U)
#define TIMERB_2_CK3_DIV_COE 14U
#elif (TIMERB_2_CK3_DIV == 32768U)
#define TIMERB_2_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

static const uint32_t u32TimerBClockArray[12U] =
{
    TIMERB_0_CK0,
    TIMERB_0_CK1,
    TIMERB_0_CK2,
    TIMERB_0_CK3,
    TIMERB_1_CK0,
    TIMERB_1_CK1,
    TIMERB_1_CK2,
    TIMERB_1_CK3,
    TIMERB_2_CK0,
    TIMERB_2_CK1,
    TIMERB_2_CK2,
    TIMERB_2_CK3,

};
/*-------------------------------------------------------*/

/*-----------------------------------------*/
void TimerB_PWM_Init(void);
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock);
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre);
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty);
void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);

/*----------------------------------------------*/
void TimerB_PWM_Init(void)
{
    uint16_t u16TimeCount = 0U;
    /*stop all clk*/
    TAUB0TT = 0xFFFFU;
    TAUB1TT = 0xFFFFU;
    TAUB2TT = 0xFFFFU;

    do
    {
        u16TimeCount++;
    }
    while (((TAUB0TE) || (TAUB1TE) || (TAUB2TE)) && (u16TimeCount < TIMERB_TIMEROUT_MAX));
    if (u16TimeCount < TIMERB_TIMEROUT_MAX)
    {
        /*CLK0~3 =PCLK */
        TAUB0TPS = ((TIMERB_0_CK3_DIV_COE << 12U) | (TIMERB_0_CK2_DIV_COE << 8U) | (TIMERB_0_CK1_DIV_COE << 4U) | (TIMERB_0_CK0_DIV_COE));
        TAUB1TPS = ((TIMERB_1_CK3_DIV_COE << 12U) | (TIMERB_1_CK2_DIV_COE << 8U) | (TIMERB_1_CK1_DIV_COE << 4U) | (TIMERB_1_CK0_DIV_COE));
        TAUB2TPS = ((TIMERB_2_CK3_DIV_COE << 12U) | (TIMERB_2_CK2_DIV_COE << 8U) | (TIMERB_2_CK1_DIV_COE << 4U) | (TIMERB_2_CK0_DIV_COE));
    }
}
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x801U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    /*control*/
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR2 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = 0U;
    /*TAUB0CMUR2 = 0U;*/

    /*output mode*/

    /*Simultaneous rewrite */
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
    /*TAUB0RDE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDS &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDM &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDC &= (~u16TimerBbit);*/
}
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x409U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR3 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = 0U;
    /*TAUB0CMUR3 = 0U;*/

    /*output mode*/
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
    *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    /*TAUB0TOE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X248U;
    *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    /*TAUB0TOM |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X24CU;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TOC &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
    if (enTimerBPolarity == TIMERB_HIGH)
    {
        /*TAUB0TOL &= (~u16TimerBbit);*/
        *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    }
    else
    {
        /*TAUB0TOL |= u16TimerBbit;*/
        *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    }

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X250U;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TDE &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X54U;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TDL &= (~u16TimerBbit);*/

    /*Simultaneous rewrite */
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
    /*TAUB0RDE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDS &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDM &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDC &= (~u16TimerBbit);*/
}

/* 返回初始化状态。1：成功。0：失败
	输出要设置的通道，通道选择的时钟源，通道有效时输出的极性*/
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{

    uint8_t u8TimerBResult = 0U;

    if ((enTimerBChannel % 2))
    {
        u8TimerBResult = 1U;
        TimerB_PWM_Master_Channel_Init(enTimerBChannel - 1U, enTimerBClock);
        TimerB_PWM_Slave_Channel_Init(enTimerBChannel, enTimerBClock, enTimerBPolarity);
    }

    return u8TimerBResult;
}

/* 返回实际设置成功的频率，如果返回0表示错误。*/
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre)
{

    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - 1U)) * 3U;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);

    uint8_t u8TimerBClockSel = (uint8_t)(((*((uint16_t *)u32TimerBRegAddrChannel))) >> 14U);
    uint8_t u8TimerBClockIndex = u8TimerBIndex * 4U + u8TimerBClockSel;
    uint32_t u32TimerBClockFre = u32TimerBClockArray[u8TimerBClockIndex];
    uint16_t u16CalBuf = (u32TimerBClockFre / u16Fre);
    uint32_t u32CalBufPeriod = 0U;
    uint32_t u32CalBufDuty = 0U;
    uint32_t u32CalFre = 0U;
    uint32_t u32Duty = 0U;
    if (enTimerBChannel % 2U)
    {
        u32CalFre = (u32TimerBClockFre / u16CalBuf);

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel));

        u32CalBufDuty = (*((uint16_t *)u32TimerBRegAddrChannel));
        /*u32CalBufDuty = TAUB0CDR3;*/

        u32CalBufPeriod = (*((uint16_t *)(u32TimerBRegAddrChannel - 4U)));
        /*u32CalBufPeriod = TAUB0CDR2;*/

        u32Duty = (u32CalBufDuty * 100000U) / (u32CalBufPeriod + 1U);

        (*((uint16_t *)(u32TimerBRegAddrChannel - 4U))) = u16CalBuf - 1U;
        /*TAUB0CDR2 = u16CalBuf - 1U;  // fre*/

        (*((uint16_t *)u32TimerBRegAddrChannel)) = (u32Duty * u16CalBuf / 100000U);
        /*TAUB0CDR3 = (u32Duty * u16CalBuf / 100000U); //  duty*/

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
        (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
        /*TAUB0RDT = (u16TimerBbit);*/
    }
    return u32CalFre;
}
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - 1U)) * 3U;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel - 1U));

    uint32_t u32CalBuf = (*((uint16_t *)u32TimerBRegAddrChannel)) + 1U;
    /*	uint32_t u32CalBuf = TAUB0CDR2 + 1U;*/

    if (enTimerBChannel % 2U)
    {
        (*((uint16_t *)(u32TimerBRegAddrChannel + 4U))) = (u32CalBuf * u16Duty / 1000U);
        /*TAUB0CDR3 = (u32CalBuf * u16Duty / 100U); */ /*duty*/

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
        (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
        /*TAUB0RDT = (u16TimerBbit);*/
    }
}

void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - 1U)) * 3U;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C4U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*	TAUB0TS = (u16TimerBbit);*/
}
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - 1U));

	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*TAUB0TT = (u16TimerBbit);*/
}
/*仅休眠时可调用*/
void TimerB_PWM_Channel_Sleep(TIMERB_Channel_en_t enTimerBChannel)
{
	uint8_t u8TimerBIndex = enTimerBChannel / 16U;
	uint8_t u8TimerBChannel = enTimerBChannel % 16U;
	uint16_t u16TimerBbit = (1U << (u8TimerBChannel - 1U)) * 3U;
	uint16_t u16TimerBRegTOL = 0U;
	uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
	uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

	(*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
	/*TAUB0TT = (u16TimerBbit);*/

	u16TimerBbit = u16TimerBbit * 2U / 3U;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
	u16TimerBRegTOL = (*((uint16_t *)u32TimerBRegAddrChannel));
	/*u16TimerBRegTOL=TAUB0TOL*/
	u16TimerBRegTOL &= u16TimerBbit;

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
	*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
	/*TAUB0TOE &= ~u16TimerBbit;*/

	u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X58U;

	if (u16TimerBRegTOL)
	{
		*((uint16_t *)u32TimerBRegAddrChannel) |= (u16TimerBbit);
		/*TAUB0TO |= u16TimerBbit;*/
	}
	else
	{
		*((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
		/*TAUB0TO &= ~u16TimerBbit;*/
	}
}


