
#ifndef GAUGES_INTERFACE_H_
#define GAUGES_INTERFACE_H_

#include "Gauges.h"

typedef enum
{
    VehGauges = 0u,
    RevGauges,
    TempGauges,
    FuelGauges,
    GasGauges_1, /*气压1*/
    GasGauges_2, /*气压2*/
    GaugesTotal,
} _GaugesNum;

extern _GaugesInfoInit GaugesInfo_Init_Table[GaugesTotal];

typedef struct
{
    uint16_t Count;
    uint16_t DataBuf[15];
    uint16_t DataDisplay;
    uint8_t  Valid;
    uint16_t LostTimer;
} DataStruct;

extern DataStruct DataStrGas1;
extern DataStruct DataStrGas2;
extern DataStruct DataStrVoltage;


extern uint16_t RealDataIn[GaugesTotal];
extern void SetGaugesPara(uint8_t GaugesID, uint16_t GaugesVal); /* 传递表头参数 */
extern void UserGaugeSchedule(void);/*在主循环中调用*/
extern void UserGaugeK30Init(void);/*30电调用*/
extern void UserGaugeK15Init(void) ;/*15电调用*/
extern uint16_t VehSpeedAmplification(uint16_t Speed);/* 车速放大函数 */
extern uint16_t RevSpeedManage(uint16_t Speed);/* 转速数据处理数据 */
extern uint16_t GetGaugesMaxOutVal(uint8_t GaugesID);/*传递表头ID获取仪表最大指示值*/
extern void SetGaugesUpVal(uint8_t GaugesID, uint16_t GaugesUpVal[]); /*调表设置参数用*/
extern void SetGaugesDownVal(uint8_t GaugesID, uint16_t GaugesDownVal[]); /*调表设置参数用*/
extern void SetGaugesOutVal(uint8_t GaugesID, uint16_t GaugesOutVal[]); /*调表设置参数用*/
/*设置FreeMoveType模式仪表走动时间*/
extern void SetFreeMoveTimes(uint16_t GaugesMoveTimes);
/*通过车速目标步得到实际车速*/
extern uint16_t GetVehDisVal(uint16_t VehCurPos, _GaugesInfoInit *GParam);
/*车速频率计算初始化*/
extern void Veh_Fre_Init(void);
/*计算周期*/
extern void Cal_Veh_Cycle(uint8_t VehInput);
/*计算车速频率*/
extern uint16_t Cal_Veh_Fre(void);
/*通过频率计算车速*/
extern uint16_t Cal_Veh_Val(void);

void TRIP_FuelConsump(void);
extern void Data_Init_KL15ON(void);
extern void Data_Group_Processing_Service(void);
extern void Data_Gas2_Processing_Service(void);
extern void Data_Gas1_Processing_Service(void);
extern void Data_CoolantTemperatue_Processing_Service(void);
extern void Data_Fuel_Processing_Service(void);
extern void Data_ESpeed_LED_Processing_Service(void);
extern void Data_BatteryCapacity_Processing_Service(void);

extern uint16_t GetEspeedConfigGreenStart(void);
extern uint16_t GetEspeedConfigGreenStop(void);

extern uint8_t getData_Fuel_InvalFlag(void);

#endif
