#ifndef KEY_H__
#define KEY_H__

#include "TYW_stdint.h"

/*
说明：
1、按键类型分为两类：
	1）CAN按键。
	2）单纯硬线按键，AD按键。
2、按键触发时间：
1）短按动作在抬手时触发、
2）长按动作在时间达到，按住时就可触发。

*/
/*所有按键枚举*/
typedef enum
{
	KEY_LEFT = 0U,
	KEY_RIGHT,
	KEY_ENTER,
	KEY_RETURN,
	KEY_UP,
	KEY_DOWN,
	KEY_FUNCTION,
	KEY_NUM_MAX,

} Key_Num_en_t;

/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
typedef enum
{
	KEY_TYPE_CAN = 0U, /*CAN按键*/
	KEY_TYPE_LINE,	   /*硬线按键，包含AD按键*/
} Key_Type_en_t;

typedef enum
{
	KEY_SET_OK = 0U,
	KEY_SET_ERROR,

	KEY_SET_MAX,
} Key_Set_en_t;
/*-----实时传入的键值--------*/
typedef enum
{
	KEY_CAN_NONE = 0U,	 /*CAN按键时，按键无动作*/
	KEY_CAN_SHORT_PRESS, /*CAN按键时，按键短按动作*/
	KEY_CAN_LONG_PRESS,	 /*CAN按键时，按键长按动作*/
	KEY_LINE_PRESS,		 /*硬线按键时，按键按下*/
	KEY_LINE_LOOSEN,	 /*硬线按键时，按键松开*/

	KEY_REAL_STATUS_MAX,

} Key_Real_Status_en_t;
/*按键具体动作*/
typedef enum
{
	KEY_EVENT_NONE = 0U,
	KEY_EVENT_SHORT_PRESS,
	KEY_EVENT_LONG_PRESS,
	KEY_EVENT_SUPER_LONG_PRESS,

	KEY_EVENT_MAX,

} Key_Event_en_t;

typedef Key_Real_Status_en_t (*Key_Real_Status_Read)(void);
typedef void (*Key_Operation)(Key_Event_en_t enKeyEvent);

/*每个按键的属性*/
typedef struct
{
	/*按键类型，是CAN的还是硬线的*/
	Key_Type_en_t enKeyType;
	/*按键实时状态的变量指针*/
	Key_Real_Status_Read pfnKeyReadStatusCallBack;
	/*按键回调函数*/
	Key_Operation pfnKeyOperationCallBack;

} Key_Attribute_st_t;

typedef enum
{
    Clock_Minute = 0u,
    Clock_Hour,
    
	Clock_Max,
} clock_en_t;

typedef enum
{
    Mileage_ODO = 0u,
    Mileage_TRIPA,
    Mileage_TRIPB,
    
	Mileage_Max,
} mileag_en_t;

typedef enum
{
    Select_Up = 0u,
    Select_Return,
    Select_Down,
    
	Select_Max,
} select_en_t;

typedef enum
{
    Vhcl_Info_IC = 0u,
    Vhcl_Info_BMS,
    Vhcl_Info_VCU,
    Vhcl_Info_MCU,
    Vhcl_Info_CHG,
    Vhcl_Info_ISL,
    Vhcl_Info_SCU,
	Vhcl_Info_ABS,
	Vhcl_Info_SW,
    Vhcl_Info_RET,

	Vhcl_Info_Max,
} vhcl_info_en_t;

typedef struct
{
    uint8_t Page;
    uint8_t Select;
} _MenuDispStruct;

/*--------------------------------------------------------------------------------------------*/
extern const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX];
extern Key_Real_Status_en_t enKeyLeftRealStatus;
extern Key_Real_Status_en_t enKeyRightRealStatus;
/*------------------------------------------------------------------------------------*/
extern void Display_Info_Init(void);
extern void Display_Info_IgnOnInit(void);
/*10ms调用一次*/
extern void Key_Service(void);
/*首次上电时调用一次即可*/
extern void Key_Init(void);
/*对于硬线按键而言，判断短按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Short_Press_Time(uint16_t u16Time);
/*对于硬线按键而言，判断长按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Long_Press_Time(uint16_t u16Time);
/*对于硬线按键而言，判断超长按的时间参数*/
extern Key_Set_en_t Key_Parameter_Set_Super_Long_Press_Time(uint16_t u16Time);

extern void Key_Turn_Test(void);
extern void Key_Turn_Service(void);

extern uint8_t Info_Select_Get(vhcl_info_en_t info);
extern uint8_t Info_Page_Get(vhcl_info_en_t info);
//extern void Brightness_Service(void);
extern uint8_t Display_Interface_Get(void);
extern uint8_t ClkSetSts_Get(void);
extern uint8_t ClkSetTyp_Get(void);
extern uint8_t ClkSetHour_Get(void);
extern uint8_t ClkSetMinute_Get(void);
extern uint8_t MileType_Get(void);
extern uint8_t MenuSetSts_Get(void);
extern uint8_t MenuSetTyp_Get(void);
extern uint8_t MenuSetGrd_Get(void);
extern uint8_t VhlInfTyp_Get(void);
extern uint8_t ResToDef_Get(void);
extern uint8_t VdoFmtTyp_Get(void);
extern void VdoFmtTyp_Set(uint8_t SetValue);

extern uint8_t LitSpdTyp_Get(void);
extern void LitSpdTyp_Set(uint8_t SetValue);

uint16_t Key3_Press_Time_Get(void);

#endif