#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "Data_VehicleSpeed.h"
#include "Services_Mileage.h"
#include "Data_Gear.h"
#include "Data_Time.h"
#include "Service_IgnOff_Time.h"
#include "RTE_CAN_NM.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "Line_In.h"
#include "Seg_Ref.h"
#include "Key.h"
#include "Services_ODO_User.h"
#include "GaugesInterface.h"
#include "Popup_Scheduler.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "BackLight_APP.h"
#include "Clock.h"
#include "loc_graphics.h"
#include "Watchdog.h"
#include "RTE_CAN.h"
#include "Analog_Signals.h"
#include "Data_DrvMtrSpd.h"
#include "Data_SOC.h"
#include "Data_PWR.h"
#include "AirPressure.h"
#include "Sound_Data.h"
#include "TimerB.h"
#include "None_NM.h"
#include "IIS_MAX98357.h"
#include "BackLight_APP.h"
#include "CAN_Lib.h"
#include "CAN_Communication_Matrix.h"
#include "Line_In_user.h"
#include "TW9990.h"
#include "CVBS.h"
#include "Data_ReversingImage.h"
#include "SEG_DISPLAY.h"
#include "init.h"
#include "IIS_MAX98357.h"
#include "BU98R10.H"

#define POWER_NM_SLEEP  0U
#define POWER_NM_WAKEUP 1U

static uint8_t PowerGetNMStatus(void);

extern uint8_t VCU_VER_NUM[5u];
extern uint8_t MCU_VER_NUM[3u];
extern uint8_t ACM_VER_NUM[3u];
extern uint8_t PDU_VER_NUM[3u];
extern uint8_t DCDC_VER_NUM[3u];
extern uint8_t EHPS_VER_NUM[3u];
extern uint16_t Popup_Current_Msg;

Power_Status_t Power_KL30_Init(void)
{
    Power_Status_t u8PowerSts;
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护开始*/
    ClearNoInitArea();
    Common_DataInit();
    Sys_KL30_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    Telltales_KL30_Init();
    SEG_BUFF_Init();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/
    
    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    AirPressure_KL30_Init();
    DrvMtrSpd_KL30_Init();
    Speed_KL30_Init();
    SOC_KL30_Init();
    DrvMtrPwr_KL30_Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/

    /*里程 大小计部分 刘明月 胡志松 辛雨 维护开始*/
    Service_OFF_Timing_KL30Init();
    Data_User_Mileage_KL30Init();
    /*里程 大小计部分 刘明月 胡志松 辛雨 维护结束*/

    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护开始*/
    Data_Gear_KL30_Init();
    Data_ODO_Clear_KL30Init();
    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护结束*/

    Display_Info_Init();
    
    Sound_Scheduler_Init();
    Sound_Player_Init();
        
    /*报警调度初始化*/
    Popup_Scheduler_Init();
        
    BL_KL30_Init();

    ReversingImage_KL30_Init();
    BL_TFT_Status_Set(1);
    /*if (TrunRight_IN_MCU && TrunLeft_IN_MCU)
    {
        Turn_Delay_Time_Set(0u);
    }
    else*/
    {
        Turn_Delay_Time_Set(20000u);
    }

    if (SYS_OPR_STAT_IGN_OFF)
    {
        BL_Open_Flag_Set(0);
        u8PowerSts = m_IGN_OFF_Init;
    }
    else
    {
        BL_Open_Flag_Set(1);
        u8PowerSts = m_IGN_ON_Init;
    }

    VCU_VER_NUM[0u] = 0xFFu;
    MCU_VER_NUM[0u] = 0xFFu;
    ACM_VER_NUM[0u] = 0xFFu;
    PDU_VER_NUM[0u] = 0xFFu;
    DCDC_VER_NUM[0u] = 0xFFu;
    EHPS_VER_NUM[0u] = 0xFFu;

    Popup_Current_Msg = 0xFFFFu;

    return  u8PowerSts;
}

void Power_Sleep_Init(void)
{
    BL_Sleep();
    
    TW9990_IIC_Sleep();    
    
    V_APOWER_MCU = 0U;
    DC12V_EN_MCU = 0U;
    LP8867_BL_EN = 0U;       /* TFT背光芯片使能 */
    DelayUs(400000);

    PORT_ISOPCR45_0 = 0x00000000ul;
    PORT_ISOPCR45_1 = 0x00000000ul;
    PORT_ISOPCR45_2 = 0x00000000ul;
    PORT_ISOPCR45_3 = 0x00000000ul;
    PORT_ISOPCR45_4 = 0x00000000ul;
    PORT_ISOPCR45_5 = 0x00000000ul;
    PORT_ISOPCR45_6 = 0x00000000ul;
    PORT_ISOPCR45_7 = 0x00000000ul;
    PORT_ISOPCR45_8 = 0x00000000ul;
    PORT_ISOPCR45_9 = 0x00000000ul;
    
    MP1530_EN_MCU = 0U;      /* TFT供电使能 */
    DelayUs(75000);
    
    GRB_LCD_MCU = 0U;        /* TFT RST */
    DelayUs(20000);
    
    LCD3V3_EN_MCU = 0U;      /* 3.3V电源使能 */
       
    VCC18_EN_MCU  = 0U;      /* 5V转1.8V使能 */
 
    //GPIO_Init(GPIO_SLEEP_MODE);
}

Power_Status_t Power_Wakeup_Init ( void )
{
    Power_Status_t u8PowerSts;
    
    Common_DataInit();
    Sys_WakeUp_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    //Telltales_KL30_Init(); 与Telltales_Wakeup_Init重复
    SEG_BUFF_Init();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/
    Telltales_Wakeup_Init();
    Data_User_Mileage_KL15Init();
    
    /*报警调度初始化*/
    Popup_Scheduler_Init();
    /*报警调度初始化*/
    Sound_Scheduler_Init();
    Sound_Player_Init();
    BL_TFT_Status_Set(1);
    /*if (TrunRight_IN_MCU && TrunLeft_IN_MCU)
    {
        Turn_Delay_Time_Set(0u);
    }
    else*/
    {
        Turn_Delay_Time_Set(20000u);
    }

    if (SYS_OPR_STAT_IGN_OFF)
    {
        u8PowerSts = m_IGN_OFF_Init;
        BL_Open_Flag_Set(0);
    }
    else
    {
        u8PowerSts = m_IGN_ON_Init;
        BL_Open_Flag_Set(1);
    }

    Popup_Current_Msg = 0xFFFFu;
     
    return  u8PowerSts;
}

void Power_IG_OFF_Init(void)
{
    Line_In_KL15_OFF_Init();
    /*end*/
    //ReversingImage_KL15_OFF_Init();
    /*报警调度*/
    LED_IgnOff_Init();
    
    Popup_Scheduler_OFF();
    BU98R10_Shutdown();
    
    BL_LCD_Stop();
}

uint8_t BL_TFT_Status;

void BL_TFT_Status_Set(uint8_t val)
{
    BL_TFT_Status = val;
} 

uint8_t BL_TFT_Status_Get(void)
{
    return BL_TFT_Status;
}

void Power_IG_ON_Init(void)
{
    Data_ODO_Clear_KL15Init();
    Line_In_KL15_ON_Init();
    Telltales_KL15_Init();
    Service_OFF_Timing_KL15Init();
    SOC_KL15_ON_Init();
    DrvMtrPwr_KL15_ON_Init();
    DrvMtrSpd_KL15_ON_Init();
    Speed_KL15_ON_Init();
    Popup_Scheduler_OFF();
    BU98R10_Init();
    Display_Info_IgnOnInit();
    Sound_Scheduler_Init();
    BL_Open_Flag_Set(1);
    BL_TFT_Start();
    BL_LCD_Start();
            
    if (Gear_Get_Value() != 1)
    {    
        ReversingImage_KL15_Init();
    }

    Popup_Current_Msg = 0xFFFFu;
}

Power_Status_t Power_Stay_ON(void)
{
    Power_Status_t u8PowerSts;
    
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    uint8_t u8Condition3;
    uint8_t u8Condition4;
    
    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();
    u8Condition3 = System_FUN_KL30_Status_Get();
    u8Condition4 = Line_In_Get_Status(LINE_IN_ChargeWake);
    
    if (((u8Condition1 == COMMON_POWER_ON ) && ( u8Condition2 == COMMON_Valid)) || u8Condition4)
    {
        u8PowerSts = m_IGN_ON;
    }
    else
    {
        if (((u8Condition1 == COMMON_POWER_OFF ) && (u8Condition2 == COMMON_Valid)) && (u8Condition4 == 0u))
        {
            u8PowerSts = m_IGN_OFF_Init;
        }
        else
        {
            u8PowerSts = m_IGN_ON;
        }
    }
    
    /*if (((u8Condition3 == 1u) || (u8Condition3 >= 7u)))
    {
        u8PowerSts = m_IGN_LIMIT;
    }*/
    
    return  u8PowerSts;
}

uint8_t TurnSts = 0;
uint8_t TurnCnt = 0;

Power_Status_t Power_Stay_OFF(void)
{
    Power_Status_t u8PowerSts = m_IGN_OFF;
    
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    uint8_t u8Condition3;
    
    uint8_t BackLightStop[4] = {0u};

    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();
    u8Condition3 = Line_In_Get_Status(LINE_IN_ChargeWake);

    if (((u8Condition1 == COMMON_POWER_ON) && (u8Condition2 == COMMON_Valid)) || (u8Condition3 == 1u))
    {
        u8PowerSts = m_IGN_ON_Init;
    }
    else
    {
        if (((u8Condition1 == COMMON_POWER_OFF) && (u8Condition2 == COMMON_Valid)) && (u8Condition3 == 0u))
        {
            if (PowerGetNMStatus() == POWER_NM_SLEEP) //无CAN报文
            {
                BackLightStop[0] = 1u; //可以关闭背光
                
                if (Common_GetIgnOffTime() >= 3000ul)
                {
                    u8PowerSts = m_IGN_Sleep_Init;
                }
            }
            else
            {
                if ((CAN_MSG_Status(ID_VCU_VCUSts1_Msg_Count) != CAN_SIG_RECEIVE) && (CAN_MSG_Status(ID_BMS_BMSFltSts_Msg_Count) != CAN_SIG_RECEIVE)) //无VCU和BCM心跳信号
                {
                    BackLightStop[0] = 1u; //可以关闭背光
                }
                else
                {
                    ;        //有心跳信号,继续显示
                }
            }
          
            if ((Common_GetIgnOffTime() < 10500ul) && (LED_Get_Parking_Status() == 0u)) //下电且手刹未拉10秒以内
            {
                u8PowerSts = m_IGN_OFF;
            }
            else
            {
                BackLightStop[1] = 1u;
            }
            
            //危急
            if (LED_Get_TurnRight_Status1() && LED_Get_TurnLeft_Status1())
            {
                if (TurnSts == 0)
                {
                    TurnSts = 1;
                    TurnCnt++; 
                }

                Turn_Delay_Time_Set(0u);
                
                u8PowerSts = m_IGN_OFF;
                
                if (TurnCnt > 3)
                {
                    BackLightStop[2] = 0u;
                }
                else
                {
                    BackLightStop[2] = 1u;
                }
            }
            else
            {
                TurnSts = 0;
                
                if (Turn_Delay_Time_Get() >= 40000u)
                {
                    BackLightStop[2] = 1u;
                    TurnCnt = 0; 
                }
                else
                {
                    u8PowerSts = m_IGN_OFF;
                    
                    if (TurnCnt > 3)
                    {
                        BackLightStop[2] = 0u;
                    }
                    else
                    {
                        BackLightStop[2] = 1u;
                    }
                } 
            }
            
            //门开
            /*if (LED_Get_Status(em_LED_Door))
            {
                u8PowerSts = m_IGN_OFF;
                BackLightStop[3]= 0u;
            } 
            else*/
            {
                BackLightStop[3] = 1u;
            }

            if (BackLightStop[0] && BackLightStop[1] && BackLightStop[2] && BackLightStop[3]) //均满足关闭背光条件
            {
                if (BL_TFT_Status == 0u) //运行中
                {
                    BL_TFT_Status = 1u;
                    BL_Open_Flag_Set(0);
                    BL_TFT_Stop();
                }
            }
            else
            {
                if (BL_TFT_Status == 1u) //已停止
                {
                    u8PowerSts = m_IGN_OFF;
                    
                    BL_TFT_Status = 0u;
                    BL_Open_Flag_Set(1);
                    BL_TFT_Start();
                }
            }
        }
        else
        {
            ;                //信号无效什么都不做
        }
    }
    
    return  u8PowerSts;
}

Power_Status_t  Power_Stay_Protect(void)
{
    Power_Status_t u8PowerSts = m_IGN_LIMIT;
        
    if (SYS_OPR_STAT_RUN)
    {
        u8PowerSts = m_IGN_ON;
    }

    return  u8PowerSts;
}

Power_Status_t Power_Stay_Sleep ( void )
{
    Power_Status_t u8PowerSts;
    loc_cvbs_ClearVRAM();
    Sys_Enter_Sleep_Mode();
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}

static uint8_t PowerGetNMStatus(void)
{
    uint8_t u8NMStatus = 0U;
    NM_Mode_t m_condition;
    m_condition = RTE_CAN_NM_GetStatus();

    if (m_condition == NM_Mode_Sleep)
    {
        u8NMStatus = POWER_NM_SLEEP;
    }
    else
    {
        u8NMStatus = POWER_NM_WAKEUP;
    }
    return u8NMStatus;
}

void ClearNoInitArea(void)
{
    uint32_t  *pRam;
    uint32_t  p;
    pRam = (unsigned int*)0x3FCE4000ul;
    for (p = 0ul; p < 4096ul; p ++)
    {
        pRam[ p ] = 0ul;
    }
}
