#include "Popups.h"
#include "Common_Interface.h"
#include "GUI.h"
#include "Sound_Scheduler.h"

#include "Gauges.h"
#include "GaugesInterface.h"

#include "CAN_Communication_Matrix.h"
#include "Popup_List.h"
#include "Telltales.h"

#include "Data_Gear.h"
#include "Line_in.h"
#include "Line_In_user.h"
#include "Data_VehicleSpeed.h"
#include "Telltales_user.h"
#include "Key.h"
#include "Data_BtyMaxCllVtg.h"
#include "Data_SOC.h"
#include "System_Monitor.h"

uint16_t Popup_Current_Msg;

void Popups_Management_Service(void)
{
    if (((Common_GetIgnOnTime() < 4000u) && (Common_Get_IG_Sts() == 1u)) || SYS_OPR_STAT_HALT)
    {
        return;
    }

    if ((Gear_Get_Value() == 1u) && (VdoFmtTyp_Get() != 0u)) //20230919解决禅道28845和28844问题
    {
        //离座报警
        if ((Get_ID_18F101D0_Sig_VCU_DrvrSts() == 1u) && (Get_ID_18F101D0_Sig_VCU_VhclSts() == 0x01u) &&\
            (Gear_Get_Value() != 0u) && (Gear_Get_Value() < 10u) && (Common_Get_IG_Sts() == 1u)) 
        {
            Popup_Request(POPUP_COM_LeaveSeat);
        }
        else
        {
            Popup_Delete(POPUP_COM_LeaveSeat);
            Sound_Delete(SND_LeaveSeat);
        }

        //return; 20230910屏掉
    }
    else //20230910加 解决倒车时离座报警没有报警声音问题
    {
        Popups_Polling();
    }

    Popup_Current_Msg = Popup_Get_Current_Message();
    
    if (Popup_Current_Msg < POPUP_MSG_NONE)
    {
        Popups_Sound_Playing(Popup_Get_Current_Sound());
    }
}

extern uint8_t Limit_Speed_Last_Status;
extern uint8_t LitSpdTyp;

void Popups_Polling_Sub(uint8_t code, uint16_t PopupID, uint8_t SoundID, uint8_t grade2)
{
    if (code)
    {
        if (code < 51u)
        {
            Popup_Request(PopupID + 2u);

            Popup_Delete(PopupID + 1u);
            Sound_Delete(SoundID + 1u);

            Popup_Delete(PopupID);
            Sound_Delete(SoundID);
        }
        else
        {
            Popup_Delete(PopupID + 2u);
            Sound_Delete(SoundID + 2u);

            if (code < grade2)
            {
                Popup_Request(PopupID + 1u);

                Popup_Delete(PopupID);
                Sound_Delete(SoundID);
            }
            else
            {
                Popup_Request(PopupID);

                Popup_Delete(PopupID + 1u);
                Sound_Delete(SoundID + 1u);
            }
        }
    }
    else
    {
        Popup_Delete(PopupID);
        Sound_Delete(SoundID);
        
        Popup_Delete(PopupID + 1u);
        Sound_Delete(SoundID + 1u);

        Popup_Delete(PopupID + 2u);
        Sound_Delete(SoundID + 2u);
    }
}

uint16_t Maintenance_Alarm_Time = 0u;
uint8_t  Maintenance_Alarm_Flag = 0u;
uint8_t  Parking_Status_Last = 0u;
uint8_t  Parking_Alarm_Delay = 0u;
uint8_t  OvrECUSpd_Times = 0u;
uint8_t  OvrSpd_Last = 0u;
uint8_t  OvrSpd_Time = 0u;
uint8_t  DTC_Code[7u];
uint8_t  DTC_Count[7u];

void Popups_Polling(void)
{
    //SYS
    uint16_t code = Get_ID_18F101D0_Sig_VCU_SysDTC(); //故障码
    if (code)
    {
        DTC_Code[0u]  = code; //故障码
        DTC_Count[0u] = Get_ID_18F101D0_Sig_VCU_SysTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_VCU_SYS1, SND_VCU_SYS1, 151u);
    
    //EPS
    code = Get_ID_18F105D0_Sig_VCU_EPSDTC(); //故障码
    if (code)
    {
        DTC_Code [1u] = code;
        DTC_Count[1u] = Get_ID_18F105D0_Sig_VCU_EPSTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_VCU_EPS1, SND_VCU_EPS1, 151u);
    
    //ACM
    code = Get_ID_18F105D0_Sig_VCU_ACMDTC(); //故障码
    if (code)
    {
        DTC_Code[2u]  = code;
        DTC_Count[2u] = Get_ID_18F105D0_Sig_VCU_ACMTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_VCU_ACM1, SND_VCU_ACM1, 151u);
    
    //DC/DC
    code = Get_ID_18F105D0_Sig_VCU_DCDCDTC(); //故障码
    if (code)
    {
        DTC_Code[6u]  = code;
        DTC_Count[6u] = Get_ID_18F105D0_Sig_VCU_DCDCTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_VCU_DCDC1, SND_VCU_DCDC1, 151u);
    
    //PDU
    code = Get_ID_18F106D0_Sig_VCU_PDUDTC(); //故障码
    if (code)
    {
        DTC_Code[4u]  = code;
        DTC_Count[4u] = Get_ID_18F106D0_Sig_VCU_PDUTtlFlt(); //故障总数
    }    
    Popups_Polling_Sub(code, POPUP_VCU_PDU1, SND_VCU_PDU1, 151u);
    
    //MCU
    code = Get_ID_18F501F0_Sig_VCU_MCUDTC(); //故障码
    if (code)
    {
        DTC_Code[5u]  = code;
        DTC_Count[5u] = Get_ID_18F501F0_Sig_VCU_MCUTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_VCU_MCU1, SND_VCU_MCU1, 151u);
    
    //BCM
    code = Get_ID_18F141F3_Sig_BMS_BMSDTC(); //故障码
    if (code)
    {
        DTC_Code [3u] = code;
        DTC_Count[3u] = Get_ID_18F141F3_Sig_BMS_BMSTtlFlt(); //故障总数
    }
    Popups_Polling_Sub(code, POPUP_BMS_BMS1, SND_BMS_BMS1, 101u);
 
    //Maintenance
    code = Get_ID_18F101D0_Sig_VCU_GrMntnRmnd();
    
    if (code)
    {
        if (Maintenance_Alarm_Flag == 0u)
        {
            Maintenance_Alarm_Flag = 1u;
            Maintenance_Alarm_Time = 0u;
        }
        else
        {
            if (Maintenance_Alarm_Time < 300) //30秒
            {
                Maintenance_Alarm_Time++;
                Popup_Request(POPUP_COM_Maintenance);
            }
            else
            {
                Popup_Delete(POPUP_COM_Maintenance);
                Sound_Delete(SND_Maintenance);
            }
        }
    }
    else
    {
        Popup_Delete(POPUP_COM_Maintenance);
        Sound_Delete(SND_Maintenance);
    }

    //OvrSpd
    uint32_t speed = 0;
    uint32_t Limit_Speed_Set = 89ul;
    if (LitSpdTyp == 1ul)
    {
        Limit_Speed_Set = 99ul;
    }
    else if (LitSpdTyp == 2ul)
    {
        Limit_Speed_Set = 109ul;
    }
    else
    {
        ;
    }
    
    if (Common_GetIgnOnTime() < 6000) 
    {
        ; 
    }
    else
    {
        speed = Speed_Get_CurDisp(); //10倍车速
    }
    
    speed /= 10ul;
    
    if (speed >= Limit_Speed_Set)
    {
        Limit_Speed_Last_Status = 1u;
        
        if (OvrSpd_Last == 0u)
        {
            OvrSpd_Last = 1u;
            OvrSpd_Time = 0u;
        }

        if (OvrSpd_Time < 50u)
        {
            OvrSpd_Time++;
            Popup_Request(POPUP_COM_OvrSpd);
        }
        else
        {
            Popup_Delete(POPUP_COM_OvrSpd);
            Sound_Delete(SND_OvrSpd); 
        }
    }
    else
    {
        if (speed <= (Limit_Speed_Set - 3ul))
        {
            OvrSpd_Last = 0u;
            Limit_Speed_Last_Status = 0u;
            
            Popup_Delete(POPUP_COM_OvrSpd);
            Sound_Delete(SND_OvrSpd);
        }
        else
        {
            if (OvrSpd_Last && (OvrSpd_Time < 50u))
            {
                OvrSpd_Time++;
                Popup_Request(POPUP_COM_OvrSpd);
            }
            else
            {
                Popup_Delete(POPUP_COM_OvrSpd);
                Sound_Delete(SND_OvrSpd); 
            }
        }
    }
    
    /* 20231009 按20230928变更单去掉 */
  #if 0
    //OvrECUSpd  
    if ((speed > 70ul) && (SOC_Get_CurVal() < 300) && SOC_Get_Valid())
    {
        Popup_Request(POPUP_COM_OvrECUSpd);

        if (OvrECUSpd_Times < 60u)
        {
            Sound_Request(SND_OvrECUSpd, 1);
            OvrECUSpd_Times++;
        }
        else
        {
            Sound_Delete(SND_OvrECUSpd);
        }
    }
    else
    {
        //if (speed < 66ul)
        {
            Popup_Delete(POPUP_COM_OvrECUSpd);
            Sound_Delete(SND_OvrECUSpd);
        }

        OvrECUSpd_Times = 0u;
    }
  #endif

    //Door
    code = LED_Get_Status(em_LED_Door);

    if (code && (speed > 10ul))
    {
        Popup_Request(POPUP_COM_Door);
    }
    else
    {
        Popup_Delete(POPUP_COM_Door);
        Sound_Delete(SND_Door);
    }

    //Seatbelt
    code = LED_Get_Status(em_LED_SeatBelt);

    if (code && (speed >= 25u))
    {
        Popup_Request(POPUP_COM_Seatbelt);
    }
    else
    {
        Popup_Delete(POPUP_COM_Seatbelt);
        Sound_Delete(SND_Seatbelt);
    }

    //Parking
    code = LED_Get_Status(em_LED_Parking);
    /* 20231009 按20230928变更增加ready、非N挡条件；车速条件改为非0；修改声音报警 */
    if (code && ((Gear_Get_Value() != 0u) && (Gear_Get_Value() < 10u)) && speed && (Get_ID_18F101D0_Sig_VCU_VhclSts() == 0x1u))
    {
        //if (speed > 5ul)
        {
            Popup_Request(POPUP_COM_ParkingOn);
        }
        //else
        {
            //if (speed < 3ul)
            {
                //Popup_Delete(POPUP_COM_ParkingOn);
                //Sound_Delete(SND_ParkingOn);
            }
        }
    }
    else
    {
        Popup_Delete(POPUP_COM_ParkingOn);
        Sound_Delete(SND_ParkingOn);
    }

    //请拉手刹
    if ((((Common_Get_IG_Sts() == 0u) && (Common_GetIgnOffTime() < 10500)) || Charged_State_Get()) && (code == 0u))
    {
        if (Parking_Status_Last == 0u)
        {
            Parking_Status_Last = 1u;
            Parking_Alarm_Delay = 0u;
        }

        if (Parking_Alarm_Delay < 5u)
        {
            Parking_Alarm_Delay++;
        }
        else
        {
            Popup_Request(POPUP_COM_ParkingOff);
        }
    }
    else
    {
        Parking_Status_Last = 0u;

        Popup_Delete(POPUP_COM_ParkingOff);
        Sound_Delete(SND_ParkingOff);
    }
    
    //离座报警
    if ((Get_ID_18F101D0_Sig_VCU_DrvrSts() == 1u) && (Get_ID_18F101D0_Sig_VCU_VhclSts() == 0x01u) &&\
        (Gear_Get_Value() != 0u) && (Gear_Get_Value() < 10u) && (Common_Get_IG_Sts() == 1u)) 
    {
        Popup_Request(POPUP_COM_LeaveSeat);
    }
    else
    {
        Popup_Delete(POPUP_COM_LeaveSeat);
        Sound_Delete(SND_LeaveSeat);
    }
    //液位低报警
    if (LED_Get_Status(em_LED_LvlLow))
    {
        Popup_Request(POPUP_COM_LvlLow);
    }
    else
    {
        Popup_Delete(POPUP_COM_LvlLow);
    }
    //无权限车辆
    if (Get_ID_18F103D0_Sig_VCU_NAthrtyVhl() == 1u)
    {
        Popup_Request(POPUP_COM_NoJurisdictionVhl);
    }
    else
    {
        Popup_Delete(POPUP_COM_NoJurisdictionVhl);
    }
    
    if (Charged_State_Get() == 0u)
    {
        code = Get_ID_18FF10B1_Sig_ACCM_CmprErrCode();
        //压缩机故障码
        //过流
        if (code == 0x1u)
        {
            Popup_Request(POPUP_ACCM_CmprErrCode0);
        }
        else
        {
            Popup_Delete(POPUP_ACCM_CmprErrCode0);
        }
        //运行过压
        if (code == 0x2u)
        {
            Popup_Request(POPUP_ACCM_CmprErrCode1);
        }
        else
        {
            Popup_Delete(POPUP_ACCM_CmprErrCode1);
        }
        //运行欠压
        if (code == 0x4u)
        {
            Popup_Request(POPUP_ACCM_CmprErrCode2);
        }
        else
        {
            Popup_Delete(POPUP_ACCM_CmprErrCode2);
        }
        //过流降频
        if (code == 0x40u)
        {
            Popup_Request(POPUP_ACCM_CmprErrCode3);
        }
        else
        {
            Popup_Delete(POPUP_ACCM_CmprErrCode3);
        }
        //过温故障
        if (code == 0x80u)
        {
            Popup_Request(POPUP_ACCM_CmprErrCode4);
        }
        else
        {
            Popup_Delete(POPUP_ACCM_CmprErrCode4);
        }
    }
    else
    {
        Popup_Delete(POPUP_ACCM_CmprErrCode0);
        Popup_Delete(POPUP_ACCM_CmprErrCode1);
        Popup_Delete(POPUP_ACCM_CmprErrCode2);
        Popup_Delete(POPUP_ACCM_CmprErrCode3);
        Popup_Delete(POPUP_ACCM_CmprErrCode4);
    }
}

void Maintenance_Alarm_Flag_Set(uint8_t val)
{
    Parking_Status_Last    = val;
    Maintenance_Alarm_Flag = val;
}

void Popups_Sound_Playing(uint8_t PopupSnd)
{
    uint8_t ReqCode = Popup_Get_Current_Sound_Req_Code( );

    if ( ReqCode )
    {
        Sound_Request(PopupSnd, ReqCode);
    }    
    else
    {
        Sound_Delete(PopupSnd);
    }
}
