#include "RTE_TIME.h"
#include "RTC.h"

uint16_t RTE_RTC_YEAR;
uint8_t RTE_RTC_MONTH;
uint8_t RTE_RTC_DATE;
uint8_t RTE_RTC_HOUR;
uint8_t RTE_RTC_MINUTE;
uint8_t RTE_RTC_SECOND;

void RTE_RTC_KL30_Init(void)
{
    RTC_Pre_Init();
}

void RTE_RTC_Wakeup_Init(void)
{

}

void RTE_RTC_Services_100Ms_Cbk(void)
{
    RTC_Get_Time();
}

void RTE_RTC_Set_Secone(uint8_t m_Second)
{
    RTE_RTC_SECOND = m_Second;
}

void RTE_RTC_Set_Hour(uint8_t m_Hour)
{
    RTE_RTC_HOUR = m_Hour;
}

void RTE_RTC_Set_Minute(uint8_t m_Minute)
{
    RTE_RTC_MINUTE = m_Minute;
}

void RTE_RTC_Set_Date(uint8_t m_Date)
{
    RTE_RTC_DATE = m_Date;
}

void RTE_RTC_Set_Month(uint8_t m_Month)
{
    RTE_RTC_MONTH = m_Month;
}

void RTE_RTC_Set_Year(uint16_t m_Year)
{
    RTE_RTC_YEAR = m_Year;
}

void RTE_RTC_Confirm_Overwrite(void)
{
    RTC_Set_Time(RTE_RTC_DATE, RTE_RTC_HOUR, RTE_RTC_MINUTE, RTE_RTC_SECOND);
}

uint16_t Get_RTC_YEAR(void)
{
    return RTC_YEAR;
}

uint8_t Get_RTC_MONTH(void)
{
    return RTC_MONTH;
}

uint8_t Get_RTC_DATE(void)
{
    return RTC_DATE;
}

uint8_t Get_RTC_HOUR(void)
{
    return RTC_HOUR;
}

uint8_t Get_RTC_MINUTE(void)
{
    return RTC_MINUTE;
}

uint8_t Get_RTC_SECOND(void)
{
    return RTC_SECOND;
}

uint8_t Calculate_Week(uint8_t month, uint8_t date, uint16_t year)
{
    if (month < 3)
    {
        month += 12;
        year--;
    }
    
    uint8_t tmp_0 = (uint8_t)(year % 100);
    uint8_t tmp_1 = (uint8_t)(year / 100);
    uint8_t week  = (uint8_t)((tmp_0 + (tmp_0 >> 2) + (tmp_1 >> 2) + 13 * (month + 1) / 5 + date - 1 - (tmp_1 << 1)) % 7);
  
    return week;
}

uint8_t Get_RTC_WEEK(void)
{
    return Calculate_Week(RTC_MONTH, RTC_DATE, RTC_YEAR);
}

