#ifndef ____RIIC_H__
#define ____RIIC_H__

#include "r_typedefs.h"

#define ADDR_W_STATE  (0x10U)
#define ADDR_R_STATE  (0x11U)
#define SLAVE_ADDR    (0xBAU)
#define IIC_DIR_W     (0x00U)
#define IIC_DIR_R     (0x01U)






/* ALL REGISTER */

typedef struct riic_cr1_field{
    uint32_t		SDA1:1;
    uint32_t		SCL1:1;
    uint32_t		SDAO:1;
    uint32_t		SCLO:1;
    uint32_t		SOWP:1;
    uint32_t		CLO:1;
    uint32_t		IICRST:1;
    uint32_t		ICE:1;
    uint32_t		:24;
}riic_cr1_field_t;

typedef union un_riic_cr1{
    uint32_t		u32Register;
    riic_cr1_field_t    stcField;
}un_riic_cr1_t;


typedef struct riic_cr2_field{
    uint32_t		:1;
    uint32_t		ST:1;
    uint32_t		RS:1;
    uint32_t		SP:1;
    uint32_t		:1;
    uint32_t		TRS:1;
    uint32_t		MST:1;
    uint32_t		BBSY:1;
    uint32_t		:24;
}riic_cr2_field_t;

typedef union un_riic_cr2{
    uint32_t		u32Register;
    riic_cr2_field_t    stcField;
}un_riic_cr2_t;


typedef struct riic_mr1_field{
    uint32_t		BC:3;
    uint32_t		BCWP:1;
    uint32_t		CKS:3;
    uint32_t		MTWP:1;
    uint32_t		:24;
}riic_mr1_field_t;

typedef union un_riic_mr1{
    uint32_t		u32Register;
    riic_mr1_field_t    stcField;
}un_riic_mr1_t;


typedef struct riic_mr2_field{
    uint32_t		TMOS:1;
    uint32_t		TMOL:1;
    uint32_t		TMOH:1;
    uint32_t		:1;
    uint32_t		SDDL:3;
    uint32_t		DLCS:1;
    uint32_t		:24;
}riic_mr2_field_t;

typedef union un_riic_mr2{
    uint32_t		u32Register;
    riic_mr2_field_t    stcField;
}un_riic_mr2_t;


typedef struct riic_mr3_field{
    uint32_t		NF:2;
    uint32_t		ACKBR:1;
    uint32_t		ACKBT:1;
    uint32_t		ACKWP:1;
    uint32_t		RDRFS:1;
    uint32_t		WAIT:1;
    uint32_t		:25;
}riic_mr3_field_t;

typedef union un_riic_mr3{
    uint32_t		u32Register;
    riic_mr3_field_t    stcField;
}un_riic_mr3_t;


typedef struct riic_fer_field{
    uint32_t		TMOE:1;
    uint32_t		MALE:1;
    uint32_t		NALE:1;
    uint32_t		SALE:1;
    uint32_t		NACKE:1;
    uint32_t		NFE:1;
    uint32_t		SCLE:1;
    uint32_t		:25;
}riic_fer_field_t;

typedef union un_riic_fer{
    uint32_t		u32Register;
    riic_fer_field_t    stcField;
}un_riic_fer_t;


typedef struct riic_ser_field{
    uint32_t		SAR0:1;
    uint32_t		SAR1:1;
    uint32_t		SAR2:1;
    uint32_t		GCE:1;
    uint32_t		:1;
    uint32_t		DIDE:1;
    uint32_t		:26;
}riic_ser_field_t;

typedef union un_riic_ser{
    uint32_t		u32Register;
    riic_ser_field_t    stcField;
}un_riic_ser_t;


typedef struct riic_ier_field{
    uint32_t		TMOIE:1;
    uint32_t		ALIE:1;
    uint32_t		STIE:1;
    uint32_t		SPIE:1;
    uint32_t		NAKIE:1;
    uint32_t		RIE:1;
    uint32_t		REIE:1;
    uint32_t		TIE:1;
    uint32_t		:24;
}riic_ier_field_t;

typedef union un_riic_ier{
    uint32_t		u32Register;
    riic_ier_field_t    stcField;
}un_riic_ier_t;


typedef struct riic_sr1_field{
    uint32_t		AAS0:1;
    uint32_t		AAS1:1;
    uint32_t		AAS2:1;
    uint32_t		GCA:1;
    uint32_t		:1;
    uint32_t		DID:1;
    uint32_t		:26;
}riic_sr1_field_t;

typedef union un_riic_sr1{
    uint32_t		u32Register;
    riic_sr1_field_t    stcField;
}un_riic_sr1_t;


typedef struct riic_sr2_field{
    uint32_t		TMOF:1;
    uint32_t		AL:1;
    uint32_t		START:1;
    uint32_t		STOP:1;
    uint32_t		NACKF:1;
    uint32_t		RDRF:1;
    uint32_t		TEND:1;
    uint32_t		TDRE:1;
    uint32_t		:24;
}riic_sr2_field_t;

typedef union un_riic_sr2{
    uint32_t		u32Register;
    riic_sr2_field_t    stcField;
}un_riic_sr2_t;


typedef struct riic_sar0_field{
    uint32_t		SVA0:1;
    uint32_t		SVA:9;
    uint32_t		:5;
    uint32_t		FSy:1;
    uint32_t		:16;
}riic_sar0_field_t;

typedef union un_riic_sar0{
    uint32_t		u32Register;
    riic_sar0_field_t    stcField;
}un_riic_sar0_t;


typedef struct riic_sar1_field{
    uint32_t		SVA0:1;
    uint32_t		SVA:9;
    uint32_t		:5;
    uint32_t		FSy:1;
    uint32_t		:16;
}riic_sar1_field_t;

typedef union un_riic_sar1{
    uint32_t		u32Register;
    riic_sar1_field_t    stcField;
}un_riic_sar1_t;


typedef struct riic_sar2_field{
    uint32_t		SVA0:1;
    uint32_t		SVA:9;
    uint32_t		:5;
    uint32_t		FSy:1;
    uint32_t		:16;
}riic_sar2_field_t;

typedef union un_riic_sar2{
    uint32_t		u32Register;
    riic_sar2_field_t    stcField;
}un_riic_sar2_t;


typedef struct riic_brl_field{
    uint32_t		BRL:5;
    uint32_t		:27;
}riic_brl_field_t;

typedef union un_riic_brl{
    uint32_t		u32Register;
    riic_brl_field_t    stcField;
}un_riic_brl_t;


typedef struct riic_brh_field{
    uint32_t		BRH:5;
    uint32_t		:27;
}riic_brh_field_t;

typedef union un_riic_brh{
    uint32_t		u32Register;
    riic_brh_field_t    stcField;
}un_riic_brh_t;


typedef struct riic_drt_field{
    uint32_t		DRT:8;
    uint32_t		:24;
}riic_drt_field_t;

typedef union un_riic_drt{
    uint32_t		u32Register;
    riic_drt_field_t    stcField;
}un_riic_drt_t;


typedef struct riic_drr_field{
    uint32_t		DRR:8;
    uint32_t		:24;
}riic_drr_field_t;

typedef union un_riic_drr{
    uint32_t		u32Register;
    riic_drr_field_t    stcField;
}un_riic_drr_t;



typedef struct stc_riic{
    un_riic_cr1_t    unCR1;
    un_riic_cr2_t    unCR2;
    un_riic_mr1_t    unMR1;
    un_riic_mr2_t    unMR2;
    un_riic_mr3_t    unMR3;
    un_riic_fer_t    unFER;
    un_riic_ser_t    unSER;
    un_riic_ier_t    unIER;
    un_riic_sr1_t    unSR1;
    un_riic_sr2_t    unSR2;
    un_riic_sar0_t   unSAR0;
    un_riic_sar1_t   unSAR1;
    un_riic_sar2_t   unSAR2;
    un_riic_brl_t    unBRL;
    un_riic_brh_t    unBRH;
    un_riic_drt_t    unDRT;
    un_riic_drr_t    unDRR;
}stc_riic_t;


volatile static stc_riic_t* const pMFS_RIIC[2] =
{
    (volatile stc_riic_t*)(0xFFDB0000U),          /*  RIIC 通锟斤拷0   */
    (volatile stc_riic_t*)(0xFFDB1000U),          /*  RIIC 通锟斤拷1   */
};


typedef struct tst_iic_param
{
    uint32_t  iic_state;
    
    uint32_t  tx_count;
    uint32_t  tx_len;
    uint8_t  *tx_data_p;
    
    uint32_t  rx_count;
    uint32_t  rx_len;
    uint8_t  *rx_data_p;   
}IIC_PARAM;


extern void RIIC_Init(uint8_t channel);
extern void RIIC_Master_Transmit(uint8_t channel, uint32_t len, uint8_t *transmission_data);
extern void RIIC_Master_Receive16B(uint8_t channel, uint16_t InternalAddress, uint32_t len, uint8_t *recebuff);

#endif
