#include "Data_BtyMaxCllTpt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint8_t BtyMaxCllTpt_Value;
uint8_t BtyMaxCllTpt_Sign;
uint8_t BtyMaxCllTpt_Valid;

void BtyMaxCllTpt_Reset(void)
{
    BtyMaxCllTpt_Value = 0;
    BtyMaxCllTpt_Sign  = 0;
    BtyMaxCllTpt_Valid = 0;
}

void BtyMaxCllTpt_KL30_Init(void)
{
    BtyMaxCllTpt_Reset();
}

void BtyMaxCllTpt_KL15_ON_Init(void)
{
    BtyMaxCllTpt_Reset();
}

void BtyMaxCllTpt_Processing_Service(void)
{
    uint8_t u8Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        BtyMaxCllTpt_Reset();
        return;
    }

    u8Result  = Get_ID_18F13EF3_Sig_BMS_BtyMaxCllTpt();
    
    if ((u8Result >= 0xFE) || (CAN_MSG_Status(ID_BMS_CllBtySts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyMaxCllTpt_Valid = 0;
        u8Result           = 0;
    }
    else
    {
        BtyMaxCllTpt_Valid = 1;
    }

    if (u8Result >= 40) 
    {
        BtyMaxCllTpt_Sign  = 0;
        u8Result          -= 40;
    }
    else
    {
        BtyMaxCllTpt_Sign = 1;
        u8Result          = 40 - u8Result;
    }

    BtyMaxCllTpt_Value = u8Result;
}

uint8_t BtyMaxCllTpt_Get_Value(void)
{
    return BtyMaxCllTpt_Value;
}

uint8_t BtyMaxCllTpt_Get_Sign(void)
{
    return BtyMaxCllTpt_Sign;
}

uint8_t BtyMaxCllTpt_Get_Valid(void)
{
    return BtyMaxCllTpt_Valid;
}
