#include "Data_BtyMinCllTpt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint8_t BtyMinCllTpt_Value;
uint8_t BtyMinCllTpt_Sign;
uint8_t BtyMinCllTpt_Valid;

void BtyMinCllTpt_Reset(void)
{
    BtyMinCllTpt_Value = 0;
    BtyMinCllTpt_Sign  = 0;
    BtyMinCllTpt_Valid = 0;
}

void BtyMinCllTpt_KL30_Init(void)
{
    BtyMinCllTpt_Reset();
}

void BtyMinCllTpt_KL15_ON_Init(void)
{
    BtyMinCllTpt_Reset();
}

void BtyMinCllTpt_Processing_Service(void)
{
    uint8_t u8Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        BtyMinCllTpt_Reset();
        return;
    }

    u8Result = Get_ID_18F13EF3_Sig_BMS_BtyMinCllTpt();
    
    if ((u8Result >= 0xFE) || (CAN_MSG_Status(ID_BMS_CllBtySts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyMinCllTpt_Valid = 0;
        u8Result           = 0;
    }
    else
    {
        BtyMinCllTpt_Valid = 1;
    }

    if (u8Result >= 40) 
    {
        BtyMinCllTpt_Sign  = 0;
        u8Result          -= 40;
    }
    else
    {
        BtyMinCllTpt_Sign = 1;
        u8Result          = 40 - u8Result;
    }

    BtyMinCllTpt_Value = u8Result;
}

uint8_t BtyMinCllTpt_Get_Value(void)
{
    return BtyMinCllTpt_Value;
}

uint8_t BtyMinCllTpt_Get_Sign(void)
{
    return BtyMinCllTpt_Sign;
}

uint8_t BtyMinCllTpt_Get_Valid(void)
{
    return BtyMinCllTpt_Valid;
}
