/**************************************************************************/ /**
  * \file     Tasks.c
  * \brief    Task list
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     07-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#include "r_typedefs.h"
#include "Sys_Scheduler.h"
#include "rh850_macros.h"
#include "RTC.h"
#include "RTE_TIME.h"
#include "debugger.h"
#include "r_ddb_api.h"
#include "r_wm_api.h"
#include "Graphic.h"
#include "Emulated_EEPROM.h"
#include "Analog_Signals.h"
#include "CAN_APP.h"
#include "Communication_Over_CAN.h"
#include "RTE_CAN_NM.h"
#include "loc_graphics.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Watchdog.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "Services_Mileage.h"
#include "Services_ODO_User.h"
#include "Line_in.h"
#include "Data_SOC.h"
#include "SEG_DISPLAY.h"
#include "BU98R10.h"
#include "System_Monitor.h"
#include "PowerManagement.h"
#include "Data_VehicleSpeed.h"
#include "Common_Interface.h"
#include "Data_BtyMaxTpt.h"
#include "Data_DrvMtrTpt.h"
#include "Data_BtyPckVtg.h"
#include "Data_BtyPckCrt.h"
#include "Data_DrvMCUTpt.h"
#include "Data_Gear.h"
#include "Data_BtyMinCllTpt.h"
#include "Data_BtyMinCllVtg.h"
#include "Data_BtyMaxCllTpt.h"
#include "Data_BtyMaxCllVtg.h"
#include "AirPressure.h"
#include "Data_DrvMtrSpd.h"
#include "Data_PWR.h"
#include "Key.h"
#include "Sound_Player.h"
#include "Flash_synchronizer.h"
#include "Sound_Scheduler.h"
#include "GUI.h"
#include "Popups.h"
#include "DoCAN_ISO15765.h"
#include "UDS_ISO14229_Server.h"
#include "Service_OFF_Time.h"
#include "BackLight_APP.h"
#include "CVBS.h"
#include "Data_ReversingImage.h"
/*******************************************************************************
*                                                                              *
*   系统常规运行模式(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )任务列表   *
*                                                                              *
*******************************************************************************/

/*==============================================================================
伪实时任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();
    BU98R10_Update_Service();
    UDS_Server_Application_Service();
}
/*==============================================================================
2ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks(void)
{
    //GPIO_OUT_PORT03_PIN03 = !GPIO_OUT_PORT03_PIN03;
    
    UDS_KL15_init();
    Analog_Signal_Conv_Service();
    Sys_Status_Update_Service();
    UDS_10ms_Service();
    Common_Input_Para();
}
/*============================================================================*/
/*==============================================================================
5ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks(void)
{
    COM_RX_Process();
    
    loc_Display_Service();
}
/*==============================================================================
10ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks(void)
{
    Data_Mileage_Write_EEPROM();
    Line_In_Debounce_Service();
    Telltales_Management();
    Key_Turn_Service();
    //CAN_BUSOFF_Recover(); /*20220617去掉,此功能在Can_BusOff_Fun()实现*/
    Sound_Play_Service();
    Can_BusOff_Fun();
    
    ReversingImage_Main();
}
/*============================================================================*/

/*==============================================================================
20ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks(void)
{
    Telltales_Left_Right_Management_Service();
    
    Speed_Processing_Service();
    DrvMtrSpd_Processing_Service();
    SOC_Processing_Service();
    DrvMtrPwr_Processing_Service();

    if (ReversingImage_GetInitCompleteFlag() == 0u)
    {
        loc_cvbs_service();
    }
}
/*============================================================================*/

/*==============================================================================
50ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
    Sound_Scheduling_Service();
    Seg_Display_Service();
    BU98R10_Update_Request();
    BL_Management_service();
    Data_Service_Gear_Processing();
}
/*============================================================================*/
/*==============================================================================
100ms周期执行任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_100ms_Tasks(void)
{
    RTE_RTC_Services_100Ms_Cbk();
    Data_ODO_Processing();
    Data_Trip_Processing();
    BtyMaxTpt_Processing_Service();
    DrvMtrTpt_Processing_Service();
    BtyPckVtg_Processing_Service();
    BtyPckCrt_Processing_Service();
    DrvMCUTpt_Processing_Service();
    BtyMinCllTpt_Processing_Service();
    BtyMinCllVtg_Processing_Service();
    BtyMaxCllTpt_Processing_Service();
    BtyMaxCllVtg_Processing_Service();
    AirPressure_Processing_Service();
    BatVlt_Filt_Service();
    Popups_Management_Service();
    Popup_Scheduling_Service();
    
    if (ReversingImage_GetInitCompleteFlag() != 0u)
    {
        loc_cvbs_service();
    }

    TYW_Data_ODO_Clear();

    ABS_Error_Code_Process();
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                     系统休眠模式(SYS_MODE_SLEEP)任务列表                     *
*                                                                              *
*******************************************************************************/
/*==============================================================================
休眠模式下执行的后台任务
------------------------------------------------------------------------------*/
void Sys_Sleep_Mode_Tasks(void)
{
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确的50us计时任务列表                             *
*                                                                              *
*******************************************************************************/
uint32_t Time250us = 0;
/*==============================================================================
精确的50us计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    Sys_Rolling();
    COM_NM_Process();
    COM_TX_Process();        //外发
    DoCAN_Timer_Update(50);
    
    if (++Time250us >= 5)
    {
        Time250us = 0;
        
        Key_Turn_Test();     //编码器左右旋判定
    }
}  
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确的100ms计时任务列表                            *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确的100ms计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    Data_Mileage_ISR();
    
    Service_OFF_Timing_Process();
}
/*============================================================================*/
void APP_Startup_Init (uint8_t startMode)
{
    PID_Parameters_Init();
    
    Power_Management_Init(startMode);
}
