#ifndef __CSIH_H__
#define __CSIH_H__

#include "r_typedefs.h"

typedef struct stc_cpg_mfsn_csih_ctl0_field{
    uint8_t		CSIHnMBS:1;
    uint8_t               CSIHnJOBE:1;
    uint8_t		:3;
    uint8_t		CSIHnRXE:1;
    uint8_t		CSIHnTXE:1;
    uint8_t		CSIHnPWR:1;            
}stc_cpg_mfsn_csih_ctl0_field_t;

typedef union un_cpg_mfsn_csih_ctl0{
    uint8_t		u8Register;
    stc_cpg_mfsn_csih_ctl0_field_t    stcField;
}un_cpg_mfsn_csih_ctl0_t;


typedef struct stc_cpg_mfsn_csih_ctl1_field{
    uint32_t		CSIHnSSE:1;
    uint32_t		CSIHnHSE:1;
    uint32_t		CSIHnSIT:1;
    uint32_t		CSIHnLBM:1;
    uint32_t		CSIHnCSRI:1;
    uint32_t		CSIHnDCS:1;
    uint32_t		CSIHnJE:1;
    uint32_t		CSIHnEDLE:1;
    uint32_t		CSIHnCSLx:8;
    uint32_t		CSIHnSLIT:1;
    uint32_t		CSIHnCKR:1;
    uint32_t		CSIHnPHE:1;
    uint32_t		:5;
    uint32_t		CSIHnSLRS:1;
    uint32_t		:7;          
}stc_cpg_mfsn_csih_ctl1_field_t;

typedef union un_cpg_mfsn_csih_ctl1{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_ctl1_field_t    stcField;
}un_cpg_mfsn_csih_ctl1_t;


typedef struct stc_cpg_mfsn_csih_ctl2_field{
    uint16_t		CSIHnBRS:12;
    uint16_t		:1;
    uint16_t		CSIHnPRS:3;   
}stc_cpg_mfsn_csih_ctl2_field_t;

typedef union un_cpg_mfsn_csih_ctl2{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_ctl2_field_t    stcField;
}un_cpg_mfsn_csih_ctl2_t;


typedef struct stc_cpg_mfsn_csih_str0_field{
    uint32_t		CSIHnOVE:1;
    uint32_t		CSIHnPE:1;
    uint32_t		:1;
    uint32_t		CSIHnDCE:1;
    uint32_t		CSIHnEMF:1;
    uint32_t		CSIHnFLF:1;
    uint32_t		:1;
    uint32_t		CSIHnTSF:1;
    uint32_t		CSIHnHPST:1;
    uint32_t		:5;
    uint32_t		CSIHnOFE:1;
    uint32_t		CSIHnTMOE:1;
    uint32_t		CSIHnSPF:8;
    uint32_t		CSIHnSRP:8;
}stc_cpg_mfsn_csih_str0_field_t;

typedef union un_cpg_mfsn_csih_str0{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_str0_field_t    stcField;
}un_cpg_mfsn_csih_str0_t;


typedef struct stc_cpg_mfsn_csih_stcr0_field{
    uint16_t		CSIHnOVEC:1;
    uint16_t		CSIHnPEC:1;
    uint16_t		:1;
    uint16_t		CSIHnDCEC:1;
    uint16_t		:4;
    uint16_t		CSIHnPCT:1;
    uint16_t		:5;
    uint16_t		CSIHnOFEC:1;
    uint16_t		CSIHnTMOEC:1;
}stc_cpg_mfsn_csih_stcr0_field_t;

typedef union un_cpg_mfsn_csih_stcr0{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_stcr0_field_t    stcField;
}un_cpg_mfsn_csih_stcr0_t;


typedef struct stc_cpg_mfsn_csih_mctl0_field{
    uint16_t		CSIHnTO:5;
    uint16_t		:3;
    uint16_t		CSIHnMMS:2;
    uint16_t		:6;
}stc_cpg_mfsn_csih_mctl0_field_t;

typedef union un_cpg_mfsn_csih_mctl0{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_mctl0_field_t    stcField;
}un_cpg_mfsn_csih_mctl0_t;


typedef struct stc_cpg_mfsn_csih_mctl1_field{
    uint32_t		CSIHnFFS:7;
    uint32_t		:9;
    uint32_t		CSIHnFES:7;
    uint32_t		:9;
}stc_cpg_mfsn_csih_mctl1_field_t;

typedef union un_cpg_mfsn_csih_mctl1{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_mctl1_field_t    stcField;
}un_cpg_mfsn_csih_mctl1_t;


typedef struct stc_cpg_mfsn_csih_mctl2_field{
    uint32_t		CSIHnSOP:7;
    uint32_t		:9;
    uint32_t		CSIHnND:8;
    uint32_t		:7;
    uint32_t		CSIHnBTST:1;
}stc_cpg_mfsn_csih_mctl2_field_t;

typedef union un_cpg_mfsn_csih_mctl2{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_mctl2_field_t    stcField;
}un_cpg_mfsn_csih_mctl2_t;


typedef struct stc_cpg_mfsn_csih_mrwp0_field{
    uint32_t		CSIHnTRWA:7;
    uint32_t		:9;
    uint32_t		CSIHnRRA:7;
    uint32_t		:9;
}stc_cpg_mfsn_csih_mrwp0_field_t;

typedef union un_cpg_mfsn_csih_mrwp0{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_mrwp0_field_t    stcField;
}un_cpg_mfsn_csih_mrwp0_t;


typedef struct stc_cpg_mfsn_csih_cfg0_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;    
}stc_cpg_mfsn_csih_cfg0_field_t;

typedef union un_cpg_mfsn_csih_cfg0{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg0_field_t    stcField;
}un_cpg_mfsn_csih_cfg0_t;


typedef struct stc_cpg_mfsn_csih_cfg1_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;   
}stc_cpg_mfsn_csih_cfg1_field_t;

typedef union un_cpg_mfsn_csih_cfg1{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg1_field_t    stcField;
}un_cpg_mfsn_csih_cfg1_t;


typedef struct stc_cpg_mfsn_csih_cfg2_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;    
}stc_cpg_mfsn_csih_cfg2_field_t;

typedef union un_cpg_mfsn_csih_cfg2{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg2_field_t    stcField;
}un_cpg_mfsn_csih_cfg2_t;


typedef struct stc_cpg_mfsn_csih_cfg3_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;   
}stc_cpg_mfsn_csih_cfg3_field_t;

typedef union un_cpg_mfsn_csih_cfg3{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg3_field_t    stcField;
}un_cpg_mfsn_csih_cfg3_t;


typedef struct stc_cpg_mfsn_csih_cfg4_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;  
}stc_cpg_mfsn_csih_cfg4_field_t;

typedef union un_cpg_mfsn_csih_cfg4{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg4_field_t    stcField;
}un_cpg_mfsn_csih_cfg4_t;


typedef struct stc_cpg_mfsn_csih_cfg5_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;    
}stc_cpg_mfsn_csih_cfg5_field_t;

typedef union un_cpg_mfsn_csih_cfg5{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg5_field_t    stcField;
}un_cpg_mfsn_csih_cfg5_t;


typedef struct stc_cpg_mfsn_csih_cfg6_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;   
}stc_cpg_mfsn_csih_cfg6_field_t;

typedef union un_cpg_mfsn_csih_cfg6{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg6_field_t    stcField;
}un_cpg_mfsn_csih_cfg6_t;


typedef struct stc_cpg_mfsn_csih_cfg7_field{
    uint32_t		CSIHnSPx:4;
    uint32_t		CSIHnINx:4;
    uint32_t		CSIHnHDx:4;
    uint32_t		CSIHnIDx:3;
    uint32_t		CSIHnIDLx:1;
    uint32_t		CSIHnDAPx:1;
    uint32_t		CSIHnCKPx:1;
    uint32_t		CSIHnDIRx:1;
    uint32_t		CSIHnRCBx:1;
    uint32_t		:4;
    uint32_t		CSIHnDLSx:4;
    uint32_t		CSIHnPSx:2;
    uint32_t		PSCLxOBRSSx:2;    
}stc_cpg_mfsn_csih_cfg7_field_t;

typedef union un_cpg_mfsn_csih_cfg7{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_cfg7_field_t    stcField;
}un_cpg_mfsn_csih_cfg7_t;


typedef struct stc_cpg_mfsn_csih_tx0w_field{
    uint32_t		CSIHnTX:16;
    uint32_t		CSIHnCS:8;
    uint32_t		:5;
    uint32_t		CSIHnEDL:1;
    uint32_t		CSIHnEOJ:1;
    uint32_t		CSIHnCIRE:1;   
}stc_cpg_mfsn_csih_tx0w_field_t;

typedef union un_cpg_mfsn_csih_tx0w{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_tx0w_field_t    stcField;
}un_cpg_mfsn_csih_tx0w_t;


typedef struct stc_cpg_mfsn_csih_tx0h_field{
    uint16_t		CSIHnTX:16;
}stc_cpg_mfsn_csih_tx0h_field_t;

typedef union un_cpg_mfsn_csih_tx0h{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_tx0h_field_t    stcField;
}un_cpg_mfsn_csih_tx0h_t;


typedef struct stc_cpg_mfsn_csih_rx0w_field{
    uint32_t		CSIHnRX:16;
    uint32_t		CSIHnCSx:8;
    uint32_t		CSIHnTDCE:1;
    uint32_t		CSIHnRPE:1;
    uint32_t		:6;  
}stc_cpg_mfsn_csih_rx0w_field_t;

typedef union un_cpg_mfsn_csih_rx0w{
    uint32_t		u32Register;
    stc_cpg_mfsn_csih_rx0w_field_t    stcField;
}un_cpg_mfsn_csih_rx0w_t;


typedef struct stc_cpg_mfsn_csih_rx0h_field{
    uint16_t		CSIHnRX:16;
}stc_cpg_mfsn_csih_rx0h_field_t;

typedef union un_cpg_mfsn_csih_rx0h{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_rx0h_field_t    stcField;
}un_cpg_mfsn_csih_rx0h_t;


typedef struct stc_cpg_mfsn_csih_emu_field{
    uint8_t		:7;
    uint8_t		CSIHnSVSDIS:1;
}stc_cpg_mfsn_csih_emu_field_t;

typedef union un_cpg_mfsn_csih_emu{
    uint8_t		u8Register;
    stc_cpg_mfsn_csih_emu_field_t    stcField;
}un_cpg_mfsn_csih_emu_t;


typedef struct stc_cpg_mfsn_csih_brs0_field{
    uint16_t		CSIHnBRS:12;
    uint16_t		:4;
}stc_cpg_mfsn_csih_brs0_field_t;

typedef union un_cpg_mfsn_csih_brs0{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_brs0_field_t    stcField;
}un_cpg_mfsn_csih_brs0_t;


typedef struct stc_cpg_mfsn_csih_brs1_field{
    uint16_t		CSIHnBRS:12;
    uint16_t		:4;
}stc_cpg_mfsn_csih_brs1_field_t;

typedef union un_cpg_mfsn_csih_brs1{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_brs1_field_t    stcField;
}un_cpg_mfsn_csih_brs1_t;


typedef struct stc_cpg_mfsn_csih_brs2_field{
    uint16_t		CSIHnBRS:12;
    uint16_t		:4;
}stc_cpg_mfsn_csih_brs2_field_t;

typedef union un_cpg_mfsn_csih_brs2{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_brs2_field_t    stcField;
}un_cpg_mfsn_csih_brs2_t;


typedef struct stc_cpg_mfsn_csih_brs3_field{
    uint16_t		CSIHnBRS:12;
    uint16_t		:4;
}stc_cpg_mfsn_csih_brs3_field_t;

typedef union un_cpg_mfsn_csih_brs3{
    uint16_t		u16Register;
    stc_cpg_mfsn_csih_brs3_field_t    stcField;
}un_cpg_mfsn_csih_brs3_t;


typedef struct stc_cpg_mfsn_csih{
    un_cpg_mfsn_csih_ctl0_t    unCTL0;
    uint8_t Reserved0[3];
    un_cpg_mfsn_csih_str0_t    unSTR0;
    un_cpg_mfsn_csih_stcr0_t   unSTCR0;
    uint8_t Reserved1[6];
    un_cpg_mfsn_csih_ctl1_t    unCTL1;
    un_cpg_mfsn_csih_ctl2_t    unCTL2;
    uint8_t Reserved2[2];
    un_cpg_mfsn_csih_emu_t     unEMU;
    uint8_t Reserved3[4071];
    un_cpg_mfsn_csih_mctl1_t   unMCTL1;
    un_cpg_mfsn_csih_mctl2_t   unMCTL2;
    un_cpg_mfsn_csih_tx0w_t    unTX0W;
    un_cpg_mfsn_csih_tx0h_t    unTX0H;
    uint8_t Reserved4[2];
    un_cpg_mfsn_csih_rx0w_t    unRX0W;
    un_cpg_mfsn_csih_rx0h_t    unRX0H;
    uint8_t Reserved5[2];
    un_cpg_mfsn_csih_mrwp0_t   unMRWP0;
    uint8_t Reserved6[36];
    un_cpg_mfsn_csih_mctl0_t   unMCTL0;
    uint8_t Reserved7[2];
    un_cpg_mfsn_csih_cfg0_t    unCFG0;
    un_cpg_mfsn_csih_cfg1_t    unCFG1;
    un_cpg_mfsn_csih_cfg2_t    unCFG2;
    un_cpg_mfsn_csih_cfg3_t    unCFG3;
    un_cpg_mfsn_csih_cfg4_t    unCFG4;
    un_cpg_mfsn_csih_cfg5_t    unCFG5;
    un_cpg_mfsn_csih_cfg6_t    unCFG6;
    un_cpg_mfsn_csih_cfg7_t    unCFG7;
    uint8_t Reserved8[4];
    un_cpg_mfsn_csih_brs0_t    unBRS0;
    uint8_t Reserved9[2];
    un_cpg_mfsn_csih_brs1_t    unBRS1;
    uint8_t Reserved10[2];
    un_cpg_mfsn_csih_brs2_t    unBRS2;
    uint8_t Reserved11[2];
    un_cpg_mfsn_csih_brs3_t    unBRS3;
}stc_cpg_mfsn_csih_t;


volatile static stc_cpg_mfsn_csih_t* const CSIH[2] =
{
    (volatile stc_cpg_mfsn_csih_t*)(0xFFDA8000U),          /*  MFS 通道0   */
    (volatile stc_cpg_mfsn_csih_t*)(0xFFDAA000U),          /*  MFS 通道1   */   
};


typedef enum
{
    CSIH_SCKH_Rising = 0,  /*  在时钟信号空闲时，为高电平, 上升沿取数  */
    CSIH_SCKH_Falling,     /*  在时钟信号空闲时，为高电平, 下降沿取数  */
    CSIH_SCKL_Rising,      /*  在时钟信号空闲时，为低电平, 上升沿取数  */
    CSIH_SCKL_Falling,     /*  在时钟信号空闲时，为低电平, 下降沿取数  */
}CSIH_SCK_Edge;


typedef enum
{
    CSIH_DAT_LSbit = 0,    /*  低位先发出去  */
    CSIH_DAT_MSbit,        /*  高位先发出去  */
}CSIH_DAT_FORMAT;


typedef enum
{
    CSIH_OptSt_OK = 0,      /*  操作完成  */
    CSIH_OptSt_BUSY,        /*  当前忙  */
}CSIH_OptSt;



static void CSIH_CPU_SleepIdle(void);
extern void CSIH_Init(uint8_t channel, 
	                  uint16_t baud,
		              uint8_t bitnum,
                      CSIH_SCK_Edge sck_edge, 
                      CSIH_DAT_FORMAT dat_format
                      );
static CSIH_OptSt CSIH_IsSendBusy(uint8_t channel);
static void CSIH_WaitForSendReady(uint8_t channel);
extern CSIH_OptSt CSIH_SendData_12bit8th(uint8_t channel, uint16_t* pdat);
extern CSIH_OptSt CSIH_SendData_9bit1th(uint8_t channel, uint16_t* pdat);

extern void CSIH_Ch0_Rx_ISR(void);
extern void CSIH_Ch1_Rx_ISR(void);
extern void CSIH_Ch0_Tx_ISR(void);
extern void CSIH_Ch1_Tx_ISR(void);

#endif
