#include "Service_TPMS.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"


/*** TPMS ***/
_USER_TPMS TPMS_Out[TPMSNumMax];

/******************************************************************************
  Function：Data_TPMS_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL30_Init(void)
{
    TPMS_Out[TpmsFrontL].TPMSTyreID   = TpmsFrontLID  ;
    TPMS_Out[TpmsFrontR].TPMSTyreID   = TpmsFrontRID  ;
    TPMS_Out[TpmsRearL].TPMSTyreID    = TpmsRearLID   ;
    TPMS_Out[TpmsRearR].TPMSTyreID    = TpmsRearRID   ;
}
/******************************************************************************
  Function：Data_TPMS_KL15_ON_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_KL15_ON_Init(void)
{

}
/******************************************************************************
  Function：Data_TPMS_Value_Processing
  Description：数据处理总接口
  Input:
  Output:
 ******************************************************************************/
void Data_TPMS_Value_Processing(void)
{
    /*报文数据获取，处理*/
    Get_Data_TPMS_Value(TpmsFrontL);
    Get_Data_TPMS_Value(TpmsFrontR);
    Get_Data_TPMS_Value(TpmsRearL);
    Get_Data_TPMS_Value(TpmsRearR);

    /*报文状态获取*/
    Get_Data_TPMS_Status(TpmsFrontL);
    Get_Data_TPMS_Status(TpmsFrontR);
    Get_Data_TPMS_Status(TpmsRearL);
    Get_Data_TPMS_Status(TpmsRearR);
}

/******************************************************************************
  Function：Get_Data_TPMS_Value
  Description：胎压数据获取 数据精度在获取数据函数进行处理
  Input: 输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID)
{
    uint16_t TyrePressure = 0u ;
    uint32_t TyreTemp = 0u ;
    uint16_t Leakrate = 0u;

    if (  TPMS_Out[TPMSTyreID].TPMSTyreID == 0u )/*Get_ID_18FEF433_Sig_TyreID() )*/
    {
        /*胎压 数据处理*/
        TyrePressure                                          = 0u ; /*Get_ID_18FEF433_Sig_TyrePressure();*/
        TPMS_Out[TPMSTyreID].TPMSPressure                     = TyrePressure * 8u;

        /*胎温 数据处理*/
        TyreTemp                                              = 0u ; /*Get_ID_18FEF433_Sig_TyreTemp();*/
        if (TyreTemp < TYRETEMP_OFFSET_VALUE)
        {
            TPMS_Out[TPMSTyreID].TPMSTemp                       = (uint16_t)(TYRETEMP_OFFSET_VALUE - TyreTemp * 3125u / 100000u);
        }
        else
        {
            TPMS_Out[TPMSTyreID].TPMSTemp                       = (uint16_t)(TyreTemp * 3125u / 100000u - TYRETEMP_OFFSET_VALUE);
        }

        /*漏气速率 数据处理*/
        Leakrate                                              = 0u ; /*Get_ID_18FEF433_Sig_Leakrate();*/
        TPMS_Out[TPMSTyreID].TPMSLeakrate                     = Leakrate / 10u;

        /*压力检测*/
        TPMS_Out[TPMSTyreID].TPMSPressureThresholdDetection   = 0u ;/*Get_ID_18FEF433_Sig_TirePressureThresholdDetection();*/

        /*数据掉线计时器*/
        TPMS_Out[TPMSTyreID].TPMSDataInvalidTime              = 0u;
    }
    else
    {
        if (TPMS_Out[TPMSTyreID].TPMSDataInvalidTime < 0xFFFFu)
        {
            TPMS_Out[TPMSTyreID].TPMSDataInvalidTime ++ ;
        }
        else
        {
            TPMS_Out[TPMSTyreID].TPMSDataInvalidTime = 0xFFFFu;
        }
    }
}

/******************************************************************************
  Function：Get_Data_TPMS_Status
  Description：胎压状态获取
  Input:输入枚举编号
  Output:
 ******************************************************************************/
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID)
{
    if ( TPMS_Out[TPMSTyreID].TPMSTyreID == 0u )/*Get_ID_18FEF533_Sig_TyreID() )*/
    {
        /*传感器故障报警信号 SensorErrorWarningSig*/
        TPMS_Out[TPMSTyreID].TPMSSensorfault            = 0u ;/*Get_ID_18FEF533_Sig_SensorErrorWarningSig();*/
        /*轮胎被盗报警信号 TyresLostWarningSig*/
        TPMS_Out[TPMSTyreID].TPMSLostWarningSig         = 0u ;/*Get_ID_18FEF533_Sig_TyresLostWarningSig();*/
        /*传感器电压低报警信号 SensorVoltWarningSig*/
        TPMS_Out[TPMSTyreID].TPMSLowvoltage             = 0u ;/*Get_ID_18FEF533_Sig_SensorVoltWarningSig();*/
        /*轮胎标准压力设置状态 TireStandarPressureSettingSts*/
        TPMS_Out[TPMSTyreID].TPMSStandarPressureSetSts  = 0u ;/*Get_ID_18FEF533_Sig_TireStandarPressureSettingSts();*/
        /*轮胎标准温度设置状态 TireStandarTemperatureSettingSts*/
        TPMS_Out[TPMSTyreID].TPMSStandarTempSetSts      = 0u ;/*Get_ID_18FEF533_Sig_TireStandarTemperatureSettingSts();*/
        /*快速漏气报警信号 RapidLeakWarningSig*/
        TPMS_Out[TPMSTyreID].TPMSRapidleakage           = 0u ;/*Get_ID_18FEF533_Sig_RapidLeakWarningSig();*/
        /*轮胎温度报警信号 TyreTempWarningSig*/
        TPMS_Out[TPMSTyreID].TPMSHightemperature        = 0u ;/*Get_ID_18FEF533_Sig_TyreTempWarningSig();*/
        /*短时未收到传感器信号 TemporaryNoSignal*/
        TPMS_Out[TPMSTyreID].TPMSTemporaryNoSignal      = 0u ;/*Get_ID_18FEF533_Sig_TemporaryNoSignal();*/
    }
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Value
  Description：获取某个编号轮胎胎压
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSPressure ;
}

/******************************************************************************
  Function： Get_DataTPMS_Pressure_Sta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据状态 有效无效等
 ******************************************************************************/
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t  Pressure_Sta = 0u;

    if ( (TPMS_Out[TPMSTyreID].TPMSDataInvalidTime) >= 50u )    /*数据超时 掉线或轮刷超时*/
    {
        Pressure_Sta = 0u;/*(uint16_t)STATUS_CAN_SIG_TIME_OUT;*/
    }
    else if ((TPMS_Out[TPMSTyreID].TPMSPressure) >= 0xFAu ) /*超出最大范围*/
    {
        Pressure_Sta =  (uint16_t)STATUS_UNSUPPORTED ;
    }
    else
    {
        Pressure_Sta = (uint16_t)STATUS_SUCCESS ;
    }

    return Pressure_Sta ;
}
/******************************************************************************
  Function： Get_DataTPMS_Pressure_FLashSta
  Description：获取某个编号轮胎胎压状态
  Input:输入枚举编号
  Output: 对应轮胎位置的胎压数据的闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t   Pressure_Sta = 0u ;

    if ((Get_DataTPMS_Pressure_Sta(TPMSTyreID)) == 0u) /*(uint16_t)STATUS_CAN_SIG_TIME_OUT)*/
    {
        Pressure_Sta  = FLASH_SYNC_1Hz ;
    }
    return (uint8_t)Pressure_Sta ;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Value
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSTemp ;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_Sta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温数据状态，有效无效正数负数等
 ******************************************************************************/
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID)
{
    uint16_t  Temp_Value = 0u;
    uint32_t  Temp_Value_CUP = 0u;

    Temp_Value_CUP = 0u; /*Get_ID_18FEF533_Sig_TyreTempWarningSig();*/

    if ( TPMS_Out[TPMSTyreID].TPMSDataInvalidTime >= 50u )      /*数据超时 掉线或轮刷超时*/
    {
        Temp_Value = 0u;/*(uint16_t)STATUS_CAN_SIG_TIME_OUT;*/
    }
    else if ((Get_DataTPMS_Temp_Value(TPMSTyreID)) >= 0xFFFFu)              /*超出最大范围*/
    {
        Temp_Value =  (uint16_t)STATUS_UNSUPPORTED ;
    }
    else if (Temp_Value_CUP >= TYRETEMP_OFFSET_VALUE )
    {
        Temp_Value = 0u; /*正数 零 返回状态*/
    }
    else if (Temp_Value_CUP < TYRETEMP_OFFSET_VALUE )
    {
        Temp_Value = 0u;/*负数 返回状态*/
    }
    else
    {
        Temp_Value = (uint16_t)STATUS_SUCCESS ;
    }
    return  (uint16_t)Temp_Value;
}

/******************************************************************************
  Function：Get_DataTPMS_Temp_FLashSta
  Description：获取某个编号轮胎胎温
  Input:输入枚举编号
  Output: 输出胎温闪烁状态
 ******************************************************************************/
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID)
{
    uint8_t   TEMP_Sta = 0u ;

    if ((Get_DataTPMS_Temp_Sta(TPMSTyreID)) == (uint16_t)STATUS_SUCCESS) /*状态值要调整*/
    {
        TEMP_Sta = FlashSync1Hz ;
    }
    return (uint8_t)TEMP_Sta ;
}

/******************************************************************************
  Function：Get_DataTPMS_Leakrate_Value
  Description：获取某个编号轮胎漏气速率
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint16_t Get_DataTPMS_Leakrate_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint16_t)TPMS_Out[TPMSTyreID].TPMSLeakrate ;
}

/******************************************************************************
  Function：Get_DataTPMS_TPMSHighpressure_Value
  Description：获取某个编号轮胎气压高
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_Highpressure_Value(TPMSNUM_t TPMSTyreID)
{
    uint8_t Highpressure_Value = 0u;

    if ((uint8_t)TPMS_Out[TPMSTyreID].TPMSPressureThresholdDetection == 1u)
    {
        Highpressure_Value = 1u;
    }
    else
    {
        Highpressure_Value = 0u;
    }
    return (uint8_t)Highpressure_Value ;
}

/******************************************************************************
 Function：Get_DataTPMS_Lowpressure_Value
 Description：获取某个编号轮胎气压低
 Input:输入枚举编号
 Output:
******************************************************************************/
uint8_t Get_DataTPMS_Lowpressure_Value(TPMSNUM_t TPMSTyreID)
{
    uint8_t Lowpressure_Value = 0u;
    uint8_t Lowpressure_Value_CUP = 0u;

    Lowpressure_Value_CUP = (uint8_t)TPMS_Out[TPMSTyreID].TPMSPressureThresholdDetection;

    if ( Lowpressure_Value_CUP == 3u)
    {
        Lowpressure_Value = 1u;
    }
    else if (Lowpressure_Value_CUP == 4u)
    {
        Lowpressure_Value = 2u;
    }
    else
    {
        Lowpressure_Value = 0u;
    }

    return (uint8_t)Lowpressure_Value ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎传感器故障信息
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSSensorfault ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎轮胎被盗报警信号
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TyresLostWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLostWarningSig ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎低气压报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_SensorVoltWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSLowpressure ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎标准压力设置状态
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TireStandarPressureSettingSts_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSStandarPressureSetSts ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎标准温度设置状态
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TireStandarTemperatureSettingSts_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSStandarTempSetSts ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎快速漏气报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return  (uint8_t)TPMS_Out[TPMSTyreID].TPMSRapidleakage ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎高温报警
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TyreTempWarningSig_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSHightemperature ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎短时无信号
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_TemporaryNoSignal_Value(TPMSNUM_t TPMSTyreID)
{
    return (uint8_t)TPMS_Out[TPMSTyreID].TPMSTemporaryNoSignal ;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎是否换色
  Input:输入枚举编号
  Output:
 ******************************************************************************/
uint8_t Get_DataTPMS_Tyre_Red_Sta(TPMSNUM_t TPMSTyreID)
{
    uint8_t  TPMS_Tyre_Status = 0u;

    return (uint8_t)TPMS_Tyre_Status;
}

/******************************************************************************
  Function：
  Description：获取某个编号轮胎闪烁状态
  Input:输入枚举编号
  Output: 0--不显示；1--闪烁
 ******************************************************************************/
uint8_t Get_DataTPMS_Tyre_FLASH_Sta(TPMSNUM_t TPMSTyreID)
{
    uint8_t  TPMS_Tyre_Status = 0u;

    TPMS_Tyre_Status = FLASH_SYNC_1Hz;

    return (uint8_t)TPMS_Tyre_Status;
}
