#include "Data_BtyPckCrt.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint16_t BtyPckCrt_Value;
uint8_t  BtyPckCrt_Sign;
uint8_t  BtyPckCrt_Valid;

void BtyPckCrt_Reset(void)
{
    BtyPckCrt_Value = 0;
    BtyPckCrt_Sign  = 0;
    BtyPckCrt_Valid = 0;
}

void BtyPckCrt_KL30_Init(void)
{
    BtyPckCrt_Reset();
}

void BtyPckCrt_KL15_ON_Init(void)
{
    BtyPckCrt_Reset();
}

void BtyPckCrt_Processing_Service(void)
{
    uint16_t u16Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF) //下电
    {
        BtyPckCrt_Reset();
        return;
    }

    u16Result = Get_ID_18F13DF3_Sig_BMS_BtyPckCrt();
    
    if ((u16Result >= 0xFFFE) || (CAN_MSG_Status(ID_BMS_BMSSts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyPckCrt_Valid = 0;
        BtyPckCrt_Sign  = 0;
        u16Result       = 0;
    }
    else
    {
        BtyPckCrt_Valid = 1;
    }
    
    if (u16Result < 10000)  //0.1A 
    {
        u16Result      = 10000 - u16Result;
        BtyPckCrt_Sign = 1;
    }
    else
    {
        u16Result     -= 10000;
        BtyPckCrt_Sign = 0;
    }
    
    if (u16Result <= 10000)
    {
        BtyPckCrt_Value = u16Result;
    }
    else
    {
        //超过有效范围保持原值
    }
}

uint16_t BtyPckCrt_Get_Value(void)
{
    return BtyPckCrt_Value;
}

uint8_t BtyPckCrt_Get_Sign(void)
{
    return BtyPckCrt_Sign;
}

uint8_t BtyPckCrt_Get_Valid(void)
{
    return BtyPckCrt_Valid;
}
