
#ifndef SYSTEM_MONITOR_H
#define SYSTEM_MONITOR_H

#include "TYW_stdint.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Line_In.h"

typedef struct
{
    uint8_t SumCnt;
    uint16_t DebounceTimer;
    uint32_t ActVoltage;
    uint8_t FinalSts;
    uint8_t ActSts;
} MonitorStruct;

/* 12V系统
     0 ----1st-------6500   不可运行   1
  6500 ----2st-------7000   回差段     2

  7000 ----3st-------9000   低压段     3
  9000 ----4st-------9500   回差段     4
  9500-----5st------16000   正常段     5
  16000----6st------16500   回差段     6

  16500----7st------18000   高压段     7
  18000----8st------18500   回差段     8
  18500----9st------65535   高压段     9

    0-----6.5   不可运行--ALL----------限制
  6.5-----9     除电机外均可运行--------正常
    9-----16.5  均可运行---------------正常
 16.5-----18.5  只有CAN可运行----------限制
 18.8-----65535 不可运行--ALL----------限制

6.5-18.5  CAN 可运行区间
*/

/* 24V系统
     0 ----1st-------8500   不可运行   1
  8500 ----2st-------9000   回差段     2

  9000 ----3st------9500    低压段     3
  9500 ----4st------10000   回差段     4
  1000-----5st------30000   正常段     5
  30000----6st------30500   回差段     6

  30500----7st------32000   高压段     7
  32000----8st------32500   回差段     8
  32500----9st------65535   高压段     9

    0-----8.5   不可运行--ALL----------限制
  8.5-----9.5   除电机外均可运行--------正常
  9.5-----30.5  均可运行---------------正常
 30.5-----32.5  只有CAN可运行----------限制
 32.5-----65535 不可运行--ALL----------限制

8.5-32.5  CAN 可运行区间
*/

/*电源运行状态*/
#define   SYS_OPR_STAT_RUN           ((System_FUN_KL30_Status_Get() > 1u) && (System_FUN_KL30_Status_Get() < 7u ))
#define   SYS_OPR_STAT_HALT          ((System_FUN_KL30_Status_Get() == 1u) || (System_FUN_KL30_Status_Get() >= 7u))

#define   SYS_OPR_STAT_LIM_LVP       (System_FUN_KL30_Status_Get() == 1U)
#define   SYS_OPR_STAT_LIM_OVP       (System_FUN_KL30_Status_Get() >= 7u)

/*仪表工作状态*/
#define   SYS_OPR_STAT_IGN_ON        ((System_FUN_KL15_Status_Get() == 1U) || (Line_In_Get_Status(LINE_IN_ChargeWake) == 1u))
#define   SYS_OPR_STAT_IGN_OFF       ((System_FUN_KL15_Status_Get() == 0U) && (Line_In_Get_Status(LINE_IN_ChargeWake) == 0u))

/*网络管理电源工作状态*/
#define   SYS_OPR_STAT_IGN_ON_NM     (System_NM_KL15_Status_Get() == 1U)
#define   SYS_OPR_STAT_IGN_OFF_NM    (System_NM_KL15_Status_Get() == 0U)

/*网络管理电源运行状态*/
#define   SYS_OPR_STAT_RUN_NM        ((System_NM_KL30_Status_Get() > 1u) && (System_NM_KL30_Status_Get() < 9u ))
#define   SYS_OPR_STAT_HALT_NM       ((System_NM_KL30_Status_Get() == 9u) || (System_NM_KL30_Status_Get() == 1u))

static uint8_t System_Calc_FunRange(uint16_t u16Vol);
static uint8_t System_Calc_NMRange(uint16_t u16Vol);

uint8_t Read_KL30_ConvertFinish(void);

static void System_Fun_Process(void);
static void System_NM_Process(void);
void Sys_LogicProcess(void);
void Sys_Status_Update_Service ( void );

uint16_t Sys_Read_KL30_Voltage(void);
uint16_t Sys_Read_KL15_Voltage(void);
uint8_t Sys_Read_KL30_Valid(void);
uint8_t Sys_Read_KL15_Valid(void);

uint16_t Sys_Force_Read_KL30_Voltage(void);
uint16_t Sys_Force_Read_KL15_Voltage(void);

uint8_t System_FUN_KL30_Status_Get(void);
uint8_t System_FUN_KL15_Status_Get(void);
uint8_t System_NM_KL15_Status_Get(void);
uint8_t System_NM_KL30_Status_Get(void);

uint8_t System_LINE_KL15(void);

void Sys_Set_DebounceTimer(uint16_t u16NMKL30, uint16_t u16NMKL15, uint16_t u16FUNKL30, uint16_t u16FUNKL15);
//void Sys_Set_VolRange(const uint16_t FUN_Vol[], const uint16_t  NM_Vol[]);
void System_Monitor_KL30Init(void);
void System_Monitor_WakeupInit(void);
void System_Fast_WakeUp(void);

void Sys_KL30_Init (void);
void Sys_WakeUp_Init (void);
void Sys_BlockDelay(uint32_t u32Ms);

void Sys_Rolling(void);
void Sys_RollingClear(void);
uint32_t Sys_Get_ms_Rolling_Counter(void);

#endif

