#include "Data_BtyMaxCllVtg.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "Common_Interface.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "GUI.h"
#include "System_Monitor.h"

uint16_t BtyMaxCllVtg_Value;
uint8_t  BtyMaxCllVtg_Valid;
uint8_t  Charged_State;

void BtyMaxCllVtg_Reset(void)
{
    BtyMaxCllVtg_Value = 0;
    BtyMaxCllVtg_Valid = 0;

    Charged_State = 0u;
}

void BtyMaxCllVtg_KL30_Init(void)
{
    BtyMaxCllVtg_Reset();
}

void BtyMaxCllVtg_KL15_ON_Init(void)
{
    BtyMaxCllVtg_Reset();
}

void BtyMaxCllVtg_Processing_Service(void)
{
    uint16_t u16Result = Get_ID_18F141F3_Sig_BMS_ChgWrCntSts();
        
    if ((u16Result == 0x55u) && SYS_OPR_STAT_IGN_ON)
    {
        Charged_State = 1u;
    }
    else
    {
        Charged_State = 0u;
    }
 
    if (Common_Get_IG_Sts() == 0u)
    {
        BtyMaxCllVtg_Reset();
    }
    else
    {
        u16Result = Get_ID_18F13EF3_Sig_BMS_BtyMaxCllVtg();
        
        if ((u16Result >= 0xFFFE) || (CAN_MSG_Status(ID_BMS_CllBtySts_Msg_Count) != CAN_SIG_RECEIVE))
        {
            BtyMaxCllVtg_Valid = 0;
            u16Result          = 0;
        }
        else
        {
            BtyMaxCllVtg_Valid = 1;
        }
        
        if (u16Result <= 10000)  //0.001V 
        {
            BtyMaxCllVtg_Value = u16Result;
        }
        else
        {
            //超过有效范围保持原值
        }
        
        if (Common_GetIgnOnTime() <= 4000u) //上电<3秒
        {
            Charged_State = 0u;
        }
    }
}

uint8_t Charged_State_Get(void)
{
    return Charged_State;
}

uint16_t BtyMaxCllVtg_Get_Value(void)
{
    return BtyMaxCllVtg_Value;
}

uint8_t BtyMaxCllVtg_Get_Valid(void)
{
    return BtyMaxCllVtg_Valid;
}
