#include "TLC6C5912.h"
#include "CSIH.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "r_typedefs.h"

volatile uint16_t  TLC6C5912_Buf [ TLC6C5912_TOTAL_CHIP_NUM ];
volatile DByteBits LEDControl [ TLC6C5912_TOTAL_CHIP_NUM ];

void TLC6C5912_Init(void)
{
    uint8_t i;

    /* close */
    TLC6C5912_nOE = 1U;    // 10脚
    TLC6C5912_nCS = 0U;    // 12脚

    /* clear */
    TLC6C5912_CLR = 1U;    // 9脚

    CSIH_Init(TLC6C5912_CSIH_Channel, 100, 12U, CSIH_SCKL_Rising, CSIH_DAT_MSbit);

    for ( i = 0U; i < TLC6C5912_TOTAL_CHIP_NUM; i++ )
    {
        TLC6C5912_Buf [ i ] = 0X0000U;
    }

    for ( i = 0U; i < TLC6C5912_TOTAL_CHIP_NUM; i++ )
    {
        LEDControl [ i ].DByte = 0X0000U;
    }

    CSIH_SendData_12bit8th(TLC6C5912_CSIH_Channel, &TLC6C5912_Buf);
    /* storage */
}

void TLC6C5912_DeInit(void)
{
    /* Disable */
    TLC6C5912_nOE = 1U;    //
}

void TLC6C5912_Sync_Service(void)
{
    uint8_t i;
    uint8_t u8Update = 0U;

    for ( i = 0; i < TLC6C5912_TOTAL_CHIP_NUM; i++ )
    {
        if ( TLC6C5912_Buf [ TLC6C5912_TOTAL_CHIP_NUM - i - 1 ] != LEDControl [ i ].DByte )
        {
            u8Update = 1U;
            break;
        }
    }

    if ( u8Update )
    {
        for ( i = 0; i < TLC6C5912_TOTAL_CHIP_NUM; i++ )
        {
            TLC6C5912_Buf [ TLC6C5912_TOTAL_CHIP_NUM - i - 1 ] = LEDControl [ i ].DByte;
        }

        CSIH_OptSt re_value = CSIH_OptSt_BUSY;

        TLC6C5912_nCS = 0U;

        re_value = CSIH_SendData_12bit8th(TLC6C5912_CSIH_Channel, &TLC6C5912_Buf);

        if ( re_value == CSIH_OptSt_OK )
        {
            /* enable */
            TLC6C5912_nOE = 0U;
            /* storage */
        }
        else
        {
        }
    }
}
