#include "Data_BtyPckVtg.h"
#include "CAN_Communication_Matrix.h"
#include "Communication_Over_CAN.h"
#include "System_Monitor.h"

uint16_t BtyPckVtg_Value;
uint8_t  BtyPckVtg_Valid;

void BtyPckVtg_Reset(void)
{
    BtyPckVtg_Value = 0;
    BtyPckVtg_Valid = 0;
}

void BtyPckVtg_KL30_Init(void)
{
    BtyPckVtg_Reset();
}

void BtyPckVtg_KL15_ON_Init(void)
{
    BtyPckVtg_Reset();
}

void BtyPckVtg_Processing_Service(void)
{
    uint16_t u16Result = 0u;
    
    if (SYS_OPR_STAT_IGN_OFF)
    {
        BtyPckVtg_Reset();
        return;
    }

    u16Result  = Get_ID_18F13DF3_Sig_BMS_BtyPckVtg();
    
    if ((u16Result >= 0xFFFE) || (CAN_MSG_Status(ID_BMS_BMSSts_Msg_Count) != CAN_SIG_RECEIVE))
    {
        BtyPckVtg_Valid = 0;
        u16Result       = 0;
    }
    else
    {
        BtyPckVtg_Valid = 1;
    }
    
    if (u16Result <= 10000)  //0.1V 
    {
        BtyPckVtg_Value = u16Result;
    }
    else
    {
        //超过有效范围保持原值
    }
}

uint16_t BtyPckVtg_Get_Value(void)
{
    return BtyPckVtg_Value;
}

uint8_t BtyPckVtg_Get_Valid(void)
{
    return BtyPckVtg_Valid;
}
