#include "Line_in.h"
#include "Line_In_user.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"

/*PIN1 水位报警信号 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_FluidLevel(void)
{
    LINE_IN_TriggerLevel_en_t Res = FluidLevel_IN_MCU;

    return Res;
}

/*PIN5 制动故障 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_BrakeFault(void)
{
    LINE_IN_TriggerLevel_en_t Res = BrakeFault_IN_MCU;

    return Res;
}

/*PIN9 充电唤醒 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ChargeWake(void)
{
    LINE_IN_TriggerLevel_en_t Res = ChargeWake_IN_MCU;

    return Res;
}

/*PIN11座位检测 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_SeatDetection(void)
{
    LINE_IN_TriggerLevel_en_t Res = SeatDetection_IN_MCU;

    return Res;
}

/*PIN17左车门开关 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_LeftDoor(void)
{
    LINE_IN_TriggerLevel_en_t Res = LeftDoor_IN_MCU;

    return Res;
}

/*PIN19安全带 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_SeatBelt(void)
{
    LINE_IN_TriggerLevel_en_t Res = SeatBelt_IN_MCU;

    return Res;
}

/*PIN20驻车灯 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_Parking(void)
{
    LINE_IN_TriggerLevel_en_t Res = Parking_IN_MCU;

    return Res;
}

/*PIN21右车门开关 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RightDoor(void)
{
    LINE_IN_TriggerLevel_en_t Res = RightDoor_IN_MCU;

    return Res;
}

/*PIN22前雾灯 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_FrontFog(void)
{
    LINE_IN_TriggerLevel_en_t Res = FrontFog_IN_MCU;

    return Res;
}

/*PIN23后雾灯 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RearFog(void)
{
    LINE_IN_TriggerLevel_en_t Res = RearFog_IN_MCU;

    return Res;
}

/*PIN24左转 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TrunLeft(void)
{
    LINE_IN_TriggerLevel_en_t Res = TrunLeft_IN_MCU;

    return Res;
}

/*PIN25位置灯 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_Position(void)
{
    LINE_IN_TriggerLevel_en_t Res = Position_IN_MCU;

    return Res;
}

/*PIN27右转 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TrunRight(void)
{
    LINE_IN_TriggerLevel_en_t Res = TrunRight_IN_MCU;

    return Res;
}

/*PIN28近光 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_LoBeam(void)
{
    LINE_IN_TriggerLevel_en_t Res = LoBeam_IN_MCU;

    return Res;
}

/*PIN30远光 高有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_HiBeam(void)
{
    LINE_IN_TriggerLevel_en_t Res = HiBeam_IN_MCU;

    return Res;
}

/*PIN31取力器 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_PTO(void)
{
    LINE_IN_TriggerLevel_en_t Res = PTO_IN_MCU;

    return Res;
}

/*PIN32ABS 低有效*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ABS(void)
{
    LINE_IN_TriggerLevel_en_t Res = ABS_IN_MCU;

    return Res;
}

/*属性表与硬线索引号Line_In_Channel_en_t一一对应*/
const Line_In_Attribute_st_t g_stLineInAttribute[LINE_IN_MAX] =
{                              /*20220617由0改为10*/
    {LINE_IN_LEVEL_LOW, 30000U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_FluidLevel   }, /*PIN1 水位报警信号 低有效*/
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_BrakeFault   }, /*PIN5 制动故障     低有效*/
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ONOFF, LINE_IN_Get_ChargeWake   }, /*PIN9 充电唤醒     高有效*/
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_SeatDetection}, /*PIN11座位检测     低有效*/ 
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ONOFF, LINE_IN_Get_LeftDoor,    }, /*PIN17左车门开关   低有效*/ 
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_SeatBelt     }, /*PIN19安全带       低有效*/
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ONOFF, LINE_IN_Get_Parking      }, /*PIN20驻车灯       低有效*/ 
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ONOFF, LINE_IN_Get_RightDoor    }, /*PIN21右车门开关   低有效*/  
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_FrontFog     }, /*PIN22前雾灯       高有效*/ 
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_RearFog      }, /*PIN23后雾灯       高有效*/
    {LINE_IN_LEVEL_HIGH, 50U,  10U, LINE_IN_IG_ONOFF, LINE_IN_Get_TrunLeft     }, /*PIN24左转         高有效*/
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ONOFF, LINE_IN_Get_Position     }, /*PIN25位置灯       高有效*/
    {LINE_IN_LEVEL_HIGH, 50U,  10U, LINE_IN_IG_ONOFF, LINE_IN_Get_TrunRight    }, /*PIN27右转         高有效*/ 
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_LoBeam       }, /*PIN28近光         高有效*/
    {LINE_IN_LEVEL_HIGH, 200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_HiBeam       }, /*PIN30远光         高有效*/
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_PTO          }, /*PIN31取力器       低有效*/
    {LINE_IN_LEVEL_LOW,  200U, 10U, LINE_IN_IG_ON,    LINE_IN_Get_ABS          }, /*PIN32ABS         低有效*/
 };
