#include "None_NM.h"
#include "RTE_CAN_NM.h"

NM_Mode_t NM_Mode_Status;
uint32_t NM_Idle_Timer;


void None_NM_Init(void)
{
    NM_Mode_Status = NM_Mode_Sleep;
    NM_Idle_Timer = 0u;
}
/*
50us ++
4s
4000ms
4000000us
0080000 tick
*/

uint16_t Turn_Delay_Time = 0u;
uint32_t IgnOffChgWak_Time = 0u;

void None_NM_Service(void)
{
    uint8_t m_conditon;
    m_conditon = RTE_CAN_GetBusStatus();
    if (m_conditon == 1u)
    {
        NM_Mode_Status = NM_Mode_Wakeup;
        NM_Idle_Timer = 0u;
    }
    else
    {
        if (NM_Idle_Timer <= 100000ul) //1600000ul) //*50uS
        {
            NM_Idle_Timer++;
        }
        else
        {
            NM_Mode_Status = NM_Mode_Sleep;
        }
    }

    if (Turn_Delay_Time < 0xFFFFu)
    {
        Turn_Delay_Time++;
    }

    if (IgnOffChgWak_Time < 0xFFFFFFFF)
    {
        IgnOffChgWak_Time++; 
    }
}

uint32_t NM_Idle_Timer_Get(void)
{
    return NM_Idle_Timer;
}

uint32_t IgnOffChgWak_Time_Get(void)
{
    return IgnOffChgWak_Time;
}

void IgnOffChgWak_Time_Set(uint32_t time)
{
    IgnOffChgWak_Time = time;
}

uint16_t Turn_Delay_Time_Get(void)
{
    return Turn_Delay_Time;
}

void Turn_Delay_Time_Set(uint16_t value)
{
    Turn_Delay_Time = value;
}

NM_Mode_t None_NM_Mode(void)
{
    return NM_Mode_Status;
}

void None_NM_Request(void)
{
    NM_Mode_Status = NM_Mode_Wakeup;
    NM_Idle_Timer = 0u;
}
void None_NM_Release(void)
{
   
}